/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.EnumSet;
import java.util.OptionalInt;
import java.util.Set;
import org.jboss.as.controller.xml.XMLUsage;

public interface XMLCardinality
extends XMLUsage {
    public static final XMLCardinality DISABLED = XMLCardinality.of(0, OptionalInt.of(0));

    public int getMinOccurs();

    public OptionalInt getMaxOccurs();

    @Override
    default public boolean isRequired() {
        return this.getMinOccurs() > 0;
    }

    default public boolean isRepeatable() {
        return this.getMaxOccurs().orElse(Integer.MAX_VALUE) > 1;
    }

    @Override
    default public boolean isEnabled() {
        return this.getMaxOccurs().orElse(Integer.MAX_VALUE) > 0;
    }

    public static XMLCardinality of(final int minOccurs, final OptionalInt maxOccurs) {
        if (minOccurs < 0 || minOccurs > maxOccurs.orElse(Integer.MAX_VALUE)) {
            throw new IllegalArgumentException(Integer.toString(minOccurs));
        }
        EnumSet<Unbounded> candidates = maxOccurs.isEmpty() ? EnumSet.allOf(Unbounded.class) : (maxOccurs.equals(Single.MAX) ? EnumSet.allOf(Single.class) : Set.of());
        for (XMLCardinality xMLCardinality : candidates) {
            if (minOccurs != xMLCardinality.getMinOccurs()) continue;
            return xMLCardinality;
        }
        return new XMLCardinality(){

            @Override
            public int getMinOccurs() {
                return minOccurs;
            }

            @Override
            public OptionalInt getMaxOccurs() {
                return maxOccurs;
            }

            public String toString() {
                return XMLCardinality.toString(this);
            }
        };
    }

    public static String toString(XMLCardinality cardinality) {
        return String.format("minOccurs=\"%d\" maxOccurs=\"%s\"", cardinality.getMinOccurs(), cardinality.getMaxOccurs().isPresent() ? Integer.valueOf(cardinality.getMaxOccurs().getAsInt()) : "unbounded");
    }

    public static enum Unbounded implements XMLCardinality
    {
        OPTIONAL(0),
        REQUIRED(1);

        private final int min;

        private Unbounded(int min) {
            this.min = min;
        }

        @Override
        public int getMinOccurs() {
            return this.min;
        }

        @Override
        public OptionalInt getMaxOccurs() {
            return OptionalInt.empty();
        }

        public String toString() {
            return XMLCardinality.toString(this);
        }
    }

    public static enum Single implements XMLCardinality
    {
        OPTIONAL(0),
        REQUIRED(1);

        private static final OptionalInt MAX;
        private final int min;

        private Single(int min) {
            this.min = min;
        }

        @Override
        public int getMinOccurs() {
            return this.min;
        }

        @Override
        public OptionalInt getMaxOccurs() {
            return MAX;
        }

        public String toString() {
            return XMLCardinality.toString(this);
        }

        static {
            MAX = OptionalInt.of(1);
        }
    }
}

