/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLConfiguration;
import org.jboss.as.controller.persistence.xml.ResourceXMLContainer;
import org.jboss.as.controller.persistence.xml.ResourceXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLElementLocalName;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.function.Functions;

public interface ResourceRegistrationXMLElement
extends ResourceXMLElement,
ResourceRegistration {

    public static class ResourcePropertyAttributesXMLContentWriter
    implements XMLContentWriter<Property> {
        private final XMLContentWriter<ModelNode> attributesWriter;

        ResourcePropertyAttributesXMLContentWriter(Collection<AttributeDefinition> attributes, AttributeDefinitionXMLConfiguration configuration) {
            this.attributesWriter = new ResourceXMLContainer.ResourceAttributesXMLContentWriter(attributes, configuration);
        }

        public void writeContent(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
            this.attributesWriter.writeContent(writer, property.getValue());
        }

        @Override
        public boolean isEmpty(Property property) {
            return this.attributesWriter.isEmpty(property.getValue());
        }
    }

    public static class DefaultResourceRegistrationXMLElement
    extends XMLElement.DefaultXMLElement<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode>
    implements ResourceRegistrationXMLElement {
        private final PathElement path;

        DefaultResourceRegistrationXMLElement(ResourceRegistration registration, QName name, XMLCardinality cardinality, XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> reader, XMLContentWriter<ModelNode> writer) {
            super(name, cardinality, reader, writer, registration.getStability());
            this.path = registration.getPathElement();
        }

        @Override
        public PathElement getPathElement() {
            return this.path;
        }

        @Override
        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ResourceRegistrationXMLElement)) {
                return false;
            }
            ResourceRegistrationXMLElement element = (ResourceRegistrationXMLElement)object;
            return this.path.equals(element.getPathElement());
        }

        @Override
        public String toString() {
            return String.format("<xs:element name=\"%s\" type=\"%s\" %s/>", this.getName().getLocalPart(), this.path.isWildcard() ? this.path.getKey() : this.path.getValue(), XMLCardinality.toString(this.getCardinality()));
        }
    }

    public static abstract class AbstractBuilder<T extends ResourceRegistrationXMLElement, B extends Builder<T, B>>
    extends ResourceXMLContainer.AbstractBuilder<T, B>
    implements Builder<T, B> {
        private final ResourceRegistration registration;
        private volatile BiConsumer<Map<PathAddress, ModelNode>, PathAddress> operationTransformation = Functions.discardingBiConsumer();
        private volatile Function<PathElement, QName> elementName;
        private volatile Optional<PathElement> operationKey = Optional.empty();

        protected AbstractBuilder(ResourceRegistration registration, FeatureRegistry registry, QNameResolver resolver) {
            super(registry, resolver, AttributeDefinitionXMLConfiguration.of(resolver));
            this.registration = registration;
            boolean wildcard = this.registration.getPathElement().isWildcard();
            ResourceXMLElementLocalName localName = wildcard ? ResourceXMLElementLocalName.KEY : ResourceXMLElementLocalName.VALUE;
            this.elementName = localName.andThen(resolver::resolve);
        }

        @Override
        public B withCardinality(XMLCardinality cardinality) {
            if (cardinality.isRepeatable() && !this.registration.getPathElement().isWildcard()) {
                throw ControllerLogger.ROOT_LOGGER.illegalXMLCardinality(cardinality);
            }
            return (B)((Builder)super.withCardinality(cardinality));
        }

        @Override
        public B withOperationKey(PathElement operationKey) {
            this.operationKey = Optional.of(operationKey);
            return (B)((Builder)this.builder());
        }

        @Override
        public B withElementLocalName(String localName) {
            return this.withElementName(this.resolve(localName));
        }

        @Override
        public B withElementLocalName(Function<PathElement, String> localName) {
            return this.withElementName(localName.andThen(this::resolve));
        }

        @Override
        public B withElementName(Function<PathElement, QName> elementName) {
            this.elementName = elementName;
            return (B)((Builder)this.builder());
        }

        @Override
        public B withOperationTransformation(BiConsumer<Map<PathAddress, ModelNode>, PathAddress> transformation) {
            this.operationTransformation = this.operationTransformation.andThen(transformation);
            return (B)((Builder)this.builder());
        }

        ResourceRegistration getResourceRegistration() {
            return this.registration;
        }

        BiConsumer<Map<PathAddress, ModelNode>, PathAddress> getOperationTransformation() {
            return this.operationTransformation;
        }

        Function<PathElement, QName> getElementName() {
            return this.elementName;
        }

        Optional<PathElement> getOperationKey() {
            return this.operationKey;
        }
    }

    public static interface Builder<T extends ResourceRegistrationXMLElement, B extends Builder<T, B>>
    extends ResourceXMLContainer.Builder<T, B> {
        public B withOperationKey(PathElement var1);

        public B withElementLocalName(String var1);

        public B withElementLocalName(Function<PathElement, String> var1);

        default public B withElementName(final QName name) {
            return this.withElementName(new Function<PathElement, QName>(){

                @Override
                public QName apply(PathElement path) {
                    return name;
                }
            });
        }

        public B withElementName(Function<PathElement, QName> var1);

        default public B thenDiscardOperation() {
            BiConsumer<Map<PathAddress, ModelNode>, PathAddress> remove = Map::remove;
            return this.withOperationTransformation(remove);
        }

        default public B withOperationTransformation(final UnaryOperator<ModelNode> transformer) {
            return this.withOperationTransformation(new BiFunction<PathAddress, ModelNode, ModelNode>(){

                @Override
                public ModelNode apply(PathAddress key, ModelNode operation) {
                    return (ModelNode)transformer.apply(operation);
                }
            });
        }

        default public B withOperationTransformation(final BiFunction<PathAddress, ModelNode, ModelNode> remappingFunction) {
            return this.withOperationTransformation(new BiConsumer<Map<PathAddress, ModelNode>, PathAddress>(){

                @Override
                public void accept(Map<PathAddress, ModelNode> operations, PathAddress operationKey) {
                    operations.compute(operationKey, remappingFunction);
                }
            });
        }

        public B withOperationTransformation(BiConsumer<Map<PathAddress, ModelNode>, PathAddress> var1);

        default public B withDefaultValues(final Map<AttributeDefinition, ModelNode> overrides) {
            return this.withOperationTransformation(new UnaryOperator<ModelNode>(){

                @Override
                public ModelNode apply(ModelNode operation) {
                    for (Map.Entry override : overrides.entrySet()) {
                        String attributeName = ((AttributeDefinition)override.getKey()).getName();
                        if (operation.hasDefined(attributeName)) continue;
                        operation.get(attributeName).set((ModelNode)override.getValue());
                    }
                    return operation;
                }
            });
        }
    }
}

