/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ParameterCorrector;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class ModuleIdentifierUtil {
    public static final ParameterCorrector MODULE_NAME_CORRECTOR = new ParameterCorrector(){

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            String corrected;
            String orig;
            if (ModelType.STRING.equals((Object)newValue.getType()) && !(orig = newValue.asString()).equals(corrected = ModuleIdentifierUtil.canonicalModuleIdentifier(orig))) {
                newValue.set(corrected);
            }
            return newValue;
        }
    };

    public static String canonicalModuleIdentifier(String moduleSpec) {
        int c;
        if (moduleSpec == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleSpec.isEmpty()) {
            throw new IllegalArgumentException("Empty module specification");
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < moduleSpec.length()) {
            c = moduleSpec.codePointAt(i);
            if (c == 92) {
                b.appendCodePoint(c);
                i = moduleSpec.offsetByCodePoints(i, 1);
                if (i >= moduleSpec.length()) {
                    throw new IllegalArgumentException("Name has an unterminated escape");
                }
                c = moduleSpec.codePointAt(i);
                b.appendCodePoint(c);
            } else {
                if (c == 58) {
                    if ((i = moduleSpec.offsetByCodePoints(i, 1)) != moduleSpec.length()) break;
                    throw new IllegalArgumentException("Slot is empty");
                }
                b.appendCodePoint(c);
            }
            i = moduleSpec.offsetByCodePoints(i, 1);
        }
        String name = b.toString();
        b.setLength(0);
        if (i >= moduleSpec.length()) {
            return ModuleIdentifierUtil.canonicalModuleIdentifier(name, null);
        }
        do {
            c = moduleSpec.codePointAt(i);
            b.appendCodePoint(c);
        } while ((i = moduleSpec.offsetByCodePoints(i, 1)) < moduleSpec.length());
        return ModuleIdentifierUtil.canonicalModuleIdentifier(name, b.toString());
    }

    public static String canonicalModuleIdentifier(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        String escaped = ModuleIdentifierUtil.escapeName(name);
        return slot == null || "main".equals(slot) ? escaped : escaped + ":" + ModuleIdentifierUtil.escapeSlot(slot);
    }

    private static String escapeName(String name) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < name.length()) {
            int c = name.codePointAt(i);
            switch (c) {
                case 58: 
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = name.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : name;
    }

    private static String escapeSlot(String slot) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < slot.length()) {
            int c = slot.codePointAt(i);
            switch (c) {
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = slot.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : slot;
    }
}

