/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller._private.OperationCancellationException;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.access.rbac.UnknowRoleException;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.NodeId;

public class ControllerLogger_$logger
extends DelegatingBasicLogger
implements ControllerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ControllerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ControllerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotResolveAddress(String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotResolveAddress$str(), (Object)address);
    }

    protected String cannotResolveAddress$str() {
        return "WFLYCTL0001: Cannot resolve address %s, so cannot match it to any InetAddress";
    }

    @Override
    public final void errorBootingContainer(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorBootingContainer0$str(), new Object[0]);
    }

    protected String errorBootingContainer0$str() {
        return "WFLYCTL0002: Error booting the container";
    }

    @Override
    public final void errorBootingContainer(Throwable cause, long bootStackSize, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorBootingContainer2$str(), (Object)bootStackSize, (Object)name);
    }

    protected String errorBootingContainer2$str() {
        return "WFLYCTL0003: Error booting the container due to insufficient stack space for the thread used to execute boot operations. The thread was configured with a stack size of [%1$d]. Setting system property %2$s to a value higher than [%1$d] may resolve this problem.";
    }

    @Override
    public final void errorRevertingOperation(Throwable cause, String className, String op, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorRevertingOperation$str(), (Object)className, (Object)op, (Object)address);
    }

    protected String errorRevertingOperation$str() {
        return "WFLYCTL0004: %s caught exception attempting to revert operation %s at address %s";
    }

    @Override
    public final void failedExecutingOperation(Throwable cause, ModelNode op, PathAddress path) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedExecutingOperation$str(), (Object)op, (Object)path);
    }

    protected String failedExecutingOperation$str() {
        return "WFLYCTL0005: Failed executing operation %s at address %s";
    }

    @Override
    public final void failedSubsystemBootOperations(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedSubsystemBootOperations$str(), (Object)name);
    }

    protected String failedSubsystemBootOperations$str() {
        return "WFLYCTL0006: Failed executing subsystem %s boot operations";
    }

    @Override
    public final void failedToCloseResource(Throwable cause, Closeable closeable) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), (Object)closeable);
    }

    protected String failedToCloseResource$str() {
        return "WFLYCTL0007: Failed to close resource %s";
    }

    @Override
    public final void failedToCloseResource(Throwable cause, XMLStreamWriter writer) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), (Object)writer);
    }

    @Override
    public final void failedToCloseResource(Throwable cause, XMLStreamReader reader) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), (Object)reader);
    }

    @Override
    public final void failedToPersistConfigurationChange(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToPersistConfigurationChange0$str(), new Object[0]);
    }

    protected String failedToPersistConfigurationChange0$str() {
        return "WFLYCTL0008: Failed to persist configuration change";
    }

    @Override
    public final void failedToStoreConfiguration(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStoreConfiguration$str(), (Object)name);
    }

    protected String failedToStoreConfiguration$str() {
        return "WFLYCTL0009: Failed to store configuration to %s";
    }

    @Override
    public final void invalidSystemPropertyValue(String value, String name, int defaultValue) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidSystemPropertyValue$str(), (Object)value, (Object)name, (Object)defaultValue);
    }

    protected String invalidSystemPropertyValue$str() {
        return "WFLYCTL0010: Invalid value %s for system property %s -- using default value [%d]";
    }

    @Override
    public final void invalidWildcardAddress(String address, String inetAddress, String anyAddress) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidWildcardAddress$str(), (Object)address, (Object)inetAddress, (Object)anyAddress);
    }

    protected String invalidWildcardAddress$str() {
        return "WFLYCTL0011: Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration element to specify that an interface should use a wildcard address; use '%3$s'";
    }

    @Override
    public final void operationFailed(Throwable cause, ModelNode op, ModelNode opAddress) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.operationFailed2$str(), (Object)op, (Object)opAddress);
    }

    protected String operationFailed2$str() {
        return "WFLYCTL0013: Operation (%s) failed - address: (%s)";
    }

    @Override
    public final void operationFailed(ModelNode op, ModelNode opAddress, ModelNode failureDescription) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.operationFailed3$str(), (Object)op, (Object)opAddress, (Object)failureDescription);
    }

    protected String operationFailed3$str() {
        return "WFLYCTL0013: Operation (%s) failed - address: (%s) - failure description: %s";
    }

    @Override
    public final void operationFailed(ModelNode op, ModelNode opAddress, ModelNode failureDescription, String emptyString) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.operationFailed4$str(), new Object[]{op, opAddress, failureDescription, emptyString});
    }

    protected String operationFailed4$str() {
        return "WFLYCTL0013: Operation (%s) failed - address: (%s) - failure description: %s%s";
    }

    @Override
    public final void wildcardAddressDetected() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.wildcardAddressDetected$str(), new Object[0]);
    }

    protected String wildcardAddressDetected$str() {
        return "WFLYCTL0015: Wildcard address detected - will ignore other interface criteria.";
    }

    @Override
    public final void noFinalProxyOutcomeReceived(ModelNode op, ModelNode opAddress, ModelNode proxyAddress) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noFinalProxyOutcomeReceived$str(), (Object)op, (Object)opAddress, (Object)proxyAddress);
    }

    protected String noFinalProxyOutcomeReceived$str() {
        return "WFLYCTL0016: Received no final outcome response for operation %s with address %s from remote process at address %s. The result of this operation will only include the remote process' preliminary response to the request.";
    }

    @Override
    public final void operationFailedOnClientError(ModelNode op, ModelNode opAddress, ModelNode failureDescription) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.operationFailedOnClientError$str(), (Object)op, (Object)opAddress, (Object)failureDescription);
    }

    protected String operationFailedOnClientError$str() {
        return "WFLYCTL0017: Operation (%s) failed - address: (%s) - failure description: %s";
    }

    @Override
    public final void gracefulManagementChannelHandlerShutdownTimedOut(int timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.gracefulManagementChannelHandlerShutdownTimedOut$str(), (Object)timeout);
    }

    protected String gracefulManagementChannelHandlerShutdownTimedOut$str() {
        return "WFLYCTL0019: Graceful shutdown of the handler used for native management requests did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding";
    }

    @Override
    public final void gracefulManagementChannelHandlerShutdownFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.gracefulManagementChannelHandlerShutdownFailed$str(), new Object[0]);
    }

    protected String gracefulManagementChannelHandlerShutdownFailed$str() {
        return "WFLYCTL0020: Graceful shutdown of the handler used for native management requests failed but shutdown of the underlying communication channel is proceeding";
    }

    @Override
    public final void invalidChannelCloseTimeout(NumberFormatException cause, String propertyName, String propValue) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.invalidChannelCloseTimeout$str(), (Object)propertyName, (Object)propValue);
    }

    protected String invalidChannelCloseTimeout$str() {
        return "WFLYCTL0021: Invalid value '%s' for system property '%s' -- value must be convertible into an int";
    }

    @Override
    public final void multipleMatchingAddresses(String interfaceName, Set<InetAddress> addresses, Set<String> nis, InetAddress inetAddress, String networkInterface) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleMatchingAddresses5$str(), new Object[]{interfaceName, addresses, nis, inetAddress, networkInterface});
    }

    protected String multipleMatchingAddresses5$str() {
        return "WFLYCTL0022: Multiple addresses or network interfaces matched the selection criteria for interface '%s'. Matching addresses: %s.  Matching network interfaces: %s. The interface will use address %s and network interface %s.";
    }

    @Override
    public final void multipleMatchingAddresses(String toMatch, Set<InetAddress> addresses, Set<String> nis) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleMatchingAddresses3$str(), (Object)toMatch, addresses, nis);
    }

    protected String multipleMatchingAddresses3$str() {
        return "WFLYCTL0023: Value '%s' for interface selection criteria 'inet-address' is ambiguous, as more than one address or network interface available on the machine matches it. Because of this ambiguity, no address will be selected as a match. Matching addresses: %s.  Matching network interfaces: %s.";
    }

    @Override
    public final void cannotReadTargetDefinition(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.cannotReadTargetDefinition$str(), new Object[0]);
    }

    protected String cannotReadTargetDefinition$str() {
        return "WFLYCTL0024: Could not read target definition!";
    }

    @Override
    public final void interruptedWaitingStability(String operation, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedWaitingStability$str(), (Object)operation, (Object)address);
    }

    protected String interruptedWaitingStability$str() {
        return "WFLYCTL0027: Operation was interrupted before service container stability could be reached. Process should be restarted. Step that first updated the service container was '%s' at address '%s'";
    }

    @Override
    public final void attributeDeprecated(String name, String address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.attributeDeprecated$str(), (Object)name, (Object)address);
    }

    protected String attributeDeprecated$str() {
        return "WFLYCTL0028: Attribute '%s' in the resource at address '%s' is deprecated, and may be removed in a future version. See the attribute description in the output of the read-resource-description operation to learn more about the deprecation.";
    }

    @Override
    public final void cannotDeleteTempFile(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotDeleteTempFile$str(), (Object)name);
    }

    protected String cannotDeleteTempFile$str() {
        return "WFLYCTL0029: Cannot delete temp file %s, will be deleted on exit";
    }

    protected String noSuchResourceType$str() {
        return "WFLYCTL0030: No resource definition is registered for address %s";
    }

    @Override
    public final String noSuchResourceType(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.noSuchResourceType$str(), address);
    }

    protected String noHandlerForOperation$str() {
        return "WFLYCTL0031: No operation named '%s' exists at address %s";
    }

    @Override
    public final String noHandlerForOperation(String operationName, PathAddress address) {
        return String.format(this.getLoggingLocale(), this.noHandlerForOperation$str(), operationName, address);
    }

    @Override
    public final void transformationWarnings(String hostName, Set<String> problems) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.transformationWarnings$str(), (Object)hostName, problems);
    }

    protected String transformationWarnings$str() {
        return "WFLYCTL0032: There were problems during the transformation process for target host: '%s' %nProblems found: %n%s";
    }

    @Override
    public final void extensionDeprecated(String extensionName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.extensionDeprecated$str(), (Object)extensionName);
    }

    protected String extensionDeprecated$str() {
        return "WFLYCTL0033: Extension '%s' is deprecated and may not be supported in future versions";
    }

    @Override
    public final void ignoringUnsupportedLegacyExtension(List<String> subsystemNames, String extensionName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ignoringUnsupportedLegacyExtension$str(), subsystemNames, (Object)extensionName);
    }

    protected String ignoringUnsupportedLegacyExtension$str() {
        return "WFLYCTL0034: Subsystems %s provided by legacy extension '%s' are not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain. On this server the extension will not register any subsystems, and future attempts to create or address subsystem resources on this server will result in failure.";
    }

    @Override
    public final void failedToUpdateAuditLog(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToUpdateAuditLog$str(), new Object[0]);
    }

    protected String failedToUpdateAuditLog$str() {
        return "WFLYCTL0035: Update of the management operation audit log failed";
    }

    @Override
    public final void disablingLoggingDueToFailures(short failureCount) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.disablingLoggingDueToFailures$str(), (Object)failureCount);
    }

    protected String disablingLoggingDueToFailures$str() {
        return "WFLYCTL0036: [%d] consecutive management operation audit logging failures have occurred; disabling audit logging";
    }

    @Override
    public final void logHandlerWriteFailed(Throwable t, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.logHandlerWriteFailed$str(), (Object)name);
    }

    protected String logHandlerWriteFailed$str() {
        return "WFLYCTL0037: Update of the management operation audit log failed in handler '%s'";
    }

    @Override
    public final void disablingLogHandlerDueToFailures(int failureCount, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.disablingLogHandlerDueToFailures$str(), (Object)failureCount, (Object)name);
    }

    protected String disablingLogHandlerDueToFailures$str() {
        return "WFLYCTL0038: [%d] consecutive management operation audit logging failures have occurred in handler '%s'; disabling this handler for audit logging";
    }

    protected String alreadyDefined$str() {
        return "WFLYCTL0039: %s already defined";
    }

    @Override
    public final XMLStreamException alreadyDefined(String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.alreadyDefined$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String alreadyDeclared4$str() {
        return "WFLYCTL0041: A %s %s already declared has already been declared in %s %s";
    }

    @Override
    public final XMLStreamException alreadyDeclared(String name, String value, String parentName, String parentValue, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.alreadyDeclared4$str(), name, value, parentName, parentValue), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String alreadyDeclared5$str() {
        return "WFLYCTL0042: A %s or a %s %s already declared has already been declared in %s %s";
    }

    @Override
    public final XMLStreamException alreadyDeclared(String name1, String name2, String value, String parentName, String parentValue, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.alreadyDeclared5$str(), name1, name2, value, parentName, parentValue), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String alreadyRegistered$str() {
        return "WFLYCTL0043: An %s named '%s' is already registered at location '%s'";
    }

    @Override
    public final IllegalArgumentException alreadyRegistered(String type, String name, String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.alreadyRegistered$str(), type, name, location));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousConfigurationFiles$str() {
        return "WFLYCTL0044: Ambiguous configuration file name '%s' as there are multiple files in %s that end in %s";
    }

    @Override
    public final IllegalStateException ambiguousConfigurationFiles(String backupType, File searchDir, String suffix) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ambiguousConfigurationFiles$str(), backupType, searchDir, suffix));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousName$str() {
        return "WFLYCTL0045: Ambiguous name '%s' in %s: %s";
    }

    @Override
    public final IllegalArgumentException ambiguousName(String prefix, String dir, Collection<String> files) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.ambiguousName$str(), prefix, dir, files));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeNotWritable$str() {
        return "WFLYCTL0048: Attribute %s is not writable";
    }

    @Override
    public final String attributeNotWritable(String attributeName) {
        return String.format(this.getLoggingLocale(), this.attributeNotWritable$str(), attributeName);
    }

    protected String cannotDetermineDefaultName$str() {
        return "WFLYCTL0050: Unable to determine a default name based on the local host name";
    }

    @Override
    public final RuntimeException cannotDetermineDefaultName(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotDetermineDefaultName$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreate$str() {
        return "WFLYCTL0051: Could not create %s";
    }

    @Override
    public final IllegalStateException cannotCreate(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreate$str(), path));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDelete$str() {
        return "WFLYCTL0052: Could not delete %s";
    }

    @Override
    public final IllegalStateException cannotDelete(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotDelete$str(), file));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRegisterSubmodelWithNullPath$str() {
        return "WFLYCTL0053: Cannot register submodels with a null PathElement";
    }

    @Override
    public final IllegalArgumentException cannotRegisterSubmodelWithNullPath() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRegisterSubmodelWithNullPath$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemove$str() {
        return "WFLYCTL0055: Cannot remove %s";
    }

    @Override
    public final OperationFailedRuntimeException cannotRemove(String name) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.cannotRemove$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotRename(IOException ioe, Path fromPath, Path toPath) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ioe, this.cannotRename$str(), (Object)fromPath, (Object)toPath);
    }

    protected String cannotRename$str() {
        return "WFLYCTL0056: Could not rename %s to %s";
    }

    protected String cannotWriteTo$str() {
        return "WFLYCTL0057: Cannot write to %s";
    }

    @Override
    public final IllegalArgumentException cannotWriteTo(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotWriteTo$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String childAlreadyDeclared$str() {
        return "WFLYCTL0058: Child %s of element %s already declared";
    }

    @Override
    public final XMLStreamException childAlreadyDeclared(String childName, String parentName, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.childAlreadyDeclared$str(), childName, parentName), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canonicalBootFileNotFound$str() {
        return "WFLYCTL0059: Could not get canonical file for boot file: %s";
    }

    @Override
    public final RuntimeException canonicalBootFileNotFound(Throwable cause, File file) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.canonicalBootFileNotFound$str(), file), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canonicalMainFileNotFound$str() {
        return "WFLYCTL0060: Could not get canonical file for main file: %s";
    }

    @Override
    public final IllegalStateException canonicalMainFileNotFound(Throwable cause, File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.canonicalMainFileNotFound$str(), file), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String compositeOperationFailed$str() {
        return "WFLYCTL0062: Composite operation failed and was rolled back. Steps that failed:";
    }

    @Override
    public final String compositeOperationFailed() {
        return String.format(this.getLoggingLocale(), this.compositeOperationFailed$str(), new Object[0]);
    }

    protected String compositeOperationRolledBack$str() {
        return "WFLYCTL0063: Composite operation was rolled back";
    }

    @Override
    public final String compositeOperationRolledBack() {
        return String.format(this.getLoggingLocale(), this.compositeOperationRolledBack$str(), new Object[0]);
    }

    protected String configurationFileNameNotAllowed$str() {
        return "WFLYCTL0064: Configuration files whose complete name is %s are not allowed";
    }

    @Override
    public final IllegalArgumentException configurationFileNameNotAllowed(String backupType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.configurationFileNameNotAllowed$str(), backupType));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configurationFileNotFound$str() {
        return "WFLYCTL0065: No configuration file ending in %s found in %s";
    }

    @Override
    public final IllegalStateException configurationFileNotFound(String suffix, File dir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configurationFileNotFound$str(), suffix, dir));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directoryNotFound$str() {
        return "WFLYCTL0066: No directory %s was found";
    }

    @Override
    public final IllegalArgumentException directoryNotFound(String pathName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.directoryNotFound$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainControllerMustBeDeclared$str() {
        return "WFLYCTL0067: Either a %s or %s domain controller configuration must be declared.";
    }

    @Override
    public final XMLStreamException domainControllerMustBeDeclared(String remoteName, String localName, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.domainControllerMustBeDeclared$str(), remoteName, localName), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAttribute$str() {
        return "WFLYCTL0068: An attribute named '%s' has already been declared";
    }

    @Override
    public final XMLStreamException duplicateAttribute(String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateAttribute$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateDeclaration1$str() {
        return "WFLYCTL0069: Duplicate %s declaration";
    }

    @Override
    public final XMLStreamException duplicateDeclaration(String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateDeclaration1$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateDeclaration2$str() {
        return "WFLYCTL0070: Duplicate %s declaration %s";
    }

    @Override
    public final XMLStreamException duplicateDeclaration(String name, String value, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateDeclaration2$str(), name, value), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateElement$str() {
        return "WFLYCTL0071: Duplicate path element '%s' found";
    }

    @Override
    public final OperationFailedRuntimeException duplicateElement(String name) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.duplicateElement$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateInterfaceDeclaration$str() {
        return "WFLYCTL0072: Duplicate interface declaration";
    }

    @Override
    public final XMLStreamException duplicateInterfaceDeclaration(Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateInterfaceDeclaration$str(), new Object[0]), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateNamedElement$str() {
        return "WFLYCTL0073: An element of this type named '%s' has already been declared";
    }

    @Override
    public final XMLStreamException duplicateNamedElement(String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateNamedElement$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateResource$str() {
        return "WFLYCTL0075: Duplicate resource %s";
    }

    @Override
    public final IllegalStateException duplicateResource(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateResource$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateResourceType$str() {
        return "WFLYCTL0076: Duplicate resource type %s";
    }

    @Override
    public final IllegalStateException duplicateResourceType(String type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateResourceType$str(), type));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedInitializingModule$str() {
        return "WFLYCTL0079: Failed initializing module %s";
    }

    @Override
    public final RuntimeException failedInitializingModule(Throwable cause, String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedInitializingModule$str(), name), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedServices$str() {
        return "WFLYCTL0080: Failed services";
    }

    @Override
    public final String failedServices() {
        return String.format(this.getLoggingLocale(), this.failedServices$str(), new Object[0]);
    }

    protected String failedToBackup$str() {
        return "WFLYCTL0081: Failed to back up %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToBackup(Throwable cause, File file) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToBackup$str(), file), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreateConfigurationBackup$str() {
        return "WFLYCTL0082: Failed to create backup copies of configuration file %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToCreateConfigurationBackup(Throwable cause, File file) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToCreateConfigurationBackup$str(), file), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadModule0$str() {
        return "WFLYCTL0083: Failed to load module";
    }

    @Override
    public final XMLStreamException failedToLoadModule(Throwable cause) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.failedToLoadModule0$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadModule1$str() {
        return "WFLYCTL0083: Failed to load module %s";
    }

    @Override
    public final XMLStreamException failedToLoadModule(Throwable cause, String name) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.failedToLoadModule1$str(), name), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToMarshalConfiguration$str() {
        return "WFLYCTL0084: Failed to marshal configuration";
    }

    @Override
    public final ConfigurationPersistenceException failedToMarshalConfiguration(Throwable cause) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToMarshalConfiguration$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParseConfiguration$str() {
        return "WFLYCTL0085: Failed to parse configuration";
    }

    @Override
    public final ConfigurationPersistenceException failedToParseConfiguration(Throwable cause) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToParseConfiguration$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToPersistConfigurationChange1$str() {
        return "WFLYCTL0086: Failed to persist configuration change: %s";
    }

    @Override
    public final String failedToPersistConfigurationChange(String cause) {
        return String.format(this.getLoggingLocale(), this.failedToPersistConfigurationChange1$str(), cause);
    }

    protected String failedToTakeSnapshot$str() {
        return "WFLYCTL0088: Failed to take a snapshot of %s to %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToTakeSnapshot(Throwable cause, File file, File snapshot) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToTakeSnapshot$str(), file, snapshot), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToWriteConfiguration$str() {
        return "WFLYCTL0089: Failed to write configuration";
    }

    @Override
    public final ConfigurationPersistenceException failedToWriteConfiguration(Throwable cause) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToWriteConfiguration$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileNotFound$str() {
        return "WFLYCTL0090: %s does not exist";
    }

    @Override
    public final IllegalArgumentException fileNotFound(String path1) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.fileNotFound$str(), path1));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileNotFoundWithPrefix$str() {
        return "WFLYCTL0091: No files beginning with '%s' found in %s";
    }

    @Override
    public final IllegalArgumentException fileNotFoundWithPrefix(String prefix, String dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.fileNotFoundWithPrefix$str(), prefix, dir));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fullServerBootRequired$str() {
        return "WFLYCTL0092: %s cannot be used except in a full server boot";
    }

    @Override
    public final IllegalStateException fullServerBootRequired(Class<?> clazz) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.fullServerBootRequired$str(), clazz));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalInterfaceCriteria$str() {
        return "WFLYCTL0094: Illegal interface criteria type %s; must be %s";
    }

    @Override
    public final String illegalInterfaceCriteria(ModelType invalidType, ModelType validType) {
        return String.format(this.getLoggingLocale(), this.illegalInterfaceCriteria$str(), invalidType, validType);
    }

    protected String illegalValueForInterfaceCriteria$str() {
        return "WFLYCTL0095: Illegal value %s for interface criteria %s; must be %s";
    }

    @Override
    public final String illegalValueForInterfaceCriteria(ModelType valueType, String id, ModelType validType) {
        return String.format(this.getLoggingLocale(), this.illegalValueForInterfaceCriteria$str(), valueType, id, validType);
    }

    protected String immutableResource$str() {
        return "WFLYCTL0096: Resource is immutable";
    }

    @Override
    public final UnsupportedOperationException immutableResource() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.immutableResource$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectType$str() {
        return "WFLYCTL0097: Wrong type for '%s'. Expected %s but was %s";
    }

    @Override
    public final OperationFailedException incorrectType(String name, Collection<ModelType> validTypes, ModelType invalidType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.incorrectType$str(), name, validTypes, invalidType));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalid1$str() {
        return "WFLYCTL0099: %s is invalid";
    }

    @Override
    public final String invalid(String name) {
        return String.format(this.getLoggingLocale(), this.invalid1$str(), name);
    }

    protected String invalid2$str() {
        return "WFLYCTL0100: %d is not a valid %s";
    }

    @Override
    public final XMLStreamException invalid(Throwable cause, int value, String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalid2$str(), value, name), location, cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAddress$str() {
        return "WFLYCTL0101: Invalid address %s (%s)";
    }

    @Override
    public final String invalidAddress(String address, String msg) {
        return String.format(this.getLoggingLocale(), this.invalidAddress$str(), address, msg);
    }

    protected String invalidAddressMaskValue$str() {
        return "WFLYCTL0102: Invalid 'value' %s -- must be of the form address/mask";
    }

    @Override
    public final String invalidAddressMaskValue(String value) {
        return String.format(this.getLoggingLocale(), this.invalidAddressMaskValue$str(), value);
    }

    protected String invalidAddressMask$str() {
        return "WFLYCTL0103: Invalid mask %s (%s)";
    }

    @Override
    public final String invalidAddressMask(String mask, String msg) {
        return String.format(this.getLoggingLocale(), this.invalidAddressMask$str(), mask, msg);
    }

    protected String invalidAddressValue$str() {
        return "WFLYCTL0104: Invalid address %s (%s)";
    }

    @Override
    public final String invalidAddressValue(String value, String msg) {
        return String.format(this.getLoggingLocale(), this.invalidAddressValue$str(), value, msg);
    }

    protected String invalidAttributeCombo$str() {
        return "WFLYCTL0105: %s is invalid in combination with %s";
    }

    @Override
    public final String invalidAttributeCombo(String attributeName, StringBuilder combos) {
        return String.format(this.getLoggingLocale(), this.invalidAttributeCombo$str(), attributeName, combos);
    }

    protected String invalidAttributeValue2$str() {
        return "WFLYCTL0106: Invalid value '%s' for attribute '%s'";
    }

    @Override
    public final XMLStreamException invalidAttributeValue(String value, QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidAttributeValue2$str(), value, name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidInterfaceCriteriaPattern$str() {
        return "WFLYCTL0109: Invalid pattern %s for interface criteria %s";
    }

    @Override
    public final String invalidInterfaceCriteriaPattern(String pattern, String name) {
        return String.format(this.getLoggingLocale(), this.invalidInterfaceCriteriaPattern$str(), pattern, name);
    }

    protected String invalidPathElementKey$str() {
        return "WFLYCTL0110: Invalid resource address element '%s'. The key '%s' is not valid for an element in a resource address.";
    }

    @Override
    public final String invalidPathElementKey(String element, String key) {
        return String.format(this.getLoggingLocale(), this.invalidPathElementKey$str(), element, key);
    }

    protected String invalidLoadFactor$str() {
        return "WFLYCTL0111: Load factor must be greater than 0 and less than or equal to 1";
    }

    @Override
    public final IllegalArgumentException invalidLoadFactor() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidLoadFactor$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMaxLength$str() {
        return "WFLYCTL0112: '%s' is an invalid value for parameter %s. Values must have a maximum length of %d characters";
    }

    @Override
    public final String invalidMaxLength(String value, String name, int length) {
        return String.format(this.getLoggingLocale(), this.invalidMaxLength$str(), value, name, length);
    }

    protected String invalidMinLength$str() {
        return "WFLYCTL0113: '%s' is an invalid value for parameter %s. Values must have a minimum length of %d characters";
    }

    @Override
    public final String invalidMinLength(String value, String name, int length) {
        return String.format(this.getLoggingLocale(), this.invalidMinLength$str(), value, name, length);
    }

    protected String invalidMaxSize$str() {
        return "WFLYCTL0114: [%d] is an invalid size for parameter %s. A maximum length of [%d] is required";
    }

    @Override
    public final String invalidMaxSize(int size, String name, int maxSize) {
        return String.format(this.getLoggingLocale(), this.invalidMaxSize$str(), size, name, maxSize);
    }

    protected String invalidMinSize$str() {
        return "WFLYCTL0115: [%d] is an invalid size for parameter %s. A minimum length of [%d] is required";
    }

    @Override
    public final String invalidMinSize(int size, String name, int minSize) {
        return String.format(this.getLoggingLocale(), this.invalidMinSize$str(), size, name, minSize);
    }

    protected String invalidMaxValue$str() {
        return "WFLYCTL0116: %d is an invalid value for parameter %s. A maximum value of %d is required";
    }

    @Override
    public final String invalidMaxValue(int value, String name, int maxValue) {
        return String.format(this.getLoggingLocale(), this.invalidMaxValue$str(), value, name, maxValue);
    }

    @Override
    public final String invalidMaxValue(long value, String name, long maxValue) {
        return String.format(this.getLoggingLocale(), this.invalidMaxValue$str(), value, name, maxValue);
    }

    protected String invalidMinValue$str() {
        return "WFLYCTL0117: %d is an invalid value for parameter %s. A minimum value of %d is required";
    }

    @Override
    public final String invalidMinValue(int value, String name, int minValue) {
        return String.format(this.getLoggingLocale(), this.invalidMinValue$str(), value, name, minValue);
    }

    @Override
    public final String invalidMinValue(long value, String name, long minValue) {
        return String.format(this.getLoggingLocale(), this.invalidMinValue$str(), value, name, minValue);
    }

    protected String invalidModificationAfterCompletedStep$str() {
        return "WFLYCTL0118: Invalid modification after completed step";
    }

    @Override
    public final IllegalStateException invalidModificationAfterCompletedStep() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidModificationAfterCompletedStep$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMulticastAddress$str() {
        return "WFLYCTL0119: Value %s for attribute %s is not a valid multicast address";
    }

    @Override
    public final OperationFailedException invalidMulticastAddress(String value, String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidMulticastAddress$str(), value, name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidOutboundSocketBinding$str() {
        return "WFLYCTL0120: An outbound socket binding: %s cannot have both %s as well as a %s at the same time";
    }

    @Override
    public final XMLStreamException invalidOutboundSocketBinding(String name, String localTag, String remoteTag, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidOutboundSocketBinding$str(), name, localTag, remoteTag), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParameterValue$str() {
        return "WFLYCTL0121: %s is not a valid value for parameter %s -- must be one of %s";
    }

    @Override
    public final IllegalArgumentException invalidParameterValue(OperationEntry.Flag flag, String name, Collection<OperationEntry.Flag> validFlags) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidParameterValue$str(), new Object[]{flag, name, validFlags}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSha1Value$str() {
        return "WFLYCTL0122: Value %s for attribute %s does not represent a properly hex-encoded SHA1 hash";
    }

    @Override
    public final XMLStreamException invalidSha1Value(Throwable cause, String value, String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidSha1Value$str(), value, name), location, cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStage$str() {
        return "WFLYCTL0123: Stage %s is not valid for context process type %s";
    }

    @Override
    public final IllegalStateException invalidStage(OperationContext.Stage stage, ProcessType processType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidStage$str(), new Object[]{stage, processType}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStepStage$str() {
        return "WFLYCTL0124: Invalid step stage specified";
    }

    @Override
    public final IllegalArgumentException invalidStepStage() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidStepStage$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTableSize$str() {
        return "WFLYCTL0126: Can not have a negative size table!";
    }

    @Override
    public final IllegalArgumentException invalidTableSize() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTableSize$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidType$str() {
        return "WFLYCTL0127: Invalid type %s";
    }

    @Override
    public final String invalidType(ModelType type) {
        return String.format(this.getLoggingLocale(), this.invalidType$str(), type);
    }

    protected String invalidPathElementValue$str() {
        return "WFLYCTL0128: Invalid resource address element '%s'. The value '%s' is not valid for an element in a resource address. Character '%s' is not allowed.";
    }

    @Override
    public final String invalidPathElementValue(String element, String value, Character character) {
        return String.format(this.getLoggingLocale(), this.invalidPathElementValue$str(), element, value, character);
    }

    protected String invalidValue$str() {
        return "WFLYCTL0129: Invalid value %s for %s; legal values are %s";
    }

    @Override
    public final String invalidValue(String value, String name, Collection<?> validValues) {
        return String.format(this.getLoggingLocale(), this.invalidValue$str(), value, name, validValues);
    }

    protected String missingOneOf$str() {
        return "WFLYCTL0132: Must include one of the following elements: %s";
    }

    @Override
    public final XMLStreamException missingOneOf(StringBuilder sb, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.missingOneOf$str(), sb), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredAttributes$str() {
        return "WFLYCTL0133: Missing required attribute(s): %s";
    }

    @Override
    public final XMLStreamException missingRequiredAttributes(StringBuilder sb, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.missingRequiredAttributes$str(), sb), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredElements$str() {
        return "WFLYCTL0134: Missing required element(s): %s";
    }

    @Override
    public final XMLStreamException missingRequiredElements(StringBuilder sb, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.missingRequiredElements$str(), sb), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moduleLoadingInterrupted$str() {
        return "WFLYCTL0135: Interrupted awaiting loading of module %s";
    }

    @Override
    public final XMLStreamException moduleLoadingInterrupted(String name) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.moduleLoadingInterrupted$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moduleInitializationInterrupted$str() {
        return "WFLYCTL0136: Interrupted awaiting initialization of module %s";
    }

    @Override
    public final RuntimeException moduleInitializationInterrupted(String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.moduleInitializationInterrupted$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleModelNodes$str() {
        return "WFLYCTL0137: Model contains multiple %s nodes";
    }

    @Override
    public final IllegalStateException multipleModelNodes(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.multipleModelNodes$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String namespaceAlreadyRegistered$str() {
        return "WFLYCTL0138: Namespace with prefix %s already registered with schema URI %s";
    }

    @Override
    public final String namespaceAlreadyRegistered(String prefix, String uri) {
        return String.format(this.getLoggingLocale(), this.namespaceAlreadyRegistered$str(), prefix, uri);
    }

    protected String namespaceNotFound$str() {
        return "WFLYCTL0139: No namespace with URI %s found";
    }

    @Override
    public final String namespaceNotFound(String prefix) {
        return String.format(this.getLoggingLocale(), this.namespaceNotFound$str(), prefix);
    }

    protected String nestedElementNotAllowed$str() {
        return "WFLYCTL0140: Nested %s not allowed";
    }

    @Override
    public final String nestedElementNotAllowed(Element element) {
        return String.format(this.getLoggingLocale(), this.nestedElementNotAllowed$str(), new Object[]{element});
    }

    protected String noActiveStep$str() {
        return "WFLYCTL0144: No active step";
    }

    @Override
    public final IllegalStateException noActiveStep() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noActiveStep$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noChildType$str() {
        return "WFLYCTL0147: No child type %s";
    }

    @Override
    public final OperationFailedRuntimeException noChildType(String name) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.noChildType$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noInterfaceCriteria$str() {
        return "WFLYCTL0149: No interface criteria was provided";
    }

    @Override
    public final String noInterfaceCriteria() {
        return String.format(this.getLoggingLocale(), this.noInterfaceCriteria$str(), new Object[0]);
    }

    protected String noOperationHandler0$str() {
        return "WFLYCTL0150: No operation handler";
    }

    @Override
    public final String noOperationHandler() {
        return String.format(this.getLoggingLocale(), this.noOperationHandler0$str(), new Object[0]);
    }

    protected String notADirectory$str() {
        return "WFLYCTL0152: %s is not a directory";
    }

    @Override
    public final IllegalStateException notADirectory(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notADirectory$str(), path));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notFound$str() {
        return "WFLYCTL0153: No %s%s found for %s";
    }

    @Override
    public final IllegalStateException notFound(String path, String className, String moduleName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notFound$str(), path, className, moduleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullAsynchronousExecutor$str() {
        return "WFLYCTL0154: Cannot execute asynchronous operation without an executor";
    }

    @Override
    public final IllegalStateException nullAsynchronousExecutor() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.nullAsynchronousExecutor$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullNotAllowed$str() {
        return "WFLYCTL0155: '%s' may not be null";
    }

    @Override
    public final OperationFailedException nullNotAllowed(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nullNotAllowed$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operation$str() {
        return "Operation %s";
    }

    @Override
    public final String operation(String step) {
        return String.format(this.getLoggingLocale(), this.operation$str(), step);
    }

    protected String operationAlreadyComplete$str() {
        return "WFLYCTL0157: Operation already complete";
    }

    @Override
    public final IllegalStateException operationAlreadyComplete() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.operationAlreadyComplete$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationHandlerFailed$str() {
        return "WFLYCTL0158: Operation handler failed: %s";
    }

    @Override
    public final String operationHandlerFailed(String msg) {
        return String.format(this.getLoggingLocale(), this.operationHandlerFailed$str(), msg);
    }

    protected String operationRollingBack$str() {
        return "WFLYCTL0160: Operation rolling back";
    }

    @Override
    public final String operationRollingBack() {
        return String.format(this.getLoggingLocale(), this.operationRollingBack$str(), new Object[0]);
    }

    protected String operationSucceeded$str() {
        return "WFLYCTL0161: Operation succeeded, committing";
    }

    @Override
    public final String operationSucceeded() {
        return String.format(this.getLoggingLocale(), this.operationSucceeded$str(), new Object[0]);
    }

    protected String operationNotRegistered$str() {
        return "WFLYCTL0162: There is no operation %s registered at address %s";
    }

    @Override
    public final String operationNotRegistered(String op, PathAddress address) {
        return String.format(this.getLoggingLocale(), this.operationNotRegistered$str(), op, address);
    }

    protected String persisterNotInjected$str() {
        return "WFLYCTL0165: No configuration persister was injected";
    }

    @Override
    public final StartException persisterNotInjected() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.persisterNotInjected$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String proxyHandlerAlreadyRegistered$str() {
        return "WFLYCTL0169: A proxy handler is already registered at location '%s'";
    }

    @Override
    public final IllegalArgumentException proxyHandlerAlreadyRegistered(String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.proxyHandlerAlreadyRegistered$str(), location));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removingServiceUnsatisfiedDependencies0$str() {
        return "WFLYCTL0171: Removing services has lead to unsatisfied dependencies:";
    }

    @Override
    public final String removingServiceUnsatisfiedDependencies() {
        return String.format(this.getLoggingLocale(), this.removingServiceUnsatisfiedDependencies0$str(), new Object[0]);
    }

    protected String removingServiceUnsatisfiedDependencies1$str() {
        return "%nService %s was depended upon by ";
    }

    @Override
    public final String removingServiceUnsatisfiedDependencies(String name) {
        return String.format(this.getLoggingLocale(), this.removingServiceUnsatisfiedDependencies1$str(), name);
    }

    protected String required$str() {
        return "WFLYCTL0172: %s is required";
    }

    @Override
    public final OperationFailedException required(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.required$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String reserved$str() {
        return "WFLYCTL0173: %s is reserved";
    }

    @Override
    public final XMLStreamException reserved(String name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.reserved$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceNotFound$str() {
        return "WFLYCTL0175: Resource %s does not exist; a resource at address %s cannot be created until all ancestor resources have been added";
    }

    @Override
    public final OperationFailedRuntimeException resourceNotFound(PathAddress ancestor, PathAddress address) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.resourceNotFound$str(), ancestor, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rollbackAlreadyInvoked$str() {
        return "WFLYCTL0176: rollback() has already been invoked";
    }

    @Override
    public final IllegalStateException rollbackAlreadyInvoked() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.rollbackAlreadyInvoked$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String schemaAlreadyRegistered$str() {
        return "WFLYCTL0177: Schema with URI %s already registered with location %s";
    }

    @Override
    public final String schemaAlreadyRegistered(String schemaUri, String location) {
        return String.format(this.getLoggingLocale(), this.schemaAlreadyRegistered$str(), schemaUri, location);
    }

    protected String schemaNotFound$str() {
        return "WFLYCTL0178: No schema location with URI %s found";
    }

    @Override
    public final String schemaNotFound(String uri) {
        return String.format(this.getLoggingLocale(), this.schemaNotFound$str(), uri);
    }

    protected String serviceInstallCancelled$str() {
        return "WFLYCTL0179: Service install was cancelled";
    }

    @Override
    public final CancellationException serviceInstallCancelled() {
        CancellationException result = new CancellationException(String.format(this.getLoggingLocale(), this.serviceInstallCancelled$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String servicesMissing$str() {
        return "is missing [%s]";
    }

    @Override
    public final String servicesMissing(StringBuilder sb) {
        return String.format(this.getLoggingLocale(), this.servicesMissing$str(), sb);
    }

    protected String servicesMissingDependencies$str() {
        return "WFLYCTL0180: Services with missing/unavailable dependencies";
    }

    @Override
    public final String servicesMissingDependencies() {
        return String.format(this.getLoggingLocale(), this.servicesMissingDependencies$str(), new Object[0]);
    }

    protected String serviceRegistryRuntimeOperationsOnly$str() {
        return "WFLYCTL0181: Get service registry only supported in runtime operations";
    }

    @Override
    public final IllegalStateException serviceRegistryRuntimeOperationsOnly() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceRegistryRuntimeOperationsOnly$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceRemovalRuntimeOperationsOnly$str() {
        return "WFLYCTL0182: Service removal only supported in runtime operations";
    }

    @Override
    public final IllegalStateException serviceRemovalRuntimeOperationsOnly() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceRemovalRuntimeOperationsOnly$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceStatusReportHeader$str() {
        return "WFLYCTL0183: Service status report%n";
    }

    @Override
    public final String serviceStatusReportHeader() {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportHeader$str(), new Object[0]);
    }

    protected String serviceStatusReportDependencies$str() {
        return "WFLYCTL0184:    New missing/unsatisfied dependencies:%n";
    }

    @Override
    public final String serviceStatusReportDependencies() {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportDependencies$str(), new Object[0]);
    }

    protected String serviceStatusReportMissing$str() {
        return "      %s (missing) dependents: %s %n";
    }

    @Override
    public final String serviceStatusReportMissing(ServiceName serviceName, String dependents) {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportMissing$str(), serviceName, dependents);
    }

    protected String serviceStatusReportCorrected$str() {
        return "WFLYCTL0185:    Newly corrected services:%n";
    }

    @Override
    public final String serviceStatusReportCorrected() {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportCorrected$str(), new Object[0]);
    }

    protected String serviceStatusReportNoLongerRequired$str() {
        return "      %s (no longer required)%n";
    }

    @Override
    public final String serviceStatusReportNoLongerRequired(ServiceName serviceName) {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportNoLongerRequired$str(), serviceName);
    }

    protected String serviceStatusReportAvailable$str() {
        return "      %s (new available)%n";
    }

    @Override
    public final String serviceStatusReportAvailable(ServiceName serviceName) {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportAvailable$str(), serviceName);
    }

    protected String serviceStatusReportFailed$str() {
        return "WFLYCTL0186:   Services which failed to start:";
    }

    @Override
    public final String serviceStatusReportFailed() {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportFailed$str(), new Object[0]);
    }

    protected String serviceTargetRuntimeOperationsOnly$str() {
        return "WFLYCTL0187: Get service target only supported in runtime operations";
    }

    @Override
    public final IllegalStateException serviceTargetRuntimeOperationsOnly() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceTargetRuntimeOperationsOnly$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stageAlreadyComplete$str() {
        return "WFLYCTL0188: Stage %s is already complete";
    }

    @Override
    public final IllegalStateException stageAlreadyComplete(OperationContext.Stage stage) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.stageAlreadyComplete$str(), new Object[]{stage}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stepHandlerFailed$str() {
        return "WFLYCTL0190: Step handler %s for operation %s at address %s failed -- %s";
    }

    @Override
    public final String stepHandlerFailed(OperationStepHandler handler, String op, PathAddress address, Throwable cause) {
        return String.format(this.getLoggingLocale(), this.stepHandlerFailed$str(), handler, op, address, cause);
    }

    protected String subsystemBootInterrupted$str() {
        return "WFLYCTL0191: Interrupted awaiting subsystem boot operation execution";
    }

    @Override
    public final String subsystemBootInterrupted() {
        return String.format(this.getLoggingLocale(), this.subsystemBootInterrupted$str(), new Object[0]);
    }

    protected String subsystemBootOperationFailed$str() {
        return "WFLYCTL0192: Boot operations for subsystem %s failed without explanation";
    }

    @Override
    public final String subsystemBootOperationFailed(String name) {
        return String.format(this.getLoggingLocale(), this.subsystemBootOperationFailed$str(), name);
    }

    protected String subsystemBootOperationFailedExecuting$str() {
        return "WFLYCTL0193: Failed executing subsystem %s boot operations";
    }

    @Override
    public final String subsystemBootOperationFailedExecuting(String name) {
        return String.format(this.getLoggingLocale(), this.subsystemBootOperationFailedExecuting$str(), name);
    }

    protected String tableIsFull$str() {
        return "WFLYCTL0194: Table is full!";
    }

    @Override
    public final IllegalStateException tableIsFull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tableIsFull$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionInterrupted$str() {
        return "WFLYCTL0195: Interrupted awaiting transaction commit or rollback";
    }

    @Override
    public final RuntimeException transactionInterrupted() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.transactionInterrupted$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedAttribute1$str() {
        return "WFLYCTL0197: Unexpected attribute '%s' encountered";
    }

    @Override
    public final XMLStreamException unexpectedAttribute(QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedAttribute1$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedElement1$str() {
        return "WFLYCTL0198: Unexpected element '%s' encountered";
    }

    @Override
    public final XMLStreamException unexpectedElement(QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedElement1$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEndElement$str() {
        return "WFLYCTL0199: Unexpected end of element '%s' encountered";
    }

    @Override
    public final XMLStreamException unexpectedEndElement(QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedEndElement$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAttribute$str() {
        return "WFLYCTL0201: Unknown attribute '%s'";
    }

    @Override
    public final String unknownAttribute(String name) {
        return String.format(this.getLoggingLocale(), this.unknownAttribute$str(), name);
    }

    protected String unknownChildType$str() {
        return "WFLYCTL0202: No known child type named %s";
    }

    @Override
    public final String unknownChildType(String name) {
        return String.format(this.getLoggingLocale(), this.unknownChildType$str(), name);
    }

    protected String unknownCriteriaInterfaceProperty$str() {
        return "WFLYCTL0203: Unknown property in interface criteria list: %s";
    }

    @Override
    public final RuntimeException unknownCriteriaInterfaceProperty(String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownCriteriaInterfaceProperty$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCriteriaInterfaceType$str() {
        return "WFLYCTL0204: Unknown interface criteria type %s";
    }

    @Override
    public final String unknownCriteriaInterfaceType(String type) {
        return String.format(this.getLoggingLocale(), this.unknownCriteriaInterfaceType$str(), type);
    }

    protected String unknownInterface$str() {
        return "WFLYCTL0205: Unknown interface %s %s must be declared in element %s";
    }

    @Override
    public final XMLStreamException unknownInterface(String value, String attributeName, String elementName, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unknownInterface$str(), value, attributeName, elementName), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownValueForElement$str() {
        return "WFLYCTL0206: Unknown %s %s %s must be declared in element %s";
    }

    @Override
    public final XMLStreamException unknownValueForElement(String elementName1, String value, String elementName2, String parentElement, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unknownValueForElement$str(), elementName1, value, elementName2, parentElement), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailed$str() {
        return "WFLYCTL0207: Validation failed for %s";
    }

    @Override
    public final String validationFailed(String name) {
        return String.format(this.getLoggingLocale(), this.validationFailed$str(), name);
    }

    protected String andNMore$str() {
        return "WFLYCTL0208: ... and %s more";
    }

    @Override
    public final String andNMore(int number) {
        return String.format(this.getLoggingLocale(), this.andNMore$str(), number);
    }

    protected String invalidAttributeValue3$str() {
        return "WFLYCTL0209: Invalid value '%s' for attribute '%s' -- valid values are %s";
    }

    @Override
    public final XMLStreamException invalidAttributeValue(String value, QName name, Set<String> validValues, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidAttributeValue3$str(), value, name, validValues), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPermissionToResolveExpression$str() {
        return "WFLYCTL0210: Caught SecurityException attempting to resolve expression '%s' -- %s";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException noPermissionToResolveExpression(ModelNode toResolve, SecurityException e) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.noPermissionToResolveExpression$str(), toResolve, e));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResolveExpression$str() {
        return "WFLYCTL0211: Cannot resolve expression '%s'";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException cannotResolveExpression(String toResolve) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.cannotResolveExpression$str(), toResolve));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateResourceAddress$str() {
        return "WFLYCTL0212: Duplicate resource %s";
    }

    @Override
    public final OperationFailedRuntimeException duplicateResourceAddress(PathAddress address) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.duplicateResourceAddress$str(), address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mainFileNotFound$str() {
        return "WFLYCTL0214: Could not load configuration file: %s. The configuration file argument must specify the path to a file located in the configuration directory. The path must be a relative path, and must be relative to the configuration directory %s.";
    }

    @Override
    public final IllegalStateException mainFileNotFound(String name, File configurationDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mainFileNotFound$str(), name, configurationDir));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String absolutePathMainFileNotFound$str() {
        return "WFLYCTL0215: Could not load configuration file: %s. The configuration file argument must specify one of the following: 1) an absolute path to an existing file; 2) a relative path to an existing file, relative to the current working directory; or 3) a relative path to a file located in the configuration directory. In the latter case, it must be a path relative to the configuration directory %s.";
    }

    @Override
    public final IllegalStateException absolutePathMainFileNotFound(String name, File configurationDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.absolutePathMainFileNotFound$str(), name, configurationDir));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String managementResourceNotFound$str() {
        return "WFLYCTL0216: Management resource '%s' not found";
    }

    @Override
    public final Resource.NoSuchResourceException managementResourceNotFound(PathAddress pathAddress) {
        Resource.NoSuchResourceException result = new Resource.NoSuchResourceException(String.format(this.getLoggingLocale(), this.managementResourceNotFound$str(), pathAddress));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String childResourceNotFound$str() {
        return "WFLYCTL0217: Child resource '%s' not found";
    }

    @Override
    public final String childResourceNotFound(PathElement childAddress) {
        return String.format(this.getLoggingLocale(), this.childResourceNotFound$str(), childAddress);
    }

    protected String nodeAlreadyRegistered$str() {
        return "WFLYCTL0218: A node is already registered at '%s'";
    }

    @Override
    public final IllegalArgumentException nodeAlreadyRegistered(String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeAlreadyRegistered$str(), location));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removingExtensionWithRegisteredSubsystem$str() {
        return "WFLYCTL0219: An attempt was made to unregister extension %s which still has subsystem %s registered";
    }

    @Override
    public final IllegalStateException removingExtensionWithRegisteredSubsystem(String moduleName, String subsystem) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.removingExtensionWithRegisteredSubsystem$str(), moduleName, subsystem));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOverrideRootRegistration$str() {
        return "WFLYCTL0220: An override model registration is not allowed for the root model registration";
    }

    @Override
    public final IllegalStateException cannotOverrideRootRegistration() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotOverrideRootRegistration$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOverrideNonWildCardRegistration$str() {
        return "WFLYCTL0221: An override model registration is not allowed for non-wildcard model registrations. This registration is for the non-wildcard name '%s'.";
    }

    @Override
    public final IllegalStateException cannotOverrideNonWildCardRegistration(String valueName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotOverrideNonWildCardRegistration$str(), valueName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wildcardRegistrationIsNotAnOverride$str() {
        return "WFLYCTL0222: A registration named '*' is not an override model and cannot be unregistered via the unregisterOverrideModel API.";
    }

    @Override
    public final IllegalArgumentException wildcardRegistrationIsNotAnOverride() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wildcardRegistrationIsNotAnOverride$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rootRegistrationIsNotOverridable$str() {
        return "WFLYCTL0223: The root resource registration does not support overrides, so no override can be removed.";
    }

    @Override
    public final IllegalStateException rootRegistrationIsNotOverridable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.rootRegistrationIsNotOverridable$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationNotRegisteredException$str() {
        return "WFLYCTL0224: There is no operation %s registered at address %s";
    }

    @Override
    public final IllegalArgumentException operationNotRegisteredException(String op, PathAddress address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.operationNotRegisteredException$str(), op, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToRecoverServices$str() {
        return "WFLYCTL0225: Failed to recover services during operation rollback";
    }

    @Override
    public final RuntimeException failedToRecoverServices(OperationFailedException cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToRecoverServices$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateSubsystem$str() {
        return "WFLYCTL0226: A subsystem named '%s' cannot be registered by extension '%s' -- a subsystem with that name has already been registered by extension '%s'.";
    }

    @Override
    public final IllegalStateException duplicateSubsystem(String subsystemName, String duplicatingModule, String existingModule) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateSubsystem$str(), subsystemName, duplicatingModule, existingModule));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedOperationHasNoField$str() {
        return "WFLYCTL0227: Operation has no '%s' field. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedOperationHasNoField(String field, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedOperationHasNoField$str(), field, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedOperationHasANullOrEmptyName$str() {
        return "WFLYCTL0228: Operation has a null or empty name. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedOperationHasANullOrEmptyName(String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedOperationHasANullOrEmptyName$str(), operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedNoOperationFound$str() {
        return "WFLYCTL0229: No operation called '%s' at '%s'. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedNoOperationFound(String name, PathAddress address, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedNoOperationFound$str(), name, address, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedActualParameterNotDescribed$str() {
        return "WFLYCTL0230: Operation contains a parameter '%s' which is not one of the expected parameters %s. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedActualParameterNotDescribed(String paramName, Set<String> parameterNames, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedActualParameterNotDescribed$str(), paramName, parameterNames, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedRequiredParameterNotPresent$str() {
        return "WFLYCTL0231: Required parameter %s is not present. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedRequiredParameterNotPresent(String paramName, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedRequiredParameterNotPresent$str(), paramName, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedRequiredParameterPresentAsWellAsAlternative$str() {
        return "WFLYCTL0232: Alternative parameter '%s' for required parameter '%s' was used. Please use one or the other. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedRequiredParameterPresentAsWellAsAlternative(String alternative, String paramName, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedRequiredParameterPresentAsWellAsAlternative$str(), alternative, paramName, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedCouldNotConvertParamToType$str() {
        return "WFLYCTL0233: Could not convert the parameter '%s' to a %s. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedCouldNotConvertParamToType(String paramName, ModelType type, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedCouldNotConvertParamToType$str(), paramName, type, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedValueIsSmallerThanMin$str() {
        return "WFLYCTL0234: The value '%s' passed in for '%s' is smaller than the minimum value '%s'. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedValueIsSmallerThanMin(Number value, String paramName, Number min, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedValueIsSmallerThanMin$str(), value, paramName, min, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedValueIsGreaterThanMax$str() {
        return "WFLYCTL0235: The value '%s' passed in for '%s' is bigger than the maximum value '%s'. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedValueIsGreaterThanMax(Number value, String paramName, Number max, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedValueIsGreaterThanMax$str(), value, paramName, max, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedValueIsShorterThanMinLength$str() {
        return "WFLYCTL0236: The value '%s' passed in for '%s' is shorter than the minimum length '%s'. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedValueIsShorterThanMinLength(Object value, String paramName, Object minLength, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedValueIsShorterThanMinLength$str(), value, paramName, minLength, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedValueIsLongerThanMaxLength$str() {
        return "WFLYCTL0237: The value '%s' passed in for '%s' is longer than the maximum length '%s'. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedValueIsLongerThanMaxLength(Object value, String paramName, Object maxLength, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedValueIsLongerThanMaxLength$str(), value, paramName, maxLength, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationFailedInvalidElementType$str() {
        return "WFLYCTL0238: %s is expected to be a list of %s. %s";
    }

    @Override
    public final IllegalArgumentException validationFailedInvalidElementType(String paramName, ModelType elementType, String operation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationFailedInvalidElementType$str(), paramName, elementType, operation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDescriptionRequiredFlagIsNotABoolean$str() {
        return "WFLYCTL0239: 'required' parameter: '%s' must be a boolean in the description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionRequiredFlagIsNotABoolean(String paramName, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionRequiredFlagIsNotABoolean$str(), paramName, address, description);
    }

    protected String invalidDescriptionUndefinedRequestProperty$str() {
        return "WFLYCTL0240: Undefined request property '%s' in description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionUndefinedRequestProperty(String name, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionUndefinedRequestProperty$str(), name, address, description);
    }

    protected String invalidDescriptionNoParamTypeInDescription$str() {
        return "WFLYCTL0241: There is no type for parameter '%s' in the description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionNoParamTypeInDescription(String paramName, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionNoParamTypeInDescription$str(), paramName, address, description);
    }

    protected String invalidDescriptionInvalidParamTypeInDescription$str() {
        return "WFLYCTL0242: Could not determine the type of parameter '%s' in the description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionInvalidParamTypeInDescription(String paramName, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionInvalidParamTypeInDescription$str(), paramName, address, description);
    }

    protected String invalidDescriptionMinMaxForParameterHasWrongType$str() {
        return "WFLYCTL0243: The '%s' attribute of the '%s' parameter can not be converted to its type: %s in the description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionMinMaxForParameterHasWrongType(String minOrMax, String paramName, ModelType expectedType, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionMinMaxForParameterHasWrongType$str(), minOrMax, paramName, expectedType, address, description);
    }

    protected String invalidDescriptionMinMaxLengthForParameterHasWrongType$str() {
        return "WFLYCTL0244: The '%s' attribute of the '%s' parameter can not be converted to an integer in the description of the operation at %s: %s";
    }

    @Override
    public final String invalidDescriptionMinMaxLengthForParameterHasWrongType(String minOrMaxLength, String paramName, PathAddress address, ModelNode description) {
        return String.format(this.getLoggingLocale(), this.invalidDescriptionMinMaxLengthForParameterHasWrongType$str(), minOrMaxLength, paramName, address, description);
    }

    protected String invalidPort$str() {
        return "WFLYCTL0245: Illegal '%s' value %s -- must be a valid port number";
    }

    @Override
    public final XMLStreamException invalidPort(String name, String value, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidPort$str(), name, value), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResolveProcessUUID$str() {
        return "WFLYCTL0246: Cannot resolve the localhost address to create a UUID-based name for this process";
    }

    @Override
    public final RuntimeException cannotResolveProcessUUID(UnknownHostException cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotResolveProcessUUID$str(), new Object[0]), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String useOperationContextRemoveService$str() {
        return "WFLYCTL0247: Do not call ServiceController.setMode(REMOVE), use OperationContext.removeService() instead.";
    }

    @Override
    public final IllegalStateException useOperationContextRemoveService() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.useOperationContextRemoveService$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEnumValue$str() {
        return "WFLYCTL0248: Invalid value %s for %s; legal values are %s";
    }

    @Override
    public final OperationFailedException invalidEnumValue(String value, String parameterName, Set<?> allowedValues) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidEnumValue$str(), value, parameterName, allowedValues));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String modelUpdateNotAuthorized$str() {
        return "WFLYCTL0249: Operation '%s' targeted at resource '%s' was directly invoked by a user. User operations are not permitted to directly update the persistent configuration of a server in a managed domain.";
    }

    @Override
    public final OperationFailedRuntimeException modelUpdateNotAuthorized(String operation, PathAddress address) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.modelUpdateNotAuthorized$str(), operation, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverResultsAccessNotAllowed$str() {
        return "WFLYCTL0250: An operation handler attempted to access the operation response server results object on a process type other than '%s'. The current process type is '%s'";
    }

    @Override
    public final IllegalStateException serverResultsAccessNotAllowed(ProcessType validType, ProcessType processType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverResultsAccessNotAllowed$str(), new Object[]{validType, processType}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cantHaveBothLoopbackAndInetAddressCriteria$str() {
        return "WFLYCTL0251: Can't have both loopback and inet-address criteria";
    }

    @Override
    public final String cantHaveBothLoopbackAndInetAddressCriteria() {
        return String.format(this.getLoggingLocale(), this.cantHaveBothLoopbackAndInetAddressCriteria$str(), new Object[0]);
    }

    protected String cantHaveSameCriteriaForBothNotAndInclusion$str() {
        return "WFLYCTL0253: Can't have same criteria for both not and inclusion %s";
    }

    @Override
    public final String cantHaveSameCriteriaForBothNotAndInclusion(InterfaceCriteria interfaceCriteria) {
        return String.format(this.getLoggingLocale(), this.cantHaveSameCriteriaForBothNotAndInclusion$str(), interfaceCriteria);
    }

    protected String nonexistentInterface$str() {
        return "WFLYCTL0254: Invalid value '%s' for attribute '%s' -- no interface configuration with that name exists";
    }

    @Override
    public final OperationFailedException nonexistentInterface(String attributeValue, String attributeName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nonexistentInterface$str(), attributeValue, attributeName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathEntryNotFound$str() {
        return "WFLYCTL0256: Could not find a path called '%s'";
    }

    @Override
    public final IllegalArgumentException pathEntryNotFound(String pathName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathEntryNotFound$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathEntryIsReadOnly$str() {
        return "WFLYCTL0257: Path entry is read-only: '%s'";
    }

    @Override
    public final IllegalArgumentException pathEntryIsReadOnly(String pathName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathEntryIsReadOnly$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathEntryAlreadyExists$str() {
        return "WFLYCTL0258: There is already a path entry called: '%s'";
    }

    @Override
    public final IllegalArgumentException pathEntryAlreadyExists(String pathName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathEntryAlreadyExists$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRelativePathValue$str() {
        return "WFLYCTL0260: Invalid relativePath value '%s'";
    }

    @Override
    public final IllegalArgumentException invalidRelativePathValue(String relativePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRelativePathValue$str(), relativePath));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathIsAWindowsAbsolutePath$str() {
        return "WFLYCTL0261: '%s' is a Windows absolute path";
    }

    @Override
    public final IllegalArgumentException pathIsAWindowsAbsolutePath(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathIsAWindowsAbsolutePath$str(), path));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveReadOnlyPath$str() {
        return "WFLYCTL0262: Path '%s' is read-only; it cannot be removed";
    }

    @Override
    public final OperationFailedException cannotRemoveReadOnlyPath(String pathName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveReadOnlyPath$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotModifyReadOnlyPath$str() {
        return "WFLYCTL0263: Path '%s' is read-only; it cannot be modified";
    }

    @Override
    public final OperationFailedException cannotModifyReadOnlyPath(String pathName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotModifyReadOnlyPath$str(), pathName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expressionNotAllowed$str() {
        return "WFLYCTL0264: %s may not be ModelType.EXPRESSION";
    }

    @Override
    public final OperationFailedException expressionNotAllowed(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.expressionNotAllowed$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathManagerNotAvailable$str() {
        return "WFLYCTL0265: PathManager not available on processes of type '%s'";
    }

    @Override
    public final IllegalStateException pathManagerNotAvailable(ProcessType processType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.pathManagerNotAvailable$str(), new Object[]{processType}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMulticastAddress$str() {
        return "WFLYCTL0266: Value %s for attribute %s is not a valid multicast address";
    }

    @Override
    public final OperationFailedException unknownMulticastAddress(UnknownHostException cause, String value, String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unknownMulticastAddress$str(), value, name), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemovePathWithDependencies$str() {
        return "WFLYCTL0267: Path '%s' cannot be removed, since the following paths depend on it: %s";
    }

    @Override
    public final OperationFailedException cannotRemovePathWithDependencies(String pathName, Set<String> dependencies) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemovePathWithDependencies$str(), pathName, dependencies));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToRenameTempFile$str() {
        return "WFLYCTL0268: Failed to rename temp file %s to %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToRenameTempFile(Throwable cause, File temp, File file) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToRenameTempFile$str(), temp, file), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLocaleString$str() {
        return "WFLYCTL0269: Invalid locale format:  %s";
    }

    @Override
    public final String invalidLocaleString(String unparsed) {
        return String.format(this.getLoggingLocale(), this.invalidLocaleString$str(), unparsed);
    }

    protected String operationCancelled$str() {
        return "WFLYCTL0271: Operation cancelled";
    }

    @Override
    public final String operationCancelled() {
        return String.format(this.getLoggingLocale(), this.operationCancelled$str(), new Object[0]);
    }

    protected String operationCancelledAsynchronously$str() {
        return "WFLYCTL0272: Operation cancelled asynchronously";
    }

    @Override
    public final OperationCancellationException operationCancelledAsynchronously() {
        OperationCancellationException result = new OperationCancellationException(String.format(this.getLoggingLocale(), this.operationCancelledAsynchronously$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String streamWasKilled$str() {
        return "WFLYCTL0273: Stream was killed";
    }

    @Override
    public final IOException streamWasKilled() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.streamWasKilled$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String streamWasClosed$str() {
        return "WFLYCTL0274: Stream was closed";
    }

    @Override
    public final IOException streamWasClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.streamWasClosed$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotHaveBothParameters$str() {
        return "WFLYCTL0275: Cannot define both '%s' and '%s'";
    }

    @Override
    public final OperationFailedException cannotHaveBothParameters(String nameA, String name2) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotHaveBothParameters$str(), nameA, name2));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDeleteFile$str() {
        return "WFLYCTL0276: Failed to delete file %s";
    }

    @Override
    public final IllegalStateException couldNotDeleteFile(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotDeleteFile$str(), file));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aliasAlreadyRegistered$str() {
        return "WFLYCTL0277: An alias is already registered at location '%s'";
    }

    @Override
    public final IllegalArgumentException aliasAlreadyRegistered(String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.aliasAlreadyRegistered$str(), location));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aliasTargetResourceRegistrationNotFound$str() {
        return "WFLYCTL0279: Alias target address not found: %s";
    }

    @Override
    public final IllegalArgumentException aliasTargetResourceRegistrationNotFound(PathAddress targetAddress) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.aliasTargetResourceRegistrationNotFound$str(), targetAddress));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aliasStepHandlerOperationNotFound$str() {
        return "WFLYCTL0280: No operation called '%s' found for alias address '%s' which maps to '%s'";
    }

    @Override
    public final IllegalArgumentException aliasStepHandlerOperationNotFound(String name, PathAddress aliasAddress, PathAddress targetAddress) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.aliasStepHandlerOperationNotFound$str(), name, aliasAddress, targetAddress));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceRegistrationIsNotAnAlias$str() {
        return "WFLYCTL0281: Resource registration is not an alias";
    }

    @Override
    public final IllegalStateException resourceRegistrationIsNotAnAlias() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.resourceRegistrationIsNotAnAlias$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String modelFieldsNotKnown$str() {
        return "WFLYCTL0282: Model contains fields that are not known in definition, fields: %s, path: %s";
    }

    @Override
    public final RuntimeException modelFieldsNotKnown(Set<String> fields, PathAddress address) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.modelFieldsNotKnown$str(), fields, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotMarshalAttributeAsElement$str() {
        return "WFLYCTL0283: Could not marshal attribute as element: %s";
    }

    @Override
    public final UnsupportedOperationException couldNotMarshalAttributeAsElement(String attributeName) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.couldNotMarshalAttributeAsElement$str(), attributeName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotMarshalAttributeAsAttribute$str() {
        return "WFLYCTL0284: Could not marshal attribute as attribute: %s";
    }

    @Override
    public final UnsupportedOperationException couldNotMarshalAttributeAsAttribute(String attributeName) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.couldNotMarshalAttributeAsAttribute$str(), attributeName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wildcardOperationFailedAtSingleAddress$str() {
        return "WFLYCTL0285: Operation %s invoked against multiple target addresses failed at address %s with failure description %s";
    }

    @Override
    public final String wildcardOperationFailedAtSingleAddress(String operation, PathAddress address, String failureMessage) {
        return String.format(this.getLoggingLocale(), this.wildcardOperationFailedAtSingleAddress$str(), operation, address, failureMessage);
    }

    protected String wildcardOperationFailedAtSingleAddressWithComplexFailure$str() {
        return "WFLYCTL0286: Operation %s invoked against multiple target addresses failed at address %s. See the operation result for details.";
    }

    @Override
    public final String wildcardOperationFailedAtSingleAddressWithComplexFailure(String operation, PathAddress address) {
        return String.format(this.getLoggingLocale(), this.wildcardOperationFailedAtSingleAddressWithComplexFailure$str(), operation, address);
    }

    protected String wildcardOperationFailedAtMultipleAddresses$str() {
        return "WFLYCTL0287: Operation %s invoked against multiple target addresses failed at addresses %s. See the operation result for details.";
    }

    @Override
    public final String wildcardOperationFailedAtMultipleAddresses(String operation, Set<PathAddress> addresses) {
        return String.format(this.getLoggingLocale(), this.wildcardOperationFailedAtMultipleAddresses$str(), operation, addresses);
    }

    protected String missingTransitiveDependencyProblem$str() {
        return "WFLYCTL0288: One or more services were unable to start due to one or more indirect dependencies not being available.";
    }

    @Override
    public final String missingTransitiveDependencyProblem() {
        return String.format(this.getLoggingLocale(), this.missingTransitiveDependencyProblem$str(), new Object[0]);
    }

    protected String missingTransitiveDependents$str() {
        return "Services that were unable to start:";
    }

    @Override
    public final String missingTransitiveDependents() {
        return String.format(this.getLoggingLocale(), this.missingTransitiveDependents$str(), new Object[0]);
    }

    protected String missingTransitiveDependencies$str() {
        return "Services that may be the cause:";
    }

    @Override
    public final String missingTransitiveDependencies() {
        return String.format(this.getLoggingLocale(), this.missingTransitiveDependencies$str(), new Object[0]);
    }

    protected String noOperationEntry$str() {
        return "WFLYCTL0289: No operation entry called '%s' registered at '%s'";
    }

    @Override
    public final String noOperationEntry(String op, PathAddress pathAddress) {
        return String.format(this.getLoggingLocale(), this.noOperationEntry$str(), op, pathAddress);
    }

    protected String noOperationHandler2$str() {
        return "WFLYCTL0290: No operation handler called '%s' registered at '%s'";
    }

    @Override
    public final String noOperationHandler(String op, PathAddress pathAddress) {
        return String.format(this.getLoggingLocale(), this.noOperationHandler2$str(), op, pathAddress);
    }

    protected String noPathToResolve$str() {
        return "WFLYCTL0291: There is no registered path to resolve with path attribute '%s' and/or relative-to attribute '%s on: %s";
    }

    @Override
    public final IllegalStateException noPathToResolve(String pathAttributeName, String relativeToAttributeName, ModelNode model) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noPathToResolve$str(), pathAttributeName, relativeToAttributeName, model));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributesDontSupportExpressions$str() {
        return "WFLYCTL0292: Attributes do not support expressions in the target model version and this resource will need to be ignored on the target host.";
    }

    @Override
    public final String attributesDontSupportExpressions() {
        return String.format(this.getLoggingLocale(), this.attributesDontSupportExpressions$str(), new Object[0]);
    }

    protected String attributesAreNotUnderstoodAndMustBeIgnored0$str() {
        return "WFLYCTL0293: Attributes are not understood in the target model version and this resource will need to be ignored on the target host.";
    }

    @Override
    public final String attributesAreNotUnderstoodAndMustBeIgnored() {
        return String.format(this.getLoggingLocale(), this.attributesAreNotUnderstoodAndMustBeIgnored0$str(), new Object[0]);
    }

    protected String transformerLoggerCoreModelResourceTransformerAttributes$str() {
        return "WFLYCTL0294: Transforming resource %s to core model version '%s' -- %s %s";
    }

    @Override
    public final String transformerLoggerCoreModelResourceTransformerAttributes(PathAddress pathAddress, ModelVersion modelVersion, String attributeNames, String message) {
        return String.format(this.getLoggingLocale(), this.transformerLoggerCoreModelResourceTransformerAttributes$str(), pathAddress, modelVersion, attributeNames, message);
    }

    protected String transformerLoggerCoreModelOperationTransformerAttributes$str() {
        return "WFLYCTL0295: Transforming operation %s at resource %s to core model version '%s' -- %s %s";
    }

    @Override
    public final String transformerLoggerCoreModelOperationTransformerAttributes(ModelNode op, PathAddress pathAddress, ModelVersion modelVersion, String attributeNames, String message) {
        return String.format(this.getLoggingLocale(), this.transformerLoggerCoreModelOperationTransformerAttributes$str(), op, pathAddress, modelVersion, attributeNames, message);
    }

    protected String transformerLoggerSubsystemModelResourceTransformerAttributes$str() {
        return "WFLYCTL0296: Transforming resource %s to subsystem '%s' model version '%s' -- %s %s";
    }

    @Override
    public final String transformerLoggerSubsystemModelResourceTransformerAttributes(PathAddress pathAddress, String subsystem, ModelVersion modelVersion, String attributeNames, String message) {
        return String.format(this.getLoggingLocale(), this.transformerLoggerSubsystemModelResourceTransformerAttributes$str(), pathAddress, subsystem, modelVersion, attributeNames, message);
    }

    protected String transformerLoggerSubsystemModelOperationTransformerAttributes$str() {
        return "WFLYCTL0297: Transforming operation %s at resource %s to subsystem '%s' model version '%s' -- %s %s";
    }

    @Override
    public final String transformerLoggerSubsystemModelOperationTransformerAttributes(ModelNode op, PathAddress pathAddress, String subsystem, ModelVersion modelVersion, String attributeNames, String message) {
        return String.format(this.getLoggingLocale(), this.transformerLoggerSubsystemModelOperationTransformerAttributes$str(), op, pathAddress, subsystem, modelVersion, attributeNames, message);
    }

    protected String illegalUnresolvedModel$str() {
        return "WFLYCTL0298: Node contains an unresolved expression %s -- a resolved model is required";
    }

    @Override
    public final OperationFailedException illegalUnresolvedModel(String expression) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.illegalUnresolvedModel$str(), expression));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rejectAttributesCoreModelResourceTransformer$str() {
        return "WFLYCTL0299: Transforming resource %s for host controller '%s' to core model version '%s' -- there were problems with some of the attributes and this resource will need to be ignored on that host. Details of the problems: %s";
    }

    @Override
    public final OperationFailedException rejectAttributesCoreModelResourceTransformer(PathAddress pathAddress, String legacyHostName, ModelVersion modelVersion, List<String> details) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.rejectAttributesCoreModelResourceTransformer$str(), pathAddress, legacyHostName, modelVersion, details));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rejectAttributesSubsystemModelResourceTransformer$str() {
        return "WFLYCTL0300: Transforming resource %s for host controller '%s' to subsystem '%s' model version '%s' --there were problems with some of the attributes and this resource will need to be ignored on that host. Details of problems: %s";
    }

    @Override
    public final OperationFailedException rejectAttributesSubsystemModelResourceTransformer(PathAddress pathAddress, String legacyHostName, String subsystem, ModelVersion modelVersion, List<String> details) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.rejectAttributesSubsystemModelResourceTransformer$str(), pathAddress, legacyHostName, subsystem, modelVersion, details));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributesDoNotSupportExpressions$str() {
        return "WFLYCTL0301: The following attributes do not support expressions: %s";
    }

    @Override
    public final String attributesDoNotSupportExpressions(Set<String> attributeNames) {
        return String.format(this.getLoggingLocale(), this.attributesDoNotSupportExpressions$str(), attributeNames);
    }

    protected String attributeNames$str() {
        return "attributes %s";
    }

    @Override
    public final String attributeNames(Set<String> attributes) {
        return String.format(this.getLoggingLocale(), this.attributeNames$str(), attributes);
    }

    protected String attributesAreNotUnderstoodAndMustBeIgnored1$str() {
        return "WFLYCTL0302: The following attributes are not understood in the target model version and this resource will need to be ignored on the target host: %s";
    }

    @Override
    public final String attributesAreNotUnderstoodAndMustBeIgnored(Set<String> attributeNames) {
        return String.format(this.getLoggingLocale(), this.attributesAreNotUnderstoodAndMustBeIgnored1$str(), attributeNames);
    }

    protected String rejectedResourceResourceTransformation$str() {
        return "WFLYCTL0303: Resource %s is rejected on the target host, and will need to be ignored on the host";
    }

    @Override
    public final String rejectedResourceResourceTransformation(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.rejectedResourceResourceTransformation$str(), address);
    }

    protected String rejectResourceOperationTransformation$str() {
        return "WFLYCTL0304: Operation %2$s at %1s is rejected on the target host and will need to be ignored on the host";
    }

    @Override
    public final String rejectResourceOperationTransformation(PathAddress address, ModelNode operation) {
        return String.format(this.getLoggingLocale(), this.rejectResourceOperationTransformation$str(), address, operation);
    }

    protected String discoveryOptionsMustBeDeclared$str() {
        return "WFLYCTL0305: Unless the Host Controller is started with command line option %s and the %s attribute is not set to %s, %s must be declared or the %s and the %s need to be provided.";
    }

    @Override
    public final XMLStreamException discoveryOptionsMustBeDeclared(String adminOnlyCmd, String policyAttribute, String fetchValue, String discoveryOptionsName, String hostName, String portName, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.discoveryOptionsMustBeDeclared$str(), adminOnlyCmd, policyAttribute, fetchValue, discoveryOptionsName, hostName, portName), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readOnlyContext$str() {
        return "WFLYCTL0306: read only context";
    }

    @Override
    public final IllegalStateException readOnlyContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.readOnlyContext$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotGetControllerLock$str() {
        return "WFLYCTL0307: We are trying to read data from the domain controller, which is currently busy executing another set of operations. This is a temporary situation, please retry";
    }

    @Override
    public final String cannotGetControllerLock() {
        return String.format(this.getLoggingLocale(), this.cannotGetControllerLock$str(), new Object[0]);
    }

    protected String unsupportedLegacyExtension$str() {
        return "WFLYCTL0309: Legacy extension '%s' is not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain";
    }

    @Override
    public final String unsupportedLegacyExtension(String extensionName) {
        return String.format(this.getLoggingLocale(), this.unsupportedLegacyExtension$str(), extensionName);
    }

    protected String extensionModuleNotFound$str() {
        return "WFLYCTL0310: Extension module %s not found";
    }

    @Override
    public final OperationFailedRuntimeException extensionModuleNotFound(ModuleNotFoundException cause, String module) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.extensionModuleNotFound$str(), module));
        result.initCause((Throwable)cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String extensionModuleLoadingFailure$str() {
        return "WFLYCTL0311: Failed to load Extension module %s";
    }

    @Override
    public final RuntimeException extensionModuleLoadingFailure(ModuleLoadException cause, String module) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.extensionModuleLoadingFailure$str(), module), (Throwable)cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noContextToDelegateTo$str() {
        return "WFLYCTL0312: no context to delegate with id: %s";
    }

    @Override
    public final IllegalStateException noContextToDelegateTo(int operationId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noContextToDelegateTo$str(), operationId));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unauthorized$str() {
        return "WFLYCTL0313: Unauthorized to execute operation '%s' for resource '%s' -- %s";
    }

    @Override
    public final UnauthorizedException unauthorized(String name, PathAddress address, ModelNode explanation) {
        UnauthorizedException result = new UnauthorizedException(String.format(this.getLoggingLocale(), this.unauthorized$str(), name, address, explanation));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalMultipleRoles$str() {
        return "WFLYCTL0314: Users with multiple roles are not allowed";
    }

    @Override
    public final SecurityException illegalMultipleRoles() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.illegalMultipleRoles$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noHandlerCalled$str() {
        return "WFLYCTL0317: There is no handler called '%s'";
    }

    @Override
    public final IllegalStateException noHandlerCalled(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noHandlerCalled$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationContextIsNotAbstractOperationContext$str() {
        return "WFLYCTL0318: The operation context is not an AbstractOperationContext";
    }

    @Override
    public final OperationFailedException operationContextIsNotAbstractOperationContext() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.operationContextIsNotAbstractOperationContext$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String handlerIsReferencedBy$str() {
        return "WFLYCTL0319: The handler is referenced by %s and so cannot be removed";
    }

    @Override
    public final IllegalStateException handlerIsReferencedBy(Set<PathAddress> references) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.handlerIsReferencedBy$str(), references));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resolvedFileDoesNotExistOrIsDirectory$str() {
        return "WFLYCTL0320: The resolved file %s either does not exist or is a directory";
    }

    @Override
    public final IllegalStateException resolvedFileDoesNotExistOrIsDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.resolvedFileDoesNotExistOrIsDirectory$str(), file));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotBackUp$str() {
        return "WFLYCTL0321: Could not back up '%s' to '%s'";
    }

    @Override
    public final IllegalStateException couldNotBackUp(IOException cause, String absolutePath, String absolutePath1) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotBackUp$str(), absolutePath, absolutePath1), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attemptToBothRemoveAndAddHandlerUpdateInstead$str() {
        return "WFLYCTL0322: Attempt was made to both remove and add a handler from a composite operation - update the handler instead";
    }

    @Override
    public final IllegalStateException attemptToBothRemoveAndAddHandlerUpdateInstead() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.attemptToBothRemoveAndAddHandlerUpdateInstead$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attemptToBothAddAndRemoveAndHandlerFromCompositeOperation$str() {
        return "WFLYCTL0323: Attempt was made to both add and remove a handler from a composite operation";
    }

    @Override
    public final IllegalStateException attemptToBothAddAndRemoveAndHandlerFromCompositeOperation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.attemptToBothAddAndRemoveAndHandlerFromCompositeOperation$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attemptToBothUpdateAndRemoveHandlerFromCompositeOperation$str() {
        return "WFLYCTL0324: Attempt was made to both update and remove a handler from a composite operation";
    }

    @Override
    public final IllegalStateException attemptToBothUpdateAndRemoveHandlerFromCompositeOperation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.attemptToBothUpdateAndRemoveHandlerFromCompositeOperation$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation$str() {
        return "WFLYCTL0325: Attempt was made to both remove and add a handler reference from a composite operation";
    }

    @Override
    public final IllegalStateException attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownRole$str() {
        return "WFLYCTL0327: Unknown role '%s'";
    }

    @Override
    public final UnknowRoleException unknownRole(String roleName) {
        UnknowRoleException result = new UnknowRoleException(String.format(this.getLoggingLocale(), this.unknownRole$str(), roleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveStandardRole$str() {
        return "WFLYCTL0328: Cannot remove standard role '%s'";
    }

    @Override
    public final IllegalStateException cannotRemoveStandardRole(String roleName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRemoveStandardRole$str(), roleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownBaseRole$str() {
        return "WFLYCTL0329: Unknown base role '%s'";
    }

    @Override
    public final IllegalArgumentException unknownBaseRole(String roleName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownBaseRole$str(), roleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String roleIsAlreadyRegistered$str() {
        return "WFLYCTL0330: Role '%s' is already registered";
    }

    @Override
    public final IllegalStateException roleIsAlreadyRegistered(String roleName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.roleIsAlreadyRegistered$str(), roleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canOnlyCreateChildAuditLoggerForMainAuditLogger$str() {
        return "WFLYCTL0331: Can only create child audit logger for main audit logger";
    }

    @Override
    public final IllegalStateException canOnlyCreateChildAuditLoggerForMainAuditLogger() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.canOnlyCreateChildAuditLoggerForMainAuditLogger$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String permissionDenied$str() {
        return "WFLYCTL0332: Permission denied";
    }

    @Override
    public final String permissionDenied() {
        return String.format(this.getLoggingLocale(), this.permissionDenied$str(), new Object[0]);
    }

    protected String permissionCollectionIsReadOnly$str() {
        return "WFLYCTL0333: Cannot add a Permission to a readonly PermissionCollection";
    }

    @Override
    public final SecurityException permissionCollectionIsReadOnly() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.permissionCollectionIsReadOnly$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatiblePermissionType$str() {
        return "WFLYCTL0334: Incompatible permission type %s";
    }

    @Override
    public final IllegalArgumentException incompatiblePermissionType(Class<?> clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incompatiblePermissionType$str(), clazz));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String managementResourceNotFoundMessage$str() {
        return "WFLYCTL0335: Management resource '%s' not found";
    }

    @Override
    public final String managementResourceNotFoundMessage(PathAddress pathAddress) {
        return String.format(this.getLoggingLocale(), this.managementResourceNotFoundMessage$str(), pathAddress);
    }

    protected String attributesMustBeDefined$str() {
        return "WFLYCTL0336: The following attributes are nillable in the current model but must be defined in the target model version: %s";
    }

    @Override
    public final String attributesMustBeDefined(Set<String> keySet) {
        return String.format(this.getLoggingLocale(), this.attributesMustBeDefined$str(), keySet);
    }

    protected String unsupportedIdentityType$str() {
        return "WFLYCTL0337: Unsupported Identity type '%X' received.";
    }

    @Override
    public final IOException unsupportedIdentityType(byte type) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unsupportedIdentityType$str(), type));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedIdentityParameter$str() {
        return "WFLYCTL0338: Unsupported Identity parameter '%X' received parsing identity type '%X'.";
    }

    @Override
    public final IOException unsupportedIdentityParameter(byte parameterType, byte principalType) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unsupportedIdentityParameter$str(), parameterType, principalType));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributesMustBeDefinedAs$str() {
        return "WFLYCTL0339: The following attributes must be defined as %s in the current model: %s";
    }

    @Override
    public final String attributesMustBeDefinedAs(ModelNode value, Set<String> names) {
        return String.format(this.getLoggingLocale(), this.attributesMustBeDefinedAs$str(), value, names);
    }

    protected String attributesMustNotBeDefinedAs$str() {
        return "WFLYCTL0340: The following attributes must NOT be defined as %s in the current model: %s";
    }

    @Override
    public final String attributesMustNotBeDefinedAs(ModelNode value, Set<String> names) {
        return String.format(this.getLoggingLocale(), this.attributesMustNotBeDefinedAs$str(), value, names);
    }

    protected String badUriSyntax$str() {
        return "WFLYCTL0341: A uri with bad syntax '%s' was passed for validation.";
    }

    @Override
    public final OperationFailedException badUriSyntax(String uri) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.badUriSyntax$str(), uri));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBlockingTimeout$str() {
        return "WFLYCTL0342: Illegal value %d for operation header %s; value must be greater than zero";
    }

    @Override
    public final OperationFailedException invalidBlockingTimeout(long timeout, String headerName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidBlockingTimeout$str(), timeout, headerName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timeoutAwaitingInitialStability0$str() {
        return "WFLYCTL0343: The service container has been destabilized by a previous operation and further runtime updates cannot be processed. Restart is required.";
    }

    @Override
    public final String timeoutAwaitingInitialStability() {
        return String.format(this.getLoggingLocale(), this.timeoutAwaitingInitialStability0$str(), new Object[0]);
    }

    protected String timeoutExecutingOperation0$str() {
        return "WFLYCTL0344: Operation timed out awaiting service container stability";
    }

    @Override
    public final String timeoutExecutingOperation() {
        return String.format(this.getLoggingLocale(), this.timeoutExecutingOperation0$str(), new Object[0]);
    }

    protected String serviceInstallTimedOut$str() {
        return "WFLYCTL0345: Timeout after %d seconds waiting for existing service %s to be removed so a new instance can be installed.";
    }

    @Override
    public final IllegalStateException serviceInstallTimedOut(long timeout, ServiceName name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceInstallTimedOut$str(), timeout, name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidDefaultBlockingTimeout(String sysPropValue, String sysPropName, long defaultUsed) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidDefaultBlockingTimeout$str(), (Object)sysPropValue, (Object)sysPropName, (Object)defaultUsed);
    }

    protected String invalidDefaultBlockingTimeout$str() {
        return "WFLYCTL0346: Invalid value %s for property %s; must be a numeric value greater than zero. Default value of %d will be used.";
    }

    @Override
    public final void timeoutAwaitingInitialStability(long blockingTimeout, String name, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.timeoutAwaitingInitialStability3$str(), (Object)blockingTimeout, (Object)name, (Object)address);
    }

    protected String timeoutAwaitingInitialStability3$str() {
        return "WFLYCTL0347: Timeout after [%d] seconds waiting for initial service container stability before allowing runtime changes for operation '%s' at address '%s'. Operation will roll back; process restart is required.";
    }

    @Override
    public final void timeoutExecutingOperation(long blockingTimeout, String name, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.timeoutExecutingOperation3$str(), (Object)blockingTimeout, (Object)name, (Object)address);
    }

    protected String timeoutExecutingOperation3$str() {
        return "WFLYCTL0348: Timeout after [%d] seconds waiting for service container stability. Operation will roll back. Step that first updated the service container was '%s' at address '%s'";
    }

    @Override
    public final void timeoutCompletingOperation(long blockingTimeout, String name, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.timeoutCompletingOperation$str(), (Object)blockingTimeout, (Object)name, (Object)address);
    }

    protected String timeoutCompletingOperation$str() {
        return "WFLYCTL0349: Timeout after [%d] seconds waiting for service container stability while finalizing an operation. Process must be restarted. Step that first updated the service container was '%s' at address '%s'";
    }

    @Override
    public final void interruptedAwaitingInitialResponse(String operation, PathAddress proxyNodeAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingInitialResponse$str(), (Object)operation, (Object)proxyNodeAddress);
    }

    protected String interruptedAwaitingInitialResponse$str() {
        return "WFLYCTL0350: Execution of operation '%s' on remote process at address '%s' interrupted while awaiting initial response; remote process has been notified to cancel operation";
    }

    @Override
    public final void interruptedAwaitingFinalResponse(String operation, PathAddress proxyNodeAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.interruptedAwaitingFinalResponse$str(), (Object)operation, (Object)proxyNodeAddress);
    }

    protected String interruptedAwaitingFinalResponse$str() {
        return "WFLYCTL0351: Execution of operation '%s' on remote process at address '%s' interrupted while awaiting final response; remote process has been notified to terminate operation";
    }

    @Override
    public final void cancellingOperation(String operation, int id, String thread) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.cancellingOperation$str(), (Object)operation, (Object)id, (Object)thread);
    }

    protected String cancellingOperation$str() {
        return "WFLYCTL0352: Cancelling operation '%s' with id '%d' running on thread '%s'";
    }

    protected String responseHandlerNotFound$str() {
        return "WFLYCTL0353: No response handler for request %s";
    }

    @Override
    public final IOException responseHandlerNotFound(int id) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.responseHandlerNotFound$str(), id));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void attemptingReconnectToSyslog(String name, int timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.attemptingReconnectToSyslog$str(), (Object)name, (Object)timeout);
    }

    protected String attemptingReconnectToSyslog$str() {
        return "WFLYCTL0354: Attempting reconnect to syslog handler '%s; after timeout of %d seconds";
    }

    @Override
    public final void reconnectToSyslogFailed(String name, Throwable e) {
        this.log.logf(FQCN, Logger.Level.INFO, e, this.reconnectToSyslogFailed$str(), (Object)name);
    }

    protected String reconnectToSyslogFailed$str() {
        return "WFLYCTL0355: Reconnecting to syslog handler '%s failed";
    }

    @Override
    public final void failedToEmitNotification(Notification notification, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToEmitNotification$str(), (Object)notification);
    }

    protected String failedToEmitNotification$str() {
        return "WFLYCTL0356: Failed to emit notification %s";
    }

    protected String notificationIsNotDescribed$str() {
        return "WFLYCTL0357: Notification of type %s is not described for the resource at the address %s";
    }

    @Override
    public final String notificationIsNotDescribed(String type, PathAddress source) {
        return String.format(this.getLoggingLocale(), this.notificationIsNotDescribed$str(), type, source);
    }

    protected String resourceWasAdded$str() {
        return "WFLYCTL0358: The resource was added at the address %s.";
    }

    @Override
    public final String resourceWasAdded(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.resourceWasAdded$str(), address);
    }

    protected String resourceWasRemoved$str() {
        return "WFLYCTL0359: The resource was removed at the address %s.";
    }

    @Override
    public final String resourceWasRemoved(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.resourceWasRemoved$str(), address);
    }

    protected String attributeValueWritten$str() {
        return "WFLYCTL0360: The attribute %s value has been changed from %s to %s.";
    }

    @Override
    public final String attributeValueWritten(String attributeName, ModelNode currentValue, ModelNode newVal) {
        return String.format(this.getLoggingLocale(), this.attributeValueWritten$str(), attributeName, currentValue, newVal);
    }

    protected String capabilitiesNotAvailable$str() {
        return "WFLYCTL0361: Capabilities cannot be queried in stage '%s'; they are not available until stage '%s'.";
    }

    @Override
    public final IllegalStateException capabilitiesNotAvailable(OperationContext.Stage currentStage, OperationContext.Stage runtime) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.capabilitiesNotAvailable$str(), new Object[]{currentStage, runtime}));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requiredCapabilityMissing1$str() {
        return "WFLYCTL0362: Capabilities required by resource '%s' are not available:";
    }

    @Override
    public final String requiredCapabilityMissing(String demandingAddress) {
        return String.format(this.getLoggingLocale(), this.requiredCapabilityMissing1$str(), demandingAddress);
    }

    protected String capabilityAlreadyRegisteredInContext2$str() {
        return "WFLYCTL0363: Capability '%s' is already registered in context '%s'.";
    }

    @Override
    public final IllegalStateException capabilityAlreadyRegisteredInContext(String capability, String context) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.capabilityAlreadyRegisteredInContext2$str(), capability, context));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCapability$str() {
        return "WFLYCTL0364: Capability '%s' is unknown.";
    }

    @Override
    public final IllegalStateException unknownCapability(String capability) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownCapability$str(), capability));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCapabilityInContext$str() {
        return "WFLYCTL0365: Capability '%s' is unknown in context '%s'.";
    }

    @Override
    public final IllegalStateException unknownCapabilityInContext(String capability, String context) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownCapabilityInContext$str(), capability, context));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String capabilityDoesNotExposeRuntimeAPI$str() {
        return "WFLYCTL0366: Capability '%s' does not expose a runtime API.";
    }

    @Override
    public final IllegalArgumentException capabilityDoesNotExposeRuntimeAPI(String capabilityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.capabilityDoesNotExposeRuntimeAPI$str(), capabilityName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveRequiredCapability$str() {
        return "WFLYCTL0367: Cannot remove capability '%s' as it is required by other capabilities:";
    }

    @Override
    public final String cannotRemoveRequiredCapability(String capability) {
        return String.format(this.getLoggingLocale(), this.cannotRemoveRequiredCapability$str(), capability);
    }

    protected String cannotRemoveRequiredCapabilityInContext$str() {
        return "WFLYCTL0368: Cannot remove capability '%s' from context '%s' as it is required by other capabilities:";
    }

    @Override
    public final String cannotRemoveRequiredCapabilityInContext(String capability, String context) {
        return String.format(this.getLoggingLocale(), this.cannotRemoveRequiredCapabilityInContext$str(), capability, context);
    }

    protected String requiredCapabilityMissing0$str() {
        return "WFLYCTL0369: Required capabilities are not available:";
    }

    @Override
    public final String requiredCapabilityMissing() {
        return String.format(this.getLoggingLocale(), this.requiredCapabilityMissing0$str(), new Object[0]);
    }

    protected String requirementPointSimple$str() {
        return "capability '%s' requires it for address '%s'";
    }

    @Override
    public final String requirementPointSimple(String capability, String requestingAddress) {
        return String.format(this.getLoggingLocale(), this.requirementPointSimple$str(), capability, requestingAddress);
    }

    protected String requirementPointFull$str() {
        return "capability '%s' requires it for attribute '%s' at address '%s'";
    }

    @Override
    public final String requirementPointFull(String capability, String attribute, String requestingAddress) {
        return String.format(this.getLoggingLocale(), this.requirementPointFull$str(), capability, attribute, requestingAddress);
    }

    protected String formattedCapabilityName$str() {
        return "    %s";
    }

    @Override
    public final String formattedCapabilityName(String capability) {
        return String.format(this.getLoggingLocale(), this.formattedCapabilityName$str(), capability);
    }

    protected String formattedCapabilityId$str() {
        return "    %s in context '%s'";
    }

    @Override
    public final String formattedCapabilityId(String capability, String context) {
        return String.format(this.getLoggingLocale(), this.formattedCapabilityId$str(), capability, context);
    }

    protected String possibleCapabilityProviderPoints$str() {
        return "; Possible registration points for this capability: %s";
    }

    @Override
    public final String possibleCapabilityProviderPoints(String providerPoints) {
        return String.format(this.getLoggingLocale(), this.possibleCapabilityProviderPoints$str(), providerPoints);
    }

    protected String noKnownProviderPoints$str() {
        return "; There are no known registration points which can provide this capability.";
    }

    @Override
    public final String noKnownProviderPoints() {
        return String.format(this.getLoggingLocale(), this.noKnownProviderPoints$str(), new Object[0]);
    }

    protected String unsupportedUsageOfExpression$str() {
        return "; This unresolvable capability likely is due to the use of an expression string in a configuration attribute that does not support expressions.";
    }

    @Override
    public final String unsupportedUsageOfExpression() {
        return String.format(this.getLoggingLocale(), this.unsupportedUsageOfExpression$str(), new Object[0]);
    }

    protected String incompleteExpression$str() {
        return "WFLYCTL0370: Incomplete expression: %s";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException incompleteExpression(String expression) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.incompleteExpression$str(), expression));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedElement$str() {
        return "WFLYCTL0371: The element '%s' is no longer supported, please use '%s' instead";
    }

    @Override
    public final XMLStreamException unsupportedElement(QName name, Location location, String supportedElement) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unsupportedElement$str(), name, supportedElement), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateElementsInList$str() {
        return "WFLYCTL0372: List attribute '%s' contains duplicates, which are not allowed";
    }

    @Override
    public final String duplicateElementsInList(String name) {
        return String.format(this.getLoggingLocale(), this.duplicateElementsInList$str(), name);
    }

    protected String deploymentResourceMustBeRuntimeOnly$str() {
        return "WFLYCTL0373: Deployment resource must be runtime only";
    }

    @Override
    public final IllegalArgumentException deploymentResourceMustBeRuntimeOnly() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.deploymentResourceMustBeRuntimeOnly$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolveExpressions$str() {
        return "WFLYCTL0374: Unable to resolve expressions at this location.";
    }

    @Override
    public final OperationFailedException unableToResolveExpressions() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToResolveExpressions$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void udpSyslogServerUnavailable(String name, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.udpSyslogServerUnavailable$str(), (Object)name, (Object)message);
    }

    protected String udpSyslogServerUnavailable$str() {
        return "WFLYCTL0375: Update of the management operation audit log failed on the handler '%s' due to '%s'. Please make sure that the syslog server is running and reachable";
    }

    protected String unexpectedAttribute2$str() {
        return "WFLYCTL0376: Unexpected attribute '%s' encountered. Valid attributes are: '%s'";
    }

    @Override
    public final XMLStreamException unexpectedAttribute(QName name, StringBuilder possibleAttributes, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedAttribute2$str(), name, possibleAttributes), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedElement2$str() {
        return "WFLYCTL0377: Unexpected element '%s' encountered. Valid elements are: '%s'";
    }

    @Override
    public final XMLStreamException unexpectedElement(QName name, StringBuilder possible, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedElement2$str(), name, possible), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeIsWrongType$str() {
        return "WFLYCTL0378: Attribute '%s' is not of type '%s', it is type '%s'";
    }

    @Override
    public final OperationFailedException attributeIsWrongType(String name, ModelType expectedType, ModelType providedType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.attributeIsWrongType$str(), name, expectedType, providedType));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String managementUnavailableDuringBoot$str() {
        return "WFLYCTL0379: System boot is in process; execution of remote management operations is not currently available";
    }

    @Override
    public final String managementUnavailableDuringBoot() {
        return String.format(this.getLoggingLocale(), this.managementUnavailableDuringBoot$str(), new Object[0]);
    }

    protected String requiredAttributeNotSet$str() {
        return "WFLYCTL0380: Attribute '%s' needs to be set or passed before attribute '%s' can be correctly set";
    }

    @Override
    public final OperationFailedException requiredAttributeNotSet(String required, String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredAttributeNotSet$str(), required, name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalPermissionName$str() {
        return "WFLYCTL0381: Illegal permission name '%s'";
    }

    @Override
    public final IllegalArgumentException illegalPermissionName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalPermissionName$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalPermissionActions$str() {
        return "WFLYCTL0382: Illegal permission actions '%s'";
    }

    @Override
    public final IllegalArgumentException illegalPermissionActions(String actions) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalPermissionActions$str(), actions));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noOperationDefined$str() {
        return "WFLYCTL0383: No operation is defined %s";
    }

    @Override
    public final String noOperationDefined(ModelNode operation) {
        return String.format(this.getLoggingLocale(), this.noOperationDefined$str(), operation);
    }

    protected String nonHostCapableSubsystemInHostModel$str() {
        return "WFLYCTL0385: An attempt was made to register the non-host capable subsystem '%s' from extension module '%s' in the host model.";
    }

    @Override
    public final IllegalStateException nonHostCapableSubsystemInHostModel(String subsystemName, String extensionModuleName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.nonHostCapableSubsystemInHostModel$str(), subsystemName, extensionModuleName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String onlyAccessHostControllerInfoInRuntimeStage$str() {
        return "WFLYCTL0386: The host controller info can only be accessed after the model stage on boot";
    }

    @Override
    public final OperationFailedException onlyAccessHostControllerInfoInRuntimeStage() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.onlyAccessHostControllerInfoInRuntimeStage$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalCLIStylePathAddress$str() {
        return "WFLYCTL0387: Illegal path address '%s' , it is not in a correct CLI format";
    }

    @Override
    public final IllegalArgumentException illegalCLIStylePathAddress(String pathAddress) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalCLIStylePathAddress$str(), pathAddress));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateEmptyConfig$str() {
        return "WFLYCTL0388: Could not create empty configuration file %s";
    }

    @Override
    public final IllegalStateException cannotCreateEmptyConfig(String absolutePath, IOException cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateEmptyConfig$str(), absolutePath), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rejectEmptyConfig$str() {
        return "WFLYCTL0389: Could not create an empty configuration at file %s as there is an existing non-empty configuration there";
    }

    @Override
    public final IllegalStateException rejectEmptyConfig(String absolutePath) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.rejectEmptyConfig$str(), absolutePath));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotResolveExpressionIndex$str() {
        return "WFLYCTL0391: Could not resolve attribute expression: '%s', invalid index '%d'";
    }

    @Override
    public final OperationFailedException couldNotResolveExpressionIndex(String attributeExpression, int index) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotResolveExpressionIndex$str(), attributeExpression, index));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotResolveExpressionList$str() {
        return "WFLYCTL0392: Could not resolve attribute expression: '%s', type is not a list";
    }

    @Override
    public final OperationFailedException couldNotResolveExpressionList(String attributeExpression) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotResolveExpressionList$str(), attributeExpression));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotResolveExpression$str() {
        return "WFLYCTL0393: Could not resolve attribute expression: '%s'";
    }

    @Override
    public final OperationFailedException couldNotResolveExpression(String attributeExpression) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotResolveExpression$str(), attributeExpression));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCapabilityServiceType$str() {
        return "WFLYCTL0394: Capability '%s' does not provide services of type '%s'";
    }

    @Override
    public final IllegalArgumentException invalidCapabilityServiceType(String capabilityName, Class<?> serviceType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCapabilityServiceType$str(), capabilityName, serviceType));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void operationDeprecated(String name, String address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.operationDeprecated$str(), (Object)name, (Object)address);
    }

    protected String operationDeprecated$str() {
        return "WFLYCTL0395: Operation %s against the resource at address %s is deprecated, and it might be removed in future version. See the the output of the read-operation-description operation to learn more about the deprecation.";
    }

    protected String discardedResourceTransformation$str() {
        return "WFLYCTL0396: Resource %s is discarded on the target host %s";
    }

    @Override
    public final String discardedResourceTransformation(PathAddress address, String host) {
        return String.format(this.getLoggingLocale(), this.discardedResourceTransformation$str(), address, host);
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return "WFLYCTL0397: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement element) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), element));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String orderedChildTypeRenamed$str() {
        return "WFLYCTL0398: An attempt was made to rename the resource found at %s to %s. However, '%s' is one of the resource types defined to be ordered on the parent resource %s";
    }

    @Override
    public final OperationFailedRuntimeException orderedChildTypeRenamed(PathAddress read, PathAddress transformed, String type, Set<String> parentOrderedChildren) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.orderedChildTypeRenamed$str(), read, transformed, type, parentOrderedChildren));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentCapabilityContexts4$str() {
        return "WFLYCTL0399: The capability '%s' required by capability '%s' in context '%s' is available in one or more socket binding groups, but not all socket binding capabilities required by '%s' can be resolved from a single socket binding group, so this configuration is invalid";
    }

    @Override
    public final String inconsistentCapabilityContexts(String requiredName, String dependentName, String dependentContext, String dependentContextAgain) {
        return String.format(this.getLoggingLocale(), this.inconsistentCapabilityContexts4$str(), requiredName, dependentName, dependentContext, dependentContextAgain);
    }

    @Override
    public final void inconsistentCapabilityContexts(String dependentName, String dependentContext, String address, String requiredName, String dependentContextAgain) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.inconsistentCapabilityContexts5$str(), new Object[]{dependentName, dependentContext, address, requiredName, dependentContextAgain});
    }

    protected String inconsistentCapabilityContexts5$str() {
        return "WFLYCTL0400: Capability '%s' in context '%s' associated with resource '%s' requires capability '%s'. It is available in one or more socket binding groups, but not all socket binding capabilities required by '%s' can be resolved from a single socket binding group, so this configuration is invalid";
    }

    protected String failedToBuildReport$str() {
        return "WFLYCTL0401: Couldn't build the report";
    }

    @Override
    public final RuntimeException failedToBuildReport(Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToBuildReport$str(), new Object[0]), t);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void removeUnsupportedLegacyExtension(List<String> subsystemNames, String extensionName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.removeUnsupportedLegacyExtension$str(), subsystemNames, (Object)extensionName);
    }

    protected String removeUnsupportedLegacyExtension$str() {
        return "WFLYCTL0402: Subsystems %s provided by legacy extension '%s' are not supported on servers running this version. Both the subsystem and the extension must be removed or migrated before the server will function.";
    }

    @Override
    public final void unexpectedOperationExecutionException(Throwable t, List<ModelNode> controllerOperations) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexpectedOperationExecutionException$str(), controllerOperations);
    }

    protected String unexpectedOperationExecutionException$str() {
        return "WFLYCTL0403: Unexpected failure during execution of the following operation(s): %s";
    }

    protected String unexpectedOperationExecutionFailureDescription$str() {
        return "WFLYCTL0404: Unexpected exception during execution: %s";
    }

    @Override
    public final String unexpectedOperationExecutionFailureDescription(RuntimeException e) {
        return String.format(this.getLoggingLocale(), this.unexpectedOperationExecutionFailureDescription$str(), e);
    }

    @Override
    public final void couldNotFindTransformerRegistryFallingBack(ModelVersion currentVersion, ModelVersion fallbackVersion) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotFindTransformerRegistryFallingBack$str(), (Object)currentVersion, (Object)fallbackVersion);
    }

    protected String couldNotFindTransformerRegistryFallingBack$str() {
        return "WFLYCTL0405: Couldn't find a transformer to %s, falling back to %s";
    }

    protected String selectFailedCouldNotConvertAttributeToType$str() {
        return "WFLYCTL0406: Could not convert the attribute '%s' to a %s";
    }

    @Override
    public final OperationFailedException selectFailedCouldNotConvertAttributeToType(String attribute, ModelType type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.selectFailedCouldNotConvertAttributeToType$str(), attribute, type));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedSendingCompletedResponse(Throwable cause, ModelNode response, int operationId) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedSendingCompletedResponse$str(), (Object)response, (Object)operationId);
    }

    protected String failedSendingCompletedResponse$str() {
        return "WFLYCTL0407: Failed sending completed response %s for %d";
    }

    @Override
    public final void failedSendingFailedResponse(Throwable cause, ModelNode response, int operationId) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedSendingFailedResponse$str(), (Object)response, (Object)operationId);
    }

    protected String failedSendingFailedResponse$str() {
        return "WFLYCTL0408: Failed sending failure response %s for %d";
    }

    protected String proxiedOperationTimedOut$str() {
        return "WFLYCTL0409: Execution of operation '%s' on remote process at address '%s' timed out after %d ms while awaiting initial response; remote process has been notified to terminate operation";
    }

    @Override
    public final String proxiedOperationTimedOut(String operation, PathAddress target, long timeout) {
        return String.format(this.getLoggingLocale(), this.proxiedOperationTimedOut$str(), operation, target, timeout);
    }

    @Override
    public final void timeoutAwaitingFinalResponse(String operation, PathAddress proxyNodeAddress, long timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timeoutAwaitingFinalResponse$str(), (Object)operation, (Object)proxyNodeAddress, (Object)timeout);
    }

    protected String timeoutAwaitingFinalResponse$str() {
        return "WFLYCTL0410: Execution of operation '%s' on remote process at address '%s' timed out after %d ms while awaiting final response; remote process has been notified to terminate operation";
    }

    @Override
    public final void failedToParseElementLenient(XMLStreamException e, String elementName) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToParseElementLenient$str(), (Object)elementName);
    }

    protected String failedToParseElementLenient$str() {
        return "WFLYCTL0411: Failed to parse element '%s', ignoring ...";
    }

    protected String missingRequiredServices$str() {
        return "WFLYCTL0412: Required services that are not installed:";
    }

    @Override
    public final String missingRequiredServices() {
        return String.format(this.getLoggingLocale(), this.missingRequiredServices$str(), new Object[0]);
    }

    protected String deprecatedAndCurrentParameterMismatch$str() {
        return "WFLYCTL0413: The deprecated parameter %s has been set in addition to the current parameter %s but with different values";
    }

    @Override
    public final OperationFailedException deprecatedAndCurrentParameterMismatch(String deprecated, String current) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.deprecatedAndCurrentParameterMismatch$str(), deprecated, current));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void couldNotCreateHistoricalBackup(String currentHistoryDir) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotCreateHistoricalBackup$str(), (Object)currentHistoryDir);
    }

    protected String couldNotCreateHistoricalBackup$str() {
        return "WFLYCTL0414: Could not create a timestamped backup of current history dir %s, so it may still include versions from the previous boot.";
    }

    protected String runtimeModificationBegun$str() {
        return "WFLYCTL0415: Modification of the runtime service container by a management operation has begun";
    }

    @Override
    public final String runtimeModificationBegun() {
        return String.format(this.getLoggingLocale(), this.runtimeModificationBegun$str(), new Object[0]);
    }

    protected String runtimeModificationComplete$str() {
        return "WFLYCTL0416: Modification of the runtime service container by a management operation has completed";
    }

    @Override
    public final String runtimeModificationComplete() {
        return String.format(this.getLoggingLocale(), this.runtimeModificationComplete$str(), new Object[0]);
    }

    protected String cannotAddMoreThanOneJvmForServerOrHost$str() {
        return "WFLYCTL0417: Cannot add more than one jvm. Add of '%s' attempted, but '%s' already exists";
    }

    @Override
    public final OperationFailedException cannotAddMoreThanOneJvmForServerOrHost(PathAddress requested, PathAddress existing) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddMoreThanOneJvmForServerOrHost$str(), requested, existing));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String socketBindingalreadyDeclared$str() {
        return "WFLYCTL0418: A %s or a %s %s already declared has already been declared in %s %s";
    }

    @Override
    public final OperationFailedRuntimeException socketBindingalreadyDeclared(String name1, String name2, String value, String parentName, String parentValue) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.socketBindingalreadyDeclared$str(), name1, name2, value, parentName, parentValue));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMaxBytesLength$str() {
        return "WFLYCTL0419: '%s' is an invalid value for parameter %s. Values must have a maximum length of %d bytes";
    }

    @Override
    public final String invalidMaxBytesLength(String str, String parameterName, int max) {
        return String.format(this.getLoggingLocale(), this.invalidMaxBytesLength$str(), str, parameterName, max);
    }

    protected String invalidMinBytesLength$str() {
        return "WFLYCTL0420: '%s' is an invalid value for parameter %s. Values must have a minimum length of %d bytes";
    }

    @Override
    public final String invalidMinBytesLength(String str, String parameterName, int min) {
        return String.format(this.getLoggingLocale(), this.invalidMinBytesLength$str(), str, parameterName, min);
    }

    protected String explodedDeploymentNotSupported$str() {
        return "WFLYCTL0421: Exploded deployment is not supported by some servers";
    }

    @Override
    public final String explodedDeploymentNotSupported() {
        return String.format(this.getLoggingLocale(), this.explodedDeploymentNotSupported$str(), new Object[0]);
    }

    protected String couldNotLoadModuleForTransformers$str() {
        return "WFLYCTL0422: Could not load module '%s' for transformers";
    }

    @Override
    public final RuntimeException couldNotLoadModuleForTransformers(String name, ModuleLoadException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotLoadModuleForTransformers$str(), name), (Throwable)e);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongMaskedPasswordFormat$str() {
        return "WFLYCTL0423: Masked password command has the wrong format.%nUsage: MASK-<encoded secret>;<salt>;<iteration count> where <salt>=UTF-8 characters, <iteration count>=reasonable sized positive integer";
    }

    @Override
    public final IOException wrongMaskedPasswordFormat() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.wrongMaskedPasswordFormat$str(), new Object[0]));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAddressFormat$str() {
        return "WFLYCTL0433: '%s' is not a valid representation of a resource address";
    }

    @Override
    public final OperationFailedException invalidAddressFormat(ModelNode address) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidAddressFormat$str(), address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bootComplete$str() {
        return "WFLYCTL0434: Boot complete";
    }

    @Override
    public final String bootComplete() {
        return String.format(this.getLoggingLocale(), this.bootComplete$str(), new Object[0]);
    }

    protected String attributeWasNotMarkedAsReloadRequired$str() {
        return "WFLYCTL0435: Attribute %s of resource %s was not marked as reload required, either set the RESTART_ALL_SERVICES flag, or register a custom write handler.";
    }

    @Override
    public final RuntimeException attributeWasNotMarkedAsReloadRequired(String name, PathAddress pathAddress) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.attributeWasNotMarkedAsReloadRequired$str(), name, pathAddress));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typeConversionError$str() {
        return "Couldn't convert %s to %s";
    }

    @Override
    public final String typeConversionError(ModelNode value, Collection<ModelType> validTypes) {
        return String.format(this.getLoggingLocale(), this.typeConversionError$str(), value, validTypes);
    }

    protected String capabilityAlreadyRegisteredInContext4$str() {
        return "WFLYCTL0436: Cannot register capability '%s' at location '%s' as it is already registered in context '%s' at location(s) '%s'";
    }

    @Override
    public final OperationFailedRuntimeException capabilityAlreadyRegisteredInContext(String capability, RegistrationPoint newPoint, String context, Set<RegistrationPoint> oldPoints) {
        OperationFailedRuntimeException result = new OperationFailedRuntimeException(String.format(this.getLoggingLocale(), this.capabilityAlreadyRegisteredInContext4$str(), capability, newPoint, context, oldPoints));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateExtensionElement$str() {
        return "WFLYCTL0437: Duplicate extension: an %s element with %s attribute value '%s' has already been parsed";
    }

    @Override
    public final XMLStreamException duplicateExtensionElement(String elementConstant, String attrConstant, String module, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateExtensionElement$str(), elementConstant, attrConstant, module), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldntConvertWarningLevel$str() {
        return "WFLYCTL0438: Couldn't convert '%s' into proper warning level, threshold falling back to 'ALL'. Possible values: SEVERE,WARNING,INFO,CONFIG,FINE,FINER,FINEST,ALL,OFF";
    }

    @Override
    public final String couldntConvertWarningLevel(String level) {
        return String.format(this.getLoggingLocale(), this.couldntConvertWarningLevel$str(), level);
    }

    protected String invalidSubnetFormat$str() {
        return "WFLYCTL0439: Value %s for attribute %s is not a valid subnet format";
    }

    @Override
    public final OperationFailedException invalidSubnetFormat(String value, String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSubnetFormat$str(), value, name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotDeleteFileOrDirectory(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotDeleteFileOrDirectory$str(), (Object)file);
    }

    protected String cannotDeleteFileOrDirectory$str() {
        return "WFLYCTL0440: Cannot delete file or directory %s";
    }

    protected String serviceStatusReportFailureHeader$str() {
        return "WFLYCTL0441: Operation has resulted in failed or missing services %n";
    }

    @Override
    public final String serviceStatusReportFailureHeader() {
        return String.format(this.getLoggingLocale(), this.serviceStatusReportFailureHeader$str(), new Object[0]);
    }

    @Override
    public final void errorStoppingServer(Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.errorStoppingServer$str(), new Object[0]);
    }

    protected String errorStoppingServer$str() {
        return "WFLYCTL0442: Error stopping server";
    }

    @Override
    public final void errorObtainingPassword(Exception cause, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.errorObtainingPassword$str(), (Object)message);
    }

    protected String errorObtainingPassword$str() {
        return "WFLYCTL0443: Error getting the password from the supplier %s";
    }

    @Override
    public final void invalidRuntimeStageForProfile(String operation, String address, OperationContext.Stage stage, ProcessType processType) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.invalidRuntimeStageForProfile$str(), new Object[]{operation, address, stage, processType});
    }

    protected String invalidRuntimeStageForProfile$str() {
        return "WFLYCTL0444: The handler for operation '%s' at address '%s' attempted to add a stage %s step. This is not valid for a 'profile' resource on process type %s so this step will not be executed.";
    }

    protected String alreadyDefinedAttribute$str() {
        return "WFLYCTL0445: %s with value '%s' in attribute %s is already defined";
    }

    @Override
    public final OperationFailedException alreadyDefinedAttribute(String resource, String value, String attribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.alreadyDefinedAttribute$str(), resource, value, attribute));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requiredWithAlternatives$str() {
        return "WFLYCTL0446: %s or alternative(s) %s is required";
    }

    @Override
    public final OperationFailedException requiredWithAlternatives(String name, Set<String> alternatives) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredWithAlternatives$str(), name, alternatives));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void attributeExpressionDeprecated(String name, String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attributeExpressionDeprecated$str(), (Object)name, (Object)address);
    }

    protected String attributeExpressionDeprecated$str() {
        return "WFLYCTL0447: Attribute '%s' in the resource at address '%s' has been configured with an expression, but support for use of expressions in this attribute's value may be removed in a future version. This attribute configures whether a capability that can be required by other parts of the configuration is present or itself configures a requirement for a capability provided by another part of the configuration. Full support for this kind of configuration cannot be provided when an expression is used.";
    }

    protected String servicesWithTransitiveUnavailability$str() {
        return "WFLYCTL0448: %s additional services are down due to their dependencies being missing or failed";
    }

    @Override
    public final String servicesWithTransitiveUnavailability(int count) {
        return String.format(this.getLoggingLocale(), this.servicesWithTransitiveUnavailability$str(), count);
    }

    protected String operationDeprecatedMessage$str() {
        return "WFLYCTL0449: Operation %s against the resource at address %s is deprecated, and it might be removed in future version. See the the output of the read-operation-description operation to learn more about the deprecation.";
    }

    @Override
    public final String operationDeprecatedMessage(String name, String address) {
        return String.format(this.getLoggingLocale(), this.operationDeprecatedMessage$str(), name, address);
    }

    protected String failedToCloneRepository$str() {
        return "WFLYCTL0450: Failed to clone the repository %s";
    }

    @Override
    public final RuntimeException failedToCloneRepository(Exception cause, String repository) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCloneRepository$str(), repository), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToPublishConfiguration$str() {
        return "WFLYCTL0451: Failed to publish configuration to %s because of %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToPublishConfiguration(Throwable cause, String name, String error) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToPublishConfiguration$str(), name, error), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToPersistConfiguration$str() {
        return "WFLYCTL0452: Failed to persist configuration to %s because of %s";
    }

    @Override
    public final ConfigurationPersistenceException failedToPersistConfiguration(Throwable cause, String name, String error) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToPersistConfiguration$str(), name, error), cause);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToDeleteConfigurationSnapshot(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToDeleteConfigurationSnapshot$str(), (Object)name);
    }

    protected String failedToDeleteConfigurationSnapshot$str() {
        return "WFLYCTL0453: Failed to delete configuration snapshot %s";
    }

    @Override
    public final void failedToListConfigurationSnapshot(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToListConfigurationSnapshot$str(), (Object)name);
    }

    protected String failedToListConfigurationSnapshot$str() {
        return "WFLYCTL0454: Failed to list configuration snapshots %s";
    }

    protected String snapshotAlreadyExistError$str() {
        return "WFLYCTL0455: Can't take snapshot %s because it already exists";
    }

    @Override
    public final ConfigurationPersistenceException snapshotAlreadyExistError(String name) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.snapshotAlreadyExistError$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void systemPropertyAlreadyExist(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.systemPropertyAlreadyExist$str(), (Object)name);
    }

    protected String systemPropertyAlreadyExist$str() {
        return "WFLYCTL0456: System property \"%s\" is already set in the <system-properties> section of the configuration file. The value set in the command line will be overridden by that value.";
    }

    protected String invalidHeaderName$str() {
        return "WFLYCTL0457: Invalid HTTP Header name '%s'";
    }

    @Override
    public final OperationFailedException invalidHeaderName(String value) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidHeaderName$str(), value));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String disallowedHeaderName$str() {
        return "WFLYCTL0458: Disallowed HTTP Header name '%s'";
    }

    @Override
    public final OperationFailedException disallowedHeaderName(String value) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.disallowedHeaderName$str(), value));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void missingManagementServices() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.missingManagementServices$str(), new Object[0]);
    }

    protected String missingManagementServices$str() {
        return "WFLYCTL0459: Triggering roll back due to missing management services.";
    }

    protected String propertyCanOnlyBeUsedWithStandaloneOrEmbeddedServer$str() {
        return "WFLYCTL0460: The system property '%s' can only be used with a standalone or embedded server";
    }

    @Override
    public final IllegalStateException propertyCanOnlyBeUsedWithStandaloneOrEmbeddedServer(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertyCanOnlyBeUsedWithStandaloneOrEmbeddedServer$str(), propertyName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyCanOnlyBeUsedWithAdminOnlyModeServer$str() {
        return "WFLYCTL0461: The system property '%s' can only be used with an admin-only server";
    }

    @Override
    public final IllegalStateException propertyCanOnlyBeUsedWithAdminOnlyModeServer(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertyCanOnlyBeUsedWithAdminOnlyModeServer$str(), propertyName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotFindDirectorySpecifiedByProperty$str() {
        return "WFLYCTL0462: Could not find the directory '%s' specified by the system property '%s'. Please make sure it exists";
    }

    @Override
    public final IllegalStateException couldNotFindDirectorySpecifiedByProperty(String fileName, String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotFindDirectorySpecifiedByProperty$str(), fileName, propertyName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moreThanOneInstanceOfAdditionalBootCliScriptInvokerFound$str() {
        return "WFLYCTL0463: More than one instance of AdditionalBootCliScriptInvoker found. Have: '%s'; found: '%s";
    }

    @Override
    public final IllegalStateException moreThanOneInstanceOfAdditionalBootCliScriptInvokerFound(String name, String name1) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.moreThanOneInstanceOfAdditionalBootCliScriptInvokerFound$str(), name, name1));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cliScriptPropertyDefinedWithoutMarkerDirectoryWhenNotSkippingReload$str() {
        return "WFLYCTL0464: If using %s=true, when you use -D%s you need to set -D%s";
    }

    @Override
    public final IllegalStateException cliScriptPropertyDefinedWithoutMarkerDirectoryWhenNotSkippingReload(String skipProperty, String scriptProperty, String markerDirectoryProperty) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cliScriptPropertyDefinedWithoutMarkerDirectoryWhenNotSkippingReload$str(), skipProperty, scriptProperty, markerDirectoryProperty));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void initialisedAdditionalBootCliScriptSystemKeepingAlive(File additionalBootCliScript, File doneMarker) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initialisedAdditionalBootCliScriptSystemKeepingAlive$str(), (Object)additionalBootCliScript, (Object)doneMarker);
    }

    protected String initialisedAdditionalBootCliScriptSystemKeepingAlive$str() {
        return "WFLYCTL0465: Initialised the additional boot CLI script functionality. The CLI commands will be read from %s. The server will remain running in admin-only mode after these have been executed, and the result of the cli operations will be written to %s";
    }

    @Override
    public final void initialisedAdditionalBootCliScriptSystemNotKeepingAlive(File additionalBootCliScript) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initialisedAdditionalBootCliScriptSystemNotKeepingAlive$str(), (Object)additionalBootCliScript);
    }

    protected String initialisedAdditionalBootCliScriptSystemNotKeepingAlive$str() {
        return "WFLYCTL0466: Initialised the additional boot CLI script functionality. The CLI commands will be read from %s. The server will be rebooted to normal mode after these have been executed";
    }

    @Override
    public final void executingBootCliScript(File additionalBootCliScript) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.executingBootCliScript$str(), (Object)additionalBootCliScript);
    }

    protected String executingBootCliScript$str() {
        return "WFLYCTL0467: Running the additional commands from the CLI script %s against the server which is running in admin-only mode";
    }

    @Override
    public final void completedRunningBootCliScript() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.completedRunningBootCliScript$str(), new Object[0]);
    }

    protected String completedRunningBootCliScript$str() {
        return "WFLYCTL0468: Completed running the commands from the CLI script";
    }

    @Override
    public final void restartingServerAfterBootCliScript(File shutdownInitiated, String cliScriptProperty, String skipReloadProperty, String markerDirectoryProperty) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.restartingServerAfterBootCliScript$str(), new Object[]{shutdownInitiated, cliScriptProperty, skipReloadProperty, markerDirectoryProperty});
    }

    protected String restartingServerAfterBootCliScript$str() {
        return "WFLYCTL0469: Restarting the server since the additional commands from the CLI script requires a restart. This will record that the restart has been initiated in the marker file %s since the restart mechanism will preserve all properties pertaining to the additional boot CLI script functionality (%s, %s, %s). The restart maintains the admin-only running mode, so a subsequent reload will happen";
    }

    @Override
    public final void reloadingServerToNormalModeAfterAdditionalBootCliScript(String cliScriptProperty, String skipReloadProperty, String markerDirectoryProperty) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reloadingServerToNormalModeAfterAdditionalBootCliScript$str(), (Object)cliScriptProperty, (Object)skipReloadProperty, (Object)markerDirectoryProperty);
    }

    protected String reloadingServerToNormalModeAfterAdditionalBootCliScript$str() {
        return "WFLYCTL0470: Reloading the server to normal mode after execution of the additional commands from the CLI script. This will clear the properties triggering the additional boot cli script functionality if they were set (%s, %s, %s), and delete the marker file indicating the server was restarted";
    }

    @Override
    public final void reloadingServerToNormalModeAfterRestartAfterAdditionalBootCliScript(String cliScriptProperty, String skipReloadProperty, String markerDirectoryProperty) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reloadingServerToNormalModeAfterRestartAfterAdditionalBootCliScript$str(), (Object)cliScriptProperty, (Object)skipReloadProperty, (Object)markerDirectoryProperty);
    }

    protected String reloadingServerToNormalModeAfterRestartAfterAdditionalBootCliScript$str() {
        return "WFLYCTL0471: Reloading the server to normal mode after restart follwoing execution of the additional commands from the CLI script. This will clear the properties triggering the additional boot cli script functionality if they were set (%s, %s, %s)";
    }

    @Override
    public final void checkingForPresenceOfRestartMarkerFile() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.checkingForPresenceOfRestartMarkerFile$str(), new Object[0]);
    }

    protected String checkingForPresenceOfRestartMarkerFile$str() {
        return "WFLYCTL0472: Checking for presence of marker file indicating that the server has been restarted following execution of the additional commands from the CLI script";
    }

    @Override
    public final void foundRestartMarkerFile(File file) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.foundRestartMarkerFile$str(), (Object)file);
    }

    protected String foundRestartMarkerFile$str() {
        return "WFLYCTL0473: Marker file indicating that the server has been restarted following execution of the additional commands from the CLI script found at %s";
    }

    @Override
    public final void noRestartMarkerFile() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noRestartMarkerFile$str(), new Object[0]);
    }

    protected String noRestartMarkerFile$str() {
        return "WFLYCTL0474: No marker file found indicating that the server has been restarted following execution of the additional commands from the CLI script";
    }

    protected String invalidAttributeValue1$str() {
        return "WFLYCTL0475: Value for attribute '%s' is invalid.";
    }

    @Override
    public final OperationFailedException invalidAttributeValue(String attributeName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidAttributeValue1$str(), attributeName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCredentialReferenceValue$str() {
        return "WFLYCTL0476: Value for attribute '%s' is invalid: either '%s' must be specified on its own or '%s' needs to be specified with at least one of '%s' or '%s'";
    }

    @Override
    public final OperationFailedException invalidCredentialReferenceValue(String attributeName, String clearTextAttributeName, String credentialStoreAttributeName, String clearTextAttributeName1, String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCredentialReferenceValue$str(), attributeName, clearTextAttributeName, credentialStoreAttributeName, clearTextAttributeName1, alias));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParameterName$str() {
        return "WFLYCTL0477: Parameter name '%s' is invalid.";
    }

    @Override
    public final IllegalArgumentException invalidParameterName(String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidParameterName$str(), parameterName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToBuildCommandCredentialSource$str() {
        return "WFLYCTL0478: Unable to create command based CredentialSource for credential reference.";
    }

    @Override
    public final OperationFailedException unableToBuildCommandCredentialSource(Throwable throwable) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToBuildCommandCredentialSource$str(), new Object[0]), throwable);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeUnresolvableUsingSimpleResolution$str() {
        return "WFLYCTL0479: Attribute '%s' at resource '%s' with unresolved value '%s' cannot be resolved using the non-security-sensitive resolution sources supported by the 'resolve' parameter. Response will report the unresolved value.";
    }

    @Override
    public final String attributeUnresolvableUsingSimpleResolution(String attribute, String address, ModelNode unresolved) {
        return String.format(this.getLoggingLocale(), this.attributeUnresolvableUsingSimpleResolution$str(), attribute, address, unresolved);
    }

    protected String expressionUnresolvableUsingSimpleResolution$str() {
        return "WFLYCTL0480: Expression '%s' cannot be resolved using the non-security-sensitive resolution sources supported by the '%s' operation. Response will report the unresolved value.";
    }

    @Override
    public final String expressionUnresolvableUsingSimpleResolution(ModelNode unresolved, String opName) {
        return String.format(this.getLoggingLocale(), this.expressionUnresolvableUsingSimpleResolution$str(), unresolved, opName);
    }

    @Override
    public final void runtimePackageDependencyAlreadyRegistered(String pckg, String location) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.runtimePackageDependencyAlreadyRegistered$str(), (Object)pckg, (Object)location);
    }

    protected String runtimePackageDependencyAlreadyRegistered$str() {
        return "WFLYCTL0481: The runtime dependency package '%s' is already registered at location '%s'";
    }

    protected String illegalCharsetName$str() {
        return "WFLYCTL0482: Value '%s' is not a legal charset name";
    }

    @Override
    public final OperationFailedException illegalCharsetName(String charset) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.illegalCharsetName$str(), charset));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedCharset$str() {
        return "WFLYCTL0483: Charset '%s' is not supported in this instance of the Java Virtual Machine";
    }

    @Override
    public final OperationFailedException unsupportedCharset(String charset) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedCharset$str(), charset));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAttributeDefinition$str() {
        return "WFLYCTL0484: Attribute definition of attribute '%s' is null";
    }

    @Override
    public final IllegalArgumentException invalidAttributeDefinition(String attributeName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidAttributeDefinition$str(), attributeName));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParseYamlConfigurationFile$str() {
        return "WFLYCTL0485: Error parsing yaml file %s";
    }

    @Override
    public final IllegalArgumentException failedToParseYamlConfigurationFile(String path, Throwable throwable) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToParseYamlConfigurationFile$str(), path), throwable);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingYamlFile$str() {
        return "WFLYCTL0486: Missing yaml file %s";
    }

    @Override
    public final IllegalArgumentException missingYamlFile(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingYamlFile$str(), path));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void loadingYamlFiles(long duration, String files) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.loadingYamlFiles$str(), (Object)duration, (Object)files);
    }

    protected String loadingYamlFiles$str() {
        return "WFLYCTL0487: It took %s ms to load and parse the following yaml files [%s]";
    }

    @Override
    public final void noResourceRegistered(String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noResourceRegistered1$str(), (Object)address);
    }

    protected String noResourceRegistered1$str() {
        return "WFLYCTL0488: No registration found for address %s - Ignoring the subtree";
    }

    protected String noResourceForUndefiningAttribute$str() {
        return "WFLYCTL0489: Can't undefine attribute %s since there is no resource at %s";
    }

    @Override
    public final IllegalArgumentException noResourceForUndefiningAttribute(String attribute, String address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noResourceForUndefiningAttribute$str(), attribute, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noAttributeSetForAddress(String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noAttributeSetForAddress$str(), (Object)address);
    }

    protected String noAttributeSetForAddress$str() {
        return "WFLYCTL0490: A YAML resource has been defined for the address %s without any attribute. No actions will be taken.";
    }

    @Override
    public final void unexpectedValueForResource(Object value, String address, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedValueForResource$str(), value, (Object)address, (Object)name);
    }

    protected String unexpectedValueForResource$str() {
        return "WFLYCTL0491: We have an unexpected value %s for address %s and name %s";
    }

    @Override
    public final void noResourceRegistered(String address, String registration) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noResourceRegistered2$str(), (Object)address, (Object)registration);
    }

    protected String noResourceRegistered2$str() {
        return "WFLYCTL0492: Couldn't find a resource registration for address %s with current registration %s";
    }

    protected String missingListAttributeValueType$str() {
        return "WFLYCTL0493: The attribute %s hasn't a valueType properly defined.";
    }

    @Override
    public final UnsupportedOperationException missingListAttributeValueType(String name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.missingListAttributeValueType$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resolverExtensionExpressionsNotAllowed$str() {
        return "WFLYCTL0494: Resolution of extension expression '%s' is not allowed at this point.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionServerException resolverExtensionExpressionsNotAllowed(String expression) {
        ExpressionResolver.ExpressionResolutionServerException result = new ExpressionResolver.ExpressionResolutionServerException(String.format(this.getLoggingLocale(), this.resolverExtensionExpressionsNotAllowed$str(), expression));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void adminOnlyPolicyDeprecatedValue() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.adminOnlyPolicyDeprecatedValue$str(), new Object[0]);
    }

    protected String adminOnlyPolicyDeprecatedValue$str() {
        return "WFLYCTL0495: \"fetch-from-master\" is a deprecated value for \"domain-controller.remote.admin-only-policy\", \"fetch-from-domain-controller\" will be used instead.";
    }

    @Override
    public final void threadDump(String dump) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.threadDump$str(), (Object)dump);
    }

    protected String threadDump$str() {
        return "WFLYCTL0496: Thread dump:\n*******************************************************************************\n{0}\n===============================================================================\nEnd Thread dump\n*******************************************************************************\n";
    }

    @Override
    public final void deadLock(String dump) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.deadLock$str(), (Object)dump);
    }

    protected String deadLock$str() {
        return "WFLYCTL0497: Deadlock detected!\n*******************************************************************************\n{0}\n===============================================================================\nEnd Deadlock\n*******************************************************************************\n";
    }

    @Override
    public final void threadDumpException(Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.threadDumpException$str(), new Object[0]);
    }

    protected String threadDumpException$str() {
        return "WFLYCTL0498: Exception thrown during generation of thread dump";
    }

    protected String errorConstructingYAMLMapping$str() {
        return "While constructing a mapping; %s; expected a mapping for merging, but found %s";
    }

    @Override
    public final String errorConstructingYAMLMapping(Mark mark, NodeId node) {
        return String.format(this.getLoggingLocale(), this.errorConstructingYAMLMapping$str(), mark, node);
    }

    protected String argYaml$str() {
        return "The yaml configuration files for customizing the configuration. Paths can be absolute, relative to the current execution directory or relative to the standalone configuration directory.";
    }

    @Override
    public final String argYaml() {
        return String.format(this.getLoggingLocale(), this.argYaml$str(), new Object[0]);
    }

    protected String noSatisfactoryCapability$str() {
        return "WFLYCTL0499: There is no satisfactory capability '%s' available to resources with capability scope '%s'. This capability is registered at address(es) '%s', and are not accessible to resources with scope '%s'.";
    }

    @Override
    public final IllegalStateException noSatisfactoryCapability(String capability, String scopeName, Set<RegistrationPoint> addresses, String scopeNameAgain) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSatisfactoryCapability$str(), capability, scopeName, addresses, scopeNameAgain));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void uuidIsEmpty(String path) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.uuidIsEmpty$str(), (Object)path);
    }

    protected String uuidIsEmpty$str() {
        return "WFLYCTL0500: There is no UUID string at '%s'. A new value will be generated.";
    }

    @Override
    public final void uuidNotValid(String corruptedUuid, String path) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.uuidNotValid$str(), (Object)corruptedUuid, (Object)path);
    }

    protected String uuidNotValid$str() {
        return "WFLYCTL0501: An invalid UUID string '%s' was found at '%s'. A new value will be generated.";
    }

    protected String noChildResource$str() {
        return "WFLYCTL0502: No child resource called '%s' could be found at address '%s'.";
    }

    @Override
    public final IllegalArgumentException noChildResource(String name, String address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noChildResource$str(), name, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToPublishConfigurationInvalidRemote$str() {
        return "WFLYCTL0503: Failed to publish configuration, because the remote name %s is not valid.";
    }

    @Override
    public final ConfigurationPersistenceException failedToPublishConfigurationInvalidRemote(String name) {
        ConfigurationPersistenceException result = new ConfigurationPersistenceException(String.format(this.getLoggingLocale(), this.failedToPublishConfigurationInvalidRemote$str(), name));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingOperationForResource$str() {
        return "WFLYCTL0504: The operation %s is not defined for resource %s.";
    }

    @Override
    public final UnsupportedOperationException missingOperationForResource(String op, String address) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.missingOperationForResource$str(), op, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unstableSubsystemNamespace$str() {
        return "WFLYCTL0505: %s subsystem namespace %s is not enabled by the current stability level";
    }

    @Override
    public final XMLStreamException unstableSubsystemNamespace(String subsystemName, String namespaceURI) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unstableSubsystemNamespace$str(), subsystemName, namespaceURI));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unstableExtension(String extensionName, String moduleName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unstableExtension$str(), (Object)extensionName, (Object)moduleName);
    }

    protected String unstableExtension$str() {
        return "WFLYCTL0506: Extension %s from module %s is not enabled by the current stability level";
    }

    protected String unsupportedDeployment$str() {
        return "WFLYCTL0507: Unsuported deployment yaml file %s with attributes %s";
    }

    @Override
    public final IllegalArgumentException unsupportedDeployment(String deployment, Set<String> attributes) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedDeployment$str(), deployment, attributes));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ignoreYamlElement$str() {
        return "WFLYCTL0508: The yaml element '%s' and its sub-elements are ignored.";
    }

    @Override
    public final String ignoreYamlElement(String element) {
        return String.format(this.getLoggingLocale(), this.ignoreYamlElement$str(), element);
    }

    protected String ignoreYamlSubElement$str() {
        return " Thus ignoring element '%s'.";
    }

    @Override
    public final String ignoreYamlSubElement(String element) {
        return String.format(this.getLoggingLocale(), this.ignoreYamlSubElement$str(), element);
    }

    protected String noAttributeDefined$str() {
        return "WFLYCTL0509: No attribute called '%s' is defined at address '%s'.";
    }

    @Override
    public final IllegalArgumentException noAttributeDefined(String name, String address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAttributeDefined$str(), name, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalOperationForAttribute$str() {
        return "WFLYCTL0510: No operation %s can be executed for attribute called '%s' is defined at address '%s'.";
    }

    @Override
    public final IllegalArgumentException illegalOperationForAttribute(String operationName, String attribute, String address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalOperationForAttribute$str(), operationName, attribute, address));
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noAttributeValueDefined(String name, String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noAttributeValueDefined$str(), (Object)name, (Object)address);
    }

    protected String noAttributeValueDefined$str() {
        return "WFLYCTL0511: No value is defined for attribute '%s'  at address '%s'.";
    }

    @Override
    public final void removingUnexistingResource(String address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.removingUnexistingResource$str(), (Object)address);
    }

    protected String removingUnexistingResource$str() {
        return "WFLYCTL0512: No resource exists at address '%s'. Ignoring the remove opreation.";
    }

    protected String unsupportedNamespace$str() {
        return "WFLYCTL0513: The XML namespace of %s is no longer supported.";
    }

    @Override
    public final XMLStreamException unsupportedNamespace(QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unsupportedNamespace$str(), name), location);
        ControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

