/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.EnhancedSyntaxSupport;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

abstract class AbstractCollectionHandler
implements OperationStepHandler {
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinition("name", ModelType.STRING, false);
    static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinition("value", ModelType.STRING, true);
    private final AttributeDefinition[] attributes;
    private final boolean requiredReadWriteAccess;

    AbstractCollectionHandler(AttributeDefinition ... attributes) {
        this.attributes = attributes;
        this.requiredReadWriteAccess = true;
    }

    AbstractCollectionHandler(boolean requiredReadWrite, AttributeDefinition ... attributes) {
        this.attributes = attributes;
        this.requiredReadWriteAccess = requiredReadWrite;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        NAME.validateAndSet(operation, model);
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AttributeAccess attributeAccess;
        ModelNode operationModel = new ModelNode();
        this.populateModel(operation, operationModel);
        String attributeName = NAME.resolveModelAttribute(context, operationModel).asString();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        boolean useEnhancedSyntax = EnhancedSyntaxSupport.containsEnhancedSyntax(attributeName, registry);
        String attributeExpression = attributeName;
        if (useEnhancedSyntax) {
            attributeName = EnhancedSyntaxSupport.extractAttributeName(attributeName);
        }
        if ((attributeAccess = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName)) == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName));
        }
        if (this.requiredReadWriteAccess && attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.attributeNotWritable(attributeName));
        }
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        Resource resource = this.requiredReadWriteAccess ? context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS) : context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode resourceModel = resource.getModel().clone();
        ModelNode model = useEnhancedSyntax ? EnhancedSyntaxSupport.resolveEnhancedSyntax(attributeExpression, resourceModel) : resourceModel.get(attributeName);
        this.updateModel(context, operationModel, attributeAccess.getAttributeDefinition(), model);
        if (this.requiredReadWriteAccess) {
            ModelNode writeOperation = Util.createOperation(WriteAttributeHandler.DEFINITION, address);
            writeOperation.get(NAME.getName()).set(useEnhancedSyntax ? attributeExpression : attributeName);
            writeOperation.get("value").set(model);
            context.addStep(writeOperation, WriteAttributeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
        }
    }

    abstract void updateModel(OperationContext var1, ModelNode var2, AttributeDefinition var3, ModelNode var4) throws OperationFailedException;
}

