/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RequirementRegistration;

public class RuntimeRequirementRegistration
extends RequirementRegistration {
    private final Map<PathAddress, RegistrationPoint> registrationPoints = new LinkedHashMap<PathAddress, RegistrationPoint>();
    private final boolean runtimeOnly;

    public RuntimeRequirementRegistration(String requiredName, String dependentName, CapabilityContext dependentContext, RegistrationPoint registrationPoint) {
        this(requiredName, dependentName, dependentContext, registrationPoint, false);
    }

    public RuntimeRequirementRegistration(String requiredName, String dependentName, CapabilityContext dependentContext, RegistrationPoint registrationPoint, boolean runtimeOnly) {
        super(requiredName, dependentName, dependentContext);
        this.registrationPoints.put(registrationPoint.getAddress(), registrationPoint);
        this.runtimeOnly = runtimeOnly;
    }

    public RuntimeRequirementRegistration(RuntimeRequirementRegistration toCopy) {
        super(toCopy.getRequiredName(), toCopy.getDependentId());
        this.registrationPoints.putAll(toCopy.registrationPoints);
        this.runtimeOnly = toCopy.runtimeOnly;
    }

    public boolean isRuntimeOnly() {
        return this.runtimeOnly;
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next();
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        return Collections.unmodifiableSet(new HashSet<RegistrationPoint>(this.registrationPoints.values()));
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.put(addedAddress, toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (!this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.remove(addedAddress);
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        return this.registrationPoints.size();
    }
}

