/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AbstractDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationRule;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class TransformingDescription
extends AbstractDescription
implements TransformationDescription,
ResourceTransformer,
OperationTransformer {
    private final DiscardPolicy discardPolicy;
    private final List<TransformationDescription> children;
    private final Map<String, AttributeTransformationDescription> attributeTransformations;
    private final List<TransformationRule> rules = Collections.emptyList();
    private final Map<String, OperationTransformer> operationTransformers;
    private final Set<String> discardedOperations;
    private final ResourceTransformer resourceTransformer;
    private final DynamicDiscardPolicy dynamicDiscardPolicy;

    protected TransformingDescription(PathElement pathElement, PathAddressTransformer pathAddressTransformer, DiscardPolicy discardPolicy, boolean inherited, ResourceTransformer resourceTransformer, Map<String, AttributeTransformationDescription> attributeTransformations, Map<String, OperationTransformer> operations, List<TransformationDescription> children, Set<String> discardedOperations, DynamicDiscardPolicy dynamicDiscardPolicy) {
        super(pathElement, pathAddressTransformer, inherited);
        this.children = children;
        this.discardPolicy = discardPolicy;
        this.resourceTransformer = resourceTransformer;
        this.attributeTransformations = attributeTransformations;
        this.discardedOperations = discardedOperations;
        this.operationTransformers = operations;
        this.dynamicDiscardPolicy = dynamicDiscardPolicy;
    }

    @Override
    public OperationTransformer getOperationTransformer() {
        return this;
    }

    @Override
    public ResourceTransformer getResourceTransformer() {
        return this;
    }

    @Override
    public Map<String, OperationTransformer> getOperationTransformers() {
        return Collections.unmodifiableMap(this.operationTransformers);
    }

    @Override
    public List<TransformationDescription> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext ctx, final PathAddress address, final ModelNode operation) throws OperationFailedException {
        DiscardPolicy discardPolicy = this.determineDiscardPolicy(ctx, address);
        switch (discardPolicy) {
            case REJECT_AND_WARN: {
                return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return ControllerLogger.ROOT_LOGGER.rejectResourceOperationTransformation(address, operation);
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
            case DISCARD_AND_WARN: 
            case SILENT: {
                return OperationTransformer.DISCARD.transformOperation(ctx, address, operation);
            }
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedOperationContext context = new TransformationRule.ChainedOperationContext(ctx){

            @Override
            void invokeNext(OperationTransformer.TransformedOperation transformedOperation) throws OperationFailedException {
                this.recordTransformedOperation(transformedOperation);
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformOperation(transformedOperation.getTransformedOperation(), address, this);
                }
            }
        };
        AttributeTransformationRule first = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)first).transformOperation(operation, address, context);
        return context.createOp();
    }

    @Override
    public void transformResource(final ResourceTransformationContext ctx, final PathAddress address, Resource original) throws OperationFailedException {
        ModelNode originalModel = TransformationRule.cloneAndProtect(original.getModel());
        DiscardPolicy discardPolicy = this.determineDiscardPolicy(ctx, address);
        switch (discardPolicy) {
            case REJECT_AND_WARN: 
            case DISCARD_AND_WARN: {
                ctx.getLogger().logRejectedResourceWarning(address, null);
                return;
            }
            case SILENT: {
                ResourceTransformer.DISCARD.transformResource(ctx, address, original);
                return;
            }
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedResourceContext context = new TransformationRule.ChainedResourceContext(ctx){

            @Override
            void invokeNext(Resource resource) throws OperationFailedException {
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformResource(resource, address, this);
                } else {
                    TransformingDescription.this.resourceTransformer.transformResource(ctx, address, resource);
                }
            }
        };
        AttributeTransformationRule rule = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)rule).transformResource(original, address, context);
    }

    @Override
    public Set<String> getDiscardedOperations() {
        return this.discardedOperations;
    }

    @Override
    public boolean isPlaceHolder() {
        return false;
    }

    private DiscardPolicy determineDiscardPolicy(TransformationContext ctx, PathAddress address) {
        DiscardPolicy discardPolicy = this.dynamicDiscardPolicy == null ? this.discardPolicy : this.dynamicDiscardPolicy.checkResource(ctx, address);
        return discardPolicy;
    }
}

