/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyResourceDefinition
implements ResourceDefinition {
    private Map<String, AttributeAccess> attributes = new HashMap<String, AttributeAccess>();
    private List<ResourceDefinition> children = new LinkedList<ResourceDefinition>();
    private final PathAddress address;
    private final ModelNode description;

    public LegacyResourceDefinition(ModelNode modelDescription) {
        ModelNode children;
        this.description = modelDescription.get("model-description");
        ModelNode attributes = this.description.has("attributes") ? this.description.get("attributes") : new ModelNode();
        this.address = PathAddress.pathAddress(modelDescription.get("address"));
        if (attributes.isDefined()) {
            for (Property property : attributes.asPropertyList()) {
                String name = property.getName();
                SimpleAttributeDefinition def = SimpleAttributeDefinitionBuilder.create(name, property.getValue()).build();
                this.attributes.put(name, new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, AttributeAccess.Storage.CONFIGURATION, null, null, def, null));
            }
        }
        if (!(children = modelDescription.get("children")).isDefined()) {
            return;
        }
        for (ModelNode child : children.asList()) {
            this.children.add(new LegacyResourceDefinition(child));
        }
        this.description.remove("children");
    }

    @Override
    public PathElement getPathElement() {
        return this.address.getLastElement();
    }

    @Override
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return new DescriptionProvider(){

            @Override
            public ModelNode getModelDescription(Locale locale) {
                return LegacyResourceDefinition.this.description;
            }
        };
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeAccess attr : this.attributes.values()) {
            resourceRegistration.registerReadOnlyAttribute(attr.getAttributeDefinition(), null);
        }
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        for (ResourceDefinition rd : this.children) {
            resourceRegistration.registerSubModel(rd);
        }
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    @Override
    public boolean isOrderedChild() {
        return false;
    }
}

