/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public abstract class AbstractConfigurationPersister
implements ExtensibleConfigurationPersister {
    private final XMLElementWriter<ModelMarshallingContext> rootDeparser;
    private final ConcurrentHashMap<String, XMLElementWriter<SubsystemMarshallingContext>> subsystemWriters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Supplier<XMLElementWriter<SubsystemMarshallingContext>>> subsystemWriterSuppliers = new ConcurrentHashMap();

    public AbstractConfigurationPersister(XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        this.rootDeparser = rootDeparser;
    }

    @Override
    public void registerSubsystemWriter(String name, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.subsystemWriters.putIfAbsent(name, writer);
    }

    @Override
    public void registerSubsystemWriter(String name, Supplier<XMLElementWriter<SubsystemMarshallingContext>> writer) {
        this.subsystemWriterSuppliers.putIfAbsent(name, writer);
    }

    @Override
    public void unregisterSubsystemWriter(String name) {
        this.subsystemWriters.remove(name);
        this.subsystemWriterSuppliers.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshallAsXml(final ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
        XMLMapper mapper = XMLMapper.Factory.create();
        final HashMap<String, XMLElementWriter<SubsystemMarshallingContext>> localSubsystemWriters = new HashMap<String, XMLElementWriter<SubsystemMarshallingContext>>(this.subsystemWriters);
        try {
            XMLStreamWriter streamWriter = null;
            try {
                streamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
                ModelMarshallingContext extensibleModel = new ModelMarshallingContext(){

                    @Override
                    public ModelNode getModelNode() {
                        return model;
                    }

                    @Override
                    public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String extensionName) {
                        Supplier<XMLElementWriter<SubsystemMarshallingContext>> supplier;
                        XMLElementWriter<SubsystemMarshallingContext> result = (XMLElementWriter<SubsystemMarshallingContext>)localSubsystemWriters.get(extensionName);
                        if (result == null && (supplier = AbstractConfigurationPersister.this.subsystemWriterSuppliers.get(extensionName)) != null) {
                            result = supplier.get();
                            localSubsystemWriters.put(extensionName, result);
                        }
                        return result;
                    }
                };
                mapper.deparseDocument(this.rootDeparser, (Object)extensibleModel, streamWriter);
                streamWriter.close();
            }
            finally {
                AbstractConfigurationPersister.safeClose(streamWriter);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToWriteConfiguration(e);
        }
    }

    @Override
    public void successfulBoot() throws ConfigurationPersistenceException {
    }

    @Override
    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return NULL_SNAPSHOT_INFO;
    }

    @Override
    public void deleteSnapshot(String name) {
    }

    private static void safeClose(XMLStreamWriter streamWriter) {
        if (streamWriter != null) {
            try {
                streamWriter.close();
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToCloseResource(t, streamWriter);
            }
        }
    }
}

