/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;

public abstract class AttributeMarshaller {
    public static final AttributeMarshaller SIMPLE = new DefaultAttributeMarshaller();
    public static final AttributeMarshaller STRING_LIST = new ListMarshaller(' ');
    public static final AttributeMarshaller COMMA_STRING_LIST = new ListMarshaller(',');
    public static final AttributeMarshaller ELEMENT_ONLY_OBJECT = new ObjectMarshaller(true);
    public static final AttributeMarshaller ATTRIBUTE_OBJECT = new ObjectMarshaller(false);
    public static final AttributeMarshaller WRAPPED_OBJECT_LIST_MARSHALLER = new ObjectListMarshaller();
    public static final AttributeMarshaller UNWRAPPED_OBJECT_LIST_MARSHALLER = new UnwrappedObjectListMarshaller();
    public static final AttributeMarshaller OBJECT_LIST_MARSHALLER = WRAPPED_OBJECT_LIST_MARSHALLER;
    public static final AttributeMarshaller OBJECT_MAP_MARSHALLER = new AttributeMarshallers.ObjectMapAttributeMarshaller();
    public static final AttributeMarshaller PROPERTIES_MARSHALLER = new AttributeMarshallers.PropertiesAttributeMarshaller();
    public static final AttributeMarshaller PROPERTIES_MARSHALLER_UNWRAPPED = new AttributeMarshallers.PropertiesAttributeMarshaller(null, false);

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
        return this.isMarshallable(attribute, resourceModel, true);
    }

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
        return resourceModel.hasDefined(attribute.getName()) && (marshallDefault || !resourceModel.get(attribute.getName()).equals(attribute.getDefaultValue()));
    }

    public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsAttribute(attribute.getName());
    }

    public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsElement(attribute.getName());
    }

    public boolean isMarshallableAsElement() {
        return false;
    }

    public void marshall(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallableAsElement()) {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        } else {
            this.marshallAsAttribute(attribute, resourceModel, marshallDefault, writer);
        }
    }

    public static void marshallElementContent(String content, XMLStreamWriter writer) throws XMLStreamException {
        if (content.indexOf(10) > -1) {
            writer.writeCharacters(content);
        } else {
            char[] chars = content.toCharArray();
            writer.writeCharacters(chars, 0, chars.length);
        }
    }

    private static Set<AttributeDefinition> sortAttributes(AttributeDefinition[] attributes) {
        LinkedHashSet<AttributeDefinition> sortedAttrs = new LinkedHashSet<AttributeDefinition>(attributes.length);
        ArrayList<AttributeDefinition> elementAds = null;
        for (AttributeDefinition ad : attributes) {
            if (ad.getParser().isParseAsElement()) {
                if (elementAds == null) {
                    elementAds = new ArrayList<AttributeDefinition>();
                }
                elementAds.add(ad);
                continue;
            }
            sortedAttrs.add(ad);
        }
        if (elementAds != null) {
            sortedAttrs.addAll(elementAds);
        }
        return sortedAttrs;
    }

    static class WrappedSimpleAttributeMarshaller
    extends AttributeElementMarshaller {
        WrappedSimpleAttributeMarshaller() {
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement(attribute.getXmlName());
            WrappedSimpleAttributeMarshaller.marshallElementContent(resourceModel.get(attribute.getName()).asString(), writer);
            writer.writeEndElement();
        }
    }

    public static abstract class AttributeElementMarshaller
    extends AttributeMarshaller {
        @Override
        public abstract void marshallAsElement(AttributeDefinition var1, ModelNode var2, boolean var3, XMLStreamWriter var4) throws XMLStreamException;

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }

        @Override
        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.hasDefined(attribute.getName());
        }
    }

    static class UnwrappedObjectListMarshaller
    extends ObjectListMarshaller {
        UnwrappedObjectListMarshaller() {
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ObjectTypeAttributeDefinition objectType = this.getObjectType(attribute);
            AttributeDefinition[] valueTypes = objectType.getValueTypes();
            if (resourceModel.hasDefined(attribute.getName())) {
                List elements = resourceModel.get(attribute.getName()).asList();
                this.writeElements(writer, objectType, valueTypes, elements);
            }
        }
    }

    static class ObjectListMarshaller
    extends AttributeMarshaller {
        ObjectListMarshaller() {
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }

        ObjectTypeAttributeDefinition getObjectType(AttributeDefinition attribute) {
            assert (attribute instanceof ObjectListAttributeDefinition);
            ObjectListAttributeDefinition list = (ObjectListAttributeDefinition)attribute;
            return list.getValueType();
        }

        private boolean isMarshallable(AttributeDefinition[] valueTypes, ModelNode element) {
            for (AttributeDefinition valueType : valueTypes) {
                if (!valueType.getMarshaller().isMarshallable(valueType, element)) continue;
                return true;
            }
            return false;
        }

        void writeElements(XMLStreamWriter writer, ObjectTypeAttributeDefinition objectType, AttributeDefinition[] valueTypes, List<ModelNode> elements) throws XMLStreamException {
            for (ModelNode element : elements) {
                if (!this.isMarshallable(valueTypes, element)) continue;
                writer.writeStartElement(objectType.getXmlName());
                Set<AttributeDefinition> sortedAttrs = AttributeMarshaller.sortAttributes(valueTypes);
                for (AttributeDefinition valueType : sortedAttrs) {
                    valueType.getMarshaller().marshall(valueType, element, false, writer);
                }
                writer.writeEndElement();
            }
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ObjectTypeAttributeDefinition objectType = this.getObjectType(attribute);
            AttributeDefinition[] valueTypes = objectType.getValueTypes();
            if (resourceModel.hasDefined(attribute.getName())) {
                List elements = resourceModel.get(attribute.getName()).asList();
                if (elements.isEmpty()) {
                    writer.writeEmptyElement(attribute.getXmlName());
                } else {
                    writer.writeStartElement(attribute.getXmlName());
                    this.writeElements(writer, objectType, valueTypes, elements);
                    writer.writeEndElement();
                }
            }
        }
    }

    static class ObjectMarshaller
    extends DefaultAttributeMarshaller {
        private final boolean marshallSimpleTypeAsElement;

        ObjectMarshaller(boolean marshallSimpleTypeAsAttribute) {
            this.marshallSimpleTypeAsElement = marshallSimpleTypeAsAttribute;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof ObjectTypeAttributeDefinition);
            if (resourceModel.hasDefined(attribute.getName())) {
                AttributeDefinition[] valueTypes = ((ObjectTypeAttributeDefinition)attribute).getValueTypes();
                Set<AttributeDefinition> sortedAttrs = AttributeMarshaller.sortAttributes(valueTypes);
                writer.writeStartElement(attribute.getXmlName());
                for (AttributeDefinition valueType : sortedAttrs) {
                    if (!resourceModel.hasDefined(new String[]{attribute.getName(), valueType.getName()})) continue;
                    ModelNode handler = resourceModel.get(attribute.getName());
                    if (this.marshallSimpleTypeAsElement) {
                        valueType.marshallAsElement(handler, marshallDefault, writer);
                        continue;
                    }
                    valueType.getMarshaller().marshall(valueType, handler, marshallDefault, writer);
                }
                writer.writeEndElement();
            }
        }

        @Override
        public boolean isMarshallableAsElement() {
            return !this.marshallSimpleTypeAsElement;
        }
    }

    static class ListMarshaller
    extends DefaultAttributeMarshaller {
        private final char delimiter;

        ListMarshaller(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        protected String asString(ModelNode value) {
            StringBuilder builder = new StringBuilder();
            Iterator values = value.asList().iterator();
            while (values.hasNext()) {
                builder.append(((ModelNode)values.next()).asString());
                if (!values.hasNext()) continue;
                builder.append(this.delimiter);
            }
            return builder.toString();
        }
    }
}

