/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.access.Action;

public class AbstractSensitivity {
    private final boolean defaultRequiresAccessPermission;
    private final boolean defaultRequiresReadPermission;
    private final boolean defaultRequiresWritePermission;
    private volatile Boolean configuredRequiresAccessPermission;
    private volatile Boolean configuredRequiresReadPermission;
    private volatile Boolean configuredRequiresWritePermission;

    protected AbstractSensitivity(boolean defaultRequiresAccessPermission, boolean defaultRequiresReadPermission, boolean defaultRequiresWritePermission) {
        this.defaultRequiresAccessPermission = defaultRequiresAccessPermission;
        this.defaultRequiresReadPermission = defaultRequiresReadPermission;
        this.defaultRequiresWritePermission = defaultRequiresWritePermission;
    }

    public boolean isDefaultRequiresAccessPermission() {
        return this.defaultRequiresAccessPermission;
    }

    public boolean isDefaultRequiresReadPermission() {
        return this.defaultRequiresReadPermission;
    }

    public boolean isDefaultRequiresWritePermission() {
        return this.defaultRequiresWritePermission;
    }

    public boolean getRequiresAccessPermission() {
        Boolean requires = this.configuredRequiresAccessPermission;
        return requires == null ? this.defaultRequiresAccessPermission : requires;
    }

    public Boolean getConfiguredRequiresAccessPermission() {
        return this.configuredRequiresAccessPermission;
    }

    public void setConfiguredRequiresAccessPermission(Boolean requiresAccessPermission) {
        this.configuredRequiresAccessPermission = requiresAccessPermission;
    }

    public boolean getRequiresReadPermission() {
        Boolean requires = this.configuredRequiresReadPermission;
        return requires == null ? this.defaultRequiresReadPermission : requires;
    }

    public Boolean getConfiguredRequiresReadPermission() {
        return this.configuredRequiresReadPermission;
    }

    public void setConfiguredRequiresReadPermission(Boolean requiresReadPermission) {
        this.configuredRequiresReadPermission = requiresReadPermission;
    }

    public boolean getRequiresWritePermission() {
        Boolean requires = this.configuredRequiresWritePermission;
        return requires == null ? this.defaultRequiresWritePermission : requires;
    }

    public Boolean getConfiguredRequiresWritePermission() {
        return this.configuredRequiresWritePermission;
    }

    public boolean isSensitive(Action.ActionEffect actionEffect) {
        if (actionEffect == Action.ActionEffect.ADDRESS) {
            return this.getRequiresAccessPermission();
        }
        if (actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME) {
            return this.getRequiresReadPermission();
        }
        return this.getRequiresWritePermission();
    }

    public void setConfiguredRequiresWritePermission(Boolean requiresWritePermission) {
        this.configuredRequiresWritePermission = requiresWritePermission;
    }

    protected boolean isCompatibleWith(AbstractSensitivity other) {
        return !this.equals(other) || this.defaultRequiresAccessPermission == other.defaultRequiresAccessPermission && this.defaultRequiresReadPermission == other.defaultRequiresReadPermission && this.defaultRequiresWritePermission == other.defaultRequiresWritePermission;
    }

    public boolean isConfiguredRequiresAccessPermissionValid(Boolean requiresAccessPermission) {
        boolean effectiveWritePermission;
        boolean effectiveAccessPermission = requiresAccessPermission == null ? this.defaultRequiresAccessPermission : requiresAccessPermission;
        boolean effectiveReadPermission = this.configuredRequiresReadPermission == null ? this.defaultRequiresReadPermission : this.configuredRequiresReadPermission;
        boolean bl = effectiveWritePermission = this.configuredRequiresWritePermission == null ? this.defaultRequiresWritePermission : this.configuredRequiresWritePermission;
        return !effectiveAccessPermission || !(!effectiveReadPermission | !effectiveWritePermission);
    }

    public boolean isConfiguredRequiresReadPermissionValid(Boolean requiresReadPermission) {
        boolean effectiveWritePermission;
        boolean effectiveReadPermission = requiresReadPermission == null ? this.defaultRequiresReadPermission : requiresReadPermission;
        boolean effectiveAccessPermission = this.configuredRequiresAccessPermission == null ? this.defaultRequiresAccessPermission : this.configuredRequiresAccessPermission;
        boolean bl = effectiveWritePermission = this.configuredRequiresWritePermission == null ? this.defaultRequiresWritePermission : this.configuredRequiresWritePermission;
        if (!effectiveReadPermission && effectiveAccessPermission) {
            return false;
        }
        return !effectiveReadPermission || effectiveWritePermission;
    }

    public boolean isConfiguredRequiresWritePermissionValid(Boolean requiresWritePermission) {
        boolean effectiveReadPermission;
        boolean effectiveWritePermission = requiresWritePermission == null ? this.defaultRequiresWritePermission : requiresWritePermission;
        boolean effectiveAccessPermission = this.configuredRequiresAccessPermission == null ? this.defaultRequiresAccessPermission : this.configuredRequiresAccessPermission;
        boolean bl = effectiveReadPermission = this.configuredRequiresReadPermission == null ? this.defaultRequiresReadPermission : this.configuredRequiresReadPermission;
        return effectiveWritePermission || !(effectiveAccessPermission | effectiveReadPermission);
    }
}

