/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class ExtensionRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ExtensionRegistry extensionRegistry;
    private final boolean isMasterDomainController;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionRemoveHandler(ExtensionRegistry extensionRegistry, boolean isMasterDomainController, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        this.extensionRegistry = extensionRegistry;
        this.isMasterDomainController = isMasterDomainController;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        final String module = address.getLastElement().getValue();
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        final ManagementResourceRegistration rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
        this.extensionRegistry.removeExtension(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), module, rootRegistration);
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                ExtensionAddHandler.initializeExtension(ExtensionRemoveHandler.this.extensionRegistry, module, rootRegistration, ExtensionRemoveHandler.this.isMasterDomainController);
            }
        });
    }
}

