/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AttributeDefinition {
    protected static final Set<ModelType> COMPLEX_TYPES = Collections.unmodifiableSet(EnumSet.of(ModelType.LIST, ModelType.OBJECT, ModelType.PROPERTY));
    private final String name;
    private final String xmlName;
    private final ModelType type;
    private final boolean allowNull;
    private final boolean allowExpression;
    private final ModelNode defaultValue;
    private final MeasurementUnit measurementUnit;
    private final String[] alternatives;
    private final String[] requires;
    private final ParameterCorrector valueCorrector;
    private final ParameterValidator validator;
    private final boolean validateNull;
    private final EnumSet<AttributeAccess.Flag> flags;
    protected final AttributeMarshaller attributeMarshaller;
    private final boolean resourceOnly;
    private final DeprecationData deprecationData;
    private final List<AccessConstraintDefinition> accessConstraints;
    private final Boolean nilSignificant;
    private final AttributeParser parser;

    protected AttributeDefinition(AbstractAttributeDefinitionBuilder<?, ?> toCopy) {
        this(toCopy.getName(), toCopy.getXmlName(), toCopy.getDefaultValue(), toCopy.getType(), toCopy.isAllowNull(), toCopy.isAllowExpression(), toCopy.getMeasurementUnit(), toCopy.getCorrector(), AttributeDefinition.wrapValidator(toCopy.getValidator(), toCopy.isAllowNull(), toCopy.isValidateNull(), toCopy.isAllowExpression(), toCopy.getType()), toCopy.isValidateNull(), toCopy.getAlternatives(), toCopy.getRequires(), toCopy.getAttributeMarshaller(), toCopy.isResourceOnly(), toCopy.getDeprecated(), AttributeDefinition.wrapConstraints(toCopy.getAccessConstraints()), toCopy.getNullSignficant(), toCopy.getParser(), AttributeDefinition.wrapFlags(toCopy.getFlags()));
    }

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AccessConstraintDefinition[] accessConstraints, Boolean nilSignificant, AttributeParser parser, AttributeAccess.Flag ... flags) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, valueCorrector, AttributeDefinition.wrapValidator(validator, allowNull, validateNull, allowExpression, type), validateNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, AttributeDefinition.wrapConstraints(accessConstraints), nilSignificant, parser, AttributeDefinition.wrapFlags(flags));
    }

    private static ParameterValidator wrapValidator(ParameterValidator toWrap, boolean allowNull, boolean validateNull, boolean allowExpression, ModelType type) {
        NillableOrExpressionParameterValidator result = null;
        if (toWrap == null) {
            toWrap = type == ModelType.STRING ? new StringLengthValidator(1, Integer.MAX_VALUE, allowNull, allowExpression) : new ModelTypeValidator(type);
        } else if (toWrap instanceof NillableOrExpressionParameterValidator) {
            NillableOrExpressionParameterValidator current = (NillableOrExpressionParameterValidator)toWrap;
            if (allowExpression == current.isAllowExpression() && (!validateNull && current.getAllowNull() == null || allowNull == current.getAllowNull())) {
                result = current;
            } else {
                toWrap = current.getDelegate();
            }
        }
        if (result == null) {
            Boolean nullCheck = validateNull ? Boolean.valueOf(allowNull) : null;
            result = new NillableOrExpressionParameterValidator(toWrap, nullCheck, allowExpression);
        }
        return result;
    }

    private static List<AccessConstraintDefinition> wrapConstraints(AccessConstraintDefinition[] accessConstraints) {
        if (accessConstraints == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(accessConstraints));
    }

    private static EnumSet<AttributeAccess.Flag> wrapFlags(AttributeAccess.Flag[] flags) {
        if (flags == null || flags.length == 0) {
            return EnumSet.noneOf(AttributeAccess.Flag.class);
        }
        if (flags.length == 1) {
            return EnumSet.of(flags[0]);
        }
        return EnumSet.of(flags[0], flags);
    }

    private AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, List<AccessConstraintDefinition> accessConstraints, Boolean nilSignificant, AttributeParser parser, EnumSet<AttributeAccess.Flag> flags) {
        this.name = name;
        this.xmlName = xmlName == null ? name : xmlName;
        this.type = type;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
        this.parser = parser != null ? parser : AttributeParser.SIMPLE;
        this.defaultValue = new ModelNode();
        if (defaultValue != null) {
            this.defaultValue.set(defaultValue);
        }
        this.defaultValue.protect();
        this.measurementUnit = measurementUnit;
        this.alternatives = alternatives;
        this.requires = requires;
        this.valueCorrector = valueCorrector;
        this.validator = validator;
        this.validateNull = validateNull;
        this.flags = flags;
        this.attributeMarshaller = attributeMarshaller != null ? attributeMarshaller : new DefaultAttributeMarshaller();
        this.resourceOnly = resourceOnly;
        this.accessConstraints = accessConstraints;
        this.deprecationData = deprecationData;
        this.nilSignificant = nilSignificant;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public ModelType getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isNullSignificant() {
        if (this.nilSignificant != null) {
            return this.nilSignificant;
        }
        return this.allowNull && this.defaultValue != null && this.defaultValue.isDefined();
    }

    Boolean getNilSignificant() {
        return this.nilSignificant;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue.isDefined() ? this.defaultValue : null;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public ParameterCorrector getCorrector() {
        return this.valueCorrector;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public boolean isValidatingNull() {
        return this.validateNull;
    }

    public String[] getAlternatives() {
        return this.alternatives;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public EnumSet<AttributeAccess.Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public boolean isMarshallable(ModelNode resourceModel) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, true);
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, marshallDefault);
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        return this.validateOperation(operationObject, false);
    }

    public final void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        ModelNode newValue;
        ModelNode correctedValue;
        if (operationObject.hasDefined(this.name) && this.isDeprecated()) {
            ControllerLogger.DEPRECATED_LOGGER.attributeDeprecated(this.getName());
        }
        if (!(correctedValue = this.correctValue(newValue = this.convertParameterExpressions(operationObject.get(this.name)), model.get(this.name))).equals(operationObject.get(this.name))) {
            operationObject.get(this.name).set(correctedValue);
        }
        ModelNode node = this.validateOperation(operationObject, true);
        model.get(this.name).set(node);
    }

    private ModelNode convertToExpectedType(ModelNode node) {
        if (node.getType() == this.type || node.getType() == ModelType.EXPRESSION || Util.isExpression(node.asString()) || !node.isDefined()) {
            return node;
        }
        switch (this.type) {
            case BIG_DECIMAL: {
                return new ModelNode(node.asBigDecimal());
            }
            case BIG_INTEGER: {
                return new ModelNode(node.asBigInteger());
            }
            case BOOLEAN: {
                return new ModelNode(node.asBoolean());
            }
            case BYTES: {
                return new ModelNode(node.asBytes());
            }
            case DOUBLE: {
                return new ModelNode(node.asDouble());
            }
            case INT: {
                return new ModelNode(node.asInt());
            }
            case LIST: {
                return new ModelNode().set((Collection)node.asList());
            }
            case LONG: {
                return new ModelNode(node.asLong());
            }
            case PROPERTY: {
                return new ModelNode().set(node.asProperty());
            }
            case TYPE: {
                return new ModelNode(node.asType());
            }
            case STRING: {
                return new ModelNode(node.asString());
            }
        }
        return node;
    }

    public ModelNode resolveModelAttribute(final OperationContext context, ModelNode model) throws OperationFailedException {
        return this.resolveModelAttribute(new ExpressionResolver(){

            @Override
            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        }, model);
    }

    public ModelNode resolveModelAttribute(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (model.has(this.name)) {
            node.set(model.get(this.name));
        }
        return this.resolveValue(resolver, node);
    }

    public ModelNode resolveValue(final OperationContext context, ModelNode value) throws OperationFailedException {
        return this.resolveValue(new ExpressionResolver(){

            @Override
            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        }, value);
    }

    public ModelNode resolveValue(ExpressionResolver resolver, ModelNode value) throws OperationFailedException {
        ModelNode node = value.clone();
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        ModelNode resolved = resolver.resolveExpressions(node);
        this.validator.validateParameter(this.name, resolved);
        return resolved;
    }

    public boolean isAllowed(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRequired(ModelNode operationObject) {
        return !this.allowNull && !this.hasAlternative(operationObject);
    }

    public boolean hasAlternative(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.marshallAsElement(resourceModel, true, writer);
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsElement(this.getName());
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle, prefix));
        }
        this.addAccessConstraints(result, bundle.getLocale());
        return result;
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode attr = this.getNoTextDescription(false);
        String description = resolver.getResourceAttributeDescription(this.getName(), locale, bundle);
        attr.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getResourceAttributeDeprecatedDescription(this.getName(), locale, bundle));
        }
        this.addAccessConstraints(result, locale);
        return result;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle, prefix));
        }
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode param = this.getNoTextDescription(true);
        String description = resolver.getOperationParameterDescription(operationName, this.getName(), locale, bundle);
        param.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getOperationParameterDeprecatedDescription(operationName, this.getName(), locale, bundle));
        }
        return result;
    }

    public String getAttributeTextDescription(ResourceBundle bundle, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        return bundle.getString(bundleKey);
    }

    public String getAttributeDeprecatedDescription(ResourceBundle bundle, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        bundleKey = bundleKey + ".deprecated";
        return bundle.getString(bundleKey);
    }

    public ModelNode addDeprecatedInfo(ModelNode model) {
        if (this.deprecationData == null) {
            return null;
        }
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }

    public ModelNode getNoTextDescription(boolean forOperation) {
        ModelNode result = new ModelNode();
        result.get("type").set(this.type);
        result.get("description");
        result.get("expressions-allowed").set(this.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        if (!forOperation && this.nilSignificant != null && this.nilSignificant.booleanValue()) {
            result.get("nil-significant").set(true);
        }
        if (this.defaultValue != null && this.defaultValue.isDefined()) {
            result.get("default").set(this.defaultValue);
        }
        if (this.measurementUnit != null && this.measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(this.measurementUnit.getName());
        }
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if (this.requires != null) {
            for (String required : this.requires) {
                result.get("requires").add(required);
            }
        }
        if (this.validator instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)this.validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.type) {
                    case BYTES: 
                    case LIST: 
                    case STRING: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.type) {
                    case BYTES: 
                    case LIST: 
                    case STRING: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(result, this.validator);
        return result;
    }

    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
        AllowedValuesValidator avv;
        List<ModelNode> allowed;
        if (validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)((Object)validator)).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
    }

    protected final ModelNode correctValue(ModelNode newValue, ModelNode oldValue) {
        if (this.valueCorrector != null) {
            return this.valueCorrector.correct(newValue, oldValue);
        }
        return newValue;
    }

    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        if (this.isAllowExpression() && COMPLEX_TYPES.contains(this.type)) {
            throw new IllegalStateException();
        }
        return this.isAllowExpression() ? AttributeDefinition.convertStringExpression(parameter) : parameter;
    }

    protected static ModelNode convertStringExpression(ModelNode node) {
        if (node.getType() == ModelType.STRING) {
            return ParseUtils.parsePossibleExpression(node.asString());
        }
        return node;
    }

    private ModelNode validateOperation(ModelNode operationObject, boolean immutableValue) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (!immutableValue) {
            node = this.convertParameterExpressions(node);
            node = this.correctValue(node, node);
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            this.validator.validateParameter(this.name, this.defaultValue);
        } else {
            this.validator.validateParameter(this.name, node);
        }
        return this.convertToExpectedType(node);
    }

    public AttributeMarshaller getAttributeMarshaller() {
        return this.attributeMarshaller;
    }

    public boolean isResourceOnly() {
        return this.resourceOnly;
    }

    public boolean isDeprecated() {
        return this.deprecationData != null;
    }

    public DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    protected void addAccessConstraints(ModelNode result, Locale locale) {
        AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.accessConstraints, locale);
    }

    public AttributeParser getParser() {
        return this.parser;
    }
}

