/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class BlockingQueueOperationListener<T extends TransactionalProtocolClient.Operation>
implements TransactionalProtocolClient.TransactionalOperationListener<T> {
    private final BlockingQueue<TransactionalProtocolClient.PreparedOperation<T>> queue;

    public BlockingQueueOperationListener() {
        this(new LinkedBlockingQueue<TransactionalProtocolClient.PreparedOperation<T>>());
    }

    public BlockingQueueOperationListener(int capacity) {
        this(new ArrayBlockingQueue<TransactionalProtocolClient.PreparedOperation<T>>(capacity));
    }

    public BlockingQueueOperationListener(BlockingQueue<TransactionalProtocolClient.PreparedOperation<T>> queue) {
        this.queue = queue;
    }

    @Override
    public void operationPrepared(TransactionalProtocolClient.PreparedOperation<T> prepared) {
        ControllerLogger.MGMT_OP_LOGGER.tracef("received prepared operation  %s", prepared.getOperation());
        if (!this.queue.offer(prepared)) {
            prepared.rollback();
        }
    }

    @Override
    public void operationFailed(T operation, ModelNode result) {
        ControllerLogger.MGMT_OP_LOGGER.tracef("received failed operation  %s", operation);
        this.queue.offer(new FailedOperation<T>(operation, result));
    }

    @Override
    public void operationComplete(T operation, ModelNode result) {
    }

    public TransactionalProtocolClient.PreparedOperation<T> retrievePreparedOperation() throws InterruptedException {
        return this.queue.take();
    }

    protected void drainTo(Collection<TransactionalProtocolClient.PreparedOperation<T>> collection) {
        if (this.queue.size() > 0) {
            this.queue.drainTo(collection);
        }
    }

    public TransactionalProtocolClient.PreparedOperation<T> retrievePreparedOperation(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.poll(timeout, timeUnit);
    }

    static class CompletedResult<T>
    implements AsyncFuture<T> {
        private final T result;

        CompletedResult(T result) {
            this.result = result;
        }

        public AsyncFuture.Status await() throws InterruptedException {
            return AsyncFuture.Status.COMPLETE;
        }

        public AsyncFuture.Status await(long timeout, TimeUnit unit) throws InterruptedException {
            return AsyncFuture.Status.COMPLETE;
        }

        public T getUninterruptibly() throws CancellationException, ExecutionException {
            return this.result;
        }

        public T getUninterruptibly(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, TimeoutException {
            return this.result;
        }

        public AsyncFuture.Status awaitUninterruptibly() {
            return AsyncFuture.Status.COMPLETE;
        }

        public AsyncFuture.Status awaitUninterruptibly(long timeout, TimeUnit unit) {
            return AsyncFuture.Status.COMPLETE;
        }

        public AsyncFuture.Status getStatus() {
            return AsyncFuture.Status.COMPLETE;
        }

        public <A> void addListener(AsyncFuture.Listener<? super T, A> listener, A attachment) {
            if (listener != null) {
                listener.handleComplete((AsyncFuture)this, attachment);
            }
        }

        public boolean cancel(boolean interruptionDesired) {
            return false;
        }

        public void asyncCancel(boolean interruptionDesired) {
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }

    public static class FailedOperation<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode finalResult;

        public static <T extends TransactionalProtocolClient.Operation> TransactionalProtocolClient.PreparedOperation<T> create(T operation, Throwable t) {
            String failureDescription = t.getLocalizedMessage() == null ? t.getClass().getName() : t.getLocalizedMessage();
            return FailedOperation.create(operation, failureDescription);
        }

        public static <T extends TransactionalProtocolClient.Operation> TransactionalProtocolClient.PreparedOperation<T> create(T operation, String failureDescription) {
            ModelNode failedResult = new ModelNode();
            failedResult.get("outcome").set("failed");
            failedResult.get("failure-description").set(failureDescription);
            return new FailedOperation<T>(operation, failedResult);
        }

        public FailedOperation(T operation, ModelNode finalResult) {
            this.operation = operation;
            this.finalResult = finalResult;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.finalResult;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isFailed() {
            return true;
        }

        @Override
        public AsyncFuture<ModelNode> getFinalResult() {
            return new CompletedResult<ModelNode>(this.finalResult);
        }

        @Override
        public void commit() {
            throw new IllegalStateException();
        }

        @Override
        public void rollback() {
            throw new IllegalStateException();
        }
    }
}

