/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationFilter;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.notification.NotificationRegistry;
import org.jboss.as.controller.notification.PathAddressUtil;

class NotificationRegistryImpl
implements NotificationRegistry {
    private final Map<PathAddress, Set<NotificationHandlerEntry>> notificationHandlers = new ConcurrentHashMap<PathAddress, Set<NotificationHandlerEntry>>();

    NotificationRegistryImpl() {
    }

    @Override
    public synchronized void registerNotificationHandler(PathAddress source, NotificationHandler handler, NotificationFilter filter) {
        Set<NotificationHandlerEntry> handlers = this.notificationHandlers.get(source);
        if (handlers == null) {
            handlers = new HashSet<NotificationHandlerEntry>();
        }
        handlers.add(new NotificationHandlerEntry(handler, filter));
        this.notificationHandlers.put(source, handlers);
    }

    @Override
    public synchronized void unregisterNotificationHandler(PathAddress source, NotificationHandler handler, NotificationFilter filter) {
        NotificationHandlerEntry entry = new NotificationHandlerEntry(handler, filter);
        Set<NotificationHandlerEntry> handlers = this.notificationHandlers.get(source);
        if (handlers != null) {
            handlers.remove(entry);
        }
    }

    List<NotificationHandler> findMatchingNotificationHandlers(Notification notification) {
        ArrayList<NotificationHandler> handlers = new ArrayList<NotificationHandler>();
        for (Map.Entry<PathAddress, Set<NotificationHandlerEntry>> entries : this.notificationHandlers.entrySet()) {
            if (!PathAddressUtil.matches(notification.getSource(), entries.getKey())) continue;
            for (NotificationHandlerEntry entry : entries.getValue()) {
                if (!entry.getFilter().isNotificationEnabled(notification)) continue;
                handlers.add(entry.getHandler());
            }
        }
        return handlers;
    }

    private class NotificationHandlerEntry {
        private final NotificationHandler handler;
        private final NotificationFilter filter;

        private NotificationHandlerEntry(NotificationHandler handler, NotificationFilter filter) {
            this.handler = handler;
            this.filter = filter;
        }

        public NotificationHandler getHandler() {
            return this.handler;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotificationHandlerEntry that = (NotificationHandlerEntry)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            return !(this.handler != null ? !this.handler.equals(that.handler) : that.handler != null);
        }

        public int hashCode() {
            int result = this.handler != null ? this.handler.hashCode() : 0;
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            return result;
        }
    }
}

