/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadOperationDescriptionHandler
implements OperationStepHandler {
    static final SimpleAttributeDefinition ACCESS_CONTROL = new SimpleAttributeDefinitionBuilder("access-control", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-operation-description", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.LOCALE, ACCESS_CONTROL).setReplyType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final OperationStepHandler INSTANCE = new ReadOperationDescriptionHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean accessControl;
        String operationName = GlobalOperationAttributes.NAME.resolveModelAttribute(context, operation).asString();
        DescribedOp describedOp = ReadOperationDescriptionHandler.getDescribedOp(context, operationName, operation, !(accessControl = ACCESS_CONTROL.resolveModelAttribute(context, operation).asBoolean()));
        if (describedOp == null || context.getProcessType() == ProcessType.DOMAIN_SERVER && !describedOp.flags.contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
            throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.operationNotRegistered(operationName, PathAddress.pathAddress(operation.require("address")))));
        }
        ModelNode result = describedOp.description;
        Set flags = describedOp.flags;
        boolean readOnly = flags.contains((Object)OperationEntry.Flag.READ_ONLY);
        result.get("read-only").set(readOnly);
        if (!readOnly) {
            if (flags.contains((Object)OperationEntry.Flag.RESTART_ALL_SERVICES)) {
                result.get("restart-required").set("all-services");
            } else if (flags.contains((Object)OperationEntry.Flag.RESTART_RESOURCE_SERVICES)) {
                result.get("restart-required").set("resource-services");
            } else if (flags.contains((Object)OperationEntry.Flag.RESTART_JVM)) {
                result.get("restart-required").set("jvm");
            }
        }
        boolean runtimeOnly = flags.contains((Object)OperationEntry.Flag.RUNTIME_ONLY);
        result.get("runtime-only").set(runtimeOnly);
        if (accessControl) {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            ModelNode operationToCheck = Util.createOperation(operationName, address);
            operationToCheck.get("operation-headers").set(operation.get("operation-headers"));
            AuthorizationResult authorizationResult = context.authorizeOperation(operationToCheck);
            result.get(new String[]{ACCESS_CONTROL.getName(), "execute"}).set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }
        context.getResult().set(result);
        context.stepCompleted();
    }

    private static DescribedOp getDescribedOp(OperationContext context, String operationName, ModelNode operation, boolean lenient) throws OperationFailedException {
        PathElement pe;
        PathAddress address;
        DescribedOp result = null;
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry != null) {
            OperationEntry operationEntry = registry.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            if (operationEntry != null) {
                Locale locale = GlobalOperationHandlers.getLocale(context, operation);
                result = new DescribedOp(operationEntry, locale);
            }
        } else if (lenient && (address = PathAddress.pathAddress(operation.get("address"))).size() > 0 && (pe = address.getLastElement()).isWildcard()) {
            ImmutableManagementResourceRegistration rootRegistration = context.getRootResourceRegistration();
            String type = pe.getKey();
            PathAddress parent = address.subAddress(0, address.size() - 1);
            Set<PathElement> children = rootRegistration.getChildAddresses(parent);
            if (children != null) {
                Locale locale = GlobalOperationHandlers.getLocale(context, operation);
                DescribedOp found = null;
                for (PathElement child : children) {
                    DescribedOp describedOp;
                    if (!type.equals(child.getKey())) continue;
                    OperationEntry oe = rootRegistration.getOperationEntry(parent.append(child), operationName);
                    DescribedOp describedOp2 = describedOp = oe == null ? null : new DescribedOp(oe, locale);
                    if (describedOp == null || found != null && !found.equals(describedOp)) {
                        found = null;
                        break;
                    }
                    found = describedOp;
                }
                result = found;
            }
        }
        return result;
    }

    private static class DescribedOp {
        private final ModelNode description;
        private final Set<OperationEntry.Flag> flags;

        private DescribedOp(OperationEntry operationEntry, Locale locale) {
            this.description = operationEntry.getDescriptionProvider().getModelDescription(locale);
            this.flags = operationEntry.getFlags();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DescribedOp that = (DescribedOp)o;
            return this.description.equals(that.description) && this.flags.equals(that.flags);
        }

        public int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + this.flags.hashCode();
            return result;
        }
    }
}

