/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ReadAttributeHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.INCLUDE_DEFAULTS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler INSTANCE = new ReadAttributeHandler();
    private final ParametersValidator validator = new ParametersValidator();
    private final OperationStepHandler overrideHandler;

    public ReadAttributeHandler() {
        this(null, null);
    }

    ReadAttributeHandler(FilteredData filteredData, OperationStepHandler overrideHandler) {
        super(filteredData);
        this.validator.registerValidator(GlobalOperationAttributes.NAME.getName(), new StringLengthValidator(1));
        this.validator.registerValidator(GlobalOperationAttributes.INCLUDE_DEFAULTS.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        assert (overrideHandler == null || filteredData != null) : "overrideHandler only supported with filteredData";
        this.overrideHandler = overrideHandler;
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData) throws OperationFailedException {
        context.addStep(operation, new AuthorizeAttributeReadHandler(filteredData), OperationContext.Stage.MODEL, true);
        if (filteredData == null) {
            this.doExecuteInternal(context, operation);
        } else {
            try {
                if (this.overrideHandler == null) {
                    this.doExecuteInternal(context, operation);
                } else {
                    this.overrideHandler.execute(context, operation);
                }
            }
            catch (UnauthorizedException ue) {
                PathAddress pa = PathAddress.pathAddress(operation.get("address"));
                filteredData.addReadRestrictedAttribute(pa, operation.get("name").asString());
                context.getResult().set(new ModelNode());
                context.stepCompleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteInternal(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require(GlobalOperationAttributes.NAME.getName()).asString();
        boolean defaults = operation.get(GlobalOperationAttributes.INCLUDE_DEFAULTS.getName()).asBoolean(true);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        AttributeAccess attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            Set<String> children = context.getResourceRegistration().getChildNames(PathAddress.EMPTY_ADDRESS);
            if (children.contains(attributeName)) {
                throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.attributeRegisteredOnResource(attributeName, operation.get("address"))));
            }
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ModelNode subModel = resource.getModel();
            if (subModel.hasDefined(attributeName)) {
                ModelNode result = subModel.get(attributeName);
                context.getResult().set(result);
            } else {
                ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                if (defaults && nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get(new String[]{"attributes", attributeName}).hasDefined("default")) {
                    ModelNode result = nodeDescription.get(new String[]{"attributes", attributeName, "default"});
                    context.getResult().set(result);
                } else if (subModel.has(attributeName) || nodeDescription.get("attributes").has(attributeName)) {
                    context.getResult();
                } else {
                    throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName)));
                }
            }
            context.stepCompleted();
        } else if (attributeAccess.getReadHandler() == null) {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ModelNode subModel = resource.getModel();
            if (subModel.hasDefined(attributeName) || !defaults) {
                ModelNode result = subModel.get(attributeName);
                context.getResult().set(result);
            } else {
                ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                if (nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get(new String[]{"attributes", attributeName}).hasDefined("default")) {
                    ModelNode result = nodeDescription.get(new String[]{"attributes", attributeName, "default"});
                    context.getResult().set(result);
                } else {
                    context.getResult();
                }
            }
            context.stepCompleted();
        } else {
            OperationStepHandler handler = attributeAccess.getReadHandler();
            ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(handler.getClass());
            try {
                handler.execute(context, operation);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
        }
    }

    private ModelNode getNodeDescription(ImmutableManagementResourceRegistration registry, OperationContext context, ModelNode operation) throws OperationFailedException {
        DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
        Locale locale = GlobalOperationHandlers.getLocale(context, operation);
        return descriptionProvider.getModelDescription(locale);
    }

    private static class AuthorizeAttributeReadHandler
    implements OperationStepHandler {
        private final FilteredData filteredData;

        private AuthorizeAttributeReadHandler(FilteredData filteredData) {
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.filteredData == null) {
                this.doExecuteInternal(context, operation);
            } else {
                try {
                    this.doExecuteInternal(context, operation);
                }
                catch (UnauthorizedException ue) {
                    if (context.hasResult()) {
                        context.getResult().set(new ModelNode());
                    }
                    PathAddress pa = PathAddress.pathAddress(operation.get("address"));
                    this.filteredData.addReadRestrictedAttribute(pa, operation.get("name").asString());
                    context.getResult().set(new ModelNode());
                    context.stepCompleted();
                }
            }
        }

        private void doExecuteInternal(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value = context.hasResult() ? context.getResult().clone() : new ModelNode();
            AuthorizationResult authorizationResult = context.authorize(operation, operation.require("name").asString(), value);
            if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                context.getResult().clear();
                throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), PathAddress.pathAddress(operation.get("address")), authorizationResult.getExplanation());
            }
            context.stepCompleted();
        }
    }
}

