/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Locale;

public final class LocaleResolver {
    private static final String ENGLISH = new Locale("en").getLanguage();

    private LocaleResolver() {
    }

    static Locale resolveLocale(String unparsed) throws IllegalArgumentException {
        int len = unparsed.length();
        if (len < 1) {
            throw new IllegalArgumentException(unparsed);
        }
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException(unparsed);
        }
        char char0 = unparsed.charAt(0);
        char char1 = unparsed.charAt(1);
        if (char0 < 'a' || char0 > 'z' || char1 < 'a' || char1 > 'z') {
            throw new IllegalArgumentException(unparsed);
        }
        if (len == 2) {
            return LocaleResolver.replaceByRootLocaleIfLanguageIsEnglish(new Locale(unparsed, ""));
        }
        if (!LocaleResolver.isLocaleSeparator(unparsed.charAt(2))) {
            throw new IllegalArgumentException(unparsed);
        }
        char char3 = unparsed.charAt(3);
        if (LocaleResolver.isLocaleSeparator(char3)) {
            return LocaleResolver.replaceByRootLocaleIfLanguageIsEnglish(new Locale(unparsed.substring(0, 2), "", unparsed.substring(4)));
        }
        char char4 = unparsed.charAt(4);
        if (char3 < 'A' || char3 > 'Z' || char4 < 'A' || char4 > 'Z') {
            throw new IllegalArgumentException(unparsed);
        }
        if (len == 5) {
            return LocaleResolver.replaceByRootLocaleIfLanguageIsEnglish(new Locale(unparsed.substring(0, 2), unparsed.substring(3)));
        }
        if (!LocaleResolver.isLocaleSeparator(unparsed.charAt(5))) {
            throw new IllegalArgumentException(unparsed);
        }
        return LocaleResolver.replaceByRootLocaleIfLanguageIsEnglish(new Locale(unparsed.substring(0, 2), unparsed.substring(3, 5), unparsed.substring(6)));
    }

    private static boolean isLocaleSeparator(char ch) {
        return ch == '-' || ch == '_';
    }

    static Locale replaceByRootLocaleIfLanguageIsEnglish(Locale locale) {
        return locale.getLanguage().equals(ENGLISH) ? Locale.ROOT : locale;
    }
}

