/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.NoSuchResourceException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.global.ReadChildrenNamesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenResourcesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenTypesHandler;
import org.jboss.as.controller.operations.global.ReadOperationDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadOperationNamesHandler;
import org.jboss.as.controller.operations.global.ReadResourceDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.operations.global.UndefineAttributeHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalOperationHandlers {
    private static final Set<String> GLOBAL_READ_OPERATION_NAMES;
    public static final String CHECK_DEFAULT_RESOURCE_ACCESS = "check-default-resource-access";
    public static final String CHECK_RESOURCE_ACCESS = "check-resource-access";

    public static boolean isGlobalReadOperation(String operationName) {
        return GLOBAL_READ_OPERATION_NAMES.contains(operationName);
    }

    public static void registerGlobalOperations(ManagementResourceRegistration root, ProcessType processType) {
        if (processType == ProcessType.HOST_CONTROLLER) {
            root.registerOperationHandler(ReadResourceHandler.DEFINITION, ReadResourceHandler.INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.DEFINITION, ReadAttributeHandler.INSTANCE, true);
        } else {
            root.registerOperationHandler(ReadResourceHandler.RESOLVE_DEFINITION, ReadResourceHandler.RESOLVE_INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.RESOLVE_DEFINITION, ReadAttributeHandler.RESOLVE_INSTANCE, true);
        }
        root.registerOperationHandler(ReadResourceDescriptionHandler.DEFINITION, ReadResourceDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenNamesHandler.DEFINITION, ReadChildrenNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenTypesHandler.DEFINITION, ReadChildrenTypesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenResourcesHandler.DEFINITION, ReadChildrenResourcesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationNamesHandler.DEFINITION, ReadOperationNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationDescriptionHandler.DEFINITION, ReadOperationDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(MapOperations.MAP_PUT_DEFINITION, MapOperations.MAP_PUT_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_GET_DEFINITION, MapOperations.MAP_GET_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_REMOVE_DEFINITION, MapOperations.MAP_REMOVE_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_CLEAR_DEFINITION, MapOperations.MAP_CLEAR_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_ADD_DEFINITION, ListOperations.LIST_ADD_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_REMOVE_DEFINITION, ListOperations.LIST_REMOVE_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_GET_DEFINITION, ListOperations.LIST_GET_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_CLEAR_DEFINITION, ListOperations.LIST_CLEAR_HANDLER, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFAULT_DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        if (processType != ProcessType.DOMAIN_SERVER) {
            root.registerOperationHandler(WriteAttributeHandler.DEFINITION, WriteAttributeHandler.INSTANCE, true);
            root.registerOperationHandler(UndefineAttributeHandler.DEFINITION, UndefineAttributeHandler.INSTANCE, true);
        }
    }

    private GlobalOperationHandlers() {
    }

    static Map<String, Set<String>> getChildAddresses(OperationContext context, PathAddress addr, ImmutableManagementResourceRegistration registry, Resource resource, String validChildType) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set<PathElement> elements = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        for (PathElement element : elements) {
            ImmutableManagementResourceRegistration childReg;
            String childType = element.getKey();
            if (validChildType != null && !validChildType.equals(childType)) continue;
            ImmutableManagementResourceRegistration childRegistration = registry.getSubModel(PathAddress.pathAddress(element));
            AliasEntry aliasEntry = childRegistration.getAliasEntry();
            LinkedHashSet<String> set = (LinkedHashSet<String>)result.get(childType);
            if (set == null) {
                set = new LinkedHashSet<String>();
                result.put(childType, set);
            }
            if (aliasEntry == null) {
                if (resource != null && resource.hasChildren(childType)) {
                    Set<String> childNames = resource.getChildrenNames(childType);
                    if (element.isWildcard()) {
                        set.addAll(childNames);
                    } else if (childNames.contains(element.getValue())) {
                        set.add(element.getValue());
                    }
                }
            } else {
                PathAddress target = aliasEntry.convertToTargetAddress(addr.append(element));
                PathAddress targetParent = target.subAddress(0, target.size() - 1);
                Resource parentResource = context.readResourceFromRoot(targetParent);
                if (parentResource != null && parentResource.hasChildren(target.getLastElement().getKey())) {
                    set.add(element.getValue());
                }
            }
            if (element.isWildcard() || (childReg = registry.getSubModel(PathAddress.pathAddress(element))) == null || !childReg.isRuntimeOnly()) continue;
            set.add(element.getValue());
        }
        for (String type : registry.getChildNames(PathAddress.EMPTY_ADDRESS)) {
            if (validChildType != null && !validChildType.equals(validChildType) || result.containsKey(type)) continue;
            result.put(type, Collections.emptySet());
        }
        return result;
    }

    static Locale getLocale(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(GlobalOperationAttributes.LOCALE.getName())) {
            return null;
        }
        String unparsed = GlobalOperationHandlers.normalizeLocale(operation.get(GlobalOperationAttributes.LOCALE.getName()).asString());
        int len = unparsed.length();
        if (len != 2 && len != 5 && len < 7) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        char char0 = unparsed.charAt(0);
        char char1 = unparsed.charAt(1);
        if (char0 < 'a' || char0 > 'z' || char1 < 'a' || char1 > 'z') {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        if (len == 2) {
            return new Locale(unparsed, "");
        }
        if (!GlobalOperationHandlers.isLocaleSeparator(unparsed.charAt(2))) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        char char3 = unparsed.charAt(3);
        if (GlobalOperationHandlers.isLocaleSeparator(char3)) {
            return new Locale(unparsed.substring(0, 2), "", unparsed.substring(4));
        }
        char char4 = unparsed.charAt(4);
        if (char3 < 'A' || char3 > 'Z' || char4 < 'A' || char4 > 'Z') {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        if (len == 5) {
            return new Locale(unparsed.substring(0, 2), unparsed.substring(3));
        }
        if (!GlobalOperationHandlers.isLocaleSeparator(unparsed.charAt(5))) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        return new Locale(unparsed.substring(0, 2), unparsed.substring(3, 5), unparsed.substring(6));
    }

    static boolean getRecursive(OperationContext context, ModelNode op) throws OperationFailedException {
        ModelNode recursiveNode = GlobalOperationAttributes.RECURSIVE.resolveModelAttribute(context, op);
        int recursiveValue = recursiveNode.isDefined() ? (recursiveNode.asBoolean() ? 1 : 0) : -1;
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        return recursiveValue > 0 && recursiveDepthValue == -1 || recursiveValue != 0 && recursiveDepthValue > 0;
    }

    static void setNextRecursive(OperationContext context, ModelNode op, ModelNode nextOp) throws OperationFailedException {
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        nextOp.get(GlobalOperationAttributes.RECURSIVE.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE.getName()));
        switch (recursiveDepthValue) {
            case -1: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()));
                break;
            }
            case 0: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue);
                break;
            }
            default: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue - 1);
            }
        }
    }

    private static String normalizeLocale(String toNormalize) {
        return "zh_Hans".equalsIgnoreCase(toNormalize) || "zh-Hans".equalsIgnoreCase(toNormalize) ? "zh_CN" : toNormalize;
    }

    private static boolean isLocaleSeparator(char ch) {
        return ch == '-' || ch == '_';
    }

    private static void reportInvalidLocaleFormat(OperationContext context, String format) {
        String msg = ControllerLogger.ROOT_LOGGER.invalidLocaleString(format);
        ControllerLogger.MGMT_OP_LOGGER.debug(msg);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(ReadResourceHandler.DEFINITION.getName());
        set.add(ReadAttributeHandler.DEFINITION.getName());
        set.add(ReadResourceDescriptionHandler.DEFINITION.getName());
        set.add(ReadChildrenNamesHandler.DEFINITION.getName());
        set.add(ReadChildrenTypesHandler.DEFINITION.getName());
        set.add(ReadChildrenResourcesHandler.DEFINITION.getName());
        set.add(ReadOperationNamesHandler.DEFINITION.getName());
        set.add(ReadOperationDescriptionHandler.DEFINITION.getName());
        set.add(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFINITION.getName());
        set.add(MapOperations.MAP_PUT_DEFINITION.getName());
        set.add(MapOperations.MAP_GET_DEFINITION.getName());
        set.add(MapOperations.MAP_CLEAR_DEFINITION.getName());
        set.add(MapOperations.MAP_REMOVE_DEFINITION.getName());
        set.add(ListOperations.LIST_ADD_DEFINITION.getName());
        GLOBAL_READ_OPERATION_NAMES = Collections.unmodifiableSet(set);
    }

    static class RegistrationAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final OperationStepHandler handler;

        RegistrationAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(address, PathAddress.EMPTY_ADDRESS, context);
            context.stepCompleted();
        }

        void execute(PathAddress address, PathAddress base, OperationContext context) {
            PathAddress current = address.subAddress(base.size());
            Iterator iterator = current.iterator();
            if (iterator.hasNext()) {
                PathElement element = (PathElement)iterator.next();
                if (element.isMultiTarget()) {
                    Set<PathElement> children = context.getResourceRegistration().getChildAddresses(base);
                    if (children == null || children.isEmpty()) {
                        return;
                    }
                    String childType = element.getKey().equals("*") ? null : element.getKey();
                    for (PathElement path : children) {
                        if (childType != null && !childType.equals(path.getKey())) continue;
                        this.execute(address, base.append(path), context);
                    }
                } else {
                    this.execute(address, base.append(element), context);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                ModelNode result = this.result.add();
                result.get("address").set(base.toModelNode());
                context.addStep(result, newOp, this.handler, OperationContext.Stage.MODEL, true);
            }
        }
    }

    public static final class ModelAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final FilteredData filteredData;
        private final OperationStepHandler handler;

        public ModelAddressResolver(ModelNode operation, ModelNode result, FilteredData filteredData, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(address, PathAddress.EMPTY_ADDRESS, context);
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (ModelAddressResolver.this.result.getType() == ModelType.LIST) {
                        boolean replace = false;
                        ModelNode replacement = new ModelNode().setEmptyList();
                        for (ModelNode item : ModelAddressResolver.this.result.asList()) {
                            if (item.isDefined() && item.hasDefined("address")) {
                                replacement.add(item);
                                continue;
                            }
                            replace = true;
                        }
                        if (replace) {
                            ModelAddressResolver.this.result.set(replacement);
                        }
                    }
                }
            });
        }

        private void safeExecute(PathAddress address, PathAddress base, OperationContext context) {
            try {
                this.execute(address, base, context);
            }
            catch (UnauthorizedException e) {
                this.filteredData.addReadRestrictedResource(base);
            }
            catch (NoSuchResourceException e) {
                this.filteredData.addAccessRestrictedResource(base);
            }
        }

        private void execute(PathAddress address, final PathAddress base, OperationContext context) {
            Resource resource = context.readResource(base, false);
            PathAddress current = address.subAddress(base.size());
            Iterator iterator = current.iterator();
            if (iterator.hasNext()) {
                PathElement element = (PathElement)iterator.next();
                if (element.isMultiTarget()) {
                    String childType = element.getKey().equals("*") ? null : element.getKey();
                    ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(base);
                    if (registration.isRemote() || registration.isRuntimeOnly()) {
                        throw new IllegalStateException();
                    }
                    Map<String, Set<String>> resolved = GlobalOperationHandlers.getChildAddresses(context, address, registration, resource, childType);
                    for (Map.Entry<String, Set<String>> entry : resolved.entrySet()) {
                        String key = entry.getKey();
                        Set<String> children = entry.getValue();
                        if (children.isEmpty()) continue;
                        if (element.isWildcard()) {
                            for (String child : children) {
                                if (!resource.hasChild(PathElement.pathElement(key, child))) continue;
                                this.safeExecute(address, base.append(PathElement.pathElement(key, child)), context);
                            }
                            continue;
                        }
                        for (String segment : element.getSegments()) {
                            if (!children.contains(segment) || !resource.hasChild(PathElement.pathElement(key, segment))) continue;
                            this.safeExecute(address, base.append(PathElement.pathElement(key, segment)), context);
                        }
                    }
                } else if (resource.hasChild(element)) {
                    this.safeExecute(address, base.append(element), context);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                ModelNode resultItem = this.result.add();
                final ModelNode resultAddress = resultItem.get("address");
                OperationStepHandler wrapper = new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        try {
                            ModelAddressResolver.this.handler.execute(context, operation);
                            resultAddress.set(base.toModelNode());
                        }
                        catch (NoSuchResourceException e) {
                            context.stepCompleted();
                        }
                    }
                };
                context.addStep(resultItem, newOp, wrapper, OperationContext.Stage.MODEL, true);
            }
        }
    }

    public static abstract class AbstractMultiTargetHandler
    implements OperationStepHandler {
        public static final ModelNode FAKE_OPERATION;
        private final FilteredData filteredData;

        protected AbstractMultiTargetHandler() {
            this(null);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData) {
            this.filteredData = filteredData;
        }

        protected FilteredData getFilteredData() {
            return this.filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            if (address.isMultiTarget()) {
                final FilteredData localFilteredData = this.filteredData == null ? new FilteredData(PathAddress.EMPTY_ADDRESS) : this.filteredData;
                ModelNode result = context.getResult().setEmptyList();
                context.addStep(new ModelNode(), FAKE_OPERATION.clone(), new ModelAddressResolver(operation, result, localFilteredData, new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        AbstractMultiTargetHandler.this.doExecute(context, operation, localFilteredData);
                    }
                }), OperationContext.Stage.MODEL, true);
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP && localFilteredData.hasFilteredData()) {
                            context.getResponseHeaders().get("access-control").set(localFilteredData.toModelNode());
                        }
                    }
                });
            } else {
                this.doExecute(context, operation, this.filteredData);
            }
        }

        abstract void doExecute(OperationContext var1, ModelNode var2, FilteredData var3) throws OperationFailedException;

        static {
            ModelNode resolve = new ModelNode();
            resolve.get("operation").set("resolve");
            resolve.get("address").setEmptyList();
            resolve.protect();
            FAKE_OPERATION = resolve;
        }
    }
}

