/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.ValidateModelStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class AbstractAddStepHandler
implements OperationStepHandler {
    static final Set<RuntimeCapability> NULL_CAPABILITIES = Collections.emptySet();
    private static final Set<? extends AttributeDefinition> NULL_ATTRIBUTES = Collections.emptySet();
    private final Set<RuntimeCapability> capabilities;
    protected final Collection<? extends AttributeDefinition> attributes;

    public AbstractAddStepHandler() {
        this.attributes = NULL_ATTRIBUTES;
        this.capabilities = NULL_CAPABILITIES;
    }

    public AbstractAddStepHandler(Collection<? extends AttributeDefinition> attributes) {
        this(NULL_CAPABILITIES, attributes);
    }

    public AbstractAddStepHandler(RuntimeCapability capability, Collection<? extends AttributeDefinition> attributes) {
        this(capability == null ? NULL_CAPABILITIES : Collections.singleton(capability), attributes);
    }

    public AbstractAddStepHandler(Set<RuntimeCapability> capabilities, Collection<? extends AttributeDefinition> attributes) {
        this.attributes = attributes == null ? NULL_ATTRIBUTES : attributes;
        this.capabilities = capabilities == null ? NULL_CAPABILITIES : capabilities;
    }

    public AbstractAddStepHandler(RuntimeCapability capability, AttributeDefinition ... attributes) {
        this(capability == null ? NULL_CAPABILITIES : Collections.singleton(capability), attributes);
    }

    public AbstractAddStepHandler(AttributeDefinition ... attributes) {
        this(NULL_CAPABILITIES, attributes);
    }

    public AbstractAddStepHandler(Set<RuntimeCapability> capabilities, AttributeDefinition ... attributes) {
        this(capabilities, attributes.length > 0 ? Arrays.asList(attributes) : NULL_ATTRIBUTES);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = this.createResource(context);
        this.populateModel(context, operation, resource);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        context.addStep(ValidateModelStepHandler.INSTANCE, OperationContext.Stage.MODEL);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractAddStepHandler.this.performRuntime(context, operation, resource);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractAddStepHandler.this.rollbackRuntime(context, operation, resource);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    protected Resource createResource(OperationContext context) {
        return context.createResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (RuntimeCapability capability : this.capabilities) {
            context.registerCapability(capability, null);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer();
    }

    @Deprecated
    protected boolean requiresRuntimeVerification() {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.performRuntime(context, operation, resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.performRuntime(context, operation, model, ServiceVerificationHandler.INSTANCE, new ArrayList());
        this.requiresRuntimeVerification();
    }

    @Deprecated
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        this.rollbackRuntime(context, operation, resource.getModel(), new ArrayList(0));
    }

    @Deprecated
    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
    }
}

