/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InetAddressValidator
extends ModelTypeValidator {
    public InetAddressValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, true);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String str = value.asString();
            try {
                InetAddress.getByName(str);
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
    }
}

