/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.impl.ClientConfigurationImpl;
import org.jboss.threads.JBossThreadFactory;

public interface ModelControllerClientConfiguration
extends Closeable {
    public String getHost();

    public int getPort();

    public String getProtocol();

    public int getConnectionTimeout();

    public CallbackHandler getCallbackHandler();

    public Map<String, String> getSaslOptions();

    public SSLContext getSSLContext();

    public ExecutorService getExecutor();

    public static class Factory {
        private static final int DEFAULT_MAX_THREADS = Factory.getSystemProperty("org.jboss.as.controller.client.max-threads", 6);
        private static final AtomicInteger executorCount = new AtomicInteger();
        private static final ThreadGroup defaultThreadGroup = new ThreadGroup("management-client-thread");

        static ExecutorService createDefaultExecutor() {
            JBossThreadFactory threadFactory = new JBossThreadFactory(defaultThreadGroup, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null, AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

                @Override
                public AccessControlContext run() {
                    return AccessController.getContext();
                }
            }));
            return new ThreadPoolExecutor(2, DEFAULT_MAX_THREADS, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory);
        }

        private static int getSystemProperty(String name, int defaultValue) {
            String value = Factory.getStringProperty(name);
            try {
                return value == null ? defaultValue : Integer.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                return defaultValue;
            }
        }

        private static String getStringProperty(final String name) {
            return System.getSecurityManager() == null ? System.getProperty(name) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, null, null, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, handler, null, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, null, null, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, null, null, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, handler, null, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, Factory.createDefaultExecutor(), true, connectionTimeout, protocol);
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, handler, saslOptions, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return new ClientConfigurationImpl(address.getHostAddress(), port, handler, saslOptions, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, Factory.createDefaultExecutor(), true, 0, protocol);
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, saslOptions, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String hostName, int port) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, null, null, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, null, Factory.createDefaultExecutor(), true, 0, null);
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, Factory.createDefaultExecutor(), true, connectionTimeout, null);
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, saslOptions, sslContext, Factory.createDefaultExecutor(), true, connectionTimeout, protocol);
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return new ClientConfigurationImpl(hostName, port, handler, saslOptions, null, Factory.createDefaultExecutor(), true, 0, protocol);
        }
    }
}

