/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.alias.AliasCompletion;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.History;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.TerminalBuilder;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Signal;
import org.aesh.util.FileAccessPermission;
import org.aesh.util.Parser;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.impl.CLIPrintStream;
import org.jboss.as.cli.impl.Console;
import org.jboss.logging.Logger;

public class ReadlineConsole
implements Console {
    private static final Logger LOG = Logger.getLogger((String)ReadlineConsole.class.getName());
    private static final boolean isTraceEnabled = LOG.isTraceEnabled();
    private final CommandContext cmdCtx;
    private final List<Completion> completions = new ArrayList<Completion>();
    private final Readline readline;
    private final CLITerminalConnection connection;
    private final CommandHistory history = new HistoryImpl();
    private final FileHistory readlineHistory;
    private String prompt;
    private final Settings settings;
    private volatile boolean started;
    private volatile boolean closed;
    private Thread startThread;
    private Thread readingThread;
    private Consumer<String> callback;
    private final ExecutorService executor = Executors.newFixedThreadPool(1, r -> new Thread(r, "CLI command"));
    private StringBuilder outputCollector;
    private final AliasManager aliasManager;
    private final List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final EnumMap<ReadlineFlag, Integer> READLINE_FLAGS = new EnumMap(ReadlineFlag.class);
    private final Consumer<Signal> interruptHandler;
    private boolean isSystemTerminal;

    ReadlineConsole(CommandContext cmdCtx, Settings settings) throws IOException {
        this.cmdCtx = cmdCtx;
        this.settings = settings;
        this.readlineHistory = new FileHistory(settings.getHistoryFile(), settings.getHistorySize(), settings.getPermission(), false);
        if (settings.isDisableHistory()) {
            this.readlineHistory.disable();
        } else {
            this.readlineHistory.enable();
        }
        if (isTraceEnabled) {
            LOG.tracef("History is enabled? %s", (Object)(!settings.isDisableHistory() ? 1 : 0));
        }
        this.connection = this.newConnection();
        this.interruptHandler = signal -> {
            if (signal == Signal.INT) {
                LOG.trace((Object)"Calling InterruptHandler");
                this.connection.write(Config.getLineSeparator());
                this.connection.close();
            }
        };
        this.connection.setSignalHandler(this.interruptHandler);
        Attributes attr = this.connection.getAttributes();
        attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
        this.connection.setAttributes(attr);
        this.aliasManager = new AliasManager(new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases"), true);
        AliasPreProcessor aliasPreProcessor = new AliasPreProcessor(this.aliasManager);
        this.preProcessors.add((Function<String, Optional<String>>)aliasPreProcessor);
        this.completions.add((Completion)new AliasCompletion(this.aliasManager));
        this.readline = new Readline();
    }

    @Override
    public void setActionCallback(Consumer<String> callback) {
        this.callback = callback;
    }

    private CLITerminalConnection newConnection() throws IOException {
        CLIPrintStream stream = (CLIPrintStream)this.settings.getOutStream();
        LOG.trace((Object)"Creating terminal connection");
        Terminal terminal = TerminalBuilder.builder().input(this.settings.getInStream() == null ? System.in : this.settings.getInStream()).output((OutputStream)stream).nativeSignals(true).name("CLI Terminal").system(!this.settings.isOutputRedefined()).build();
        if (isTraceEnabled) {
            LOG.tracef("New Terminal %s", terminal.getClass());
        }
        CLITerminalConnection c = new CLITerminalConnection(terminal);
        this.isSystemTerminal = c.supportsAnsi();
        return c;
    }

    @Override
    public void addCompleter(CommandLineCompleter completer) {
        this.completions.add(co -> {
            String buffer;
            ArrayList<String> candidates = new ArrayList<String>();
            if (isTraceEnabled) {
                LOG.tracef("Completing %s", (Object)co.getBuffer());
            }
            int offset = completer.complete(this.cmdCtx, co.getBuffer(), co.getCursor(), candidates);
            co.setOffset(offset);
            co.addCompletionCandidates(candidates);
            String string = buffer = this.cmdCtx.getArgumentsString() == null ? co.getBuffer() : this.cmdCtx.getArgumentsString() + co.getBuffer();
            if (co.getCompletionCandidates().size() == 1 && ((TerminalString)co.getCompletionCandidates().get(0)).getCharacters().startsWith(buffer)) {
                co.doAppendSeparator(true);
            } else {
                co.doAppendSeparator(false);
            }
            if (isTraceEnabled) {
                LOG.tracef("Completion candidates %s", (Object)co.getCompletionCandidates());
            }
        });
    }

    @Override
    public CommandHistory getHistory() {
        return this.history;
    }

    @Override
    public void clearScreen() {
        this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
    }

    @Override
    public void printColumns(Collection<String> list) {
        String[] newList = new String[list.size()];
        list.toArray(newList);
        String line = Parser.formatDisplayList((String[])newList, (int)this.getHeight(), (int)this.getWidth());
        if (this.outputCollector == null) {
            this.connection.write(line);
        } else {
            this.outputCollector.append(line);
        }
    }

    @Override
    public void print(String line) {
        LOG.tracef("Print %s", (Object)line);
        if (this.outputCollector == null) {
            this.connection.write(line);
        } else {
            this.outputCollector.append(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCollectedOutput() {
        if (this.outputCollector == null) {
            return;
        }
        try {
            String line = this.outputCollector.toString();
            if (line.isEmpty()) {
                return;
            }
            String[] lines = line.split("\\R", -1);
            int max = this.connection.getTerminal().getSize().getHeight();
            int currentLines = 0;
            int allLines = 0;
            while (allLines < lines.length) {
                if (currentLines > max - 2) {
                    try {
                        this.connection.write(ANSI.CURSOR_SAVE);
                        int percentage = allLines * 100 / lines.length;
                        this.connection.write("--More(" + percentage + "%)--");
                        Key k = this.read();
                        this.connection.write(ANSI.CURSOR_RESTORE);
                        this.connection.stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            allLines = lines.length;
                            continue;
                        }
                        switch (k) {
                            case SPACE: {
                                currentLines = 0;
                                break;
                            }
                            case ENTER: 
                            case CTRL_M: {
                                --currentLines;
                                break;
                            }
                            case q: {
                                allLines = lines.length;
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                }
                String l = lines[allLines];
                ++currentLines;
                if (++allLines == lines.length && l.isEmpty()) continue;
                this.connection.write(l + Config.getLineSeparator());
            }
        }
        finally {
            this.outputCollector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key read() throws InterruptedException {
        ActionDecoder decoder = new ActionDecoder();
        Key[] key = new Key[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(sig -> latch.countDown());
        Attributes attributes = this.connection.enterRawMode();
        this.connection.setStdinHandler(keys -> {
            decoder.add(keys);
            if (decoder.hasNext()) {
                key[0] = Key.findStartKey((int[])decoder.next().buffer().array());
                latch.countDown();
                this.connection.suspend();
            }
        });
        this.connection.awake();
        try {
            latch.await();
        }
        finally {
            this.connection.setStdinHandler(null);
            this.connection.setSignalHandler(prevHandler);
        }
        return key[0];
    }

    @Override
    public void printNewLine() {
        this.print(this.outputCollector == null ? Config.getLineSeparator() : "\n");
    }

    @Override
    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(String prompt, Character mask) throws IOException {
        this.logPromptMask(prompt, mask);
        this.printCollectedOutput();
        this.outputCollector = this.createCollector();
        this.readingThread = Thread.currentThread();
        try {
            if (!this.started) {
                String string = this.promptFromNonStartedConsole(prompt, mask);
                return string;
            }
            String string = this.promptFromStartedConsole(prompt, mask);
            return string;
        }
        finally {
            this.readingThread = null;
        }
    }

    private StringBuilder createCollector() {
        if (!this.isSystemTerminal) {
            return null;
        }
        return new StringBuilder();
    }

    private String promptFromNonStartedConsole(String prompt, Character mask) {
        LOG.trace((Object)"Not started");
        String[] out = new String[1];
        if (this.connection.suspended()) {
            this.connection.awake();
        }
        this.readline.readline((Connection)this.connection, new Prompt(prompt, mask), newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            this.connection.stopReading();
        }, null, null, null, null, READLINE_FLAGS);
        try {
            this.connection.openBlockingInterruptable();
        }
        catch (InterruptedException ex) {
            this.interrupted(ex);
        }
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptFromStartedConsole(String prompt, Character mask) {
        this.logPromptMask(prompt, mask);
        String[] out = new String[1];
        if (this.readingThread == this.startThread) {
            throw new RuntimeException("Can't prompt from the Thread that is reading terminal input");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        this.readline.readline((Connection)this.connection, new Prompt(prompt, mask), newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            latch.countDown();
        }, null, null, null, null, READLINE_FLAGS);
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            this.interrupted(ex);
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
        }
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    private void logPromptMask(String prompt, Character mask) {
        LOG.tracef("Prompt %s mask %s", (Object)prompt, (Object)mask);
    }

    private void interrupted(InterruptedException ex) {
        LOG.trace((Object)"Thread interrupted");
        Thread.currentThread().interrupt();
        throw new RuntimeException(ex);
    }

    @Override
    public int getTerminalWidth() {
        return this.getWidth();
    }

    @Override
    public int getTerminalHeight() {
        return this.getHeight();
    }

    private int getHeight() {
        if (this.connection instanceof TerminalConnection) {
            return this.connection.getTerminal().getSize().getHeight();
        }
        return this.connection.size().getHeight();
    }

    private int getWidth() {
        if (this.connection instanceof TerminalConnection) {
            return this.connection.getTerminal().getSize().getWidth();
        }
        return this.connection.size().getWidth();
    }

    @Override
    public void start() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Console has already been closed");
        }
        if (!this.started) {
            this.startThread = Thread.currentThread();
            this.started = true;
            this.loop();
            LOG.tracef("Started in thread %s. Waiting...", (Object)this.startThread.getName());
            try {
                this.connection.openBlockingInterruptable();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.trace((Object)"Leaving console");
        } else {
            LOG.trace((Object)"Already started");
        }
    }

    private void loop() {
        if (isTraceEnabled) {
            LOG.tracef("Set a readline callback with prompt %s", (Object)this.prompt);
        }
        if (!this.closed) {
            this.readline.readline((Connection)this.connection, new Prompt(this.prompt), line -> {
                LOG.tracef("Executing command %s in a new thread.", line);
                if (line == null || line.trim().length() == 0 || this.handleAlias((String)line)) {
                    this.loop();
                    return;
                }
                this.executor.submit(() -> {
                    Consumer handler = this.connection.getSignalHandler();
                    Thread callingThread = Thread.currentThread();
                    this.connection.setSignalHandler(signal -> {
                        switch (signal) {
                            case INT: {
                                LOG.tracef("Interrupting command: %s", line);
                                callingThread.interrupt();
                            }
                        }
                    });
                    try {
                        this.outputCollector = this.createCollector();
                        this.callback.accept((String)line);
                    }
                    finally {
                        this.printCollectedOutput();
                        Thread.interrupted();
                        this.connection.setSignalHandler(handler);
                        LOG.tracef("Done Executing command %s", line);
                        this.loop();
                    }
                });
            }, this.completions, this.preProcessors, (History)this.readlineHistory, null, READLINE_FLAGS);
        }
    }

    private boolean handleAlias(String line) {
        if (line.startsWith("alias ") || line.equals("alias")) {
            String out = this.aliasManager.parseAlias(line.trim());
            if (out != null) {
                this.connection.write(out);
            }
            return true;
        }
        if (line.startsWith("unalias ") || line.equals("unalias")) {
            String out = this.aliasManager.removeAlias(line.trim());
            if (out != null) {
                this.connection.write(out);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        if (!this.closed) {
            LOG.trace((Object)"Stopping.");
            this.closed = true;
            if (this.readingThread != null) {
                LOG.trace((Object)"Interrupting reading thread");
                this.readingThread.interrupt();
            }
            if (this.started) {
                this.readlineHistory.stop();
                this.aliasManager.persist();
            }
            this.executor.shutdown();
            this.connection.close();
        }
    }

    @Override
    public boolean running() {
        return this.started;
    }

    @Override
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    static {
        READLINE_FLAGS.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
    }

    class HistoryImpl
    implements CommandHistory {
        HistoryImpl() {
        }

        @Override
        public List<String> asList() {
            ArrayList<String> lst = new ArrayList<String>();
            for (int[] l : ReadlineConsole.this.readlineHistory.getAll()) {
                lst.add(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])l)));
            }
            return lst;
        }

        @Override
        public boolean isUseHistory() {
            return ReadlineConsole.this.readlineHistory.isEnabled();
        }

        @Override
        public void setUseHistory(boolean useHistory) {
            if (useHistory) {
                ReadlineConsole.this.readlineHistory.enable();
            } else {
                ReadlineConsole.this.readlineHistory.disable();
            }
        }

        @Override
        public void clear() {
            ReadlineConsole.this.readlineHistory.clear();
        }

        @Override
        public int getMaxSize() {
            return ReadlineConsole.this.readlineHistory.size();
        }
    }

    public static class SettingsBuilder {
        private InputStream inStream;
        private OutputStream outStream;
        private boolean disableHistory;
        private File historyFile;
        private int historySize;
        private FileAccessPermission permission;
        private Runnable interrupt;
        private boolean outputRedefined;

        public SettingsBuilder inputStream(InputStream inStream) {
            this.inStream = inStream;
            return this;
        }

        public SettingsBuilder outputStream(OutputStream outStream) {
            this.outStream = outStream;
            return this;
        }

        public SettingsBuilder disableHistory(boolean disableHistory) {
            this.disableHistory = disableHistory;
            return this;
        }

        public SettingsBuilder historyFile(File historyFile) {
            this.historyFile = historyFile;
            return this;
        }

        public SettingsBuilder historySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public SettingsBuilder historyFilePermission(FileAccessPermission permission) {
            this.permission = permission;
            return this;
        }

        public SettingsBuilder interruptHook(Runnable interrupt) {
            this.interrupt = interrupt;
            return this;
        }

        public SettingsBuilder outputRedefined(boolean outputRedefined) {
            this.outputRedefined = outputRedefined;
            return this;
        }

        public Settings create() {
            return new SettingsImpl(this.inStream, this.outStream, this.outputRedefined, this.disableHistory, this.historyFile, this.historySize, this.permission, this.interrupt);
        }
    }

    private static class SettingsImpl
    implements Settings {
        private final InputStream inStream;
        private final OutputStream outStream;
        private final boolean disableHistory;
        private final File historyFile;
        private final int historySize;
        private final FileAccessPermission permission;
        private final Runnable interrupt;
        private final boolean outputRedefined;

        private SettingsImpl(InputStream inStream, OutputStream outStream, boolean outputRedefined, boolean disableHistory, File historyFile, int historySize, FileAccessPermission permission, Runnable interrupt) {
            this.inStream = inStream;
            this.outStream = outStream;
            this.outputRedefined = outputRedefined;
            this.disableHistory = disableHistory;
            this.historyFile = historyFile;
            this.historySize = historySize;
            this.permission = permission;
            this.interrupt = interrupt;
        }

        @Override
        public InputStream getInStream() {
            return this.inStream;
        }

        @Override
        public OutputStream getOutStream() {
            return this.outStream;
        }

        @Override
        public boolean isDisableHistory() {
            return this.disableHistory;
        }

        @Override
        public boolean isOutputRedefined() {
            return this.outputRedefined;
        }

        @Override
        public File getHistoryFile() {
            return this.historyFile;
        }

        @Override
        public int getHistorySize() {
            return this.historySize;
        }

        @Override
        public FileAccessPermission getPermission() {
            return this.permission;
        }

        @Override
        public Runnable getInterrupt() {
            return this.interrupt;
        }
    }

    private static class CLITerminalConnection
    extends TerminalConnection {
        private final Consumer<int[]> interceptor = ints -> {
            if (isTraceEnabled) {
                LOG.tracef("Writing %s", (Object)Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
            }
            CLITerminalConnection.super.stdoutHandler().accept(ints);
        };
        private Thread connectionThread;

        CLITerminalConnection(Terminal terminal) {
            super(terminal);
        }

        public Consumer<int[]> stdoutHandler() {
            return this.interceptor;
        }

        public void openBlockingInterruptable() throws InterruptedException {
            this.connectionThread = new Thread(() -> {
                Thread thr = new Thread(() -> super.openBlocking(), "CLI Terminal Connection (uninterruptable)");
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "CLI Terminal Connection (interruptable)");
            this.connectionThread.start();
            this.connectionThread.join();
        }

        public void close() {
            super.close();
            if (this.connectionThread != null) {
                this.connectionThread.interrupt();
            }
        }
    }

    public static interface Settings {
        public InputStream getInStream();

        public OutputStream getOutStream();

        public boolean isDisableHistory();

        public boolean isOutputRedefined();

        public File getHistoryFile();

        public int getHistorySize();

        public FileAccessPermission getPermission();

        public Runnable getInterrupt();
    }
}

