/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.loop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

class ForControlFlow
implements CommandLineRedirection {
    private static final String CTX_KEY = "FOR";
    private CommandLineRedirection.Registration registration;
    private final List<ModelNode> result;
    private final List<String> forBlock = new ArrayList<String>();
    private final String varName;

    static ForControlFlow get(CommandContext ctx) {
        return (ForControlFlow)ctx.get(CommandContext.Scope.CONTEXT, CTX_KEY);
    }

    ForControlFlow(CommandContext ctx, String varName, String iterable) throws CommandLineException {
        ModelNode targetValue;
        if (varName == null) {
            throw new IllegalArgumentException("Variable is null");
        }
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable is null");
        }
        if (ctx.getVariable(varName) != null) {
            throw new CommandFormatException("Variable " + varName + " already exists.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandLineException("The connection to the controller has not been established.");
        }
        this.varName = varName;
        ModelNode forRequest = ctx.buildRequest(iterable);
        try {
            targetValue = ctx.execute(forRequest, "for iterable");
        }
        catch (IOException e) {
            throw new CommandLineException("iterable request failed", e);
        }
        if (!targetValue.hasDefined("result")) {
            throw new CommandLineException("iterable request failed, no result");
        }
        ModelNode mn = targetValue.get("result");
        this.result = mn.asList();
        ctx.setVariable(varName, "null");
        ctx.set(CommandContext.Scope.CONTEXT, CTX_KEY, this);
    }

    @Override
    public void set(CommandLineRedirection.Registration registration) {
        this.registration = registration;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine line = ctx.getParsedCommandLine();
        if (line.getFormat() == CommandFormat.INSTANCE) {
            String cmd = line.getOperationName();
            if ("for".equals(cmd)) {
                throw new CommandFormatException("for is not allowed while in for block");
            }
            if (line.hasProperty("--help") || line.hasProperty("-h") || "done".equals(cmd) || "help".equals(cmd)) {
                this.registration.handle(line);
                return;
            }
        }
        this.forBlock.add(line.getOriginalLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(CommandContext ctx, boolean discard) throws CommandLineException {
        try {
            this.registration.unregister();
            if (!discard) {
                for (ModelNode v : this.result) {
                    String value = v.asString();
                    ctx.setVariable(this.varName, value);
                    for (String cmd : this.forBlock) {
                        ctx.handle(cmd);
                    }
                }
            }
        }
        finally {
            ctx.setVariable(this.varName, null);
            if (this.registration.isActive()) {
                this.registration.unregister();
            }
            ctx.remove(CommandContext.Scope.CONTEXT, CTX_KEY);
        }
    }
}

