/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.module;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.ModuleNameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.handlers.module.ModuleConfigImpl;
import org.jboss.as.cli.handlers.module.ModuleDependency;
import org.jboss.as.cli.handlers.module.ResourceRoot;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.staxmapper.FormattingXMLStreamWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ASModuleHandler
extends CommandHandlerWithHelp {
    private static final String JBOSS_HOME = "JBOSS_HOME";
    private static final String JBOSS_HOME_PROPERTY = "jboss.home.dir";
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String MODULE_SEPARATOR = ",";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_REMOVE = "remove";
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public Collection<String> getAllCandidates(CommandContext ctx) {
            return Arrays.asList(ASModuleHandler.ACTION_ADD, ASModuleHandler.ACTION_REMOVE);
        }
    }), 0, "--action");
    private final ArgumentWithValue name;
    private final ArgumentWithValue mainClass;
    private final ArgumentWithValue resources;
    private final ArgumentWithValue absoluteResources;
    private final ArgumentWithListValue dependencies;
    private final ArgumentWithListValue exportDependencies;
    private final ArgumentWithListValue props;
    private final ArgumentWithValue moduleArg;
    private final ArgumentWithValue slot;
    private final ArgumentWithValue resourceDelimiter;
    private final ArgumentWithValue moduleRootDir;
    private final ArgumentWithoutValue allowNonExistentResources;
    private File modulesDir;

    public ASModuleHandler(CommandContext ctx) {
        super("module", false);
        final FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.moduleRootDir = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--module-root-dir");
        this.name = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                try {
                    String currentAction = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
                    ModuleNameTabCompleter moduleNameCompleter = ModuleNameTabCompleter.completer(ASModuleHandler.this.getModulesDir(ctx)).excludeNonModuleFolders(ASModuleHandler.ACTION_REMOVE.equals(currentAction)).includeSystemModules(ASModuleHandler.ACTION_ADD.equals(currentAction)).build();
                    candidates.addAll(moduleNameCompleter.complete(buffer));
                    return 0;
                }
                catch (CommandLineException e) {
                    return -1;
                }
            }
        }, "--name"){

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.name.addRequiredPreceding(this.action);
        this.mainClass = new AddModuleArgument("--main-class");
        this.resources = new AddModuleArgument("--resources", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int lastSeparator = buffer.lastIndexOf(PATH_SEPARATOR);
                if (lastSeparator >= 0) {
                    return lastSeparator + 1 + pathCompleter.complete(ctx, buffer.substring(lastSeparator + 1), cursor, candidates);
                }
                return pathCompleter.complete(ctx, buffer, cursor, candidates);
            }
        }){

            @Override
            public String getValue(ParsedCommandLine args) {
                String value = super.getValue(args);
                if (value != null) {
                    if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    value = pathCompleter.translatePath(value);
                }
                return value;
            }

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.allowNonExistentResources = new ArgumentWithoutValue(this, "--allow-nonexistent-resources");
        this.allowNonExistentResources.addRequiredPreceding(this.resources);
        this.absoluteResources = new AddModuleArgument("--absolute-resources", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int lastSeparator = buffer.lastIndexOf(PATH_SEPARATOR);
                if (lastSeparator >= 0) {
                    return lastSeparator + 1 + pathCompleter.complete(ctx, buffer.substring(lastSeparator + 1), cursor, candidates);
                }
                return pathCompleter.complete(ctx, buffer, cursor, candidates);
            }
        }){

            @Override
            public String getValue(ParsedCommandLine args) {
                String value = super.getValue(args);
                if (value != null) {
                    if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    value = pathCompleter.translatePath(value);
                }
                return value;
            }

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.resourceDelimiter = new AddModuleArgument("--resource-delimiter");
        this.dependencies = new AddModuleListArgument("--dependencies", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                return ASModuleHandler.this.doCompleteDependencies(ctx, buffer, cursor, candidates);
            }
        });
        this.exportDependencies = new AddModuleListArgument("--export-dependencies", new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                return ASModuleHandler.this.doCompleteDependencies(ctx, buffer, cursor, candidates);
            }
        });
        this.props = new AddModuleListArgument("--properties");
        this.moduleArg = new FileSystemPathArgument(this, pathCompleter, "--module-xml"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String actionValue = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
                return ASModuleHandler.ACTION_ADD.equals(actionValue) && ASModuleHandler.this.name.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
            }
        };
        this.slot = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                File moduleDir;
                String moduleName = ASModuleHandler.this.name.getValue(ctx.getParsedCommandLine());
                if (moduleName == null) {
                    return Collections.emptyList();
                }
                try {
                    moduleDir = new File(ASModuleHandler.this.getModulesDir(ctx), moduleName.replace('.', File.separatorChar));
                }
                catch (CommandLineException e) {
                    return Collections.emptyList();
                }
                if (!moduleDir.exists()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(moduleDir.list());
            }
        }), "--slot");
        this.moduleArg.addCantAppearAfter(this.mainClass);
        this.moduleArg.addCantAppearAfter(this.dependencies);
        this.moduleArg.addCantAppearAfter(this.exportDependencies);
        this.moduleArg.addCantAppearAfter(this.props);
        this.mainClass.addCantAppearAfter(this.moduleArg);
        this.dependencies.addCantAppearAfter(this.moduleArg);
        this.exportDependencies.addCantAppearAfter(this.moduleArg);
        this.props.addCantAppearAfter(this.moduleArg);
    }

    private int doCompleteDependencies(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int lastSeparator = buffer.lastIndexOf(MODULE_SEPARATOR);
        try {
            ModuleNameTabCompleter moduleNameCompleter = ModuleNameTabCompleter.completer(this.getModulesDir(ctx)).excludeNonModuleFolders(true).includeSystemModules(true).build();
            if (lastSeparator >= 0) {
                candidates.addAll(moduleNameCompleter.complete(buffer.substring(lastSeparator + 1)));
                return lastSeparator + 1;
            }
            candidates.addAll(moduleNameCompleter.complete(buffer));
            return 0;
        }
        catch (CommandLineException e) {
            return -1;
        }
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return !ctx.isDomainMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String actionValue = this.action.getValue(parsedCmd);
        if (actionValue == null) {
            throw new CommandFormatException("Action argument is missing: add or remove");
        }
        if (ACTION_ADD.equals(actionValue)) {
            this.addModule(ctx, parsedCmd);
        } else if (ACTION_REMOVE.equals(actionValue)) {
            this.removeModule(parsedCmd, ctx);
        } else {
            throw new CommandFormatException("Unexpected action '" + actionValue + "', expected values: " + ACTION_ADD + ", " + ACTION_REMOVE);
        }
    }

    protected void addModule(CommandContext ctx, ParsedCommandLine parsedCmd) throws CommandLineException {
        ModuleConfigImpl config;
        String moduleName = this.name.getValue(parsedCmd, true);
        if (!(this.moduleArg.isPresent(parsedCmd) || this.resources.isPresent(parsedCmd) || this.absoluteResources.isPresent(parsedCmd))) {
            throw new CommandFormatException("You must specify at least one resource: use --resources or --absolute-resources parameter");
        }
        String resourcePaths = this.resources.getValue(parsedCmd);
        String absoluteResourcePaths = this.absoluteResources.getValue(parsedCmd);
        String pathDelimiter = PATH_SEPARATOR;
        if (this.resourceDelimiter.isPresent(parsedCmd)) {
            pathDelimiter = this.resourceDelimiter.getValue(parsedCmd);
        }
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        String[] resourceArr = resourcePaths == null ? new String[]{} : resourcePaths.split(pathDelimiter);
        File[] resourceFiles = new File[resourceArr.length];
        boolean allowNonExistent = this.allowNonExistentResources.isPresent(parsedCmd);
        for (int i = 0; i < resourceArr.length; ++i) {
            File f = new File(pathCompleter.translatePath(resourceArr[i]));
            if (!f.exists() && !allowNonExistent) {
                throw new CommandLineException("Failed to locate " + f.getAbsolutePath() + ", if you defined a nonexistent resource on purpose you should " + "use the " + this.allowNonExistentResources.getFullName() + " option");
            }
            resourceFiles[i] = f;
        }
        String[] absoluteResourceArr = absoluteResourcePaths == null ? new String[]{} : absoluteResourcePaths.split(pathDelimiter);
        File[] absoluteResourceFiles = new File[absoluteResourceArr.length];
        for (int i = 0; i < absoluteResourceArr.length; ++i) {
            File f = new File(pathCompleter.translatePath(absoluteResourceArr[i]));
            if (!f.exists()) {
                throw new CommandLineException("Failed to locate " + f.getAbsolutePath());
            }
            absoluteResourceFiles[i] = f;
        }
        File moduleDir = this.getModulePath(this.getModulesDir(ctx), moduleName, this.slot.getValue(parsedCmd));
        if (moduleDir.exists()) {
            throw new CommandLineException("Module " + moduleName + " already exists at " + moduleDir.getAbsolutePath());
        }
        if (!moduleDir.mkdirs()) {
            throw new CommandLineException("Failed to create directory " + moduleDir.getAbsolutePath());
        }
        String moduleXml = this.moduleArg.getValue(parsedCmd);
        if (moduleXml != null) {
            config = null;
            File[] source = new File(moduleXml);
            if (!source.exists()) {
                throw new CommandLineException("Failed to locate the file on the filesystem: " + source.getAbsolutePath());
            }
            ASModuleHandler.copy((File)source, new File(moduleDir, "module.xml"));
        } else {
            config = new ModuleConfigImpl(moduleName);
        }
        for (File file : resourceFiles) {
            ASModuleHandler.copyResource(file, new File(moduleDir, file.getName()), ctx, this);
            if (config == null) continue;
            config.addResource(new ResourceRoot(file.getName()));
        }
        for (File file : absoluteResourceFiles) {
            if (config == null) continue;
            try {
                config.addResource(new ResourceRoot(file.getCanonicalPath()));
            }
            catch (IOException ioe) {
                throw new CommandLineException("Failed to read path: " + file.getAbsolutePath(), ioe);
            }
        }
        if (config != null) {
            String mainCls;
            String slotVal;
            String string;
            String exportDependenciesStr;
            HashSet<String> modules = new HashSet<String>();
            String dependenciesStr = this.dependencies.getValue(parsedCmd);
            if (dependenciesStr != null) {
                String[] depsArr;
                for (String dep : depsArr = dependenciesStr.split(",+")) {
                    String depName = dep.trim();
                    config.addDependency(new ModuleDependency(depName));
                    modules.add(depName);
                }
            }
            if ((exportDependenciesStr = this.exportDependencies.getValue(parsedCmd)) != null) {
                String[] stringArray;
                for (String dep : stringArray = exportDependenciesStr.split(",+")) {
                    String depName = dep.trim();
                    if (modules.contains(depName)) {
                        this.deleteRecursively(moduleDir);
                        throw new CommandLineException("Error, duplicated dependency " + depName);
                    }
                    modules.add(depName);
                    config.addDependency(new ModuleDependency(depName, true));
                }
            }
            if ((string = this.props.getValue(parsedCmd)) != null) {
                String[] pairs;
                for (String pair : pairs = string.split(MODULE_SEPARATOR)) {
                    int equals = pair.indexOf(61);
                    if (equals == -1) {
                        throw new CommandFormatException("Property '" + pair + "' in '" + string + "' is missing the equals sign.");
                    }
                    String propName = pair.substring(0, equals);
                    if (propName.isEmpty()) {
                        throw new CommandFormatException("Property name is missing for '" + pair + "' in '" + string + "'");
                    }
                    config.setProperty(propName, pair.substring(equals + 1));
                }
            }
            if ((slotVal = this.slot.getValue(parsedCmd)) != null) {
                config.setSlot(slotVal);
            }
            if ((mainCls = this.mainClass.getValue(parsedCmd)) != null) {
                config.setMainClass(mainCls);
            }
            FileOutputStream fos = null;
            File moduleFile = new File(moduleDir, "module.xml");
            try {
                fos = new FileOutputStream(moduleFile);
                XMLExtendedStreamWriter xmlWriter = ASModuleHandler.create(XMLOutputFactory.newInstance().createXMLStreamWriter(fos, StandardCharsets.UTF_8.name()));
                config.writeContent(xmlWriter, null);
                xmlWriter.flush();
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to create file " + moduleFile.getAbsolutePath(), e);
            }
            catch (XMLStreamException e) {
                throw new CommandLineException("Failed to write to " + moduleFile.getAbsolutePath(), e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void removeModule(ParsedCommandLine parsedCmd, CommandContext ctx) throws CommandLineException {
        String moduleName = this.name.getValue(parsedCmd, true);
        File modulesDir = this.getModulesDir(ctx);
        File modulePath = this.getModulePath(modulesDir, moduleName, this.slot.getValue(parsedCmd));
        if (!modulePath.exists()) {
            throw new CommandLineException("Failed to locate module " + moduleName + " at " + modulePath.getAbsolutePath());
        }
        this.deleteRecursively(modulePath);
        modulePath = modulePath.getParentFile();
        while (!modulesDir.equals(modulePath) && modulePath.list().length <= 0) {
            if (!modulePath.delete()) {
                throw new CommandLineException("Failed to delete " + modulePath.getAbsolutePath());
            }
            modulePath = modulePath.getParentFile();
        }
    }

    protected void deleteRecursively(File file) throws CommandLineException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                this.deleteRecursively(f);
            }
        }
        if (!file.delete()) {
            throw new CommandLineException("Failed to delete " + file.getAbsolutePath());
        }
    }

    protected File getModulePath(File modulesDir, String moduleName, String slot) throws CommandLineException {
        return new File(modulesDir, moduleName.replace('.', File.separatorChar) + File.separatorChar + (slot == null ? "main" : slot));
    }

    protected File getModulesDir(CommandContext ctx) throws CommandLineException {
        File modsDir = null;
        String moduleRootDirStr = this.moduleRootDir.getValue(ctx.getParsedCommandLine());
        if (moduleRootDirStr != null) {
            modsDir = new File(moduleRootDirStr);
        }
        if (modsDir == null) {
            if (this.modulesDir != null) {
                return this.modulesDir;
            }
            String rootDir = WildFlySecurityManager.getEnvPropertyPrivileged((String)JBOSS_HOME, null);
            if (rootDir == null) {
                rootDir = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_HOME_PROPERTY, null);
            }
            if (rootDir == null) {
                throw new CommandLineException("JBOSS_HOME environment variable is not set.");
            }
            modsDir = this.modulesDir = new File(rootDir, "modules");
        }
        if (!modsDir.exists()) {
            throw new CommandLineException("Failed to locate the modules dir on the filesystem: " + modsDir.getAbsolutePath());
        }
        return modsDir;
    }

    public static XMLExtendedStreamWriter create(XMLStreamWriter writer) throws CommandLineException {
        try {
            return new FormattingXMLStreamWriter(writer);
        }
        catch (Exception e) {
            throw new CommandLineException("Failed to create xml stream writer.", e);
        }
    }

    private static void copyResource(File source, File target, CommandContext ctx, ASModuleHandler handler) throws CommandLineException {
        if (!source.exists()) {
            target.mkdir();
            return;
        }
        if (source.isDirectory()) {
            ASModuleHandler.copyDirectory(source, target, ctx, handler);
        } else {
            ASModuleHandler.copy(source, target);
        }
    }

    private static void copyDirectory(File source, File target, CommandContext ctx, ASModuleHandler handler) throws CommandLineException {
        try {
            ASModuleHandler.copyDirectory(source, target);
        }
        catch (IOException ex) {
            Exception removalException = null;
            try {
                handler.removeModule(ctx.getParsedCommandLine(), ctx);
            }
            catch (Exception ee) {
                removalException = ee;
            }
            String msg = "An error occurred while copying directory  " + source.getAbsolutePath() + " to " + target.getAbsolutePath() + " :" + ex;
            msg = removalException == null ? "Module not added. " + msg : msg + ". Attempt to remove the module has failed: " + removalException;
            throw new CommandLineException(msg);
        }
    }

    private static void copyDirectory(File source, File target) throws IOException {
        final Path sourcePath = source.toPath();
        final Path targetPath = target.toPath();
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink()) {
                    Path symTarget = Files.readSymbolicLink(file);
                    File symTargetFile = symTarget.toFile();
                    if (!symTargetFile.isAbsolute()) {
                        if (file.getParent() != null) {
                            symTarget = file.getParent().resolve(symTarget);
                        } else {
                            throw new IOException("Recursive symbolic link: " + file.toFile().getAbsolutePath() + "=>" + symTargetFile.getCanonicalPath() + ". Can't copy directory");
                        }
                    }
                    if (symTarget.toFile().getCanonicalFile().isDirectory()) {
                        if (file.getParent().toFile().getCanonicalPath().startsWith(symTarget.toFile().getCanonicalPath())) {
                            throw new IOException("Recursive symbolic link: " + file.toFile().getAbsolutePath() + "=>" + symTarget.toFile().getCanonicalPath() + ". Can't copy directory");
                        }
                        ASModuleHandler.copyDirectory(symTarget.toFile(), targetPath.resolve(sourcePath.relativize(file)).toFile());
                        return FileVisitResult.CONTINUE;
                    }
                }
                Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copy(File source, File target) throws CommandLineException {
        byte[] buff = new byte[8192];
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(target));
            while ((read = in.read(buff)) != -1) {
                ((BufferedOutputStream)out).write(buff, 0, read);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (FileNotFoundException e) {
            throw new CommandLineException("Failed to locate the file on the filesystem copying " + source.getAbsolutePath() + " to " + target.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to copy " + source.getAbsolutePath() + " to " + target.getAbsolutePath(), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class AddModuleListArgument
    extends ArgumentWithListValue {
        private AddModuleListArgument(String fullname) {
            super(ASModuleHandler.this, fullname);
        }

        private AddModuleListArgument(String fullname, CommandLineCompleter completer) {
            super((CommandHandlerWithArguments)ASModuleHandler.this, completer, fullname);
        }

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            String actionValue = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
            return ASModuleHandler.ACTION_ADD.equals(actionValue) && ASModuleHandler.this.name.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
        }
    }

    private class AddModuleArgument
    extends ArgumentWithValue {
        private AddModuleArgument(String fullName) {
            super(ASModuleHandler.this, fullName);
        }

        private AddModuleArgument(String fullName, CommandLineCompleter completer) {
            super((CommandHandlerWithArguments)ASModuleHandler.this, completer, fullName);
        }

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            String actionValue = ASModuleHandler.this.action.getValue(ctx.getParsedCommandLine());
            return ASModuleHandler.ACTION_ADD.equals(actionValue) && ASModuleHandler.this.name.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
        }
    }
}

