/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.protocol.ProtocolTimeoutHandler;

public interface ModelControllerClientFactory {
    public static final String SASL_DISALLOWED_MECHANISMS = "SASL_DISALLOWED_MECHANISMS";
    public static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    public static final Map<String, String> DISABLED_LOCAL_AUTH = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
    public static final Map<String, String> ENABLED_LOCAL_AUTH = Collections.emptyMap();
    public static final ModelControllerClientFactory DEFAULT = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(ControllerAddress address, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, boolean fallbackSslContext, int connectionTimeout, ConnectionCloseHandler closeHandler, ProtocolTimeoutHandler timeoutHandler, String clientBindAddress) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            ModelControllerClientConfiguration config = new ModelControllerClientConfiguration.Builder().setProtocol(address.getProtocol()).setHostName(address.getHost()).setPort(address.getPort()).setHandler(handler).setSslContext(sslContext).setConnectionTimeout(connectionTimeout).setSaslOptions(saslOptions).setClientBindAddress(clientBindAddress).build();
            return ModelControllerClient.Factory.create((ModelControllerClientConfiguration)config);
        }
    };
    public static final ModelControllerClientFactory CUSTOM = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(ControllerAddress address, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, boolean fallbackSslContext, int connectionTimeout, ConnectionCloseHandler closeHandler, ProtocolTimeoutHandler timeoutHandler, String clientBindAddress) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return new CLIModelControllerClient(address, handler, connectionTimeout, closeHandler, saslOptions, sslContext, fallbackSslContext, timeoutHandler, clientBindAddress);
        }
    };

    public ModelControllerClient getClient(ControllerAddress var1, CallbackHandler var2, boolean var3, SSLContext var4, boolean var5, int var6, ConnectionCloseHandler var7, ProtocolTimeoutHandler var8, String var9) throws IOException;

    public static interface ConnectionCloseHandler {
        public void handleClose();
    }
}

