/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.DeploymentHandler;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.spi.MountHandle;

public class DeployHandler
extends DeploymentHandler {
    private final ArgumentWithoutValue force;
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithoutValue url;
    private final ArgumentWithoutValue name;
    private final ArgumentWithoutValue rtName;
    private final ArgumentWithListValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue disabled;
    private final ArgumentWithoutValue unmanaged;
    private final ArgumentWithValue script;
    private AccessRequirement listPermission;
    private AccessRequirement fullReplacePermission;
    private AccessRequirement mainAddPermission;
    private AccessRequirement deployPermission;
    private PerNodeOperationAccess serverGroupAddPermission;

    public DeployHandler(CommandContext ctx) {
        super(ctx, "deploy", true);
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        requiredAddress.toNodeType("deployment");
        this.addRequiredPath(requiredAddress);
        this.l = new ArgumentWithoutValue(this, "-l");
        this.l.setExclusive(true);
        this.l.setAccessRequirement(this.listPermission);
        AccessRequirement addOrReplacePermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainAddPermission).requirement(this.fullReplacePermission).build();
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, 0, "--path");
        this.path.addCantAppearAfter(this.l);
        this.path.setAccessRequirement(addOrReplacePermission);
        this.url = new ArgumentWithValue(this, "--url");
        this.url.addCantAppearAfter(this.path);
        this.path.addCantAppearAfter(this.url);
        this.url.setAccessRequirement(addOrReplacePermission);
        this.force = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--force", "-f");
        this.force.addRequiredPreceding(this.path);
        this.force.setAccessRequirement(this.fullReplacePermission);
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                try {
                    if (DeployHandler.this.path.isPresent(args) || DeployHandler.this.url.isPresent(args)) {
                        return -1;
                    }
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, "--name");
        this.name.addCantAppearAfter(this.l);
        this.path.addCantAppearAfter(this.name);
        this.url.addCantAppearAfter(this.name);
        this.name.setAccessRequirement(this.deployPermission);
        this.rtName = new ArgumentWithValue(this, "--runtime-name");
        this.rtName.addRequiredPreceding(this.path);
        this.rtName.setAccessRequirement(addOrReplacePermission);
        this.allServerGroups = new ArgumentWithoutValue(this, "--all-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.allServerGroups.addRequiredPreceding(this.path);
        this.allServerGroups.addRequiredPreceding(this.name);
        this.allServerGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.setAccessRequirement(this.deployPermission);
        this.serverGroups = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return DeployHandler.this.serverGroupAddPermission.getAllowedOn(ctx);
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.path);
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.serverGroups);
        this.serverGroups.setAccessRequirement(this.deployPermission);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.disabled = new ArgumentWithoutValue(this, "--disabled");
        this.disabled.addRequiredPreceding(this.path);
        this.disabled.addCantAppearAfter(this.serverGroups);
        this.disabled.addCantAppearAfter(this.allServerGroups);
        if (ctx.isDomainMode()) {
            this.disabled.addCantAppearAfter(this.force);
            this.force.addCantAppearAfter(this.disabled);
        }
        this.disabled.setAccessRequirement(this.mainAddPermission);
        this.unmanaged = new ArgumentWithoutValue(this, "--unmanaged");
        this.unmanaged.addRequiredPreceding(this.path);
        this.unmanaged.setAccessRequirement(this.mainAddPermission);
        this.script = new ArgumentWithValue(this, "--script");
        this.script.addRequiredPreceding(this.path);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.listPermission = AccessRequirementBuilder.Factory.create(ctx).all().operation("read-children-names").operation("deployment=?", "read-resource").build();
        this.fullReplacePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("full-replace-deployment").build();
        this.mainAddPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "add").build();
        this.serverGroupAddPermission = new PerNodeOperationAccess(ctx, "server-group", "deployment=?", "add");
        this.deployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "deploy").all().requirement(this.serverGroupAddPermission).serverGroupOperation("deployment=?", "deploy").parent().build();
        return AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.listPermission).requirement(this.fullReplacePermission).requirement(this.mainAddPermission).requirement(this.deployPermission).build();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode steps;
        ModelNode deployRequest;
        URL deploymentUrl;
        String urlString;
        File f;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            this.listDeployments(ctx, l);
            return;
        }
        boolean unmanaged = this.unmanaged.isPresent(args);
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (!unmanaged && f.isDirectory()) {
                throw new CommandFormatException(f.getAbsolutePath() + " is a directory.");
            }
        } else {
            f = null;
        }
        if ((urlString = this.url.getValue(args)) != null) {
            if (f != null) {
                throw new CommandFormatException("Either one of the filesystem path or --url argument can be specified at a time.");
            }
            try {
                deploymentUrl = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new CommandFormatException("Failed to parse URL", e);
            }
        } else {
            deploymentUrl = null;
        }
        if (this.isCliArchive(f)) {
            ModelNode request = this.buildRequestWOValidation(ctx);
            if (request == null) {
                throw new CommandFormatException("Operation request wasn't built.");
            }
            if (!request.get("steps").isDefined()) {
                return;
            }
            try {
                ModelNode result = client.execute(request);
                if (Util.isSuccess(result)) {
                    return;
                }
                throw new CommandFormatException("Failed to execute archive script: " + Util.getFailureDescription(result));
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to execute archive script: " + e.getLocalizedMessage(), e);
            }
        }
        String name = this.name.getValue(args);
        if (name == null) {
            if (f == null) {
                if (deploymentUrl == null) {
                    throw new CommandFormatException("Filesystem path, --url or --name is required.");
                }
                name = deploymentUrl.getPath();
                if (name.charAt(name.length() - 1) == '/') {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.lastIndexOf(47) > -1) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
            } else {
                name = f.getName();
            }
        }
        String runtimeName = this.rtName.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        if (force) {
            if (disabled && ctx.isDomainMode() || serverGroups != null || allServerGroups) {
                throw new CommandFormatException(this.force.getFullName() + " only replaces the content in the deployment repository and can't be used in combination with any of " + this.disabled.getFullName() + ", " + this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + '.');
            }
            if (Util.isDeploymentInRepository(name, client)) {
                this.replaceDeployment(ctx, f, deploymentUrl, name, runtimeName, disabled);
                return;
            }
            if (ctx.isDomainMode()) {
                ModelNode request = this.buildAddRequest(ctx, f, deploymentUrl, name, runtimeName, unmanaged);
                this.execute(ctx, request, f, unmanaged);
                return;
            }
        }
        if (disabled) {
            if (serverGroups != null || allServerGroups) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't be used in combination with " + this.disabled.getFullName() + '.');
            }
            if (Util.isDeploymentInRepository(name, client)) {
                throw new CommandFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            ModelNode request = this.buildAddRequest(ctx, f, deploymentUrl, name, runtimeName, unmanaged);
            this.execute(ctx, request, f, unmanaged);
            return;
        }
        if (ctx.isDomainMode()) {
            List<String> sgList;
            if (allServerGroups) {
                if (serverGroups != null) {
                    throw new CommandFormatException(this.serverGroups.getFullName() + " can't appear in the same command with " + this.allServerGroups.getFullName());
                }
                sgList = Util.getServerGroups(client);
                if (sgList.isEmpty()) {
                    throw new CommandFormatException("No server group is available.");
                }
            } else {
                if (serverGroups == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("One of ");
                    if (f != null || deploymentUrl != null) {
                        buf.append(this.disabled.getFullName()).append(", ");
                    }
                    buf.append(this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " is missing.");
                    throw new CommandFormatException(buf.toString());
                }
                sgList = Arrays.asList(serverGroups.split(","));
                if (sgList.isEmpty()) {
                    throw new CommandFormatException("Couldn't locate server group name in '" + this.serverGroups.getFullName() + "=" + serverGroups + "'.");
                }
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (serverGroups != null || allServerGroups) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't appear in standalone mode.");
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("deploy");
            deployRequest.get(new String[]{"address", "deployment"}).set(name);
        }
        if (f != null || deploymentUrl != null) {
            if (Util.isDeploymentInRepository(name, client)) {
                throw new CommandFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            ModelNode request = new ModelNode();
            request.get("operation").set("composite");
            request.get("address").setEmptyList();
            steps = request.get("steps");
            steps.add(this.buildAddRequest(ctx, f, deploymentUrl, name, runtimeName, unmanaged));
            steps.add(deployRequest);
            this.execute(ctx, request, f, unmanaged);
            return;
        }
        if (!Util.isDeploymentInRepository(name, client)) {
            throw new CommandFormatException("'" + name + "' is not found among the registered deployments.");
        }
        try {
            ModelNode result = client.execute(deployRequest);
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to deploy", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode addRequest;
        ModelNode deployRequest;
        String name;
        File f;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            throw new OperationFormatException("Command is missing arguments for non-interactive mode: '" + args.getOriginalLine() + "'.");
        }
        boolean unmanaged = this.unmanaged.isPresent(args);
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                throw new OperationFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (!unmanaged && f.isDirectory()) {
                throw new OperationFormatException(f.getAbsolutePath() + " is a directory.");
            }
        } else {
            f = null;
        }
        if ((name = this.name.getValue(args)) == null) {
            if (f == null) {
                throw new OperationFormatException("Either path or --name is required.");
            }
            name = f.getName();
        }
        String runtimeName = this.rtName.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        boolean archive = this.isCliArchive(f);
        if (force) {
            if (f == null) {
                throw new OperationFormatException(this.force.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
            }
            if (disabled && ctx.isDomainMode() || serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.force.getFullName() + " only replaces the content in the deployment repository and can't be used in combination with any of " + this.disabled.getFullName() + ", " + this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + '.');
            }
            if (archive) {
                throw new OperationFormatException(this.force.getFullName() + " can't be used in combination with a CLI archive.");
            }
            if (Util.isDeploymentInRepository(name, client)) {
                return this.buildDeploymentReplace(f, name, runtimeName, disabled);
            }
            return this.buildDeploymentAdd(f, name, runtimeName, unmanaged, ctx.isDomainMode() ? null : Boolean.valueOf(disabled));
        }
        if (disabled) {
            if (f == null) {
                throw new OperationFormatException(this.disabled.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
            }
            if (serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't be used in combination with " + this.disabled.getFullName() + '.');
            }
            if (archive) {
                throw new OperationFormatException(this.disabled.getFullName() + " can't be used in combination with a CLI archive.");
            }
            if (!ctx.isBatchMode() && Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            return this.buildDeploymentAdd(f, name, runtimeName, unmanaged, ctx.isDomainMode() ? null : Boolean.TRUE);
        }
        if (archive) {
            ModelNode modelNode;
            MountHandle root;
            TempFileProvider tempFileProvider;
            if (serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't be used in combination with a CLI archive.");
            }
            try {
                tempFileProvider = TempFileProvider.create((String)"cli", (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(), (boolean)true);
                root = this.extractArchive(f, tempFileProvider);
            }
            catch (IOException e) {
                throw new OperationFormatException("Unable to extract archive '" + f.getAbsolutePath() + "' to temporary location");
            }
            File currentDir = ctx.getCurrentDir();
            ctx.setCurrentDir(root.getMountSource());
            String holdbackBatch = this.activateNewBatch(ctx);
            try {
                File scriptFile;
                String script = this.script.getValue(args);
                if (script == null) {
                    script = "deploy.scr";
                }
                if (!(scriptFile = new File(ctx.getCurrentDir(), script)).exists()) {
                    throw new CommandFormatException("ERROR: script '" + script + "' not found.");
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(scriptFile));
                    String line = reader.readLine();
                    while (!ctx.isTerminated() && line != null) {
                        ctx.handle(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new CommandFormatException("ERROR: script '" + script + "' not found.");
                }
                catch (IOException e) {
                    throw new CommandFormatException("Failed to read the next command from " + scriptFile.getName() + ": " + e.getMessage(), e);
                }
                catch (CommandLineException e) {
                    throw new CommandFormatException(e.getMessage(), e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                modelNode = ctx.getBatchManager().getActiveBatch().toRequest();
                ctx.setCurrentDir(currentDir);
            }
            catch (Throwable throwable) {
                ctx.setCurrentDir(currentDir);
                this.discardBatch(ctx, holdbackBatch);
                VFSUtils.safeClose((Closeable[])new Closeable[]{root, tempFileProvider});
                throw throwable;
            }
            this.discardBatch(ctx, holdbackBatch);
            VFSUtils.safeClose((Closeable[])new Closeable[]{root, tempFileProvider});
            return modelNode;
        }
        if (ctx.isDomainMode()) {
            List<String> sgList;
            if (allServerGroups) {
                if (serverGroups != null) {
                    throw new OperationFormatException(this.serverGroups.getFullName() + " can't appear in the same command with " + this.allServerGroups.getFullName());
                }
                sgList = Util.getServerGroups(client);
                if (sgList.isEmpty()) {
                    throw new OperationFormatException("No server group is available.");
                }
            } else {
                if (serverGroups == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("One of ");
                    if (f != null) {
                        buf.append(this.disabled.getFullName()).append(", ");
                    }
                    buf.append(this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " is missing.");
                    throw new OperationFormatException(buf.toString());
                }
                sgList = Arrays.asList(serverGroups.split(","));
                if (sgList.isEmpty()) {
                    throw new OperationFormatException("Couldn't locate server group name in '" + this.serverGroups.getFullName() + "=" + serverGroups + "'.");
                }
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            ModelNode steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't appear in standalone mode.");
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("deploy");
            deployRequest.get(new String[]{"address", "deployment"}).set(name);
        }
        if (f != null) {
            if (!ctx.isBatchMode() && Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            addRequest = this.buildDeploymentAdd(f, name, runtimeName, unmanaged, ctx.isDomainMode() ? null : Boolean.FALSE);
        } else {
            if (!ctx.isBatchMode() && !Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' is not found among the registered deployments.");
            }
            addRequest = null;
        }
        if (addRequest != null) {
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            steps.add(addRequest);
            steps.add(deployRequest);
            return composite;
        }
        return deployRequest;
    }

    protected ModelNode buildDeploymentReplace(File f, String name, String runtimeName, boolean disabled) throws OperationFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("full-replace-deployment");
        request.get("address").setEmptyList();
        request.get("name").set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        request.get("enabled").set(!disabled);
        byte[] bytes = Util.readBytes(f);
        request.get("content").get(0).get("bytes").set(bytes);
        return request;
    }

    protected ModelNode buildDeploymentAdd(File f, String name, String runtimeName, boolean unmanaged, Boolean disabled) throws OperationFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get(new String[]{"address", "deployment"}).set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        if (unmanaged) {
            ModelNode content = request.get("content").get(0);
            content.get("path").set(f.getAbsolutePath());
            content.get("archive").set(f.isFile());
        } else {
            byte[] bytes = Util.readBytes(f);
            request.get("content").get(0).get("bytes").set(bytes);
        }
        if (disabled != null) {
            request.get("enabled").set(disabled == false);
        }
        return request;
    }

    protected void execute(CommandContext ctx, ModelNode request, File f, boolean unmanaged) throws CommandFormatException {
        ModelNode result;
        this.addHeaders(ctx, request);
        try {
            if (!unmanaged && f != null) {
                OperationBuilder op = new OperationBuilder(request);
                op.addFileAsAttachment(f);
                request.get("content").get(0).get("input-stream-index").set(0);
                Operation operation = op.build();
                result = ctx.getModelControllerClient().execute(operation);
                operation.close();
            } else {
                result = ctx.getModelControllerClient().execute(request);
            }
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to add the deployment content to the repository: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess(result)) {
            throw new CommandFormatException(Util.getFailureDescription(result));
        }
    }

    protected ModelNode buildAddRequest(CommandContext ctx, File f, URL url, String name, String runtimeName, boolean unmanaged) throws CommandFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get(new String[]{"address", "deployment"}).set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        ModelNode content = request.get("content").get(0);
        if (f == null) {
            if (url == null) {
                this.addRequiresDeployment();
            }
            content.get("url").set(url.toExternalForm());
        } else if (unmanaged) {
            content.get("path").set(f.getAbsolutePath());
            content.get("archive").set(f.isFile());
        } else {
            content.get("input-stream-index").set(0);
        }
        return request;
    }

    protected void replaceDeployment(CommandContext ctx, File f, URL url, String name, String runtimeName, boolean disabled) throws CommandFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("full-replace-deployment");
        request.get("name").set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        request.get("enabled").set(!disabled);
        ModelNode content = request.get("content").get(0);
        if (f == null) {
            if (url == null) {
                this.forceRequiresDeployment();
            }
            content.get("url").set(url.toExternalForm());
        } else {
            content.get("input-stream-index").set(0);
        }
        this.execute(ctx, request, f, false);
    }

    protected void addRequiresDeployment() throws CommandFormatException {
        throw new CommandFormatException("Filesystem path or --url pointing to the deployment is required.");
    }

    protected void forceRequiresDeployment() throws CommandFormatException {
        this.argumentRequiresDeployment(this.force);
    }

    protected void argumentRequiresDeployment(ArgumentWithoutValue arg) throws CommandFormatException {
        throw new CommandFormatException(arg.getFullName() + " requires a filesystem path or --url pointing to the deployment to be added to the repository.");
    }
}

