/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.ConnectionInfo;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.NodePathFormatter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class CommandExecutor {
    private final CommandContext ctx;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Future<?> handlerTask;

    public CommandExecutor(CommandContext ctx) {
        this.ctx = ctx;
    }

    ModelNode execute(Operation op, int timeout, TimeUnit unit) throws CommandLineException, InterruptedException, ExecutionException, TimeoutException, IOException {
        ModelControllerClient client = this.ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandLineException("CLI not connected");
        }
        if (timeout <= 0) {
            return client.execute(op);
        }
        AsyncFuture task = client.executeAsync(op, OperationMessageHandler.DISCARD);
        try {
            return (ModelNode)task.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            CommandExecutor.cancelTask(task);
            throw ex;
        }
    }

    public void execute(CommandHandler handler, int timeout, TimeUnit unit) throws CommandLineException, InterruptedException, ExecutionException, TimeoutException {
        if (timeout <= 0) {
            handler.handle(this.ctx);
        } else {
            TimeoutCommandContext context = new TimeoutCommandContext(this.ctx);
            Future<Void> task = this.executorService.submit(() -> {
                handler.handle(context);
                return null;
            });
            try {
                task.get(timeout, unit);
            }
            catch (TimeoutException ex) {
                context.timeout();
                task.cancel(true);
                throw ex;
            }
        }
    }

    private static void cancelTask(Future<?> task) {
        if (!(task == null || task.isDone() && task.isCancelled())) {
            try {
                task.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void cancel() {
        this.executorService.shutdownNow();
    }

    public Future<?> getLastTask() {
        return this.handlerTask;
    }

    public class TimeoutCommandContext
    implements CommandContext {
        private final CommandContext wrapped;
        private final ModelControllerClient client;
        private Future<?> handlerTask;
        private boolean timeout;

        TimeoutCommandContext(CommandContext wrapped) {
            this.wrapped = wrapped;
            this.client = wrapped.getModelControllerClient() == null ? null : new TimeoutModelControllerClient(wrapped.getModelControllerClient());
        }

        synchronized void timeout() {
            this.timeout = true;
            CommandExecutor.cancelTask(this.handlerTask);
        }

        public synchronized void setLastHandlerTask(Future<?> handlerTask) {
            if (this.timeout) {
                CommandExecutor.cancelTask(handlerTask);
            } else {
                this.handlerTask = handlerTask;
            }
        }

        public Future<?> getLastTask() {
            return this.handlerTask;
        }

        @Override
        public CliConfig getConfig() {
            return this.wrapped.getConfig();
        }

        @Override
        public String getArgumentsString() {
            return this.wrapped.getArgumentsString();
        }

        @Override
        public ParsedCommandLine getParsedCommandLine() {
            return this.wrapped.getParsedCommandLine();
        }

        @Override
        public void printLine(String message) {
            this.wrapped.printLine(message);
        }

        @Override
        public void printColumns(Collection<String> col) {
            this.wrapped.printColumns(col);
        }

        @Override
        public void clearScreen() {
            this.wrapped.clearScreen();
        }

        @Override
        public void terminateSession() {
            this.wrapped.terminateSession();
        }

        @Override
        public boolean isTerminated() {
            return this.wrapped.isTerminated();
        }

        @Override
        public void set(CommandContext.Scope scope, String key, Object value) {
            this.wrapped.set(scope, key, value);
        }

        @Override
        public Object get(CommandContext.Scope scope, String key) {
            return this.wrapped.get(scope, key);
        }

        @Override
        public void clear(CommandContext.Scope scope) {
            this.wrapped.clear(scope);
        }

        @Override
        public Object remove(CommandContext.Scope scope, String key) {
            return this.wrapped.remove(scope, key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public void connectController() throws CommandLineException {
            this.wrapped.connectController();
        }

        @Override
        public void connectController(String controller) throws CommandLineException {
            this.wrapped.connectController(controller);
        }

        @Override
        public void connectController(String host, int port) throws CommandLineException {
            this.wrapped.connectController(host, port);
        }

        @Override
        public void bindClient(ModelControllerClient newClient) {
            this.wrapped.bindClient(newClient);
        }

        @Override
        public void disconnectController() {
            this.wrapped.disconnectController();
        }

        @Override
        public String getDefaultControllerHost() {
            return this.wrapped.getDefaultControllerHost();
        }

        @Override
        public int getDefaultControllerPort() {
            return this.wrapped.getDefaultControllerPort();
        }

        @Override
        public ControllerAddress getDefaultControllerAddress() {
            return this.wrapped.getDefaultControllerAddress();
        }

        @Override
        public String getControllerHost() {
            return this.wrapped.getControllerHost();
        }

        @Override
        public int getControllerPort() {
            return this.wrapped.getControllerPort();
        }

        @Override
        public CommandLineParser getCommandLineParser() {
            return this.wrapped.getCommandLineParser();
        }

        @Override
        public OperationRequestAddress getCurrentNodePath() {
            return this.wrapped.getCurrentNodePath();
        }

        @Override
        public NodePathFormatter getNodePathFormatter() {
            return this.wrapped.getNodePathFormatter();
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.wrapped.getOperationCandidatesProvider();
        }

        @Override
        public CommandHistory getHistory() {
            return this.wrapped.getHistory();
        }

        @Override
        public boolean isBatchMode() {
            return this.wrapped.isBatchMode();
        }

        @Override
        public boolean isWorkflowMode() {
            return this.wrapped.isWorkflowMode();
        }

        @Override
        public BatchManager getBatchManager() {
            return this.wrapped.getBatchManager();
        }

        @Override
        public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
            return this.wrapped.toBatchedCommand(line);
        }

        @Override
        public ModelNode buildRequest(String line) throws CommandFormatException {
            return this.wrapped.buildRequest(line);
        }

        @Override
        public CommandLineCompleter getDefaultCommandCompleter() {
            return this.wrapped.getDefaultCommandCompleter();
        }

        @Override
        public boolean isDomainMode() {
            return this.wrapped.isDomainMode();
        }

        @Override
        public void addEventListener(CliEventListener listener) {
            this.wrapped.addEventListener(listener);
        }

        @Override
        public int getExitCode() {
            return this.wrapped.getExitCode();
        }

        @Override
        public void handle(String line) throws CommandLineException {
            this.wrapped.handle(line);
        }

        @Override
        public void handleSafe(String line) {
            this.wrapped.handleSafe(line);
        }

        @Override
        public void interact() {
            this.wrapped.interact();
        }

        @Override
        public File getCurrentDir() {
            return this.wrapped.getCurrentDir();
        }

        @Override
        public void setCurrentDir(File dir) {
            this.wrapped.setCurrentDir(dir);
        }

        @Override
        public boolean isResolveParameterValues() {
            return this.wrapped.isResolveParameterValues();
        }

        @Override
        public void setResolveParameterValues(boolean resolve) {
            this.wrapped.setResolveParameterValues(resolve);
        }

        @Override
        public boolean isSilent() {
            return this.wrapped.isSilent();
        }

        @Override
        public void setSilent(boolean silent) {
            this.wrapped.setSilent(silent);
        }

        @Override
        public int getTerminalWidth() {
            return this.wrapped.getTerminalWidth();
        }

        @Override
        public int getTerminalHeight() {
            return this.wrapped.getTerminalHeight();
        }

        @Override
        public void setVariable(String name, String value) throws CommandLineException {
            this.wrapped.setVariable(name, value);
        }

        @Override
        public String getVariable(String name) {
            return this.wrapped.getVariable(name);
        }

        @Override
        public Collection<String> getVariables() {
            return this.wrapped.getVariables();
        }

        @Override
        public void registerRedirection(CommandLineRedirection redirection) throws CommandLineException {
            this.wrapped.registerRedirection(redirection);
        }

        @Override
        public ConnectionInfo getConnectionInfo() {
            return this.wrapped.getConnectionInfo();
        }

        @Override
        public void captureOutput(PrintStream captor) {
            this.wrapped.captureOutput(captor);
        }

        @Override
        public void releaseOutput() {
            this.wrapped.releaseOutput();
        }

        @Override
        public void setCommandTimeout(int numSeconds) {
            this.wrapped.setCommandTimeout(numSeconds);
        }

        @Override
        public int getCommandTimeout() {
            return this.wrapped.getCommandTimeout();
        }

        @Override
        public void resetTimeout(CommandContext.TIMEOUT_RESET_VALUE value) {
            this.wrapped.resetTimeout(value);
        }

        @Override
        public ModelNode execute(ModelNode mn, String description) throws CommandLineException, IOException {
            return this.wrapped.execute(mn, description);
        }

        @Override
        public ModelNode execute(Operation op, String description) throws CommandLineException, IOException {
            return this.wrapped.execute(op, description);
        }

        private class TimeoutModelControllerClient
        implements ModelControllerClient,
        AwaiterModelControllerClient {
            private final ModelControllerClient wrapped;

            TimeoutModelControllerClient(ModelControllerClient wrapped) {
                this.wrapped = wrapped;
            }

            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecute(operation, messageHandler);
            }

            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecute(operation, messageHandler);
            }

            public ModelNode execute(ModelNode operation) throws IOException {
                return this.doExecute(operation);
            }

            public ModelNode execute(Operation operation) throws IOException {
                return this.doExecute(operation);
            }

            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.doExecuteAsync(operation, messageHandler);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.doExecuteAsync(operation, messageHandler);
            }

            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return this.doExecuteOperation(operation, messageHandler);
            }

            public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.doExecuteOperationAsync(operation, messageHandler);
            }

            @Override
            public ModelNode execute(ModelNode operation, boolean awaitClose) throws IOException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new IOException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ModelNode response = this.execute(operation);
                if (!Util.isSuccess(response)) {
                    return response;
                }
                ((AwaiterModelControllerClient)this.wrapped).awaitClose(awaitClose);
                return response;
            }

            @Override
            public void awaitClose(boolean awaitClose) throws IOException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new IOException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ((AwaiterModelControllerClient)this.wrapped).awaitClose(awaitClose);
            }

            @Override
            public boolean isConnected() {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new RuntimeException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                return ((AwaiterModelControllerClient)this.wrapped).isConnected();
            }

            @Override
            public void ensureConnected(long timeoutMillis) throws CommandLineException {
                if (!(this.wrapped instanceof AwaiterModelControllerClient)) {
                    throw new CommandLineException("Unsupported ModelControllerClient implementation " + this.wrapped.getClass().getName());
                }
                ((AwaiterModelControllerClient)this.wrapped).ensureConnected(timeoutMillis);
            }

            private AsyncFuture<OperationResponse> doExecuteOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    AsyncFuture task = this.wrapped.executeOperationAsync(operation, messageHandler);
                    TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                    return task;
                }
                return this.wrapped.executeOperationAsync(operation, messageHandler);
            }

            private OperationResponse doExecuteOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    AsyncFuture task = this.wrapped.executeOperationAsync(operation, messageHandler);
                    TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                    try {
                        return (OperationResponse)task.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException(ex);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException(ex);
                    }
                }
                return this.wrapped.executeOperation(operation, messageHandler);
            }

            private AsyncFuture<ModelNode> doExecuteAsync(Operation operation, OperationMessageHandler messageHandler) {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    AsyncFuture task = this.wrapped.executeAsync(operation, messageHandler);
                    TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                    return task;
                }
                return this.wrapped.executeAsync(operation, messageHandler);
            }

            private AsyncFuture<ModelNode> doExecuteAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    AsyncFuture task = this.wrapped.executeAsync(operation, messageHandler);
                    TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                    return task;
                }
                return this.wrapped.executeAsync(operation, messageHandler);
            }

            private ModelNode doExecute(Operation operation) throws IOException {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    try {
                        AsyncFuture task = this.wrapped.executeAsync(operation, OperationMessageHandler.DISCARD);
                        TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                        return (ModelNode)task.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException(ex);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException(ex);
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                return this.wrapped.execute(operation);
            }

            private ModelNode doExecute(ModelNode operation) throws IOException {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    try {
                        AsyncFuture task = this.wrapped.executeAsync(operation, OperationMessageHandler.DISCARD);
                        TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                        return (ModelNode)task.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException(ex);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException(ex);
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                return this.wrapped.execute(operation);
            }

            private ModelNode doExecute(ModelNode operation, OperationMessageHandler handler) throws IOException {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    try {
                        AsyncFuture task = this.wrapped.executeAsync(operation, handler);
                        TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                        return (ModelNode)task.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException(ex);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException(ex);
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                return this.wrapped.execute(operation, handler);
            }

            private ModelNode doExecute(Operation operation, OperationMessageHandler handler) throws IOException {
                if (CommandExecutor.this.ctx.getCommandTimeout() > 0) {
                    try {
                        AsyncFuture task = this.wrapped.executeAsync(operation, handler);
                        TimeoutCommandContext.this.setLastHandlerTask((Future<?>)task);
                        return (ModelNode)task.get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException(ex);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException(ex);
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                return this.wrapped.execute(operation, handler);
            }

            public void close() throws IOException {
                this.wrapped.close();
            }
        }
    }
}

