/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.ParsedRolloutPlanHeader;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;

public class RolloutPlanCompleter
implements CommandLineCompleter {
    public static final RolloutPlanCompleter INSTANCE = new RolloutPlanCompleter();
    private static final DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
    private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        SingleRolloutPlanGroup lastGroup;
        block38: {
            boolean containsAll;
            block37: {
                String propName;
                block41: {
                    block40: {
                        block39: {
                            if (!ctx.isDomainMode()) {
                                return -1;
                            }
                            if (buffer.isEmpty()) {
                                candidates.add("{rollout");
                                return 0;
                            }
                            try {
                                this.parsedOp.parseOperation(null, buffer);
                            }
                            catch (CommandFormatException e) {
                                return -1;
                            }
                            if (this.parsedOp.isRequestComplete()) {
                                return -1;
                            }
                            if (this.parsedOp.endsOnHeaderListStart() || this.parsedOp.endsOnHeaderSeparator()) {
                                candidates.add("rollout");
                                return this.parsedOp.getLastSeparatorIndex() + 1;
                            }
                            if (this.parsedOp.getLastHeader() == null) {
                                if (!ctx.getParsedCommandLine().getOriginalLine().endsWith(" ")) return buffer.length();
                                String originalLine = ctx.getParsedCommandLine().getOriginalLine();
                                int bufferIndex = originalLine.lastIndexOf(buffer);
                                if (bufferIndex == -1) {
                                    return -1;
                                }
                                candidates.add("id=");
                                candidates.addAll(Util.getServerGroups(ctx.getModelControllerClient()));
                                return originalLine.length() - bufferIndex;
                            }
                            ParsedOperationRequestHeader lastHeader = this.parsedOp.getLastHeader();
                            if (!(lastHeader instanceof ParsedRolloutPlanHeader)) {
                                throw new IllegalStateException("Expected " + ParsedRolloutPlanHeader.class + " but got " + lastHeader.getName() + " of " + lastHeader);
                            }
                            ParsedRolloutPlanHeader rollout = (ParsedRolloutPlanHeader)lastHeader;
                            if (rollout.endsOnPlanIdValueSeparator()) {
                                candidates.addAll(Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan"));
                                return rollout.getLastSeparatorIndex() + 1;
                            }
                            String planRef = rollout.getPlanRef();
                            if (planRef != null) {
                                List<String> nodeNames = Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan");
                                Iterator<String> iterator = nodeNames.iterator();
                                while (iterator.hasNext()) {
                                    String name = iterator.next();
                                    if (!name.startsWith(planRef)) continue;
                                    candidates.add(name);
                                }
                                return rollout.getLastChunkIndex();
                            }
                            if (rollout.hasProperties()) {
                                String lastName = rollout.getLastPropertyName();
                                if (!"rollback-across-groups".startsWith(lastName)) return rollout.getLastChunkIndex();
                                candidates.add("rollback-across-groups");
                                return rollout.getLastChunkIndex();
                            }
                            if (rollout.endsOnGroupSeparator()) {
                                List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
                                Iterator<String> iterator = serverGroups.iterator();
                                while (iterator.hasNext()) {
                                    String group = iterator.next();
                                    if (rollout.containsGroup(group)) continue;
                                    candidates.add(group);
                                }
                                return buffer.length();
                            }
                            lastGroup = rollout.getLastGroup();
                            if (lastGroup == null) {
                                return -1;
                            }
                            if (lastGroup.endsOnPropertyListEnd()) {
                                candidates.add("^");
                                candidates.add(",");
                                if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                                    candidates.add("rollback-across-groups");
                                }
                                candidates.add(";");
                                candidates.add("}");
                                return buffer.length();
                            }
                            if (lastGroup.endsOnPropertyListStart()) {
                                candidates.add("max-failed-servers");
                                candidates.add("max-failure-percentage");
                                candidates.add("rolling-to-servers");
                                candidates.add("!");
                                return buffer.length();
                            }
                            if (lastGroup.endsOnNotOperator()) {
                                candidates.add("rolling-to-servers");
                                return buffer.length();
                            }
                            if (!lastGroup.hasProperties()) break block38;
                            containsAll = lastGroup.hasProperty("max-failed-servers") && lastGroup.hasProperty("max-failure-percentage") && lastGroup.hasProperty("rolling-to-servers");
                            String propValue = lastGroup.getLastPropertyValue();
                            if (propValue == null) break block39;
                            if ("true".startsWith(propValue)) {
                                candidates.add("true");
                                break block37;
                            } else if ("false".startsWith(propValue)) {
                                candidates.add("false");
                                break block37;
                            } else {
                                candidates.add(containsAll ? ")" : ",");
                                return buffer.length();
                            }
                        }
                        if (lastGroup.endsOnPropertyValueSeparator()) {
                            if (!"rolling-to-servers".equals(lastGroup.getLastPropertyName())) return buffer.length();
                            candidates.add("false");
                            candidates.add(containsAll ? ")" : ",");
                            return buffer.length();
                        }
                        if (lastGroup.endsOnPropertySeparator()) {
                            if (!lastGroup.hasProperty("max-failed-servers")) {
                                candidates.add("max-failed-servers");
                            }
                            if (!lastGroup.hasProperty("max-failure-percentage")) {
                                candidates.add("max-failure-percentage");
                            }
                            if (lastGroup.hasProperty("rolling-to-servers")) return lastGroup.getLastSeparatorIndex() + 1;
                            candidates.add("rolling-to-servers");
                            candidates.add("!");
                            return lastGroup.getLastSeparatorIndex() + 1;
                        }
                        propName = lastGroup.getLastPropertyName();
                        if ("max-failed-servers".startsWith(propName)) {
                            candidates.add("max-failed-servers=");
                        }
                        if (!"max-failure-percentage".startsWith(propName)) break block40;
                        candidates.add("max-failure-percentage=");
                        break block37;
                    }
                    if (!"rolling-to-servers".equals(propName)) break block41;
                    if (lastGroup.isLastPropertyNegated() && !containsAll) {
                        candidates.add("rolling-to-servers,");
                        break block37;
                    } else {
                        candidates.add("=false");
                        if (!containsAll) {
                            candidates.add(",");
                            break block37;
                        } else {
                            candidates.add(")");
                        }
                    }
                    break block37;
                }
                if ("rolling-to-servers".startsWith(propName)) {
                    candidates.add("rolling-to-servers");
                }
            }
            if (!candidates.isEmpty()) return lastGroup.getLastChunkIndex();
            if (!containsAll) return lastGroup.getLastChunkIndex();
            candidates.add(")");
            return lastGroup.getLastChunkIndex();
        }
        if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            candidates.add("(");
            candidates.add("^");
            candidates.add(",");
            candidates.add("rollback-across-groups");
            candidates.add(";");
            candidates.add("}");
            return buffer.length();
        }
        int result = lastGroup.getLastChunkIndex();
        String groupName = lastGroup.getGroupName();
        List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
        for (String group : serverGroups) {
            if (!group.startsWith(groupName)) continue;
            candidates.add(group);
        }
        if ("id".startsWith(groupName)) {
            candidates.add("id=");
            return result;
        }
        if (candidates.size() != 1) return result;
        String group = candidates.get(0);
        candidates.set(0, group + '(');
        candidates.add(group + ',');
        candidates.add(group + '^');
        candidates.add(group + ';');
        candidates.add(group + '}');
        return result;
    }

    static {
        address.toNode("management-client-content", "rollout-plans");
    }
}

