/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class VersionHandler
implements CommandHandler {
    public static final VersionHandler INSTANCE = new VersionHandler();

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return true;
    }

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return false;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandFormatException {
        StringBuilder buf = new StringBuilder();
        buf.append("JBoss Admin Command-line Interface\n");
        buf.append("JBOSS_HOME: ").append(WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null)).append('\n');
        buf.append("JBoss AS release: ");
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            buf.append("<connect to the controller and re-run the version command to see the release info>\n");
        } else {
            ModelNode req = new ModelNode();
            req.get("operation").set("read-resource");
            req.get("address").setEmptyList();
            try {
                ModelNode response = client.execute(req);
                if (Util.isSuccess(response)) {
                    if (response.hasDefined("result")) {
                        String codename;
                        ModelNode result = response.get("result");
                        int flag = 0;
                        if (result.hasDefined("release-version")) {
                            buf.append(result.get("release-version").asString());
                            flag = (byte)(flag + 1);
                        }
                        if (result.hasDefined("release-codename") && (codename = result.get("release-codename").asString()).length() > 0) {
                            buf.append(" \"").append(codename).append('\"');
                            flag = (byte)(flag + 1);
                        }
                        if (flag == 0) {
                            buf.append("release info was not provided by the controller");
                        }
                        if (result.hasDefined("product-name")) {
                            buf.append("\nJBoss AS product: ").append(result.get("product-name").asString());
                            if (result.hasDefined("product-version")) {
                                buf.append(' ').append(result.get("product-version").asString());
                            }
                        }
                    } else {
                        buf.append("result was not available.");
                    }
                } else {
                    buf.append(Util.getFailureDescription(response));
                }
                buf.append('\n');
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to get the AS release info: " + e.getLocalizedMessage());
            }
        }
        buf.append("JAVA_HOME: ").append(WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAVA_HOME", null)).append('\n');
        buf.append("java.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.version", null)).append('\n');
        buf.append("java.vm.vendor: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.vm.vendor", null)).append('\n');
        buf.append("java.vm.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.vm.version", null)).append('\n');
        buf.append("os.name: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"os.name", null)).append('\n');
        buf.append("os.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"os.version", null));
        ctx.printLine(buf.toString());
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        return null;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return false;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return false;
    }

    public List<CommandArgument> getArguments(CommandContext ctx) {
        return Collections.emptyList();
    }
}

