/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.Configuration;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.AddShutdownHookAction;

class SecurityActions {
    SecurityActions() {
    }

    static void addShutdownHook(Thread hook) {
        if (!WildFlySecurityManager.isChecking()) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(new AddShutdownHookAction(hook));
        }
    }

    static Configuration getGlobalJaasConfiguration() throws SecurityException {
        if (!WildFlySecurityManager.isChecking()) {
            return SecurityActions.internalGetGlobalJaasConfiguration();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Configuration>(){

                @Override
                public Configuration run() throws Exception {
                    return SecurityActions.internalGetGlobalJaasConfiguration();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SecurityException)e.getCause();
        }
    }

    private static Configuration internalGetGlobalJaasConfiguration() throws SecurityException {
        return Configuration.getConfiguration();
    }

    static void setGlobalJaasConfiguration(final Configuration configuration) throws SecurityException {
        if (!WildFlySecurityManager.isChecking()) {
            SecurityActions.internalSetGlobalJaasConfiguration(configuration);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SecurityActions.internalSetGlobalJaasConfiguration(configuration);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SecurityException)e.getCause();
            }
        }
    }

    private static void internalSetGlobalJaasConfiguration(Configuration configuration) throws SecurityException {
        Configuration.setConfiguration(configuration);
    }
}

