/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ProcessedOption;
import org.jboss.as.cli.impl.aesh.HelpSupport;
import org.wildfly.core.cli.command.aesh.activator.DependOneOfOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DependOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DomainOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.RejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.StandaloneOptionActivator;

class SynopsisGenerator {
    private final List<ProcessedOption> opts;
    private final ProcessedOption arg;
    private final boolean domain;
    private Set<SynopsisOption> synopsisOptions;
    private final ResourceBundle bundle;
    private final String parentName;
    private final String commandName;
    private final boolean hasActions;
    private final List<String> superNames;
    private final boolean isOperation;
    private static final boolean duplicateOneOfDependencies = Boolean.getBoolean("jboss.as.cli.impl.help.synopsis.duplicateOneOfDependencies");

    SynopsisGenerator(ResourceBundle bundle, String parentName, String commandName, List<ProcessedOption> opts, ProcessedOption arg, boolean hasActions, List<String> superNames, boolean isOperation, boolean domain) {
        this.bundle = bundle;
        this.parentName = parentName;
        this.commandName = commandName;
        this.opts = opts;
        this.arg = arg;
        this.hasActions = hasActions;
        this.superNames = superNames;
        this.isOperation = isOperation;
        this.domain = domain;
    }

    String generateSynopsis() {
        SynopsisOption opt;
        boolean hasOptions;
        this.synopsisOptions = SynopsisGenerator.buildSynopsisOptions(this.opts, this.arg, this.domain);
        StringBuilder synopsisBuilder = new StringBuilder();
        if (this.parentName != null) {
            synopsisBuilder.append(this.parentName).append(" ");
        }
        synopsisBuilder.append(this.commandName);
        if (this.isOperation && !this.opts.isEmpty()) {
            synopsisBuilder.append("(");
        } else {
            synopsisBuilder.append(" ");
        }
        boolean bl = hasOptions = this.arg != null || !this.opts.isEmpty();
        if (this.hasActions && hasOptions) {
            synopsisBuilder.append(" [");
        }
        if (this.hasActions) {
            synopsisBuilder.append(" <action>");
        }
        if (this.hasActions && hasOptions) {
            synopsisBuilder.append(" ] || [");
        }
        while ((opt = SynopsisGenerator.retrieveNextOption(this.synopsisOptions, false)) != null) {
            String content = this.addSynopsisOption(opt);
            if (content == null) continue;
            synopsisBuilder.append(content.trim());
            if (this.isOperation) {
                if (!this.synopsisOptions.isEmpty()) {
                    synopsisBuilder.append(",");
                } else {
                    synopsisBuilder.append(")");
                }
            }
            synopsisBuilder.append(" ");
        }
        if (this.hasActions && hasOptions) {
            synopsisBuilder.append(" ]");
        }
        return synopsisBuilder.toString();
    }

    private String addSynopsisOption(SynopsisOption currentOption) {
        if (!this.synopsisOptions.contains(currentOption)) {
            return null;
        }
        StringBuilder synopsisBuilder = new StringBuilder();
        this.synopsisOptions.remove(currentOption);
        if (!currentOption.dependsOn.isEmpty()) {
            throw new RuntimeException("Option has still some dependencies");
        }
        if (!currentOption.conflictWith.isEmpty()) {
            Object next;
            SynopsisOption nextOption;
            Set<SynopsisOption> commonDependencies = SynopsisGenerator.retrieveCommonDependenciesFromConflicts(currentOption);
            Set<SynopsisOption> allDependedBy = SynopsisGenerator.retrieveAllDependedBy(currentOption);
            Set<SynopsisOption> allConflicts = SynopsisGenerator.retrieveAllDependenciesOfConflicts(currentOption.conflictWith);
            Set<SynopsisOption> allOneOfDependedBy = SynopsisGenerator.retrieveAllOneOfDependedBy(currentOption);
            allConflicts.addAll(currentOption.conflictWith);
            while ((nextOption = SynopsisGenerator.retrieveNextOption(commonDependencies, false)) != null) {
                commonDependencies.remove(nextOption);
                next = this.addSynopsisOption(nextOption);
                if (next == null) continue;
                synopsisBuilder.append(" ").append(((String)next).trim());
            }
            synopsisBuilder.append(" ( ");
            this.addSynopsisOptionNameValue(synopsisBuilder, currentOption);
            for (SynopsisOption option : currentOption.dependedBy) {
                option.dependsOn.remove(currentOption);
            }
            while ((nextOption = SynopsisGenerator.retrieveNextOption(currentOption.dependedBy, false)) != null) {
                currentOption.dependedBy.remove(nextOption);
                for (SynopsisOption conflict : allConflicts) {
                    nextOption.conflictWith.remove(conflict);
                    conflict.conflictWith.remove(nextOption);
                }
                next = this.addSynopsisOption(nextOption);
                if (next == null) continue;
                synopsisBuilder.append(" ").append(((String)next).trim());
            }
            synopsisBuilder.append(" |");
            HashSet<SynopsisOption> conflicts = new HashSet<SynopsisOption>(currentOption.conflictWith);
            TreeSet<SynopsisOption> conflicts2 = new TreeSet<SynopsisOption>(Comparator.comparing(SynopsisOption::getName));
            conflicts2.addAll(currentOption.conflictWith);
            for (SynopsisOption so : conflicts2) {
                Set<SynopsisOption> conflictAndDependencies = SynopsisGenerator.retrieveAllDependencies(so);
                conflictAndDependencies.add(so);
                for (SynopsisOption s : conflictAndDependencies) {
                    s.conflictWith.remove(currentOption);
                    currentOption.conflictWith.remove(s);
                }
                while ((nextOption = SynopsisGenerator.retrieveNextOption(conflictAndDependencies, false)) != null) {
                    conflictAndDependencies.remove(nextOption);
                    nextOption.conflictWith.remove(currentOption);
                    currentOption.conflictWith.remove(nextOption);
                    for (SynopsisOption conflict : allDependedBy) {
                        nextOption.conflictWith.remove(conflict);
                        conflict.conflictWith.remove(nextOption);
                    }
                    for (SynopsisOption conflict : conflicts) {
                        nextOption.conflictWith.remove(conflict);
                        conflict.conflictWith.remove(nextOption);
                    }
                    String next2 = this.addSynopsisOption(nextOption);
                    if (next2 != null) {
                        synopsisBuilder.append(" ").append(next2.trim());
                    }
                    if (currentOption.conflictWith.isEmpty()) continue;
                    synopsisBuilder.append(" |");
                }
            }
            synopsisBuilder.append(" )");
            if (allOneOfDependedBy.isEmpty()) {
                synopsisBuilder.append(" ");
            } else {
                while ((nextOption = SynopsisGenerator.retrieveNextOption(allOneOfDependedBy, true)) != null) {
                    allOneOfDependedBy.remove(nextOption);
                    currentOption.dependedByOneOff.remove(nextOption);
                    String next3 = this.addSynopsisOption(nextOption);
                    if (next3 == null) continue;
                    synopsisBuilder.append(" ").append(next3.trim());
                }
            }
        } else {
            SynopsisOption nextOption;
            this.addSynopsisOptionNameValue(synopsisBuilder, currentOption);
            for (SynopsisOption option : currentOption.dependedBy) {
                option.dependsOn.remove(currentOption);
            }
            while ((nextOption = SynopsisGenerator.retrieveNextOption(currentOption.dependedBy, true)) != null) {
                currentOption.dependedBy.remove(nextOption);
                String next = this.addSynopsisOption(nextOption);
                if (next == null) continue;
                synopsisBuilder.append(" ").append(next.trim());
            }
        }
        return synopsisBuilder.toString();
    }

    private static Set<SynopsisOption> retrieveCommonDependenciesFromConflicts(SynopsisOption currentOption) {
        HashSet<SynopsisOption> common = new HashSet<SynopsisOption>();
        ArrayList<Set<SynopsisOption>> dependencies = new ArrayList<Set<SynopsisOption>>();
        dependencies.add(SynopsisGenerator.retrieveAllDependencies(currentOption));
        HashSet<SynopsisOption> allDependencies = new HashSet<SynopsisOption>();
        for (SynopsisOption option : currentOption.conflictWith) {
            Set<SynopsisOption> deps = SynopsisGenerator.retrieveAllDependencies(option);
            dependencies.add(deps);
            allDependencies.addAll(deps);
        }
        HashSet<SynopsisOption> allConflicts = new HashSet<SynopsisOption>();
        for (SynopsisOption option : currentOption.conflictWith) {
            Set<SynopsisOption> confs = SynopsisGenerator.retrieveAllConflicts(option);
            allConflicts.addAll(confs);
        }
        for (SynopsisOption opt : allDependencies) {
            boolean shared = true;
            for (Set set : dependencies) {
                if (set.contains(opt)) continue;
                shared = false;
                break;
            }
            if (shared && allConflicts.contains(opt)) {
                shared = false;
            }
            if (!shared) continue;
            common.add(opt);
        }
        return common;
    }

    private static Set<SynopsisOption> retrieveAllDependencies(SynopsisOption option) {
        HashSet<SynopsisOption> options = new HashSet<SynopsisOption>();
        for (SynopsisOption opt : option.dependsOn) {
            options.add(opt);
            options.addAll(SynopsisGenerator.retrieveAllDependencies(opt));
        }
        return options;
    }

    private static Set<SynopsisOption> retrieveAllDependenciesOfConflicts(Set<SynopsisOption> conflicts) {
        HashSet<SynopsisOption> options = new HashSet<SynopsisOption>();
        for (SynopsisOption conflict : conflicts) {
            options.addAll(conflict.dependsOn);
            options.addAll(SynopsisGenerator.retrieveAllDependenciesOfConflicts(conflict.dependsOn));
        }
        return options;
    }

    private static Set<SynopsisOption> retrieveAllConflicts(SynopsisOption option) {
        HashSet<SynopsisOption> options = new HashSet<SynopsisOption>();
        options.addAll(option.conflictWith);
        for (SynopsisOption opt : option.dependsOn) {
            options.addAll(SynopsisGenerator.retrieveAllConflicts(opt));
        }
        return options;
    }

    private static Set<SynopsisOption> retrieveAllDependedBy(SynopsisOption option) {
        HashSet<SynopsisOption> options = new HashSet<SynopsisOption>();
        options.addAll(option.dependedBy);
        for (SynopsisOption opt : option.dependedBy) {
            options.addAll(SynopsisGenerator.retrieveAllDependedBy(opt));
        }
        return options;
    }

    private static Set<SynopsisOption> retrieveAllOneOfDependedBy(SynopsisOption option) {
        HashSet<SynopsisOption> options = new HashSet<SynopsisOption>();
        options.addAll(option.dependedByOneOff);
        for (SynopsisOption opt : option.conflictWith) {
            options.addAll(opt.dependedByOneOff);
        }
        return options;
    }

    private static Set<SynopsisOption> buildSynopsisOptions(List<ProcessedOption> opts, ProcessedOption arg, boolean domain) {
        IdentityHashMap<String, SynopsisOption> options = new IdentityHashMap<String, SynopsisOption>();
        if (arg != null) {
            SynopsisGenerator.buildOption(options, true, arg, opts, arg, domain);
        }
        for (ProcessedOption opt : opts) {
            SynopsisGenerator.buildOption(options, false, opt, opts, arg, domain);
        }
        return new HashSet<SynopsisOption>(options.values());
    }

    private static void buildOption(Map<String, SynopsisOption> options, boolean isArgument, ProcessedOption opt, List<ProcessedOption> opts, ProcessedOption arg, boolean domain) {
        List<ProcessedOption> expected = SynopsisGenerator.retrieveExpected(opt.activator(), opts, isArgument ? null : arg, domain);
        SynopsisOption synopsisOpt = null;
        if (isArgument) {
            synopsisOpt = new SynopsisOption();
            synopsisOpt.option = arg;
            options.put("", synopsisOpt);
        } else {
            synopsisOpt = options.get(opt.name());
            if (synopsisOpt == null) {
                synopsisOpt = new SynopsisOption();
                synopsisOpt.option = opt;
                options.put(opt.name(), synopsisOpt);
            }
        }
        for (ProcessedOption e : expected) {
            Object depDep = options.get(e.name());
            if (depDep == null) {
                depDep = new SynopsisOption();
                ((SynopsisOption)depDep).option = e;
                options.put(e.name(), (SynopsisOption)depDep);
            }
            synopsisOpt.dependsOn.add((SynopsisOption)depDep);
            ((SynopsisOption)depDep).dependedBy.add(synopsisOpt);
        }
        List<ProcessedOption> oneOfExpected = SynopsisGenerator.retrieveOneOfExpected(opt.activator(), opts, arg, domain);
        int i = 0;
        for (ProcessedOption e : oneOfExpected) {
            SynopsisOption depDep = options.get(e.name());
            if (depDep == null) {
                depDep = new SynopsisOption();
                depDep.option = e;
                options.put(e.name(), depDep);
            }
            if (duplicateOneOfDependencies) {
                if (i == 0) {
                    synopsisOpt.dependsOn.add(depDep);
                    depDep.dependedBy.add(synopsisOpt);
                    ++i;
                    continue;
                }
                SynopsisOption o = new SynopsisOption("oneof-" + e.name());
                o.option = opt;
                o.dependsOn.add(depDep);
                depDep.dependedBy.add(o);
                options.put("oneof-" + e.name(), o);
                continue;
            }
            depDep.dependedByOneOff.add(synopsisOpt);
        }
        List<ProcessedOption> notExpected = SynopsisGenerator.retrieveNotExpected(opt.activator(), opts, arg, domain);
        for (ProcessedOption e : notExpected) {
            SynopsisOption depDep = options.get(e.name());
            if (depDep == null) {
                depDep = new SynopsisOption();
                depDep.option = e;
                options.put(e.name(), depDep);
            }
            synopsisOpt.conflictWith.add(depDep);
            depDep.conflictWith.add(synopsisOpt);
        }
    }

    private static List<ProcessedOption> retrieveNotExpected(OptionActivator activator, List<ProcessedOption> opts, ProcessedOption arg, boolean domain) {
        ArrayList<ProcessedOption> notExpected = new ArrayList<ProcessedOption>();
        if (activator == null) {
            return notExpected;
        }
        if (activator instanceof RejectOptionActivator) {
            for (String s : ((RejectOptionActivator)activator).getRejected()) {
                if (s == null || s.equals("")) {
                    if (arg == null || !SynopsisGenerator.isDomainCompliant(arg, domain)) continue;
                    notExpected.add(arg);
                    continue;
                }
                for (ProcessedOption opt : opts) {
                    if (!s.equals(opt.name()) || !SynopsisGenerator.isDomainCompliant(opt, domain)) continue;
                    notExpected.add(opt);
                }
            }
        }
        return notExpected;
    }

    private static List<ProcessedOption> retrieveExpected(OptionActivator activator, List<ProcessedOption> opts, ProcessedOption arg, boolean domain) {
        ArrayList<ProcessedOption> expected = new ArrayList<ProcessedOption>();
        if (activator == null) {
            return expected;
        }
        if (activator instanceof DependOptionActivator) {
            for (String s : ((DependOptionActivator)activator).getDependsOn()) {
                if (s == null || s.equals("")) {
                    if (arg == null || !SynopsisGenerator.isDomainCompliant(arg, domain)) continue;
                    expected.add(arg);
                    continue;
                }
                for (ProcessedOption opt : opts) {
                    if (!s.equals(opt.name()) || !SynopsisGenerator.isDomainCompliant(opt, domain)) continue;
                    expected.add(opt);
                }
            }
        }
        return expected;
    }

    private static List<ProcessedOption> retrieveOneOfExpected(OptionActivator activator, List<ProcessedOption> opts, ProcessedOption arg, boolean domain) {
        ArrayList<ProcessedOption> expected = new ArrayList<ProcessedOption>();
        if (activator == null) {
            return expected;
        }
        if (activator instanceof DependOneOfOptionActivator) {
            for (String s : ((DependOneOfOptionActivator)activator).getOneOfDependsOn()) {
                if (s == null || s.equals("")) {
                    if (arg == null || !SynopsisGenerator.isDomainCompliant(arg, domain)) continue;
                    expected.add(arg);
                    continue;
                }
                for (ProcessedOption opt : opts) {
                    if (!s.equals(opt.name()) || !SynopsisGenerator.isDomainCompliant(opt, domain)) continue;
                    expected.add(opt);
                }
            }
        }
        return expected;
    }

    private static boolean isDomainCompliant(ProcessedOption arg, boolean domain) {
        return !(domain ? arg.activator() instanceof StandaloneOptionActivator : arg.activator() instanceof DomainOptionActivator);
    }

    private static SynopsisOption retrieveNextOption(Set<SynopsisOption> synopsisOptions, boolean wantLeafDependency) {
        if (synopsisOptions.isEmpty()) {
            return null;
        }
        ArrayList<SynopsisOption> options = new ArrayList<SynopsisOption>();
        for (SynopsisOption synopsisOption : synopsisOptions) {
            if (!synopsisOption.dependsOn.isEmpty()) continue;
            options.add(synopsisOption);
        }
        if (options.isEmpty()) {
            if (!wantLeafDependency) {
                throw new RuntimeException("No option without dependency...alert");
            }
            return null;
        }
        Collections.sort(options, (o1, o2) -> {
            if (o1.option.name().equals("headers")) {
                return 1;
            }
            if (o2.option.name().equals("headers")) {
                return -1;
            }
            if (o1.option.isRequired() && o2.option.isRequired()) {
                return o1.option.name().compareTo(o2.option.name());
            }
            if (o1.option.isRequired()) {
                return -1;
            }
            if (o2.option.isRequired()) {
                return 1;
            }
            return o1.option.name().compareTo(o2.option.name());
        });
        return (SynopsisOption)options.get(0);
    }

    private void addSynopsisOptionNameValue(StringBuilder synopsisBuilder, SynopsisOption currentOption) {
        if (!currentOption.option.isRequired()) {
            synopsisBuilder.append("[");
        }
        if (currentOption.option.name().equals("")) {
            String value = HelpSupport.getValue(this.bundle, this.parentName, this.commandName, this.superNames, "arguments.value", true);
            synopsisBuilder.append("<").append(value == null ? "argument" : value).append(">");
        } else {
            if (this.isOperation) {
                synopsisBuilder.append(currentOption.option.name()).append("=");
            } else {
                synopsisBuilder.append("--").append(currentOption.option.name());
            }
            if (currentOption.option.hasValue()) {
                String val;
                if (this.isOperation) {
                    val = HelpSupport.VALUES.get(currentOption.option.type());
                } else {
                    val = HelpSupport.getValue(this.bundle, this.parentName, this.commandName, this.superNames, "option." + currentOption.option.name() + ".value", true);
                    val = val == null ? HelpSupport.VALUES.get(currentOption.option.type()) : val;
                    synopsisBuilder.append("=");
                }
                synopsisBuilder.append("<").append(val).append(">");
            }
        }
        if (!currentOption.option.isRequired()) {
            synopsisBuilder.append("]");
        }
    }

    public static class SynopsisOption {
        private ProcessedOption option;
        private final Set<SynopsisOption> dependsOn = new HashSet<SynopsisOption>();
        private final Set<SynopsisOption> conflictWith = new HashSet<SynopsisOption>();
        private final Set<SynopsisOption> dependedBy = new HashSet<SynopsisOption>();
        private final Set<SynopsisOption> dependedByOneOff = new HashSet<SynopsisOption>();
        private final String radical;

        SynopsisOption(String radical) {
            this.radical = radical;
        }

        SynopsisOption() {
            this(null);
        }

        public boolean equals(Object other) {
            if (!(other instanceof SynopsisOption)) {
                return false;
            }
            SynopsisOption dep = (SynopsisOption)other;
            return this.toString().equals(dep.getName());
        }

        public int hashCode() {
            int hash = 7;
            hash = 13 * hash + Objects.hashCode(this.getName());
            return hash;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return (String)(this.radical == null ? "" : this.radical + "-") + this.option.name();
        }
    }
}

