/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.SecurityActions;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public interface Configuration {
    public Path getJBossHome();

    public ModuleLoader getModuleLoader();

    public String[] getCommandArguments();

    public static class Builder {
        private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
        private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
        private static final String SYSPROP_KEY_LOGGING_PROVIDER = "org.jboss.logging.provider";
        private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
        private static final String SYSPROP_KEY_SYSTEM_MODULES = "jboss.modules.system.pkgs";
        private static final String JBOSS_MODULES_DIR_NAME = "modules";
        private static final AtomicBoolean MODULE_LOADER_CONFIGURED = new AtomicBoolean(false);
        private final Path jbossHome;
        private final List<String> cmdArgs;
        private final List<String> systemPackages;
        private LoggerHint loggerHint;
        private ModuleLoader moduleLoader;
        private String modulePath;

        private Builder(File jbossHome) {
            this(jbossHome.toPath());
        }

        private Builder(Path jbossHome) {
            this.jbossHome = jbossHome;
            this.cmdArgs = new ArrayList<String>();
            this.systemPackages = new ArrayList<String>();
        }

        public static Builder of(File jbossHome) {
            if (jbossHome == null) {
                throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHome");
            }
            return new Builder(jbossHome);
        }

        public static Builder of(Path jbossHome) {
            if (jbossHome == null) {
                throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHome");
            }
            return new Builder(jbossHome);
        }

        public Builder addCommandArgument(String arg) {
            if (arg != null) {
                this.cmdArgs.add(arg);
            }
            return this;
        }

        public Builder addCommandArguments(String ... args) {
            if (args != null) {
                this.cmdArgs.addAll(Arrays.asList(args));
            }
            return this;
        }

        public Builder setCommandArguments(String ... args) {
            this.cmdArgs.clear();
            return this.addCommandArguments(args);
        }

        public Builder setLoggerHint(LoggerHint loggerHint) {
            this.loggerHint = loggerHint;
            return this;
        }

        public Builder setModuleLoader(ModuleLoader moduleLoader) {
            this.moduleLoader = moduleLoader;
            return this;
        }

        public Builder setModulePath(String modulePath) {
            if (MODULE_LOADER_CONFIGURED.get()) {
                EmbeddedLogger.ROOT_LOGGER.moduleLoaderAlreadyConfigured(SYSPROP_KEY_MODULE_PATH);
            }
            this.modulePath = modulePath;
            return this;
        }

        public Builder addSystemPackage(String systemPackage) {
            if (MODULE_LOADER_CONFIGURED.get()) {
                EmbeddedLogger.ROOT_LOGGER.moduleLoaderAlreadyConfigured(SYSPROP_KEY_SYSTEM_MODULES);
            }
            if (systemPackage != null) {
                this.systemPackages.add(systemPackage);
            }
            return this;
        }

        public Builder addSystemPackages(String ... systemPackages) {
            if (MODULE_LOADER_CONFIGURED.get()) {
                EmbeddedLogger.ROOT_LOGGER.moduleLoaderAlreadyConfigured(SYSPROP_KEY_SYSTEM_MODULES);
            }
            if (systemPackages != null) {
                this.systemPackages.addAll(Arrays.asList(systemPackages));
            }
            return this;
        }

        public Builder setSystemPackages(String ... systemPackages) {
            if (MODULE_LOADER_CONFIGURED.get()) {
                EmbeddedLogger.ROOT_LOGGER.moduleLoaderAlreadyConfigured(SYSPROP_KEY_SYSTEM_MODULES);
            }
            this.systemPackages.clear();
            return this.addSystemPackages(systemPackages);
        }

        public Configuration build() {
            ModuleLoader moduleLoader;
            final Path jbossHome = this.jbossHome;
            LoggerHint loggerHint = this.loggerHint == null ? LoggerHint.DEFAULT : this.loggerHint;
            this.configureLogging(loggerHint);
            final String[] cmdArgs = this.cmdArgs.toArray(new String[0]);
            String[] systemPackages = this.systemPackages.toArray(new String[0]);
            if (this.moduleLoader == null) {
                String modulePath = this.modulePath == null ? SecurityActions.getPropertyPrivileged(SYSPROP_KEY_MODULE_PATH, jbossHome.resolve(JBOSS_MODULES_DIR_NAME).toAbsolutePath().toString()) : this.modulePath;
                moduleLoader = Builder.setupModuleLoader(modulePath, systemPackages);
                MODULE_LOADER_CONFIGURED.set(true);
            } else {
                moduleLoader = this.moduleLoader;
            }
            return new Configuration(){

                @Override
                public Path getJBossHome() {
                    return jbossHome;
                }

                @Override
                public ModuleLoader getModuleLoader() {
                    return moduleLoader;
                }

                @Override
                public String[] getCommandArguments() {
                    return Arrays.copyOf(cmdArgs, cmdArgs.length);
                }
            };
        }

        private void configureLogging(LoggerHint loggerHint) {
            String systemPackage;
            String providerCode = loggerHint.providerCode;
            if (SecurityActions.getPropertyPrivileged(SYSPROP_KEY_LOGGING_PROVIDER) == null && providerCode != null) {
                SecurityActions.setPropertyPrivileged(SYSPROP_KEY_LOGGING_PROVIDER, providerCode);
            }
            if ((systemPackage = loggerHint.systemPackage) != null && !this.systemPackages.contains(systemPackage)) {
                this.systemPackages.add(systemPackage);
            }
        }

        private static String trimPathToModulesDir(String modulePath) {
            int index = modulePath.indexOf(File.pathSeparator);
            return index == -1 ? modulePath : modulePath.substring(0, index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
            assert (modulePath != null) : "modulePath not null";
            Path moduleDir = Paths.get(Builder.trimPathToModulesDir(modulePath), new String[0]);
            if (Files.notExists(moduleDir, new LinkOption[0]) || !Files.isDirectory(moduleDir, new LinkOption[0])) {
                throw new RuntimeException("The first directory of the specified module path " + modulePath + " is invalid or does not exist.");
            }
            SecurityActions.setPropertyPrivileged(SYSPROP_KEY_JBOSS_MODULES_DIR, moduleDir.toAbsolutePath().toString());
            String classPath = SecurityActions.getPropertyPrivileged(SYSPROP_KEY_CLASS_PATH);
            try {
                SecurityActions.clearPropertyPrivileged(SYSPROP_KEY_CLASS_PATH);
                SecurityActions.setPropertyPrivileged(SYSPROP_KEY_MODULE_PATH, modulePath);
                StringBuilder packages = new StringBuilder("org.jboss.modules,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
                if (systemPackages != null) {
                    for (String packageName : systemPackages) {
                        packages.append(",");
                        packages.append(packageName);
                    }
                }
                SecurityActions.setPropertyPrivileged(SYSPROP_KEY_SYSTEM_MODULES, packages.toString());
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                return moduleLoader;
            }
            finally {
                if (classPath != null) {
                    SecurityActions.setPropertyPrivileged(SYSPROP_KEY_CLASS_PATH, classPath);
                }
            }
        }
    }

    public static enum LoggerHint {
        DEFAULT(null, null),
        JBOSS_LOG_MANAGER("jboss", null),
        LOG4J2("log4j2", "org.apache.logging.log4j"),
        LOGBACK("slf4j", "org.slf4j"),
        JUL("jdk", null);

        private final String providerCode;
        private final String systemPackage;

        private LoggerHint(String providerCode, String systemPackage) {
            this.providerCode = providerCode;
            this.systemPackage = systemPackage;
        }

        public String getProviderCode() {
            return this.providerCode;
        }
    }
}

