/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;

public class ModuleNameTabCompleter {
    private static final EscapeSelector ESCAPE_SELECTOR = ch -> ch == '\\' || ch == ' ' || ch == '\"';
    private static final String MODULE_NAME_SEPARATOR = ".";
    public static final String LAYERS_DIR = "system/layers";
    public static final String ADDONS_DIR = "system/add-ons";
    private final File modulesRoot;
    private final File layersDir;
    private final File addonsDir;
    private final boolean includeSystemModules;
    private final boolean excludeNonModuleFolders;

    private ModuleNameTabCompleter(Builder builder) {
        this.modulesRoot = builder.modulesRoot.getAbsoluteFile();
        this.layersDir = new File(this.modulesRoot, LAYERS_DIR);
        this.addonsDir = new File(this.modulesRoot, ADDONS_DIR);
        this.excludeNonModuleFolders = builder.excludeNonModuleFolders;
        this.includeSystemModules = builder.includeSystemModules;
    }

    public List<String> complete(String buffer) {
        String userEntry = buffer == null ? "" : buffer;
        TreeSet<String> suggestions = new TreeSet<String>();
        List<File> moduleTrees = this.findInitialModuleDirectories();
        for (File f : moduleTrees) {
            this.findSuggestion(f, f.getName(), userEntry, suggestions);
        }
        return new ArrayList<String>(suggestions);
    }

    private List<File> findInitialModuleDirectories() {
        ArrayList<File> moduleTrees = new ArrayList<File>();
        moduleTrees.addAll(Arrays.asList(this.modulesRoot.listFiles(this::isNotSystemFolder)));
        if (this.includeSystemModules && this.layersDir.exists()) {
            for (File layer : this.layersDir.listFiles(File::isDirectory)) {
                moduleTrees.addAll(Arrays.asList(layer.listFiles(this::isNotPatchFolder)));
            }
        }
        if (this.includeSystemModules && this.addonsDir.exists()) {
            for (File addon : this.addonsDir.listFiles(File::isDirectory)) {
                moduleTrees.addAll(Arrays.asList(addon.listFiles(this::isNotPatchFolder)));
            }
        }
        return moduleTrees;
    }

    private void findSuggestion(File currentDirectory, String suggestion, String userEntry, Collection<String> candidates) {
        block6: {
            block3: {
                String partialModuleName;
                String fullModuleName;
                block4: {
                    boolean hasNestedModules;
                    block7: {
                        boolean isCompleteModule;
                        block5: {
                            if (!this.matchesUserEntry(currentDirectory, userEntry) || this.excludeNonModuleFolders && this.isSlotDirectory(currentDirectory)) {
                                return;
                            }
                            if (!this.tail(userEntry).isEmpty() || this.requestsSubmodules(userEntry)) break block3;
                            fullModuleName = Util.escapeString(suggestion, ESCAPE_SELECTOR);
                            partialModuleName = Util.escapeString(suggestion + MODULE_NAME_SEPARATOR, ESCAPE_SELECTOR);
                            if (!this.excludeNonModuleFolders) break block4;
                            boolean isExactMatch = currentDirectory.getName().equals(userEntry);
                            hasNestedModules = this.hasNestedModules(currentDirectory);
                            isCompleteModule = this.isCompleteModule(currentDirectory);
                            if (!isCompleteModule || !hasNestedModules || !isExactMatch) break block5;
                            candidates.add(fullModuleName);
                            candidates.add(partialModuleName);
                            break block6;
                        }
                        if (!isCompleteModule) break block7;
                        candidates.add(fullModuleName);
                        break block6;
                    }
                    if (!hasNestedModules) break block6;
                    candidates.add(partialModuleName);
                    break block6;
                }
                boolean hasChildren = currentDirectory.listFiles(File::isDirectory).length > 0;
                boolean isExactMatch = currentDirectory.getName().equals(userEntry);
                if (hasChildren && isExactMatch) {
                    candidates.add(partialModuleName);
                }
                candidates.add(fullModuleName);
                break block6;
            }
            for (File file : currentDirectory.listFiles(File::isDirectory)) {
                this.findSuggestion(file, suggestion + MODULE_NAME_SEPARATOR + file.getName(), this.tail(userEntry), candidates);
            }
        }
    }

    private boolean matchesUserEntry(File currentDirectory, String userEntry) {
        if (!userEntry.endsWith(MODULE_NAME_SEPARATOR) && this.tail(userEntry).isEmpty()) {
            return currentDirectory.getName().startsWith(this.head(userEntry));
        }
        return currentDirectory.getName().equals(this.head(userEntry));
    }

    private boolean isCompleteModule(File file) {
        return file.listFiles(f -> f.isDirectory() && this.isSlotDirectory(f)).length > 0;
    }

    private boolean hasNestedModules(File file) {
        File[] nonSlotChildren;
        for (File potentialModule : nonSlotChildren = file.listFiles(f -> f.isDirectory() && !this.isSlotDirectory(f))) {
            if (!this.subModuleExists(potentialModule)) continue;
            return true;
        }
        return false;
    }

    private boolean subModuleExists(File dir) {
        File[] children;
        if (this.isSlotDirectory(dir)) {
            return true;
        }
        for (File child : children = dir.listFiles(File::isDirectory)) {
            if (!this.subModuleExists(child)) continue;
            return true;
        }
        return false;
    }

    private boolean isSlotDirectory(File currentDirectory) {
        return currentDirectory.listFiles(f -> f.getName().equals("module.xml")).length > 0;
    }

    private boolean requestsSubmodules(String moduleNamePattern) {
        return moduleNamePattern.endsWith(MODULE_NAME_SEPARATOR);
    }

    private boolean isNotSystemFolder(File f) {
        return f.isDirectory() && !f.getName().equals("system");
    }

    private boolean isNotPatchFolder(File f) {
        return f.isDirectory() && !f.getName().equals("patches");
    }

    private String head(String moduleName) {
        if (moduleName.indexOf(MODULE_NAME_SEPARATOR) > 0) {
            return moduleName.substring(0, moduleName.indexOf(MODULE_NAME_SEPARATOR));
        }
        return moduleName;
    }

    private String tail(String moduleName) {
        if (moduleName.indexOf(MODULE_NAME_SEPARATOR) > 0) {
            return moduleName.substring(moduleName.indexOf(MODULE_NAME_SEPARATOR) + 1);
        }
        return "";
    }

    public static Builder completer(File modulesRoot) {
        return new Builder(modulesRoot);
    }

    public static class Builder {
        private final File modulesRoot;
        private boolean includeSystemModules;
        private boolean excludeNonModuleFolders;

        public Builder(File modulesRoot) {
            this.modulesRoot = modulesRoot;
        }

        public Builder includeSystemModules(boolean includeSystemModules) {
            this.includeSystemModules = includeSystemModules;
            return this;
        }

        public Builder excludeNonModuleFolders(boolean excludeNonModuleFolders) {
            this.excludeNonModuleFolders = excludeNonModuleFolders;
            return this;
        }

        public ModuleNameTabCompleter build() {
            return new ModuleNameTabCompleter(this);
        }
    }
}

