/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class CommandContextFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.jboss.as.cli.impl.CommandContextFactoryImpl";

    public static CommandContextFactory getInstance() throws CliInitializationException {
        Class<?> factoryCls;
        try {
            factoryCls = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged().loadClass(DEFAULT_FACTORY_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new CliInitializationException("Failed to load org.jboss.as.cli.impl.CommandContextFactoryImpl", e);
        }
        try {
            return (CommandContextFactory)factoryCls.newInstance();
        }
        catch (Exception e) {
            throw new CliInitializationException("Failed to create an instance of " + factoryCls, e);
        }
    }

    protected CommandContextFactory() {
    }

    public abstract CommandContext newCommandContext() throws CliInitializationException;

    public abstract CommandContext newCommandContext(String var1, char[] var2) throws CliInitializationException;

    public abstract CommandContext newCommandContext(String var1, String var2, char[] var3) throws CliInitializationException;

    @Deprecated
    public abstract CommandContext newCommandContext(String var1, String var2, char[] var3, boolean var4, int var5) throws CliInitializationException;

    @Deprecated
    public abstract CommandContext newCommandContext(String var1, String var2, char[] var3, boolean var4, boolean var5, int var6) throws CliInitializationException;

    public abstract CommandContext newCommandContext(String var1, String var2, char[] var3, InputStream var4, OutputStream var5) throws CliInitializationException;

    public abstract CommandContext newCommandContext(CommandContextConfiguration var1) throws CliInitializationException;

    @Deprecated
    public abstract CommandContext newCommandContext(String var1, int var2, String var3, char[] var4) throws CliInitializationException;

    @Deprecated
    public abstract CommandContext newCommandContext(String var1, int var2, String var3, char[] var4, boolean var5, int var6) throws CliInitializationException;

    @Deprecated
    public abstract CommandContext newCommandContext(String var1, int var2, String var3, char[] var4, InputStream var5, OutputStream var6) throws CliInitializationException;
}

