/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.InputStream;
import java.io.OutputStream;

public class CommandContextConfiguration {
    private final String controller;
    private final String username;
    private final char[] password;
    private final String clientBindAddress;
    private final InputStream consoleInput;
    private final OutputStream consoleOutput;
    private final boolean initConsole;
    private final boolean disableLocalAuth;
    private final int connectionTimeout;
    private boolean silent;
    private boolean outputOnly;
    private boolean errorOnInteract;

    private CommandContextConfiguration(String controller, String username, char[] password, String clientBindAddress, boolean disableLocalAuth, boolean initConsole, int connectionTimeout, InputStream consoleInput, OutputStream consoleOutput) {
        this.controller = controller;
        this.username = username;
        this.password = password;
        this.clientBindAddress = clientBindAddress;
        this.consoleInput = consoleInput;
        this.consoleOutput = consoleOutput;
        this.initConsole = initConsole;
        this.disableLocalAuth = disableLocalAuth || username != null;
        this.connectionTimeout = connectionTimeout;
    }

    public String getController() {
        return this.controller;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getClientBindAddress() {
        return this.clientBindAddress;
    }

    public InputStream getConsoleInput() {
        return this.consoleInput;
    }

    public OutputStream getConsoleOutput() {
        return this.consoleOutput;
    }

    public boolean isInitConsole() {
        return this.initConsole;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isDisableLocalAuth() {
        return this.disableLocalAuth;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isOutputOnly() {
        return this.outputOnly;
    }

    public boolean isErrorOnInteract() {
        return this.errorOnInteract;
    }

    public static class Builder {
        private String controller;
        private String username;
        private char[] password;
        private String clientBindAddress;
        private InputStream consoleInput;
        private OutputStream consoleOutput;
        private boolean initConsole = false;
        private boolean disableLocalAuth;
        private int connectionTimeout = -1;
        private boolean disableLocalAuthUnset = true;
        private boolean silent = false;
        private boolean outputOnly = false;
        private boolean errorOnInteract = false;

        public CommandContextConfiguration build() {
            if (this.disableLocalAuthUnset) {
                this.disableLocalAuth = this.username != null;
            }
            CommandContextConfiguration config = new CommandContextConfiguration(this.controller, this.username, this.password, this.clientBindAddress, this.disableLocalAuth, this.initConsole, this.connectionTimeout, this.consoleInput, this.consoleOutput);
            config.silent = this.silent;
            config.outputOnly = this.outputOnly;
            config.errorOnInteract = this.errorOnInteract;
            return config;
        }

        public Builder setController(String controller) {
            this.controller = controller;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(char[] password) {
            this.password = password;
            return this;
        }

        public Builder setClientBindAddress(String clientBindAddress) {
            this.clientBindAddress = clientBindAddress;
            return this;
        }

        public Builder setConsoleInput(InputStream consoleInput) {
            this.consoleInput = consoleInput;
            return this;
        }

        public Builder setConsoleOutput(OutputStream consoleOutput) {
            this.consoleOutput = consoleOutput;
            return this;
        }

        public Builder setInitConsole(boolean initConsole) {
            this.initConsole = initConsole;
            return this;
        }

        public Builder setDisableLocalAuth(boolean disableLocalAuth) {
            this.disableLocalAuth = disableLocalAuth;
            this.disableLocalAuthUnset = false;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder setOutputOnly(boolean outputOnly) {
            this.outputOnly = outputOnly;
            return this;
        }

        public Builder setErrorOnInteract(boolean errorOnInteract) {
            this.errorOnInteract = errorOnInteract;
            return this;
        }
    }
}

