/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.embedded.EmbeddedServerLaunch;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;

class StopEmbeddedHostControllerHandler
extends CommandHandlerWithHelp {
    private final AtomicReference<EmbeddedServerLaunch> hostControllerReference;

    StopEmbeddedHostControllerHandler(AtomicReference<EmbeddedServerLaunch> hostControllerReference) {
        super("stop-embedded-host-controller", false);
        assert (hostControllerReference != null);
        this.hostControllerReference = hostControllerReference;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return this.hostControllerReference.get() != null;
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        EmbeddedServerLaunch hostControllerLaunch = this.hostControllerReference.get();
        if (hostControllerLaunch != null) {
            ctx.disconnectController();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup(AtomicReference<EmbeddedServerLaunch> hostControllerReference) {
        EmbeddedServerLaunch hostControllerLaunch = hostControllerReference.get();
        if (hostControllerLaunch != null) {
            try {
                hostControllerLaunch.getHostController().stop();
            }
            finally {
                try {
                    hostControllerLaunch.getEnvironmentRestorer().restoreEnvironment();
                }
                finally {
                    hostControllerReference.compareAndSet(hostControllerLaunch, null);
                }
            }
        }
    }
}

