/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactory;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyManager;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.MechanismConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.PropertiesRealmConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.Realm;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SecurityDomain;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ServerSSLContext;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.x500.cert.acme.CertificateAuthority;

public abstract class ElytronUtil {
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String DIGEST_MD5_MECHANISM = "DIGEST-MD5";
    private static final String EXTERNAL_MECHANISM = "EXTERNAL";
    private static final String JBOSS_LOCAL_USER_MECHANISM = "JBOSS-LOCAL-USER";
    private static final String BASIC_MECHANISM = "BASIC";
    private static final String DIGEST_MECHANISM = "DIGEST";
    private static final String FORM_MECHANISM = "FORM";
    private static final String CLIENT_CERT_MECHANISM = "CLIENT_CERT";
    private static final String SCRAM_SHA_1 = "SCRAM-SHA-1";
    private static final String SCRAM_SHA_1_PLUS = "SCRAM-SHA-1-PLUS";
    private static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
    private static final String SCRAM_SHA_256_PLUS = "SCRAM-SHA-256-PLUS";
    private static final String SCRAM_SHA_384 = "SCRAM-SHA-384";
    private static final String SCRAM_SHA_384_PLUS = "SCRAM-SHA-384-PLUS";
    private static final String SCRAM_SHA_512 = "SCRAM-SHA-512";
    private static final String SCRAM_SHA_512_PLUS = "SCRAM-SHA-512-PLUS";
    private static final String DIGEST_SHA = "DIGEST-SHA";
    private static final String DIGEST_SHA_256 = "DIGEST-SHA-256";
    private static final String DIGEST_SHA_384 = "DIGEST-SHA-384";
    private static final String DIGEST_SHA_512 = "DIGEST-SHA-512";
    public static final String JKS = "JKS";
    public static final String PKCS12 = "PKCS12";
    public static final String TLS_V1_2 = "TLSv1.2";
    public static String OOTB_MANAGEMENT_SASL_FACTORY = "management-sasl-authentication";
    public static String OOTB_MANAGEMENT_HTTP_FACTORY = "management-http-authentication";
    public static String OOTB_APPLICATION_HTTP_FACTORY = "application-http-authentication";
    public static String OOTB_APPLICATION_DOMAIN = "ApplicationDomain";
    public static final String SASL_SERVER_CAPABILITY = "org.wildfly.security.sasl-server-factory";
    public static final String HTTP_SERVER_CAPABILITY = "org.wildfly.security.http-server-mechanism-factory";
    private static final Set<String> MECHANISMS_WITH_REALM = new HashSet<String>();
    private static final Set<String> MECHANISMS_WITH_TRUST_STORE = new HashSet<String>();
    private static final Set<String> MECHANISMS_LOCAL_USER = new HashSet<String>();

    private ElytronUtil() {
    }

    static String retrieveKeyStorePassword(CommandContext ctx, String name) throws OperationFormatException, IOException {
        ModelNode res;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-attribute");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.addProperty("name", "credential-reference");
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        String password = null;
        if (Util.isSuccess(response) && response.hasDefined("result") && (res = response.get("result")).hasDefined("clear-text")) {
            password = res.get("clear-text").asString();
        }
        return password;
    }

    static String findMatchingKeyStore(CommandContext ctx, File path, String relativeTo, String password, String type, Boolean required, String alias) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyStoreResource(path, relativeTo, password, type, required, alias);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "key-store", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static List<String> findMatchingKeyStores(CommandContext ctx, File path, String relativeTo) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyStoreResource(path, relativeTo, null, null, null, null);
        return ElytronUtil.findMatchingResources(ctx, "key-store", resource);
    }

    private static ModelNode buildKeyStoreResource(File path, String relativeTo, String password, String type, Boolean required, String alias) throws IOException {
        ModelNode localKS = new ModelNode();
        if (path != null) {
            localKS.get("path").set(path.getPath());
        }
        if (relativeTo != null) {
            localKS.get("relative-to").set(relativeTo);
        } else {
            localKS.get("relative-to");
        }
        if (password != null) {
            localKS.get("credential-reference").set(ElytronUtil.buildCredentialReferences(password));
        }
        if (type != null) {
            localKS.get("type").set(type);
        }
        if (required != null) {
            localKS.get("required").set(required);
        }
        if (alias != null) {
            localKS.get("alias-filter", alias);
        } else {
            localKS.get("alias-filter");
        }
        return localKS;
    }

    private static ModelNode buildKeyManagerResource(KeyStore keyStore, String alias, String algorithm) {
        ModelNode localKM = new ModelNode();
        if (keyStore.getPassword() != null) {
            localKM.get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        }
        localKM.get("key-store").set(keyStore.getName());
        if (alias != null) {
            localKM.get("alias-filter", alias);
        } else {
            localKM.get("alias-filter");
        }
        if (algorithm != null) {
            localKM.get("algorithm", algorithm);
        } else {
            localKM.get("algorithm");
        }
        return localKM;
    }

    private static ModelNode buildTrustManagerResource(KeyStore keyStore, String alias, String algorithm) {
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        mn.remove("credential-reference");
        return mn;
    }

    private static List<String> findMatchingResources(CommandContext ctx, String type, ModelNode resource) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-children-resources");
        builder.addNode("subsystem", "elytron");
        builder.addProperty("child-type", type);
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        ArrayList<String> matches = new ArrayList<String>();
        if (Util.isSuccess(response) && response.hasDefined("result")) {
            ModelNode res = response.get("result");
            for (String ksName : res.keys()) {
                ModelNode ks = res.get(ksName);
                ArrayList<String> meaninglessKeys = new ArrayList<String>();
                for (String k : ks.keys()) {
                    if (resource.keys().contains(k)) continue;
                    meaninglessKeys.add(k);
                }
                for (String s : meaninglessKeys) {
                    ks.remove(s);
                }
                if (!resource.equals(ks)) continue;
                matches.add(ksName);
            }
        }
        return matches;
    }

    static String findMatchingKeyManager(CommandContext ctx, KeyStore keyStore, String alias, String algorithm) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "key-manager", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static String findMatchingTrustManager(CommandContext ctx, KeyStore keyStore, String alias, String algorithm) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildTrustManagerResource(keyStore, alias, algorithm);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "trust-manager", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static String findMatchingSSLContext(CommandContext ctx, ServerSSLContext sslCtx) throws OperationFormatException, IOException {
        List<String> names = ElytronUtil.findMatchingResources(ctx, "server-ssl-context", sslCtx.buildResource());
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static ModelNode addKeyStore(CommandContext ctx, String name, File path, String relativeTo, String password, String type, Boolean required, String alias) throws Exception {
        ModelNode mn = ElytronUtil.buildKeyStoreResource(path, relativeTo, password, type, required, alias);
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    static ModelNode generateKeyPair(CommandContext ctx, String name, String dn, String alias, Long validity, String keyAlg, int keySize) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("generate-key-pair");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("distinguished-name").set(dn);
        builder.getModelNode().get("algorithm").set(keyAlg);
        builder.getModelNode().get("key-size").set(keySize);
        builder.getModelNode().get("alias").set(alias);
        if (validity != null) {
            builder.getModelNode().get("validity").set(validity);
        }
        return builder.buildRequest();
    }

    static ModelNode importCertificate(CommandContext ctx, File trustedCertificate, String alias, boolean validate, KeyStore trustStore, boolean trust) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("import-certificate");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", trustStore.getName());
        builder.getModelNode().get("alias").set(alias);
        builder.getModelNode().get("path").set(trustedCertificate.getAbsolutePath());
        builder.getModelNode().get("trust-cacerts").set(trust);
        builder.getModelNode().get("validate").set(validate);
        return builder.buildRequest();
    }

    static ModelNode storeKeyStore(CommandContext ctx, String name) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("store");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return builder.buildRequest();
    }

    static ModelNode removeKeyStore(CommandContext ctx, String name) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return builder.buildRequest();
    }

    static ModelNode exportCertificate(CommandContext ctx, String name, File path, String relativeTo, String alias, boolean pem) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("export-certificate");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("path").set(path.getPath());
        builder.getModelNode().get("alias").set(alias);
        if (relativeTo != null) {
            builder.getModelNode().get("relative-to").set(relativeTo);
        }
        builder.getModelNode().get("pem").set(pem);
        return builder.buildRequest();
    }

    static ModelNode generateSigningRequest(CommandContext ctx, String name, File path, String relativeTo, String alias) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("generate-certificate-signing-request");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("path").set(path.getPath());
        builder.getModelNode().get("alias").set(alias);
        if (relativeTo != null) {
            builder.getModelNode().get("relative-to").set(relativeTo);
        }
        return builder.buildRequest();
    }

    static ModelNode addKeyManager(CommandContext ctx, KeyStore keyStore, String name, String alias, String algorithm) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-manager", name);
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        return builder.buildRequest();
    }

    static ModelNode addTrustManager(CommandContext ctx, KeyStore keyStore, String name, String alias, String algorithm) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("trust-manager", name);
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        if (keyStore.getPassword() != null) {
            builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        }
        return builder.buildRequest();
    }

    static ModelNode addServerSSLContext(CommandContext ctx, ServerSSLContext sslCtx, String name) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("server-ssl-context", name);
        ModelNode mn = sslCtx.buildResource();
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    private static ModelNode buildCredentialReferences(String password) {
        ModelNode mn = new ModelNode();
        mn.get("clear-text").set(password);
        return mn;
    }

    static boolean keyManagerExists(CommandContext ctx, String name) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-manager", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean trustManagerExists(CommandContext ctx, String name) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("trust-manager", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean keyStoreExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean serverSSLContextExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("server-ssl-context", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static List<String> getKeyStoreNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "key-store");
    }

    public static List<String> getSecurityDomainNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "security-domain");
    }

    public static List<String> getConstantRoleMappers(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "constant-role-mapper");
    }

    private static List<String> getNames(ModelControllerClient client, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-children-names");
            builder.addNode("subsystem", "elytron");
            builder.addProperty("child-type", type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static ModelNode getChildResource(String name, String type, CommandContext ctx) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-resource");
            builder.addNode("subsystem", "elytron");
            builder.addNode(type, name);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                return outcome.get("result");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasServerSSLContext(CommandContext context, String sslContextName) {
        return ElytronUtil.getChildResource(sslContextName, "server-ssl-context", context) != null;
    }

    public static ServerSSLContext getServerSSLContext(CommandContext context, String sslContextName) {
        ModelNode sslContext = ElytronUtil.getChildResource(sslContextName, "server-ssl-context", context);
        ServerSSLContext ctx = null;
        if (sslContext != null) {
            String kmName = sslContext.get("key-manager").asString();
            ModelNode km = ElytronUtil.getChildResource(kmName, "key-manager", context);
            if (km == null) {
                throw new IllegalArgumentException("The ServerSSLContext " + sslContextName + " references the KeyManager " + kmName + " that doesn't exist.");
            }
            String ksName = km.get("key-store").asString();
            KeyStore keyStore = new KeyStore(ksName, null, true);
            KeyManager keyManager = new KeyManager(kmName, keyStore, true);
            KeyManager trustManager = null;
            if (sslContext.hasDefined("trust-manager")) {
                trustManager = new KeyManager(sslContext.get("trust-manager").asString(), keyStore, true);
            }
            ctx = new ServerSSLContext(ksName, keyManager, trustManager, true);
        }
        return ctx;
    }

    public static KeyStore getKeyStore(CommandContext ctx, String name) throws OperationFormatException, IOException {
        String password = ElytronUtil.retrieveKeyStorePassword(ctx, name);
        if (password == null) {
            // empty if block
        }
        return new KeyStore(name, password, true);
    }

    public static boolean isElytronSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static boolean isKeyStoreManagementSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-operation-description");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", "?");
        builder.addProperty("name", "generate-key-pair");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static ModelNode getAuthFactoryResource(String authFactory, AuthFactorySpec spec, CommandContext ctx) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-resource");
            builder.addNode("subsystem", "elytron");
            builder.addNode(spec.getResourceType(), authFactory);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                return outcome.get("result");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ModelNode reorderSASLFactory(CommandContext ctx, List<String> order, String factoryName) throws Exception {
        ModelNode factory = ElytronUtil.getAuthFactoryResource(factoryName, AuthFactorySpec.SASL, ctx);
        if (factory == null) {
            throw new Exception("Invalid factory name " + factoryName);
        }
        if (factory.hasDefined("mechanism-configurations")) {
            ModelNode mechanisms = factory.get("mechanism-configurations");
            HashSet<String> seen = new HashSet<String>();
            ArrayList<ModelNode> newOrder = new ArrayList<ModelNode>();
            for (String o : order) {
                for (ModelNode m : mechanisms.asList()) {
                    String name = m.get("mechanism-name").asString();
                    if (o.equals(name)) {
                        newOrder.add(m);
                    }
                    seen.add(name);
                }
            }
            for (String r : order) {
                if (seen.contains(r)) continue;
                throw new Exception("Mechanism " + r + " is not contained in SASL factory " + factoryName);
            }
            if (!order.containsAll(seen)) {
                throw new Exception("Mechanism list is not complete, existing mechanisms are:" + seen);
            }
            if (newOrder.isEmpty()) {
                throw new Exception("Error: All mechanisms would be removed, this would fully disable access.");
            }
            ModelNode newValue = new ModelNode();
            newValue.set(newOrder);
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("write-attribute");
            builder.addNode("subsystem", "elytron");
            builder.addNode(AuthFactorySpec.SASL.getResourceType(), factoryName);
            builder.addProperty("name", "mechanism-configurations");
            builder.getModelNode().get("value").set(newValue);
            return builder.buildRequest();
        }
        throw new Exception("No mechanism to re-order in Factory " + factoryName);
    }

    public static AuthFactory findMatchingAuthFactory(AuthMechanism newMechanism, AuthFactorySpec spec, CommandContext ctx) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-children-resources");
        builder.addNode("subsystem", "elytron");
        builder.addProperty("child-type", spec.getResourceType());
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        AuthFactory factory = null;
        if (Util.isSuccess(response) && response.hasDefined("result")) {
            ModelNode res = response.get("result");
            for (String ksName : res.keys()) {
                ModelNode ks = res.get(ksName);
                AuthFactory fact = ElytronUtil.getAuthFactory(ks, ksName, spec, ctx);
                List<Object> mecs = fact != null ? fact.getMechanisms() : Collections.emptyList();
                if (mecs.isEmpty() || mecs.size() > 1) continue;
                AuthMechanism mec = (AuthMechanism)mecs.get(0);
                if (!newMechanism.getType().equals(mec.getType())) continue;
                if (newMechanism.getConfig().getRealmMapper() == null) {
                    if (!Objects.equals(newMechanism.getConfig().getRealmName(), mec.getConfig().getRealmName())) continue;
                    factory = fact;
                    break;
                }
                if (!Objects.equals(newMechanism.getConfig().getRealmMapper(), mec.getConfig().getRealmMapper())) continue;
                factory = fact;
                break;
            }
        }
        return factory;
    }

    public static AuthFactory getAuthFactory(String authFactory, AuthFactorySpec spec, CommandContext ctx) {
        ModelNode mn = ElytronUtil.getAuthFactoryResource(authFactory, spec, ctx);
        return ElytronUtil.getAuthFactory(mn, authFactory, spec, ctx);
    }

    public static AuthFactory getAuthFactory(ModelNode mn, String authFactory, AuthFactorySpec spec, CommandContext ctx) {
        AuthFactory factory = null;
        if (mn != null) {
            SecurityDomain sc = new SecurityDomain(mn.get("security-domain").asString());
            factory = new AuthFactory(authFactory, sc, spec);
            if (mn.hasDefined("mechanism-configurations")) {
                ModelNode lst = mn.get("mechanism-configurations");
                for (ModelNode m : lst.asList()) {
                    String name = m.get("mechanism-name").asString();
                    String realmMapper = null;
                    String realmName = null;
                    if (m.hasDefined("realm-mapper")) {
                        realmMapper = m.get("realm-mapper").asString();
                    }
                    if (m.hasDefined("mechanism-realm-configurations")) {
                        ModelNode config = m.get("mechanism-realm-configurations");
                        for (ModelNode c : config.asList()) {
                            if (!c.hasDefined("realm-name")) continue;
                            realmName = c.get("realm-name").asString();
                            break;
                        }
                    }
                    final String finalRealmName = realmName;
                    final String finalRealmMapper = realmMapper;
                    AuthMechanism mec = new AuthMechanism(name, new MechanismConfiguration(){

                        @Override
                        public String getRealmName() {
                            return finalRealmName;
                        }

                        @Override
                        public String getRoleDecoder() {
                            return null;
                        }

                        @Override
                        public String getRoleMapper() {
                            return null;
                        }

                        @Override
                        public String getRealmMapper() {
                            return finalRealmMapper;
                        }

                        @Override
                        public String getExposedRealmName() {
                            return finalRealmName;
                        }

                        @Override
                        public void setRealmMapperName(String constantMapper) {
                        }
                    });
                    factory.addMechanism(mec);
                }
            }
        }
        return factory;
    }

    public static String findMatchingUsersPropertiesRealm(CommandContext ctx, PropertiesRealmConfiguration config) throws Exception {
        ModelNode resource = ElytronUtil.buildRealmResource(config);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "properties-realm", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    private static ModelNode buildRealmResource(Realm realm) {
        ModelNode mn = new ModelNode();
        mn.get("realm").set(realm.getResourceName());
        if (realm.getConfig().getRoleDecoder() != null) {
            mn.get("role-decoder").set(realm.getConfig().getRoleDecoder());
        }
        if (realm.getConfig().getRoleMapper() != null) {
            mn.get("role-mapper").set(realm.getConfig().getRoleMapper());
        }
        return mn;
    }

    private static ModelNode buildRealmResource(PropertiesRealmConfiguration config) throws Exception {
        ModelNode localRealm = new ModelNode();
        localRealm.get("groups-attribute").set("groups");
        if (config.getGroupPropertiesFile() != null) {
            localRealm.get("groups-properties").set(ElytronUtil.buildGroupsResource(config));
        }
        localRealm.get("users-properties").set(ElytronUtil.buildUsersResource(config));
        return localRealm;
    }

    private static ModelNode buildGroupsResource(PropertiesRealmConfiguration config) throws IOException {
        ModelNode mn = new ModelNode();
        mn.get("path").set(config.getGroupPropertiesFile());
        if (config.getRelativeTo() != null) {
            mn.get("relative-to").set(config.getRelativeTo());
        }
        return mn;
    }

    private static ModelNode buildUsersResource(PropertiesRealmConfiguration config) throws IOException {
        ModelNode mn = new ModelNode();
        mn.get("path").set(config.getUserPropertiesFile());
        if (config.getRelativeTo() != null) {
            mn.get("relative-to").set(config.getRelativeTo());
        }
        mn.get("digest-realm-name").set(config.getExposedRealmName());
        if (config.getPlainText()) {
            mn.get("plain-text").set(config.getPlainText());
        }
        return mn;
    }

    public static boolean serverPropertiesRealmExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("properties-realm", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static ModelNode addUsersPropertiesRealm(CommandContext ctx, String realmName, PropertiesRealmConfiguration config) throws Exception {
        ModelNode mn = ElytronUtil.buildRealmResource(config);
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("properties-realm", realmName);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    public static String findKeyStoreRealm(CommandContext ctx, String trustStore) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        String name = null;
        builder.setOperationName("read-children-resources");
        builder.addNode("subsystem", "elytron");
        builder.addProperty("child-type", "key-store-realm");
        ModelNode response = ctx.getModelControllerClient().execute(builder.buildRequest());
        if (Util.isSuccess(response) && response.hasDefined("result")) {
            ModelNode mn = response.get("result");
            for (String key : mn.keys()) {
                String ks;
                ModelNode ksr = mn.get(key);
                if (!ksr.hasDefined("key-store") || !(ks = ksr.get("key-store").asString()).equals(trustStore)) continue;
                name = key;
                break;
            }
        }
        return name;
    }

    public static ModelNode addKeyStoreRealm(CommandContext ctx, String ksRealmName, String keyStore) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store-realm", ksRealmName);
        builder.addProperty("key-store", keyStore);
        return builder.buildRequest();
    }

    public static String findConstantRealmMapper(CommandContext ctx, String realmName) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-children-resources");
        builder.addNode("subsystem", "elytron");
        builder.addProperty("child-type", "constant-realm-mapper");
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        if (Util.isSuccess(response) && response.hasDefined("result")) {
            ModelNode res = response.get("result");
            for (String csName : res.keys()) {
                ModelNode mn = res.get(csName);
                String constantName = mn.get("realm-name").asString();
                if (!realmName.equals(constantName)) continue;
                return csName;
            }
        }
        return null;
    }

    public static ModelNode addConstantRealmMapper(CommandContext ctx, String realmName) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("constant-realm-mapper", realmName);
        builder.addProperty("realm-name", realmName);
        return builder.buildRequest();
    }

    public static boolean securityDomainExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("security-domain", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static ModelNode addSecurityDomain(CommandContext ctx, Realm realm, String newSecurityDomain) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("security-domain", newSecurityDomain);
        ModelNode mn = ElytronUtil.buildSecurityDomainResource(realm);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    private static ModelNode buildSecurityDomainResource(Realm realm) {
        ModelNode sd = new ModelNode();
        if (realm != null) {
            sd.get("realms").add(ElytronUtil.buildRealmResource(realm));
        }
        sd.get("permission-mapper").set("default-permission-mapper");
        return sd;
    }

    public static boolean factoryExists(CommandContext ctx, String name, AuthFactorySpec spec) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode(spec.getResourceType(), name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static ModelNode addAuthFactory(CommandContext ctx, SecurityDomain securityDomain, String newAuthFactoryName, AuthFactorySpec spec) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode(spec.getResourceType(), newAuthFactoryName);
        ModelNode mn = ElytronUtil.buildAuthFactoryResource(securityDomain, spec);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    private static ModelNode buildAuthFactoryResource(SecurityDomain domain, AuthFactorySpec spec) {
        ModelNode sd = new ModelNode();
        sd.get(spec.getServerType()).set(spec.getServerValue());
        sd.get("security-domain").set(domain.getName());
        return sd;
    }

    public static void addAuthMechanism(CommandContext ctx, AuthFactory authFactory, AuthMechanism mechanism, ModelNode steps) throws OperationFormatException {
        ModelNode mechanisms = ElytronUtil.retrieveMechanisms(ctx, authFactory);
        ModelNode newMechanism = ElytronUtil.buildMechanismResource(mechanism);
        int index = 0;
        boolean found = false;
        for (ModelNode m : mechanisms.asList()) {
            String name;
            if (m.hasDefined("mechanism-name") && (name = m.get("mechanism-name").asString()).equals(mechanism.getType())) {
                if (newMechanism.equals(m)) {
                    return;
                }
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            mechanisms.remove(index);
            mechanisms.insert(newMechanism, index);
        } else {
            mechanisms.add(newMechanism);
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "elytron");
        builder.addNode(authFactory.getSpec().getResourceType(), authFactory.getName());
        builder.getModelNode().get("value").set(mechanisms);
        builder.getModelNode().get("name").set("mechanism-configurations");
        steps.add(builder.buildRequest());
    }

    private static ModelNode buildMechanismResource(AuthMechanism mechanism) {
        ModelNode mn = new ModelNode();
        mn.get("mechanism-name").set(mechanism.getType());
        if (mechanism.getConfig().getRealmMapper() != null) {
            mn.get("realm-mapper").set(mechanism.getConfig().getRealmMapper());
        }
        if (mechanism.getConfig().getExposedRealmName() != null) {
            ModelNode realmConfig = new ModelNode();
            realmConfig.get("realm-name").set(mechanism.getConfig().getExposedRealmName());
            mn.get("mechanism-realm-configurations").add(realmConfig);
        }
        return mn;
    }

    public static void addRealm(CommandContext ctx, SecurityDomain securityDomain, Realm realm, ModelNode steps) throws OperationFormatException {
        ModelNode realms = ElytronUtil.retrieveSecurityDomainRealms(ctx, securityDomain);
        ModelNode newRealm = ElytronUtil.buildRealmResource(realm);
        int index = 0;
        boolean found = false;
        for (ModelNode r : realms.asList()) {
            String n;
            if (r.hasDefined("realm") && (n = r.get("realm").asString()).equals(realm.getResourceName())) {
                if (newRealm.equals(r)) {
                    return;
                }
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            realms.remove(index);
            realms.insert(newRealm, index);
        } else {
            realms.add(newRealm);
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "elytron");
        builder.addNode("security-domain", securityDomain.getName());
        builder.getModelNode().get("value").set(realms);
        builder.getModelNode().get("name").set("realms");
        steps.add(builder.buildRequest());
    }

    private static ModelNode retrieveSecurityDomainRealms(CommandContext ctx, SecurityDomain domain) {
        ModelNode mn = ElytronUtil.getSecurityDomainResource(domain, ctx);
        if (mn == null) {
            return new ModelNode().setEmptyList();
        }
        if (mn.hasDefined("realms")) {
            return mn.get("realms");
        }
        return new ModelNode().setEmptyList();
    }

    public static ModelNode getSecurityDomainResource(SecurityDomain domain, CommandContext ctx) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-resource");
            builder.addNode("subsystem", "elytron");
            builder.addNode("security-domain", domain.getName());
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                return outcome.get("result");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ModelNode retrieveMechanisms(CommandContext ctx, AuthFactory authFactory) {
        ModelNode mn = ElytronUtil.getAuthFactoryResource(authFactory.getName(), authFactory.getSpec(), ctx);
        if (mn == null) {
            return new ModelNode().setEmptyList();
        }
        if (mn.hasDefined("mechanism-configurations")) {
            return mn.get("mechanism-configurations");
        }
        return new ModelNode().setEmptyList();
    }

    public static final Set<String> getMechanismsWithRealm() {
        return MECHANISMS_WITH_REALM;
    }

    public static final Set<String> getMechanismsWithTrustStore() {
        return MECHANISMS_WITH_TRUST_STORE;
    }

    public static final Set<String> getMechanismsLocalUser() {
        return MECHANISMS_LOCAL_USER;
    }

    private static boolean isMechanismSupported(String name) {
        return ElytronUtil.getMechanismsWithRealm().contains(name) || ElytronUtil.getMechanismsWithTrustStore().contains(name) || ElytronUtil.getMechanismsLocalUser().contains(name);
    }

    public static List<String> getMechanisms(CommandContext ctx, AuthFactorySpec spec) throws OperationFormatException, IOException {
        ArrayList<String> lst = new ArrayList<String>();
        for (String m : ElytronUtil.getAvailableMechanisms(ctx, spec)) {
            if (!ElytronUtil.isMechanismSupported(m)) continue;
            lst.add(m);
        }
        return lst;
    }

    public static List<String> getAvailableMechanisms(CommandContext ctx, AuthFactorySpec spec) throws OperationFormatException, IOException {
        ArrayList<String> lst = new ArrayList<String>();
        ModelNode resource = ElytronUtil.getServerFactory(spec.getServerValue(), spec, ctx);
        if (resource == null) {
            return null;
        }
        for (ModelNode m : resource.get("available-mechanisms").asList()) {
            lst.add(m.asString());
        }
        return lst;
    }

    public static List<String> getFileSystemRealmNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "filesystem-realm");
    }

    public static List<String> getPropertiesRealmNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "properties-realm");
    }

    public static List<String> getKeyStoreRealmNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "key-store-realm");
    }

    private static ModelNode getServerFactory(String factory, AuthFactorySpec spec, CommandContext ctx) throws OperationFormatException, IOException {
        for (ModelNode point : ElytronUtil.getServerFactoriesProviderPoints(ctx, spec)) {
            ModelNode fact = ElytronUtil.getServerfactory(ctx, point.asString(), factory);
            if (fact == null) continue;
            return fact;
        }
        return null;
    }

    private static List<ModelNode> getServerFactoriesProviderPoints(CommandContext ctx, AuthFactorySpec spec) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("get-provider-points");
        builder.addNode("core-service", "capability-registry");
        builder.getModelNode().get("name").set(spec.getCapability());
        ModelNode response = ctx.getModelControllerClient().execute(builder.buildRequest());
        if (Util.isSuccess(response)) {
            return response.get("result").asList();
        }
        return null;
    }

    private static ModelNode getServerfactory(CommandContext ctx, String point, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        for (String p : point.split("/")) {
            if (p.isEmpty()) continue;
            String[] ps = p.split("=");
            if (ps[1].equals("*")) {
                ps[1] = name;
            }
            builder.addNode(ps[0], ps[1]);
        }
        builder.getModelNode().get("include-runtime").set(true);
        ModelNode response = ctx.getModelControllerClient().execute(builder.buildRequest());
        if (Util.isSuccess(response)) {
            return response.get("result");
        }
        return null;
    }

    public static List<String> getSimpleDecoderNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "simple-role-decoder");
    }

    public static boolean localUserExists(CommandContext ctx) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("identity-realm", "local");
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static ModelNode removeMechanisms(CommandContext ctx, ModelNode factory, String factoryName, AuthFactorySpec spec, Set<String> toRemove) throws Exception {
        if (factory.hasDefined("mechanism-configurations")) {
            ArrayList<ModelNode> remains = new ArrayList<ModelNode>();
            HashSet<String> seen = new HashSet<String>();
            ModelNode mechanisms = factory.get("mechanism-configurations");
            for (ModelNode m : mechanisms.asList()) {
                String name = m.get("mechanism-name").asString();
                if (!toRemove.contains(name)) {
                    remains.add(m);
                }
                seen.add(name);
            }
            for (String r : toRemove) {
                if (seen.contains(r)) continue;
                throw new Exception("Mechanism " + r + " is not contained in factory " + factoryName);
            }
            if (remains.isEmpty()) {
                throw new Exception("Error: All mechanisms would be removed, this would fully disable access. To fully disable authentication, don't provide mechanism.");
            }
            ModelNode newValue = new ModelNode();
            newValue.set(remains);
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("write-attribute");
            builder.addNode("subsystem", "elytron");
            builder.addNode(spec.getResourceType(), factoryName);
            builder.addProperty("name", "mechanism-configurations");
            builder.getModelNode().get("value").set(newValue);
            return builder.buildRequest();
        }
        throw new Exception("No mechanism to remove in Factory " + factoryName);
    }

    public static List<String> getMechanisms(CommandContext ctx, String factoryName, AuthFactorySpec spec) throws Exception {
        ModelNode factory = ElytronUtil.getAuthFactoryResource(factoryName, spec, ctx);
        if (factory == null) {
            throw new Exception("Invalid factory name " + factoryName);
        }
        ArrayList<String> lst = new ArrayList<String>();
        if (factory.hasDefined("mechanism-configurations")) {
            ModelNode mechanisms = factory.get("mechanism-configurations");
            for (ModelNode m : mechanisms.asList()) {
                String name = m.get("mechanism-name").asString();
                lst.add(name);
            }
        } else {
            throw new Exception("No mechanism in Factory " + factoryName);
        }
        return lst;
    }

    static String findMatchingConstantRoleMapper(List<String> roles, CommandContext ctx) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildConstantRoleMapperResource(roles);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "constant-role-mapper", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    private static ModelNode buildConstantRoleMapperResource(List<String> roles) {
        ModelNode mn = new ModelNode();
        ModelNode r = mn.get("roles");
        for (String role : roles) {
            r.add(role);
        }
        return mn;
    }

    static ModelNode buildConstantRoleMapper(List<String> roles, String mapperName, CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("constant-role-mapper", mapperName);
        builder.getModelNode().get("roles").set(ElytronUtil.buildConstantRoleMapperResource(roles).get("roles"));
        return builder.buildRequest();
    }

    public static boolean constantRoleMapperExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("constant-role-mapper", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static ModelNode addCertificateAuthority(CertificateAuthority certificateAuthority) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("certificate-authority", certificateAuthority.getName());
        builder.addProperty("url", certificateAuthority.getUrl());
        return builder.buildRequest();
    }

    public static ModelNode addCertificateAuthorityAccount(String name, String password, String alias, String keyStoreName, List<String> contactUrls, CertificateAuthority customCertificateAuthority) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("certificate-authority-account", name);
        if (!contactUrls.isEmpty()) {
            builder.getModelNode().get("contact-urls").set(ElytronUtil.createModelNodes(contactUrls));
        }
        builder.addProperty("key-store", keyStoreName);
        builder.addProperty("alias", alias);
        if (customCertificateAuthority != null) {
            builder.addProperty("certificate-authority", customCertificateAuthority.getName());
        }
        builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(password));
        return builder.buildRequest();
    }

    private static List<ModelNode> createModelNodes(List<String> items) {
        ArrayList<ModelNode> modelNodes = new ArrayList<ModelNode>();
        for (String item : items) {
            if (item.isEmpty()) continue;
            modelNodes.add(new ModelNode(item));
        }
        return modelNodes;
    }

    public static ModelNode removeCertificateAuthorityAccount(String name) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("subsystem", "elytron");
        builder.addNode("certificate-authority-account", name);
        return builder.buildRequest();
    }

    public static ModelNode obtainCertificateRequest(String keyStoreName, String alias, String password, List<String> domainNames, String certificateAuthorityAccount, boolean agreedToTOS, int key_size, String key_algorithm) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("obtain-certificate");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", keyStoreName);
        builder.addProperty("alias", alias);
        builder.getModelNode().get("domain-names").set(ElytronUtil.createModelNodes(domainNames));
        builder.addProperty("certificate-authority-account", certificateAuthorityAccount);
        builder.addProperty("agree-to-terms-of-service", String.valueOf(agreedToTOS));
        builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(password));
        builder.addProperty("algorithm", key_algorithm);
        builder.addProperty("key-size", String.valueOf(key_size));
        return builder.buildRequest();
    }

    public static List<String> getCaAccountNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "certificate-authority-account");
    }

    static {
        MECHANISMS_WITH_REALM.add(PLAIN_MECHANISM);
        MECHANISMS_WITH_REALM.add(DIGEST_MD5_MECHANISM);
        MECHANISMS_WITH_REALM.add(DIGEST_MECHANISM);
        MECHANISMS_WITH_REALM.add(FORM_MECHANISM);
        MECHANISMS_WITH_REALM.add(BASIC_MECHANISM);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_1);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_1_PLUS);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_256);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_256_PLUS);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_384);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_384_PLUS);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_512);
        MECHANISMS_WITH_REALM.add(SCRAM_SHA_512_PLUS);
        MECHANISMS_WITH_REALM.add(DIGEST_SHA);
        MECHANISMS_WITH_REALM.add(DIGEST_SHA_256);
        MECHANISMS_WITH_REALM.add(DIGEST_SHA_384);
        MECHANISMS_WITH_REALM.add(DIGEST_SHA_512);
        MECHANISMS_WITH_TRUST_STORE.add(EXTERNAL_MECHANISM);
        MECHANISMS_WITH_TRUST_STORE.add(CLIENT_CERT_MECHANISM);
        MECHANISMS_LOCAL_USER.add(JBOSS_LOCAL_USER_MECHANISM);
    }
}

