/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.PropertiesRealmConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.Realm;
import org.jboss.as.cli.operation.OperationFormatException;

public class DefaultResourceNames {
    private static final String SECURITY_DOMAIN_NAME = "security-domain";
    public static final String ROLE_MAPPER_NAME = "role-mapper";
    private static final String FACTORY_NAME = "factory";

    public static String buildDefaultKeyStoreName(String name, CommandContext ctx) throws OperationFormatException, IOException {
        int i = 1;
        Object computedName = name;
        while (ElytronUtil.keyStoreExists(ctx, (String)computedName)) {
            computedName = name + "_" + i;
            ++i;
        }
        return computedName;
    }

    public static String buildDefaultKeyStoreName(File path, CommandContext ctx) throws OperationFormatException, IOException {
        return DefaultResourceNames.buildDefaultKeyStoreName(path.getName(), ctx);
    }

    public static String buildDefaultKeyStorePath(File path, CommandContext ctx) throws OperationFormatException, IOException {
        return DefaultResourceNames.buildDefaultKeyStoreName(path.getName(), ctx);
    }

    public static String buildDefaultKeyStoreAlias(String dn, CommandContext ctx) throws OperationFormatException, IOException {
        return dn.substring(0, dn.indexOf("="));
    }

    static String buildDefaultKeyStoreType(String type, CommandContext ctx) {
        return "JKS";
    }

    static String buildDefaultKeyManagerName(CommandContext ctx, String keystoreName) throws IOException, OperationFormatException {
        int i = 1;
        String computedName = "key-manager-" + keystoreName;
        while (ElytronUtil.keyManagerExists(ctx, computedName)) {
            computedName = "key-manager-" + keystoreName + "_" + i;
            ++i;
        }
        return computedName;
    }

    static String buildDefaultSSLContextName(CommandContext ctx, String keystoreName) throws IOException, OperationFormatException {
        int i = 1;
        String computedName = "ssl-context-" + keystoreName;
        while (ElytronUtil.serverSSLContextExists(ctx, computedName)) {
            computedName = "ssl-context-" + keystoreName + "_" + i;
            ++i;
        }
        return computedName;
    }

    public static String getDefaultManagementInterfaceName(CommandContext ctx) {
        return "http-interface";
    }

    static List<String> getDefaultProtocols(CommandContext ctx) {
        return Arrays.asList("TLSv1.2");
    }

    static String getDefaultHttpSecureSocketBindingName(String managementInterface, CommandContext ctx) {
        return "management-https";
    }

    public static String getDefaultServerName(CommandContext context) {
        return "default-server";
    }

    static String getDefaultApplicationLegacyRealm() {
        return "ApplicationRealm";
    }

    public static String buildUserPropertiesDefaultRealmName(CommandContext ctx, PropertiesRealmConfiguration config) throws OperationFormatException, IOException {
        String name = new File(config.getUserPropertiesFile()).getName();
        int i = 1;
        Object computedName = name;
        while (ElytronUtil.serverPropertiesRealmExists(ctx, (String)computedName)) {
            computedName = name + "_" + i;
            ++i;
        }
        return computedName;
    }

    public static String buildDefaultSecurityDomainName(Realm realm, CommandContext ctx) throws OperationFormatException, IOException {
        int i = 1;
        Object computedName = SECURITY_DOMAIN_NAME;
        while (ElytronUtil.securityDomainExists(ctx, (String)computedName)) {
            computedName = "security-domain_" + i;
            ++i;
        }
        return computedName;
    }

    public static String buildConstantRoleMapperName(Realm realm, CommandContext ctx) throws OperationFormatException, IOException {
        int i = 1;
        Object computedName = ROLE_MAPPER_NAME;
        while (ElytronUtil.constantRoleMapperExists(ctx, (String)computedName)) {
            computedName = "role-mapper_" + i;
            ++i;
        }
        return computedName;
    }

    public static String buildDefaultAuthFactoryName(AuthMechanism meca, AuthFactorySpec spec, CommandContext ctx) throws OperationFormatException, IOException {
        int i = 1;
        String computedName = spec.getName() + "-factory";
        while (ElytronUtil.factoryExists(ctx, computedName, spec)) {
            computedName = spec.getName() + "-factory_" + i;
            ++i;
        }
        return computedName;
    }
}

