/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;

public class DeploymentItemCompleter
implements CommandLineCompleter {
    private final OperationRequestAddress address;
    private final Logger log = Logger.getLogger(DeploymentItemCompleter.class);

    public DeploymentItemCompleter(OperationRequestAddress address) {
        this.address = address;
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        this.getCandidates(ctx, buffer, candidates);
        return buffer.lastIndexOf("/") + 1;
    }

    private static String[] parsePath(String path) {
        if (((String)path).isEmpty()) {
            path = "./";
        } else if (((String)path).charAt(0) == '/') {
            path = "." + (String)path;
        } else if (((String)path).charAt(0) != '.') {
            path = "./" + (String)path;
        }
        String directory = path;
        String subpath = "";
        int directoryIndex = ((String)path).lastIndexOf("/");
        if (directoryIndex >= 0) {
            directory = ((String)path).substring(0, directoryIndex + 1);
            subpath = ((String)path).substring(directoryIndex + 1);
        }
        String[] ret = new String[]{directory, subpath};
        return ret;
    }

    private void getCandidates(CommandContext ctx, String buffer, List<String> candidates) {
        try {
            if (buffer.equals(".")) {
                candidates.add("./");
                return;
            }
            if (buffer.equals("/")) {
                return;
            }
            String[] parsed = DeploymentItemCompleter.parsePath(buffer);
            String directory = parsed[0];
            String subpath = parsed[1];
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(this.address);
            builder.setOperationName("browse-content");
            builder.addProperty("path", directory);
            builder.addProperty("depth", "1");
            ModelNode mn = builder.buildRequest();
            ModelNode response = ctx.getModelControllerClient().execute(mn);
            if (response.hasDefined("outcome") && response.get("outcome").asString().equals("success")) {
                ModelNode result = response.get("result");
                if (result.getType() == ModelType.LIST) {
                    for (int i = 0; i < result.asInt(); ++i) {
                        String path = result.get(i).get("path").asString();
                        if (!path.startsWith(subpath) || path.equals(subpath)) continue;
                        candidates.add(path);
                    }
                }
            } else {
                this.log.debug("Invalid response getting candidates");
            }
        }
        catch (IOException | OperationFormatException ex) {
            this.log.debug((Object)"Exception getting candidates", ex);
        }
    }
}

