/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.util.List;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyManager;
import org.jboss.dmr.ModelNode;

public class ServerSSLContext {
    private final String name;
    private final KeyManager keyManager;
    private final KeyManager trustManager;
    private final boolean exists;
    private List<String> protocols;
    private boolean authenticationOptional;
    private String cipherSuiteFilter = "DEFAULT";
    private String cipherSuiteNames;
    private String finalPrincipalTransformer;
    private String postRealmPrincipalTransformer;
    private String preRealmPrincipalTransformer;
    private String providerName;
    private List<String> providers;
    private String realmMapper;
    private String securityDomain;
    private boolean want;
    private boolean need;
    private boolean useCipherSuiteOrder;

    public ServerSSLContext(String name, KeyManager keyManager, KeyManager trustManager, boolean exists) {
        this.name = name;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.exists = exists;
    }

    public boolean exists() {
        return this.exists;
    }

    public String getName() {
        return this.name;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public KeyManager getTrustManager() {
        return this.trustManager;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public boolean isAuthenticationOptional() {
        return this.authenticationOptional;
    }

    public void setAuthenticationOptional(boolean authenticationOptional) {
        this.authenticationOptional = authenticationOptional;
    }

    public String getCipherSuiteFilter() {
        return this.cipherSuiteFilter;
    }

    public void setCipherSuiteFilter(String cipherSuiteFilter) {
        this.cipherSuiteFilter = cipherSuiteFilter;
    }

    public String getCipherSuiteNames() {
        return this.cipherSuiteNames;
    }

    public void setCipherSuiteNames(String cipherSuiteNames) {
        this.cipherSuiteNames = cipherSuiteNames;
    }

    public String getFinalPrincipalTransformer() {
        return this.finalPrincipalTransformer;
    }

    public void setFinalPrincipalTransformer(String finalPrincipalTransformer) {
        this.finalPrincipalTransformer = finalPrincipalTransformer;
    }

    public String getPostRealmPrincipalTransformer() {
        return this.postRealmPrincipalTransformer;
    }

    public void setPostRealmPrincipalTransformer(String postRealmPrincipalTransformer) {
        this.postRealmPrincipalTransformer = postRealmPrincipalTransformer;
    }

    public String getPreRealmPrincipalTransformer() {
        return this.preRealmPrincipalTransformer;
    }

    public void setPreRealmPrincipalTransformer(String preRealmPrincipalTransformer) {
        this.preRealmPrincipalTransformer = preRealmPrincipalTransformer;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public void setProviders(List<String> providers) {
        this.providers = providers;
    }

    public String getRealmMapper() {
        return this.realmMapper;
    }

    public void setRealmMapper(String realmMapper) {
        this.realmMapper = realmMapper;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isWant() {
        return this.want;
    }

    public void setWant(boolean want) {
        this.want = want;
    }

    public boolean isNeed() {
        return this.need;
    }

    public void setNeed(boolean need) {
        this.need = need;
    }

    public boolean isUseCipherSuiteOrder() {
        return this.useCipherSuiteOrder;
    }

    public void setUseCipherSuiteOrder(boolean useCipherSuiteOrder) {
        this.useCipherSuiteOrder = useCipherSuiteOrder;
    }

    public ModelNode buildResource() {
        ModelNode sslCtx = new ModelNode();
        sslCtx.get("key-manager").set(this.keyManager.getName());
        sslCtx.get("want-client-auth").set(this.want);
        sslCtx.get("need-client-auth").set(this.need);
        if (this.trustManager != null) {
            sslCtx.get("trust-manager").set(this.trustManager.getName());
        } else {
            sslCtx.get("trust-manager");
        }
        if (this.protocols != null) {
            ModelNode protocolsNode = sslCtx.get("protocols");
            for (String p : this.protocols) {
                protocolsNode.add(p);
            }
        } else {
            sslCtx.get("protocols");
        }
        sslCtx.get("authentication-optional").set(this.authenticationOptional);
        if (this.cipherSuiteFilter != null) {
            sslCtx.get("cipher-suite-filter").set(this.cipherSuiteFilter);
        } else {
            sslCtx.get("cipher-suite-filter");
        }
        if (this.cipherSuiteNames != null) {
            sslCtx.get("cipher-suite-names").set(this.cipherSuiteNames);
        } else {
            sslCtx.get("cipher-suite-names");
        }
        if (this.finalPrincipalTransformer != null) {
            sslCtx.get("final-principal-transformer").set(this.finalPrincipalTransformer);
        } else {
            sslCtx.get("final-principal-transformer");
        }
        if (this.postRealmPrincipalTransformer != null) {
            sslCtx.get("post-realm-principal-transformer").set(this.postRealmPrincipalTransformer);
        } else {
            sslCtx.get("post-realm-principal-transformer");
        }
        if (this.preRealmPrincipalTransformer != null) {
            sslCtx.get("pre-realm-principal-transformer").set(this.preRealmPrincipalTransformer);
        } else {
            sslCtx.get("pre-realm-principal-transformer");
        }
        if (this.providerName != null) {
            sslCtx.get("provider-name").set(this.providerName);
        } else {
            sslCtx.get("provider-name");
        }
        if (this.providers != null) {
            ModelNode providersNode = sslCtx.get("providers");
            for (String p : this.providers) {
                providersNode.add(p);
            }
        } else {
            sslCtx.get("providers");
        }
        if (this.realmMapper != null) {
            sslCtx.get("realm-mapper").set(this.realmMapper);
        } else {
            sslCtx.get("realm-mapper");
        }
        if (this.securityDomain != null) {
            sslCtx.get("security-domain").set(this.securityDomain);
        } else {
            sslCtx.get("security-domain");
        }
        sslCtx.get("use-cipher-suites-order").set(this.useCipherSuiteOrder);
        return sslCtx;
    }
}

