/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.aesh.complete.AeshCompleteOperation;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.CommandSubstitutionException;
import org.jboss.as.cli.parsing.UnresolvedVariableException;
import org.jboss.as.cli.parsing.operation.OperationFormat;

public class CLICommandCompleter {
    public void complete(CommandContext ctx, AeshCompleteOperation op, Completer completer) {
        int offset = 0;
        Object buffer = op.getBuffer();
        if (ctx.getArgumentsString() != null) {
            offset = ctx.getArgumentsString().length();
            buffer = ctx.getArgumentsString() + (String)buffer;
        }
        AeshCompleteOperation op2 = new AeshCompleteOperation(op.getContext(), (String)buffer, op.getCursor());
        this.doComplete(ctx, op2, completer);
        if (!op2.getCompletionCandidates().isEmpty()) {
            CLICommandCompleter.transferOperation(op2, op);
            op.setOffset(op2.getOffset() - offset);
        }
    }

    public static void transferOperation(AeshCompleteOperation from, AeshCompleteOperation to) {
        to.setIgnoreNonEscapedSpace(from.doIgnoreNonEscapedSpace());
        to.setIgnoreOffset(from.doIgnoreOffset());
        to.setIgnoreStartsWith(from.isIgnoreStartsWith());
        to.setSeparator(from.getSeparator());
        to.doAppendSeparator(from.hasAppendSeparator());
        if (!from.getCompletionCandidates().isEmpty()) {
            to.addCompletionCandidatesTerminalString(from.getCompletionCandidates());
            to.setOffset(from.getOffset());
        }
    }

    protected void doComplete(CommandContext ctx, AeshCompleteOperation op, Completer completer) {
        String variable;
        int index;
        int notIndex;
        ArrayList<String> candidates;
        boolean unresolvedVariableException;
        DefaultCallbackHandler parsedCmd;
        String buffer;
        block18: {
            buffer = op.getBuffer();
            int cursor = op.getCursor();
            if (buffer.isEmpty() || cursor == 0) {
                completer.addAllCommandNames(ctx, op);
                return;
            }
            parsedCmd = (DefaultCallbackHandler)ctx.getParsedCommandLine();
            unresolvedVariableException = false;
            candidates = new ArrayList<String>();
            try {
                if (ctx.getArgumentsString() == null && buffer.length() > cursor) {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer.substring(0, cursor), false, ctx);
                } else if (ctx.getArgumentsString() != null && buffer.length() - ctx.getArgumentsString().length() > cursor) {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer.substring(0, ctx.getArgumentsString().length() + cursor), false, ctx);
                } else {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer, false, ctx);
                }
            }
            catch (UnresolvedVariableException e) {
                unresolvedVariableException = true;
                String variable2 = e.getExpression();
                if (buffer.endsWith(variable2)) {
                    for (String var : ctx.getVariables()) {
                        if (!var.startsWith(variable2)) continue;
                        candidates.add(var);
                    }
                    Collections.sort(candidates);
                    op.addCompletionCandidates(candidates);
                    op.setOffset(buffer.length() - variable2.length());
                    return;
                }
                return;
            }
            catch (CommandSubstitutionException e) {
                String cmd = e.getExpression();
                if (buffer.endsWith(cmd)) {
                    AeshCompleteOperation subsOp = new AeshCompleteOperation(op.getContext(), cmd, cmd.length());
                    this.doComplete(ctx, subsOp, completer);
                    if (subsOp.getCompletionCandidates().isEmpty()) {
                        return;
                    }
                    CLICommandCompleter.transferOperation(subsOp, op);
                    op.setOffset(buffer.length() - cmd.length() + subsOp.getOffset());
                    return;
                }
                return;
            }
            catch (CommandFormatException e) {
                if (parsedCmd.endsOnAddressOperationNameSeparator() && parsedCmd.endsOnSeparator()) break block18;
                return;
            }
        }
        completer.complete(ctx, parsedCmd, op);
        if (parsedCmd.getFormat() != OperationFormat.INSTANCE && (notIndex = candidates.indexOf("!")) >= 0) {
            candidates.remove(notIndex);
        }
        if (!unresolvedVariableException && (index = buffer.lastIndexOf(36)) != -1 && buffer.length() != index + 1 && buffer.endsWith(variable = buffer.substring(index + 1))) {
            ArrayList<String> candidateVariables = new ArrayList<String>();
            for (String e : ctx.getVariables()) {
                if (!e.startsWith(variable) || e.equals(variable)) continue;
                candidateVariables.add(e);
            }
            if (!candidateVariables.isEmpty()) {
                candidates.addAll(candidateVariables);
                Collections.sort(candidates);
                op.addCompletionCandidates(candidates);
                op.setOffset(index + 1);
                return;
            }
        }
        if (candidates.isEmpty() && buffer.charAt(buffer.length() - 1) == '$' && !ctx.getVariables().isEmpty()) {
            candidates.addAll(ctx.getVariables());
            Collections.sort(candidates);
            op.addCompletionCandidates(candidates);
            op.setOffset(buffer.length());
        }
    }

    public static interface Completer {
        public void addAllCommandNames(CommandContext var1, AeshCompleteOperation var2);

        public void complete(CommandContext var1, DefaultCallbackHandler var2, AeshCompleteOperation var3);
    }
}

