/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class CommandCommandHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new SimpleTabCompleter(new String[]{"add", "list", "remove"}), 0, "--action");
    private final ArgumentWithValue nodePath;
    private final ArgumentWithValue nodeChild;
    private final ArgumentWithValue idProperty;
    private final ArgumentWithValue commandName;
    private final CommandRegistry cmdRegistry;
    private DefaultCallbackHandler callback;

    public CommandCommandHandler(CommandRegistry cmdRegistry) {
        super("command", true);
        this.cmdRegistry = cmdRegistry;
        this.action.addCantAppearAfter(this.helpArg);
        this.nodePath = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int offset = 0;
                int result = OperationRequestCompleter.ARG_VALUE_COMPLETER.complete(ctx, buffer, cursor + offset, candidates) - offset;
                return result;
            }
        }, "--node-type"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String nChild = CommandCommandHandler.this.nodeChild.getValue(ctx.getParsedCommandLine(), false);
                return "add".equals(CommandCommandHandler.this.action.getValue(ctx.getParsedCommandLine())) && super.canAppearNext(ctx) && nChild == null;
            }
        };
        this.nodeChild = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int offset = 0;
                int result = OperationRequestCompleter.ARG_VALUE_COMPLETER.complete(ctx, buffer, cursor + offset, candidates) - offset;
                return result;
            }
        }, "--node-child"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String ntype = CommandCommandHandler.this.nodePath.getValue(ctx.getParsedCommandLine(), false);
                return "add".equals(CommandCommandHandler.this.action.getValue(ctx.getParsedCommandLine())) && super.canAppearNext(ctx) && ntype == null;
            }
        };
        this.idProperty = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                List<Property> props;
                try {
                    props = CommandCommandHandler.this.getNodeProperties(ctx);
                }
                catch (CommandFormatException e) {
                    return Collections.emptyList();
                }
                ArrayList<String> candidates = new ArrayList<String>();
                for (Property prop : props) {
                    ModelNode value = prop.getValue();
                    if (!value.has("access-type") || !"read-only".equals(value.get("access-type").asString())) continue;
                    candidates.add(prop.getName());
                }
                return candidates;
            }
        }), "--property-id");
        this.idProperty.addRequiredPreceding(this.nodePath);
        this.commandName = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){
            private final DefaultCallbackHandler callback = new DefaultCallbackHandler();

            public List<String> getAllCandidates(CommandContext ctx) {
                String actionName = CommandCommandHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionName == null) {
                    return Collections.emptyList();
                }
                if (actionName.equals("add")) {
                    boolean isChildPath = false;
                    String thePath = CommandCommandHandler.this.nodePath.getValue(ctx.getParsedCommandLine());
                    if (thePath == null) {
                        thePath = CommandCommandHandler.this.nodeChild.getValue(ctx.getParsedCommandLine());
                        boolean bl = isChildPath = thePath != null;
                    }
                    if (thePath == null) {
                        return Collections.emptyList();
                    }
                    this.callback.reset();
                    try {
                        ParserUtil.parseOperationRequest(thePath, this.callback);
                    }
                    catch (CommandFormatException e) {
                        return Collections.emptyList();
                    }
                    OperationRequestAddress typeAddress = this.callback.getAddress();
                    if (!typeAddress.endsOnType() && !isChildPath) {
                        return Collections.emptyList();
                    }
                    if (typeAddress.endsOnType()) {
                        return Collections.singletonList(typeAddress.getNodeType());
                    }
                    return Collections.singletonList(typeAddress.getNodeName());
                }
                if (actionName.equals("remove")) {
                    return CommandCommandHandler.this.getExistingCommands();
                }
                return Collections.emptyList();
            }
        }), "--command-name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                ParsedCommandLine args = ctx.getParsedCommandLine();
                if (this.isPresent(args)) {
                    return false;
                }
                String actionStr = CommandCommandHandler.this.action.getValue(args);
                if (actionStr == null) {
                    return false;
                }
                if ("add".equals(actionStr)) {
                    return CommandCommandHandler.this.nodePath.isValueComplete(args) || CommandCommandHandler.this.nodeChild.isValueComplete(args);
                }
                return "remove".equals(actionStr);
            }
        };
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String action = this.action.getValue(args);
        if (action == null) {
            throw new CommandFormatException("Command is missing.");
        }
        if (action.equals("list")) {
            ctx.printColumns(this.getExistingCommands());
            return;
        }
        if (action.equals("add")) {
            String nodePath = this.nodePath.getValue(args, false);
            String nodeChild = this.nodeChild.getValue(args, false);
            if (nodePath == null && nodeChild == null) {
                throw new CommandFormatException(this.nodePath.getFullName() + " or " + this.nodeChild.getFullName() + " must be defined");
            }
            if (nodePath != null && nodeChild != null) {
                throw new CommandFormatException("Only one of " + this.nodePath.getFullName() + " or " + this.nodeChild.getFullName() + " can be defined");
            }
            boolean isChildPath = nodeChild != null;
            String path = isChildPath ? nodeChild : nodePath;
            String propName = this.idProperty.getValue(args, false);
            String cmdName = this.commandName.getValue(args, true);
            this.validateInput(ctx, path, propName, isChildPath);
            if (this.cmdRegistry.getCommandHandler(cmdName) != null) {
                throw new CommandFormatException("Command '" + cmdName + "' already registered.");
            }
            this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler(cmdName, ctx, path, propName, isChildPath), cmdName);
            return;
        }
        if (action.equals("remove")) {
            String cmdName = this.commandName.getValue(args, true);
            CommandHandler handler = this.cmdRegistry.getCommandHandler(cmdName);
            if (!(handler instanceof GenericTypeOperationHandler)) {
                throw new CommandFormatException("Command '" + cmdName + "' is not a generic type command.");
            }
            this.cmdRegistry.remove(cmdName);
            return;
        }
        throw new CommandFormatException("Unexpected action: " + action);
    }

    protected List<String> getExistingCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
            if (!(this.cmdRegistry.getCommandHandler(cmd) instanceof GenericTypeOperationHandler)) continue;
            commands.add(cmd);
        }
        return commands;
    }

    protected List<Property> getNodeProperties(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyList();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyList();
        }
        return result.get("attributes").asPropertyList();
    }

    protected ModelNode initRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        String type = this.nodePath.getValue(ctx.getParsedCommandLine());
        if (this.callback == null) {
            this.callback = new DefaultCallbackHandler();
        } else {
            this.callback.reset();
        }
        ParserUtil.parseOperationRequest(type, this.callback);
        OperationRequestAddress typeAddress = this.callback.getAddress();
        if (!typeAddress.endsOnType()) {
            return null;
        }
        String typeName = typeAddress.toParentNode().getType();
        for (OperationRequestAddress.Node node : typeAddress) {
            address.add(node.getType(), node.getName());
        }
        address.add(typeName, "?");
        return request;
    }

    protected void validateInput(CommandContext ctx, String typePath, String propertyName, boolean isChildType) throws CommandFormatException {
        ModelNode result;
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.callback == null) {
            this.callback = new DefaultCallbackHandler();
        } else {
            this.callback.reset();
        }
        try {
            ParserUtil.parseOperationRequest(typePath, this.callback);
        }
        catch (CommandFormatException e) {
            throw new CommandFormatException("Failed to validate input: " + e.getLocalizedMessage());
        }
        OperationRequestAddress typeAddress = this.callback.getAddress();
        if (!typeAddress.endsOnType() && !isChildType) {
            throw new CommandFormatException("Node path '" + typePath + "' doesn't appear to end on a type.");
        }
        if (typeAddress.endsOnType() && isChildType) {
            throw new CommandFormatException("Child path '" + typePath + "' appears to end on a type.");
        }
        if (isChildType) {
            for (OperationRequestAddress.Node node : typeAddress) {
                address.add(node.getType(), node.getName());
            }
            request.get("operation").set("read-resource");
        } else {
            String typeName = typeAddress.toParentNode().getType();
            for (Object node : typeAddress) {
                address.add(node.getType(), node.getName());
            }
            request.get("operation").set("read-children-types");
            try {
                result = ctx.getModelControllerClient().execute(request);
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to validate input: " + e.getLocalizedMessage());
            }
            if (!result.hasDefined("result")) {
                throw new CommandFormatException("Failed to validate input: operation response doesn't contain result info.");
            }
            boolean pathValid = false;
            for (ModelNode typeNode : result.get("result").asList()) {
                if (!typeNode.asString().equals(typeName)) continue;
                pathValid = true;
                break;
            }
            if (!pathValid) {
                throw new CommandFormatException("Type '" + typeName + "' not found among child types of '" + ctx.getNodePathFormatter().format(typeAddress) + "'");
            }
            address.add(typeName, "?");
            request.get("operation").set("read-resource-description");
        }
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException(e.getLocalizedMessage());
        }
        if (isChildType) {
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException("Failure retrieving resource " + typePath + ". Check that the resource already exists.");
            }
        } else {
            if (!result.hasDefined("result")) {
                throw new CommandFormatException("Failed to validate input: operation response doesn't contain result info.");
            }
            if (!(result = result.get("result")).hasDefined("attributes")) {
                throw new CommandFormatException("Failed to validate input: description of attributes is missing for " + typePath);
            }
            if (propertyName != null) {
                for (Property prop : result.get("attributes").asPropertyList()) {
                    if (!prop.getName().equals(propertyName)) continue;
                    ModelNode value = prop.getValue();
                    if (value.has("access-type") && "read-only".equals(value.get("access-type").asString())) {
                        return;
                    }
                    throw new CommandFormatException("Property " + propertyName + " is not read-only.");
                }
            } else {
                return;
            }
            throw new CommandFormatException("Property '" + propertyName + "' wasn't found among the properties of " + typePath);
        }
    }
}

