/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.AbstractDisableAuthenticationCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependOptionActivator;

@CommandDefinition(name="disable-http-auth-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerDisableAuthCommand
extends AbstractDisableAuthenticationCommand {
    @Option(name="security-domain", required=true, completer=SecurityCommand.OptionCompleters.SecurityDomainCompleter.class)
    String securityDomain;
    @Option(name="mechanism", completer=MechanismCompleter.class, activator=MechanismActivator.class)
    String factoryMechanism;
    private final CommandContext ctx;

    public HTTPServerDisableAuthCommand(CommandContext ctx) {
        super(AuthFactorySpec.HTTP);
        this.ctx = ctx;
    }

    @Override
    protected String getMechanism() {
        return this.factoryMechanism;
    }

    @Override
    public ModelNode buildSecurityRequest(CommandContext context) throws Exception {
        if (HTTPServer.hasAuthFactory(this.ctx, this.securityDomain)) {
            return super.buildSecurityRequest(context);
        }
        return this.disableFactory(context);
    }

    @Override
    public String getEnabledFactory(CommandContext ctx) throws Exception {
        if (HTTPServer.hasAuthFactory(ctx, this.securityDomain)) {
            return HTTPServer.getSecurityDomainFactoryName(this.securityDomain, ctx);
        }
        return HTTPServer.getReferencedSecurityDomainName(this.securityDomain, ctx);
    }

    @Override
    protected ModelNode disableFactory(CommandContext context) throws Exception {
        return HTTPServer.disableHTTPAuthentication(this.securityDomain, context);
    }

    @Override
    protected String getSecuredEndpoint(CommandContext ctx) {
        return "security domain " + this.securityDomain;
    }

    public static class MechanismActivator
    extends AbstractDependOptionActivator {
        public MechanismActivator() {
            super(false, "security-domain");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            if (!super.isActivated(processedCommand)) {
                return false;
            }
            HTTPServerDisableAuthCommand cmd = (HTTPServerDisableAuthCommand)processedCommand.command();
            ParsedOption opt = processedCommand.findLongOptionNoActivatorCheck("security-domain");
            if (opt != null && opt.value() != null) {
                try {
                    return HTTPServer.hasAuthFactory(cmd.ctx, opt.value());
                }
                catch (IOException | OperationFormatException ex) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MechanismCompleter
    extends SecurityCommand.OptionCompleters.MechanismDisableCompleter {
        @Override
        protected List<String> getItems(CLICompleterInvocation completerInvocation) {
            HTTPServerDisableAuthCommand cmd = (HTTPServerDisableAuthCommand)completerInvocation.getCommand();
            try {
                if (!HTTPServer.hasAuthFactory(cmd.ctx, cmd.securityDomain)) {
                    return Collections.emptyList();
                }
                return super.getItems(completerInvocation);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }
    }
}

