/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import org.wildfly.common.Assert;

public class SimpleTable {
    private final Object[] header;
    private final int[] columnLengths;
    private final List<String[]> lines = new ArrayList<String[]>();
    private final int terminalWidth;

    public SimpleTable(String[] header, int terminalWidth) {
        this.terminalWidth = terminalWidth;
        Assert.checkNotEmptyParam("header", header);
        this.header = new String[header.length];
        this.columnLengths = new int[header.length];
        for (int i = 0; i < header.length; ++i) {
            String name = header[i];
            if (name == null) {
                throw new IllegalArgumentException("One of the headers is null: " + Arrays.asList(header));
            }
            this.header[i] = name;
            this.columnLengths[i] = name.length() + 1;
        }
    }

    public SimpleTable(int columnsTotal, int terminalWidth) {
        this.terminalWidth = terminalWidth;
        this.header = null;
        this.columnLengths = new int[columnsTotal];
    }

    public int columnsTotal() {
        return this.columnLengths.length;
    }

    public void addLine(String ... line) {
        Assert.checkNotNullParam("line", line);
        if (line.length != this.columnLengths.length) {
            throw new IllegalArgumentException("Line length " + line.length + " doesn't match headers' length " + this.header.length);
        }
        String[] values = new String[line.length];
        for (int i = 0; i < line.length; ++i) {
            String value = line[i];
            if (value == null) {
                value = "null";
            }
            values[i] = value;
            if (this.columnLengths[i] == 0) {
                this.columnLengths[i] = value.length() < this.terminalWidth ? value.length() + 1 : this.terminalWidth;
                continue;
            }
            if (this.columnLengths[i] >= value.length() + 1 || value.length() >= this.terminalWidth) continue;
            this.columnLengths[i] = value.length() + 1;
        }
        this.lines.add(values);
    }

    public int size() {
        return this.lines.size();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean order) {
        return this.append(new StringBuilder(), order).toString();
    }

    public StringBuilder append(StringBuilder buf, boolean order) {
        int i;
        Formatter formatter = new Formatter(buf);
        StringBuilder formatBuf = new StringBuilder();
        for (int length : this.columnLengths) {
            formatBuf.append("%-").append(length).append('s');
        }
        String format = formatBuf.toString();
        if (this.header != null) {
            formatter.format(format, this.header);
            buf.append('\n');
        }
        if (order) {
            Collections.sort(this.lines, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return o1[0].compareTo(o2[0]);
                }
            });
        }
        if ((i = 0) < this.lines.size()) {
            formatter.format(format, this.lines.get(i));
        }
        while (++i < this.lines.size()) {
            buf.append('\n');
            formatter.format(format, this.lines.get(i));
        }
        return buf;
    }
}

