/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.PathTokenizer;

public class VirtualFileAssembly
implements Closeable {
    private static final Random RANDOM_NUM_GEN = new SecureRandom();
    private final AssemblyNode rootNode = new AssemblyNode("");
    private final List<Closeable> mountHandles = new CopyOnWriteArrayList<Closeable>();
    private final VirtualFile mountRoot = VFS.getChild("assembly-mounts").getChild(this.getAssemblyId());
    private TempFileProvider tempFileProvider;

    public void add(VirtualFile virtualFile) {
        String path = virtualFile.getName();
        AssemblyNode assemblyNode = this.rootNode.findOrBuild(path);
        assemblyNode.setTarget(virtualFile);
    }

    public void add(String path, VirtualFile virtualFile) {
        AssemblyNode assemblyNode = this.rootNode.findOrBuild(path);
        assemblyNode.setTarget(virtualFile);
    }

    public void add(String path, File root) throws IOException {
        VirtualFile mountPoint = this.mountRoot.getChild(path);
        Closeable handle = VFS.mountReal(root, mountPoint);
        this.mountHandles.add(handle);
        this.add(path, mountPoint);
    }

    public void addZip(String path, File zipFile) throws IOException {
        VirtualFile mountPoint = this.mountRoot.getChild(path);
        Closeable handle = VFS.mountZip(zipFile, mountPoint, this.getTempFileProvider());
        this.mountHandles.add(handle);
        this.add(path, mountPoint);
    }

    public VirtualFile getFile(VirtualFile mountPoint, VirtualFile target) {
        String path = target.getPathNameRelativeTo(mountPoint);
        return this.rootNode.getFile(new Path(path), mountPoint);
    }

    public List<String> getChildNames(VirtualFile mountPoint, VirtualFile target) {
        LinkedList<String> names = new LinkedList<String>();
        AssemblyNode targetNode = null;
        targetNode = mountPoint.equals(target) ? this.rootNode : this.rootNode.find(target.getPathNameRelativeTo(mountPoint));
        if (targetNode != null) {
            for (AssemblyNode childNode : targetNode.children.values()) {
                names.add(childNode.realName);
            }
        }
        return names;
    }

    public boolean contains(VirtualFile mountPoint, VirtualFile target) {
        String path = target.getPathNameRelativeTo(mountPoint);
        return this.rootNode.find(path) != null;
    }

    @Override
    public void close() {
        VFSUtils.safeClose(this.mountHandles);
    }

    private TempFileProvider getTempFileProvider() throws IOException {
        if (this.tempFileProvider == null) {
            this.tempFileProvider = TempFileProvider.create("temp", Executors.newSingleThreadScheduledExecutor());
        }
        return this.tempFileProvider;
    }

    private String getAssemblyId() {
        return Long.toHexString(RANDOM_NUM_GEN.nextLong());
    }

    private static class AssemblyNode {
        private final Map<String, AssemblyNode> children = new ConcurrentHashMap<String, AssemblyNode>();
        private final String realName;
        private VirtualFile target;

        AssemblyNode(String realName) {
            this.realName = realName;
        }

        public AssemblyNode find(String path) {
            return this.find(new Path(path), false);
        }

        public AssemblyNode findOrBuild(String path) {
            return this.find(new Path(path), true);
        }

        public AssemblyNode find(Path path, boolean createIfMissing) {
            if (path.isEndOfPath()) {
                return this;
            }
            String current = path.getCurrent();
            AssemblyNode childNode = this.getChild(current);
            if (childNode == null) {
                if (!createIfMissing) {
                    return null;
                }
                childNode = new AssemblyNode(current);
                this.addChild(current, childNode);
            }
            return childNode.find(path, createIfMissing);
        }

        public VirtualFile getFile(Path path, VirtualFile assemblyMountPoint) {
            if (path.isEndOfPath()) {
                return this.target;
            }
            String current = path.getCurrent();
            AssemblyNode childNode = this.getChild(current);
            if (childNode != null) {
                return childNode.getFile(path, assemblyMountPoint);
            }
            if (this.target != null) {
                VirtualFile currentFile;
                VirtualFile virtualFile = currentFile = this.target != null ? this.target.getChild(current) : null;
                if (currentFile != null) {
                    while (!path.isEndOfPath()) {
                        current = path.getCurrent();
                        if ((currentFile = currentFile.getChild(current)) != null) continue;
                        return null;
                    }
                    return currentFile;
                }
            }
            return null;
        }

        private void addChild(String name, AssemblyNode child) {
            this.children.put(name.toLowerCase(), child);
        }

        private AssemblyNode getChild(String name) {
            return this.children.get(name.toLowerCase());
        }

        private void setTarget(VirtualFile target) {
            this.target = target;
        }
    }

    private static class Path {
        private final Queue<String> parts = new LinkedList<String>();

        private Path(String path) {
            List<String> tokens = PathTokenizer.getTokens(path);
            this.parts.addAll(tokens);
        }

        private boolean isEndOfPath() {
            return this.parts.isEmpty();
        }

        private String getCurrent() {
            return this.parts.poll();
        }
    }
}

