/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.alias;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aesh.readline.alias.Alias;
import org.aesh.readline.alias.AliasConflictException;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.utils.Config;

public class AliasManager {
    private final List<Alias> aliases;
    private final Pattern aliasPattern = Pattern.compile("^(alias)\\s+(\\w+)\\s*=\\s*(.*)$");
    private final Pattern listAliasPattern = Pattern.compile("^(alias)((\\s+\\w+)+)$");
    private final Pattern aliasHelpPattern = Pattern.compile("^(alias)\\s+\\-\\-help$");
    private final Pattern unaliasHelpPattern = Pattern.compile("^(unalias)\\s+\\-\\-help$");
    private static final String ALIAS = "alias";
    private static final String ALIAS_SPACE = "alias ";
    private static final String UNALIAS = "unalias";
    private File aliasFile;
    private boolean persistAlias = false;
    private static final Logger LOGGER = LoggerUtil.getLogger(AliasManager.class.getName());

    public AliasManager(File aliasFile, boolean persistAlias) throws IOException {
        this.persistAlias = persistAlias;
        this.aliases = new ArrayList<Alias>();
        if (aliasFile != null) {
            this.aliasFile = aliasFile;
            if (this.aliasFile.isFile()) {
                this.readAliasesFromFile();
            }
        }
    }

    public boolean verifyNoNewAliasConflict(String aliasName) throws AliasConflictException {
        return true;
    }

    private void readAliasesFromFile() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.aliasFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(ALIAS)) continue;
                try {
                    this.parseAlias(line);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void persist() {
        if (this.persistAlias && this.aliasFile != null) {
            try {
                boolean keepGoing = true;
                if (this.aliasFile.isFile()) {
                    keepGoing = this.aliasFile.delete();
                }
                if (keepGoing) {
                    File parentFile = this.aliasFile.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    keepGoing = this.aliasFile.createNewFile();
                }
                if (keepGoing) {
                    FileWriter fw = new FileWriter(this.aliasFile);
                    Collections.sort(this.aliases);
                    for (Alias a : this.aliases) {
                        fw.write(ALIAS_SPACE + a.toString() + Config.getLineSeparator());
                    }
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not persist to alias file:", e);
            }
        }
    }

    void addAlias(String name, String value) {
        Alias alias = new Alias(name, value);
        if (this.aliases.contains(alias)) {
            this.aliases.remove(alias);
        }
        this.aliases.add(alias);
    }

    public String printAllAliases() {
        StringBuilder sb = new StringBuilder();
        this.aliases.stream().sorted().forEach(a -> sb.append(ALIAS_SPACE).append(a.toString()).append(Config.getLineSeparator()));
        return sb.toString();
    }

    public Optional<Alias> getAlias(String name) {
        return this.aliases.stream().filter(a -> a.getName().equals(name)).findFirst();
    }

    public Optional<String> getAliasName(String input) {
        String name = Parser.findFirstWord(input);
        return this.aliases.stream().filter(a -> a.getName().equals(name)).map(alias -> alias.getValue() + input.substring(name.length())).findAny();
    }

    public List<String> findAllMatchingNames(String name) {
        return this.aliases.stream().filter(a -> a.getName().startsWith(name)).map(Alias::getName).collect(Collectors.toList());
    }

    public List<String> getAllNames() {
        return this.aliases.stream().map(Alias::getName).collect(Collectors.toList());
    }

    public String removeAlias(String buffer) {
        if (buffer.trim().equals(UNALIAS)) {
            return this.unaliasUsage();
        }
        if (this.unaliasHelpPattern.matcher(buffer).matches()) {
            return this.unaliasUsage();
        }
        buffer = buffer.substring(UNALIAS.length()).trim();
        for (String s : buffer.split(" ")) {
            if (s == null) continue;
            Optional<Alias> a = this.getAlias(s.trim());
            if (a.isPresent()) {
                this.aliases.remove(a.get());
                continue;
            }
            return "unalias: " + s + ": not found" + Config.getLineSeparator();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseAlias(String buffer) {
        if (buffer.trim().equals(ALIAS)) {
            return this.printAllAliases();
        }
        if (this.aliasHelpPattern.matcher(buffer).matches()) {
            return this.aliasUsage();
        }
        Matcher aliasMatcher = this.aliasPattern.matcher(buffer);
        boolean aliasMatched = false;
        if (aliasMatcher.matches()) {
            aliasMatched = true;
            String name = aliasMatcher.group(2);
            String value = aliasMatcher.group(3);
            if (value.startsWith("'")) {
                if (!value.endsWith("'")) return this.aliasUsage();
                value = value.substring(1, value.length() - 1);
            } else if (value.startsWith("\"")) {
                if (!value.endsWith("\"")) return this.aliasUsage();
                value = value.substring(1, value.length() - 1);
            }
            if (name.contains(" ")) {
                return this.aliasUsage();
            }
            try {
                if (!this.verifyNoNewAliasConflict(name)) return "Alias " + name + " is in conflict with an existing command";
                this.addAlias(name, value);
                return null;
            }
            catch (AliasConflictException ace) {
                return ace.getMessage();
            }
        }
        Matcher listMatcher = this.listAliasPattern.matcher(buffer);
        if (listMatcher.matches()) {
            StringBuilder sb = new StringBuilder();
            for (String s : listMatcher.group(2).trim().split(" ")) {
                if (s == null) continue;
                Optional<Alias> a = this.getAlias(s.trim());
                if (a.isPresent()) {
                    sb.append(ALIAS_SPACE).append(a.get().getName()).append("='").append(a.get().getValue()).append("'").append(Config.getLineSeparator());
                    continue;
                }
                sb.append("alias: ").append(s).append(" : not found").append(Config.getLineSeparator());
            }
            return sb.toString();
        }
        if (aliasMatched) return null;
        StringBuilder sb = new StringBuilder();
        sb.append(buffer).append(" is not valid command, make sure alias name is among of [a-zA-Z0-9_]").append(Config.getLineSeparator());
        return sb.toString();
    }

    public String aliasUsage() {
        return "alias: usage: alias [name[=value] ... ]" + Config.getLineSeparator();
    }

    public String unaliasUsage() {
        return "unalias: usage: unalias name [name ...]" + Config.getLineSeparator();
    }
}

