/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedControllerHandlerRegistrar;
import org.jboss.as.cli.embedded.EmbeddedLogContext;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.embedded.EnvironmentRestorer;
import org.jboss.as.cli.embedded.StopEmbeddedServerHandler;
import org.jboss.as.cli.embedded.ThreadContextsModelControllerClient;
import org.jboss.as.cli.embedded.ThreadLocalContextSelector;
import org.jboss.as.cli.embedded.UncloseablePrintStream;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.modules.ModuleLoader;
import org.jboss.stdio.NullOutputStream;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.core.embedded.Configuration;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.security.manager.WildFlySecurityManager;

class EmbedServerHandler
extends CommandHandlerWithHelp {
    private static final String ECHO = "echo";
    private static final String DISCARD_STDOUT = "discard";
    private static final String JBOSS_SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String JBOSS_SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String JBOSS_SERVER_LOG_DIR = "jboss.server.log.dir";
    private final AtomicReference<EmbeddedProcessLaunch> serverReference;
    private ArgumentWithValue jbossHome;
    private ArgumentWithValue stdOutHandling;
    private ArgumentWithValue adminOnly;
    private ArgumentWithValue serverConfig;
    private ArgumentWithValue dashC;
    private ArgumentWithoutValue emptyConfig;
    private ArgumentWithoutValue removeExisting;
    private ArgumentWithValue timeout;

    static EmbedServerHandler create(AtomicReference<EmbeddedProcessLaunch> serverReference, CommandContext ctx, boolean modular) {
        EmbedServerHandler result = new EmbedServerHandler(serverReference);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        if (!modular) {
            result.jbossHome = new FileSystemPathArgument((CommandHandlerWithArguments)result, pathCompleter, "--jboss-home");
        }
        result.stdOutHandling = new ArgumentWithValue((CommandHandlerWithArguments)result, new SimpleTabCompleter(new String[]{ECHO, DISCARD_STDOUT}), "--std-out");
        result.serverConfig = new ArgumentWithValue(result, "--server-config");
        result.dashC = new ArgumentWithValue(result, "-c");
        result.dashC.addCantAppearAfter(result.serverConfig);
        result.serverConfig.addCantAppearAfter(result.dashC);
        result.adminOnly = new ArgumentWithValue((CommandHandlerWithArguments)result, SimpleTabCompleter.BOOLEAN, "--admin-only");
        result.emptyConfig = new ArgumentWithoutValue(result, "--empty-config");
        result.removeExisting = new ArgumentWithoutValue(result, "--remove-existing");
        result.removeExisting.addRequiredPreceding(result.emptyConfig);
        result.timeout = new ArgumentWithValue(result, "--timeout");
        return result;
    }

    private EmbedServerHandler(AtomicReference<EmbeddedProcessLaunch> serverReference) {
        super("embed-server", false);
        assert (serverReference != null);
        this.serverReference = serverReference;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return ctx.getModelControllerClient() == null;
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        boolean startEmpty;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        File jbossHome = this.getJBossHome(parsedCmd);
        String baseDir = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_SERVER_BASE_DIR, (String)(jbossHome + File.separator + "standalone"));
        String xml = this.serverConfig.getValue(parsedCmd);
        if (xml == null) {
            xml = this.dashC.getValue(parsedCmd);
        }
        boolean adminOnlySetting = true;
        String adminProp = this.adminOnly.getValue(parsedCmd);
        if (adminProp != null && "false".equalsIgnoreCase(adminProp)) {
            adminOnlySetting = false;
        }
        boolean removeConfig = (startEmpty = this.emptyConfig.isPresent(parsedCmd)) && this.removeExisting.isPresent(parsedCmd);
        List<String> args = parsedCmd.getOtherProperties();
        if (!args.isEmpty() && args.size() != 1) {
            throw new CommandFormatException("The command accepts 0 unnamed argument(s) but received: " + args);
        }
        Long bootTimeout = null;
        String timeoutString = this.timeout.getValue(parsedCmd);
        if (this.timeout.isPresent(parsedCmd) && (timeoutString == null || timeoutString.isEmpty())) {
            throw new CommandFormatException("The --timeout parameter requires a value.");
        }
        if (timeoutString != null) {
            bootTimeout = TimeUnit.SECONDS.toNanos(Long.parseLong(timeoutString));
        }
        String stdOutString = this.stdOutHandling.getValue(parsedCmd);
        if (this.stdOutHandling.isPresent(parsedCmd)) {
            if (stdOutString == null || stdOutString.isEmpty()) {
                throw new CommandFormatException("The --std-out parameter requires a value { echo, discard }.");
            }
            if (!stdOutString.equals(ECHO) && !stdOutString.equals(DISCARD_STDOUT)) {
                throw new CommandFormatException("The --std-out parameter should be one of { echo, discard }.");
            }
        }
        EnvironmentRestorer restorer = new EnvironmentRestorer(JBOSS_SERVER_LOG_DIR);
        boolean ok = false;
        ThreadLocalContextSelector contextSelector = null;
        try {
            String serverLogDir;
            Contexts defaultContexts = restorer.getDefaultContexts();
            StdioContext discardStdoutContext = null;
            if (!ECHO.equalsIgnoreCase(this.stdOutHandling.getValue(parsedCmd))) {
                UncloseablePrintStream nullStream = new UncloseablePrintStream((OutputStream)NullOutputStream.getInstance());
                StdioContext currentContext = defaultContexts.getStdioContext();
                discardStdoutContext = StdioContext.create((InputStream)currentContext.getIn(), (PrintStream)nullStream, (PrintStream)currentContext.getErr());
            }
            if ((serverLogDir = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_SERVER_LOG_DIR, null)) == null) {
                serverLogDir = baseDir + File.separator + "log";
                WildFlySecurityManager.setPropertyPrivileged((String)JBOSS_SERVER_LOG_DIR, (String)serverLogDir);
            }
            String serverCfgDir = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_SERVER_CONFIG_DIR, (String)(baseDir + File.separator + "configuration"));
            LogContext embeddedLogContext = EmbeddedLogContext.configureLogContext(new File(serverLogDir), new File(serverCfgDir), "server.log", ctx);
            Contexts localContexts = new Contexts(embeddedLogContext, discardStdoutContext);
            contextSelector = new ThreadLocalContextSelector(localContexts, defaultContexts);
            contextSelector.pushLocal();
            StdioContext.setStdioContextSelector((StdioContextSelector)contextSelector);
            LogContext.setLogContextSelector((LogContextSelector)contextSelector);
            ArrayList<String> cmdsList = new ArrayList<String>();
            if (xml == null && (parsedCmd.hasProperty("--server-config") || parsedCmd.hasProperty("-c"))) {
                throw new CommandFormatException("The --server-config (or -c) parameter requires a value.");
            }
            if (xml != null) {
                if ((xml = xml.trim()).length() == 0) {
                    throw new CommandFormatException("The --server-config parameter requires a value.");
                }
                if (!xml.endsWith(".xml")) {
                    throw new CommandFormatException("The --server-config filename must end with .xml.");
                }
                cmdsList.add("--server-config=" + xml);
            }
            if (startEmpty && !removeConfig) {
                String configFileName = xml == null ? "standalone.xml" : xml;
                File configFile = new File(serverCfgDir + File.separator + configFileName);
                if (configFile.exists()) {
                    throw new CommandFormatException("The configuration file " + configFileName + " already exists, please use --remove-existing if you wish to overwrite.");
                }
            }
            if (adminOnlySetting) {
                cmdsList.add("--admin-only");
            }
            if (startEmpty) {
                cmdsList.add("--internal-empty-config");
                if (removeConfig) {
                    cmdsList.add("--internal-remove-config");
                }
            }
            String[] cmds = cmdsList.toArray(new String[cmdsList.size()]);
            Configuration.Builder configBuilder = this.jbossHome == null ? Configuration.Builder.of((File)jbossHome).setModuleLoader(ModuleLoader.forClass(this.getClass())).setCommandArguments(cmds) : Configuration.Builder.of((File)jbossHome.getAbsoluteFile()).addSystemPackages(EmbeddedControllerHandlerRegistrar.EXTENDED_SYSTEM_PKGS).setCommandArguments(cmds);
            WildFlySecurityManager.setPropertyPrivileged((String)"org.wildfly.logging.embedded", (String)"false");
            StandaloneServer server = EmbeddedProcessFactory.createStandaloneServer((Configuration)configBuilder.build());
            server.start();
            this.serverReference.set(new EmbeddedProcessLaunch((EmbeddedManagedProcess)server, restorer, false));
            ThreadContextsModelControllerClient mcc = new ThreadContextsModelControllerClient(server.getModelControllerClient(), contextSelector);
            if (bootTimeout == null || bootTimeout > 0L) {
                String status;
                long expired;
                long l = expired = bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + bootTimeout;
                while ((status = server.getProcessState()) == null || "starting".equals(status)) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new CommandLineException("Interrupted while waiting for embedded server to start");
                    }
                    if (System.nanoTime() < expired) continue;
                }
                if (status == null || "starting".equals(status)) {
                    assert (bootTimeout != null);
                    StopEmbeddedServerHandler.cleanup(this.serverReference);
                    throw new CommandLineException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(bootTimeout) + " seconds");
                }
            }
            ctx.bindClient(mcc);
            ctx.addEventListener(new CliEventListener(){

                @Override
                public void cliEvent(CliEvent event, CommandContext ctx) {
                    if (event == CliEvent.DISCONNECTED) {
                        StopEmbeddedServerHandler.cleanup(EmbedServerHandler.this.serverReference);
                    }
                }
            });
            ok = true;
        }
        catch (RuntimeException | EmbeddedProcessStartException e) {
            throw new CommandLineException("Cannot start embedded server", e);
        }
        finally {
            if (!ok) {
                ctx.disconnectController();
                restorer.restoreEnvironment();
            } else if (contextSelector != null) {
                contextSelector.restore(null);
            }
        }
    }

    private File getJBossHome(ParsedCommandLine parsedCmd) throws CommandLineException {
        String jbossHome;
        String string = jbossHome = this.jbossHome == null ? null : this.jbossHome.getValue(parsedCmd);
        if (jbossHome == null || jbossHome.length() == 0) {
            jbossHome = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null);
            if (jbossHome == null || jbossHome.length() == 0) {
                if (this.jbossHome != null) {
                    throw new CommandLineException("Missing configuration value for --jboss-home and environment variable JBOSS_HOME is not set");
                }
                throw new CommandLineException("Environment variable JBOSS_HOME is not set");
            }
            return EmbedServerHandler.validateJBossHome(jbossHome, "environment variable JBOSS_HOME");
        }
        return EmbedServerHandler.validateJBossHome(jbossHome, "argument --jboss-home");
    }

    private static File validateJBossHome(String jbossHome, String source) throws CommandLineException {
        File f = new File(jbossHome);
        if (!f.exists()) {
            throw new CommandLineException(String.format("File %s specified by %s does not exist", jbossHome, source));
        }
        if (!f.isDirectory()) {
            throw new CommandLineException(String.format("File %s specified by %s is not a directory", jbossHome, source));
        }
        return f;
    }
}

