/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SecurityDomain;

public class AuthFactory {
    private final String name;
    private final SecurityDomain domain;
    private final List<AuthMechanism> mechanisms = new ArrayList<AuthMechanism>();
    private final AuthFactorySpec spec;

    public AuthFactory(String name, SecurityDomain domain, AuthFactorySpec spec) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(domain);
        Objects.requireNonNull(spec);
        this.name = name;
        this.domain = domain;
        this.spec = spec;
    }

    public AuthFactorySpec getSpec() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public SecurityDomain getSecurityDomain() {
        return this.domain;
    }

    public void addMechanism(AuthMechanism mec) {
        Objects.requireNonNull(mec);
        this.mechanisms.add(mec);
    }

    public List<AuthMechanism> getMechanisms() {
        return Collections.unmodifiableList(this.mechanisms);
    }
}

