/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl._private.BootScriptInvokerLogger;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.impl.AdditionalBootCliScriptInvoker;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BootScriptInvoker
implements AdditionalBootCliScriptInvoker {
    private final Properties props = new Properties();
    private final Properties existingProps = new Properties();

    public void runCliScript(ModelControllerClient client, File file) {
        BootScriptInvokerLogger.ROOT_LOGGER.processScript(file);
        String log = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script.logging", (String)"false");
        LogManager logManager = LogManager.getLogManager();
        if (!Boolean.parseBoolean(log) && logManager instanceof org.jboss.logmanager.LogManager) {
            org.jboss.logmanager.LogManager jbossLogManager = (org.jboss.logmanager.LogManager)logManager;
            jbossLogManager.getLogger(CommandContext.class.getName()).setLevel(Level.OFF);
        }
        CommandContext ctx = null;
        String props = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script.properties", null);
        if (props != null) {
            File propsFile = new File(props);
            if (!propsFile.exists()) {
                throw BootScriptInvokerLogger.ROOT_LOGGER.propertiesFileNotFound(propsFile);
            }
            this.handleProperties(propsFile);
        }
        File logFile = null;
        String logFilePath = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script.output.file", null);
        if (logFilePath != null) {
            logFile = new File(logFilePath);
        }
        try {
            FileOutputStream output = null;
            if (logFile != null) {
                output = new FileOutputStream(logFile);
            }
            ctx = new CommandContextImpl(output);
            ctx.bindClient(client);
            BootScriptInvoker.processFile(file, ctx);
        }
        catch (Exception ex) {
            try {
                BootScriptInvokerLogger.ROOT_LOGGER.errorProcessingScript(file);
                StringBuilder errBuilder = new StringBuilder();
                for (String line : Files.readAllLines(file.toPath())) {
                    errBuilder.append(line).append("\n");
                }
                BootScriptInvokerLogger.ROOT_LOGGER.error(errBuilder.toString());
                if (logFile != null) {
                    BootScriptInvokerLogger.ROOT_LOGGER.cliOutput();
                    StringBuilder logBuilder = new StringBuilder();
                    for (String line : Files.readAllLines(logFile.toPath())) {
                        logBuilder.append(line).append("\n");
                    }
                    BootScriptInvokerLogger.ROOT_LOGGER.error(logBuilder.toString());
                }
            }
            catch (IOException ex1) {
                RuntimeException rtex = new RuntimeException(ex1);
                rtex.addSuppressed(ex);
                throw rtex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (ctx != null) {
                ctx.terminateSession();
            }
            this.clearProperties();
        }
        BootScriptInvokerLogger.ROOT_LOGGER.doneProcessScript(file);
    }

    private static void processFile(File file, CommandContext cmdCtx) throws IOException {
        File errors;
        String errorFile;
        File warns;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (cmdCtx.getExitCode() == 0 && !cmdCtx.isTerminated() && line != null) {
                BootScriptInvokerLogger.ROOT_LOGGER.executeCommand(line.trim());
                cmdCtx.handle(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            throw BootScriptInvokerLogger.ROOT_LOGGER.unexpectedException(e, file);
        }
        String warnFile = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script.warn.file", null);
        if (warnFile != null && (warns = new File(warnFile)).exists()) {
            StringBuilder warnBuilder = new StringBuilder();
            for (String line : Files.readAllLines(warns.toPath())) {
                warnBuilder.append(line).append("\n");
            }
            BootScriptInvokerLogger.ROOT_LOGGER.warn(warnBuilder.toString());
        }
        if ((errorFile = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script.error.file", null)) != null && (errors = new File(errorFile)).exists()) {
            StringBuilder errorBuilder = new StringBuilder();
            for (String line : Files.readAllLines(errors.toPath())) {
                errorBuilder.append(line).append("\n");
            }
            BootScriptInvokerLogger.ROOT_LOGGER.error(errorBuilder.toString());
            throw BootScriptInvokerLogger.ROOT_LOGGER.unexpectedErrors(file, errors);
        }
        if (cmdCtx.getExitCode() != 0 || cmdCtx.isTerminated()) {
            throw new RuntimeException("Error applying " + file + " CLI script.");
        }
    }

    private void handleProperties(File propertiesFile) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), StandardCharsets.UTF_8);){
            this.props.load(inputStreamReader);
            for (String key : this.props.stringPropertyNames()) {
                String original = WildFlySecurityManager.getPropertyPrivileged((String)key, null);
                if (original != null) {
                    this.existingProps.put(key, original);
                }
                WildFlySecurityManager.setPropertyPrivileged((String)key, (String)this.props.getProperty(key));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void clearProperties() {
        for (String key : this.props.stringPropertyNames()) {
            WildFlySecurityManager.clearPropertyPrivileged((String)key);
        }
        for (String key : this.existingProps.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)this.existingProps.getProperty(key));
        }
    }
}

